*_________________________________________________________________________
*|	  							         |
*|	/\/\/\/\/\/   DES LASERS ET DES HOMMES	 \/\/\/\/\/\		 |
*|	   								 |
*|_______________________________________________________________________|



	OPT	O+,OW+,V+,W+
	MC68030
	opt 	d+,x+
	OUTPUT ".PRG"

	*GRAPHS ACTUELS
NBMUR	EQU	12
NBOBJ	EQU	7
NBSOL	EQU	6
NBPLAN	EQU	15
	*SKIP INTRO
SKIP	EQU	1

	*MUSIQUE
FREQU	EQU	25000	*32780	*FREQUENCE DU REPLAY 
	*VARIABLES ECRAN
INDIC	EQU	1	*0=AFF. BOUSSOLE ET NN VBLS
ROUL	EQU	20	*TAILLE DU ROULEAU (PRESENTATION)
	*VARIABLES COULEURS
COULCAD	EQU	30*2048+30	*COULEUR DU CADRE
FONB	EQU	25		*COULEUR DU FOND
FONG	EQU	31
FONR	EQU	25 

COLASER	EQU	20*32*64

	*VARIABLES PERSO
FREQINC	EQU	15		*PERIODE D'AUGMENTATION DU SHIELD
SHILD	EQU	10000		*SHIELD DU HEROS
FORCEA	EQU	50		*POUVOIR DU LASER DES AUTRES
FORCEH	EQU	70		*POUVOIR DE SON LASER
HIT_SC	EQU	3		*POINTS POUR AVOIR TOUCH UN ENNEMI
TOUCH_SC	EQU	-2	*POINTS POUR AVOIR ETE TOUCH
FRIEND_SC	EQU	-1	*POINTS POUR TOUCHER UN AMI
BASE_SC		EQU	142	*BASE POUR LES NON-JOUEURS (EMULATION)
SURVIVAL_SC	EQU	600	*POINTS POUR AVOIR SURVECU
MORE50_SC	EQU	100	*POINTS POUR UN % >50
MORE75_SC	EQU	200	*"	"	  >75

		*DEPLACEMENT
LONG_CHEMIN	EQU	70	*FUITE D'UN PERSO
HLASERD	EQU	30	*HAUTEUR DU TIR LASER DES AUTRES
HLASER	EQU	60
SEUIL_SOL	EQU	7	*HAUTEUR DE TRANSPARENCE

PAS	EQU	10	*PAS EN DEMI-DEGRE POUR 2 VBLS
PAS2	EQU	16	*DEPLACEMENT TRANSLATERAL
EPAISS	EQU	80	*EPAISSEUR DU PERSONNAGE (EN 1/256 DE CASE)

PAS3	EQU	16	*DEPLACEMENT / 4VBLS POUR LES AUTRES PERSONNAGES
PAS4	EQU	32	*DEPLACEMENT POUR LE LASER

	*SENSIBILITE SOURIS
M_SENSY	EQU	4
	
	
	*VARIABLES ECRANS (SUITE)
ECLINT	EQU	25	*GRADIENT D'ECLAIRAGE
ECLSUB	EQU	-30	*SOUSTRACTION A Z
ECLINT2	EQU	30	*GRADIENT D'ECLAIRAGE LORS DU TIR
ECLSUB2	EQU	-18	*SOUSTRACTION A Z


*XMACLIP	EQU	319	*CLIPPING	-45 + x*357/256 pour pleinecr
XMACLIP	EQU	319-45	*CLIPPING	-45 + x*357/256 pour pleinecr
XMICLIP	EQU	45			*180 lignes occupe
*XMICLIP	EQU	1			*180 lignes occupe

YMACLIPD	EQU	99-18-7
YMICLIPD	EQU	0+17-7	
YMACLIP	EQU	199-35-14
YMICLIP	EQU	0+35-14
*YMACLIPD	EQU	179/2
*YMICLIPD	EQU	0	
*YMACLIP	EQU	179
*YMICLIP	EQU	0

X0	EQU	80	*CENTRE DU RECTANGLE
Z0	EQU	0	* "           "
XTR	EQU	80	*DCALAGE DU RECTANGLE
ZTR	EQU	-250	* "	      "
XV	EQU	160	* X POINT DE VUE

YTRD	EQU	50-37	* "           "
YVD	EQU	40-7	* Y "         "
LONECRD	EQU	(640*YMACLIPD)+(100-YMACLIPD)*640*2

YTR	EQU	2*(50-37)	* "           "
YV	EQU	80-14  	* Y "         "
LONECR	EQU	640*200

*ZV	EQU	256	* Z "         "
XIMG	EQU	160	*192	*LARGEUR IMAGE  (ECRAN)
YIMG	EQU	120	*HAUTEUR IMAGE	(ECRAN)
XLARG	EQU	160	*192	*LARGEUR IMAGE MEMOIRE

YIMG_DD	EQU	60
YIMG_D	EQU	120

BIT_SOLX	EQU	80	*TAILLE SOL BITMAP
BIT_SOLY	EQU	80
	*PARAM .INF
LONG_INF	EQU	64+(NBPLAN+1)*180

	*POUR ITEMS
R	EQU	2048
G	EQU	32




	*SHRINK
	MOVEA.L	4(A7),A5
	MOVE.L	$C(A5),D0
	ADD.L	$14(A5),D0
	ADD.L	$1C(A5),D0
	ADD.L	#$100,D0

	MOVE.L	D0,-(A7)
	PEA	(A5)
	CLR.W	-(A7)
	MOVE	#$4A,-(A7)
	TRAP	#1
	TST	D0
	BMI	MEMORY_OUT
	LEA	$C(A7),A7

	*RESERVE MEMOIRE POUR AMIS & ENNEMIS



	PEA	47*9636+256	*=442K
	MOVE	#$48,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	MOVE.L	D0,AMIS
	BEQ	MEMORY_OUT

	PEA	47*9636+256	*=442K
	MOVE	#$48,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	MOVE.L	D0,ENNEMIS
	BEQ	MEMORY_OUT
	
	*TESTE LA PRESENCE DES READMES
	LEA	NOM_F1,A5
	JSR	IS_THERE?
	BMI	NO_FILE

	LEA	NOM_F2,A5
	JSR	IS_THERE?
	BMI	NO_FILE
	
	
	
	*CHARGEMENT DES PREFERENCES
	JSR	CHARGE_INF
	BMI	NO_FILE
	
	SF	REGISTRE_F
	JSR	TST_REGISTRE	*REGARDE SI C'EST UNE VERSION ENREGISTRE

	MOVE.B	BUF_INF+26,PARANOIA_F

	*CHARGEMENT DES GRAPHISMES DES BONHOMMES
	MOVE.L	AMIS,A6
	LEA	NOMS_AMIS,A5
	MOVEQ	#1,D7	*NOMBRE
	JSR	CHARGE
	BMI	NO_FILE
	*DECOMPRESSION
	MOVE.L	AMIS,A0
	LEA	256(A0),A1	*PROTECTION DE 256 OCTETS
	MOVE.L	A1,AMIS
	JSR	UNSQUEEZE
	* D0=0 si erreur
	* D0=longueur dcompresse sinon


	MOVE.L	ENNEMIS,A6
	LEA	NOMS_ENNEMIS,A5
	MOVEQ	#1,D7	*NOMBRE
	JSR	CHARGE
	BMI	NO_FILE
	MOVE.L	ENNEMIS,A0
	LEA	256(A0),A1	*PROTECTION DE 256 OCTETS
	MOVE.L	A1,ENNEMIS
	JSR	UNSQUEEZE
	* D0=0 si erreur
	* D0=longueur dcompresse sinon

	*LANCE PROGRAMME DSP
	JSR	DSP_EXEC

	*INIT VALEUR ECRAN (POUR PAS QUE CA MERDOIE)
	MOVE.L	#ECRAN,D0
	AND.L	#$FFFFFF00,D0
	MOVE.L	D0,ECRANG
	

	*DETECTE LA TELE
	MOVE	#$59,-(SP)
	TRAP	#14
	ADDQ.L	#2,SP
	MOVE	D0,MONTYPE

	* RECUPERE LA RESOLUTION
	MOVE	#-1,-(SP)
	MOVE	#$58,-(SP)
	TRAP	#14
	ADDQ.L	#4,SP
	MOVE	D0,OLDRES
	
	MOVE	#2,-(SP)
	TRAP	#14
	ADDQ.L	#2,SP
	MOVE.L	D0,PHYBASE	
	*CHANGE L'ADRESSE

*	MOVE	#-1,-(SP)
*	MOVE.L	ECRANG,-(SP)
*	MOVE.L	ECRANG,-(SP)
*	MOVE	#5,-(SP)
*	TRAP	#14
*	LEA	12(SP),SP
	
	PEA	0.W
	MOVE	#$20,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	
	*VRIFICATION DU TYPE D'ARCHITECTURE ET DE CLAVIER
	MOVE.L	$5A0.W,A6		*COOKIE_JAR
	MOVE.L	A6,D0
	BEQ.S	NOT_FALCON

NEXT_COOKIE
	CMPI.L	#'_MCH',(A6)
	BEQ.S	.FALCON_TEST
	CMPI.L	#"_AKP",(A6)
	BEQ.S	.KBD_TEST
	TST.L	(A6)
	BEQ.S	.AFTER_COOK
	ADDQ.L	#8,A6
	BRA.S	NEXT_COOKIE

.FALCON_TEST
	CMPI.L	#$30000,4(A6)
	BNE.S	NOT_FALCON
	ADDQ.L	#8,A6
	BRA.S	NEXT_COOKIE
.KBD_TEST	
	MOVE.B	6(A6),D0
	CMP.B	#2,D0
	BEQ.S	.FRENCH
	CMP.B	#7,D0
	BEQ.S	.FRENCH
	*ENGLISH
	SF	AZERTY_F
	ADDQ.L	#8,A6
	BRA.S	NEXT_COOKIE
.FRENCH	ST	AZERTY_F
	ADDQ.L	#8,A6
	BRA.S	NEXT_COOKIE
.AFTER_COOK



	BSR.S	MAIN
	

	*VIEILLE RESOLUTION
	MOVE	OLDRES,-(SP)
	MOVE	#$58,-(SP)
	TRAP	#14
	ADDQ.L	#4,SP

	*SAUVEGARDE LES PREFERENCES
	JSR	SAUVE_INF
	BMI.S	ERROR_WRITE

*	PEA	0.W
*	MOVE	#$20,-(SP)
*	TRAP	#1
*	ADDQ.L	#6,SP
	
	
*	MOVE	#-1,-(SP)
*	MOVE.L	PHYBASE,-(SP)
*	MOVE.L	PHYBASE,-(SP)
*	MOVE	#5,-(SP)
*	TRAP	#14
*	LEA	12(SP),SP


	CLR	-(SP)
	TRAP	#1

	*ERREURS
NOT_FALCON
	PEA	TXT_NOFALCON
	BRA.S	QUIT_ERR
ERROR_WRITE
	*PAS POSSIBLE D'ENREGISTRER LES PREFERENCES
	PEA	TXT_WRITE_ERR
	BRA.S	QUIT_ERR
NO_FILE	*PAS LES BONS FICHIERS
	PEA	TXT_NOFILE
	BRA.S	QUIT_ERR
MEMORY_OUT
	*A PLUS MEMORY
	PEA	MESSAGE
QUIT_ERR
	MOVE	#$9,-(SP)
	TRAP	#1
	MOVE	#8,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	
	CLR	-(SP)
	TRAP	#1




******************************************************
MAIN
	MOVE.L	SP,NIVEAU0
	SF	EVOL_YV
	SF	SEC_VBL
	SF	SEC_VBL_D
	SF	HUIT_VBLS
	CLR.B	FL_AMIS
	CLR.B	MOUV
	CLR.B	MOUV2

	MOVE.B	$FFFF8209.W,RANDOM	*GRAINE
	MOVE.B	$FFFF8207.W,RANDOM+1
	MOVE.L	$FFFF9800.W,SOVCOL0
	
		
	BSR	INITIALISATIONS
	BSR	CLS
	BSR	A_KARINE
	JSR	INSTALL_MUSIC
	BSR	CLS
	
	*PRESENTATION
	IFNE	SKIP
	ST	REGSCR_F
	BSR	PRESENTATION
	SF	REGSCR_F
	
	MOVE.L	BASE,-(SP)
	MOVE.L	ECRANG,-(SP)
	ADD.L	#128000,ECRANG
	ADD.L	#128000,BASE
		
	BSR	CLS_FRACT

	*AVERTISSEMENT
	LEA	AVERTISSEMENT,A0
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#11,D7
.GARDE
	MOVE.L	D0,-(SP)
	MOVE.L	D1,-(SP)
	MOVE.L	D7,-(SP)
	PEA	(A0)
	BSR	PRINT_T
	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,D7
	MOVE.L	(SP)+,D1
	MOVE.L	(SP)+,D0
	ADD	#16,D1
	LEA	21(A0),A0
	DBF	D7,.GARDE
	*DEROULE
	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,BASE
	MOVE.L	A0,ECRANG
	ADD.L	#128000,A0
	MOVE.L	A0,SOVREG
	ADD.L	#640,SOVREG
	BSR	DEROUL	

.VIDE_BUF
	TST.B	KEY_TAB+57
	BNE.S	.VIDE_BUF	
	
	MOVE.L	BASE,A0
	BSR	FADE_OUT

	ENDC

RE_GAME
	SF	MORE75_FL
	SF	SURVIE_FL
	SF	MORE50_FL
	SF	GAGNE_F

	
	MOVE.L	BASE,-(SP)
	MOVE.L	ECRANG,-(SP)
	ADD.L	#128000,ECRANG
	ADD.L	#128000,BASE
		

	BSR	CLS_FRACT
	*RECOPIE DANS ECRANG+128000 (3EME ECRAN)
	LEA	([ECRANG],128000.L),A0
	MOVE.L	ECRANG,A1
	MOVE	#31999,D0
.FRAC_SOV
	MOVE.L	(A1)+,(A0)+	*SAUVEGARDE DE LA FRACTALE EN FOND
	DBF	D0,.FRAC_SOV
		
.LOOP_LEVEL_CHOICE
	JSR	INIT_LEVEL
	
	
	*POSITIONNEMENT DES AUTRES PERSONNAGES 
	BSR	AFFICHE_PLAN
	MOVE	NUM_LEVEL,D0
	MOVE.L	(PLANS_TXT,D0*4),A0
	MOVEQ	#0,D0
	MOVE	#180,D1
	BSR	PRINT_T
	LEA	TXT_TITRE1,A0
	MOVE	#160,D0
	MOVEQ	#50,D1
	BSR	PRINT_T
	LEA	TXT_TITRE2,A0
	MOVE	#160,D0
	MOVEQ	#70,D1
	BSR	PRINT_T
	LEA	TXT_TITRE3,A0
	MOVE	#160-8,D0
	MOVEQ	#90,D1
	BSR	PRINT_T


	*CREATION DES PERSOS
	MOVE	NUM_LEVEL,D0
	MOVE.L	(PLANS+4,D0.W*8),A6
	MOVEQ	#0,D0
	MOVE.B	(A6)+,D0
	MOVE	D0,NB_AMIS
	MOVE.B	(A6)+,D0
	MOVE	D0,NB_ENNEMIS
	
	MOVE.B	(A6)+,X_POS
	MOVE.B	#128,X_POS+1
	MOVE	X_POS,X_POS2
	MOVE.B	(A6)+,Y_POS
	MOVE.B	#128,Y_POS+1
	MOVE	Y_POS,Y_POS2


	*AFFICHE LA POS DU JOUEUR
	MOVE.L	BASE,A5
	MOVE.B	X_POS,D6
	MOVE.B	Y_POS,D4
	AND.W	#$FF,D6
	AND.W	#$FF,D4
	MOVEQ	#0,D0
	MOVE	D4,D0
	EXT.L	D6
	MULU	#640*5,D0
	MULU	#10,D6
	ADD.L	D6,D0
	LEA	HEROS_IT,A2	*SRCE
	ADD.L	D0,A5	*DEST
	MOVEQ	#0,D0
.FOR0	MOVE.L	(A2)+,(A5,D0)
	MOVE.L	(A2)+,4(A5,D0)
	MOVE	(A2)+,8(A5,D0)
	ADD	#640,D0
	CMP	#640*5,D0
	BNE.S	.FOR0


	*A0=PLAN, A1=PILE_,D7=NOMBRE-1,D3=0 AMI 2^15 ENNEMI
	*AUTRES PERSOS
	
	LEA	PF_TBLA,A4	*SOLDAT 2ND CLASSE POUR AMI+BILL
	LEA	PLAN,A0
	LEA	PILE_AMIS2,A1
	MOVE	NB_AMIS,D7
	SUBQ	#1,D7
	MOVEQ	#0,D3
	BSR	CREE_PERSO

	LEA	PF_TBLE,A4	*TOUT UN TAS DE MECHANTS ENNEMIS
	LEA	PILE_ENNEMIS2,A1
	MOVE	NB_ENNEMIS,D7
	SUBQ	#1,D7
	MOVE	#$8000,D3
	BSR	CREE_PERSO
	
	MOVE	NB_AMIS,FRIENDS
	MOVE	NB_ENNEMIS,FOES

	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,BASE
	MOVE.L	A0,ECRANG
	ADD.L	#128000,A0

	BSR	ZOOM_IN

	LEA	KEY_TAB,A6
.POZ	
	TST.B	1(A6)			*ESC
	BNE	ENDE2

	TST.B	57(A6)			*ESPACE
	BNE	.SELECT
	TST.B	75(A6)			*GAUCHE
	BEQ.S	.TST_FOL
	SUBQ	#1,NUM_LEVEL
	BPL.S	.AFF_BOUC
	CLR	NUM_LEVEL
	BRA.S	.POZ
.TST_FOL
	TST.B	77(A6)			*DROITE
	BEQ.S	.POZ
	ADDQ	#1,NUM_LEVEL
	MOVE	#NBPLAN-1,D0
	TST.B	REGISTRE_F
	BNE.S	.TOUS
	MOVEQ	#1,D0		*2 NIVEAUX SI PAS ENREGISTR
.TOUS	CMP	NUM_LEVEL,D0
	BHS.S	.AFF_BOUC
	MOVE	D0,NUM_LEVEL
	BRA.S	.POZ
	
.AFF_BOUC
	LEA	([ECRANG],128000.l),A0
	BSR	ZOOM_OUT

	MOVE.L	BASE,-(SP)
	MOVE.L	ECRANG,-(SP)
	ADD.L	#128000,ECRANG
	ADD.L	#128000,BASE
	*RECOPIE DANS ECRANG+128000 (3EME ECRAN)
	LEA	([ECRANG],128000.l),A0
	MOVE.L	ECRANG,A1
	MOVE	#31999,D0
.FRAC_SOV2
	MOVE.L	(A0)+,(A1)+	*RAPPEL DE LA FRACTALE EN FOND
	DBF	D0,.FRAC_SOV2
	BRA	.LOOP_LEVEL_CHOICE



.SELECT	*NIVEAU SELECTIONN
	LEA	([ECRANG],128000.L),A0
	BSR	ZOOM_OUT

	MOVE.L	BASE,-(SP)
	MOVE.L	ECRANG,-(SP)
	ADD.L	#128000,BASE
	ADD.L	#128000,ECRANG

	*RECOPIE DANS ECRANG+128000 (3EME ECRAN)
	LEA	([ECRANG],128000.l),A0
	MOVE.L	ECRANG,A1
	MOVE	#31999,D0
.FRAC_SOV22
	MOVE.L	(A0)+,(A1)+	*RAPPEL DE LA FRACTALE EN FOND
	DBF	D0,.FRAC_SOV22

	

	MOVE.B	BUF_INF+28,DOUBLE_F
	*SELECTION DE LA RESOLUTION SI RGB
	MOVEQ	#32,D0
	MOVEQ	#10,D1
	LEA	TXT_SEL_RES,A0
	BSR	PRINT_T
	MOVEQ	#88,D0
	MOVEQ	#100-30,D1
	LEA	TXT_RESN,A0
	BSR	PRINT_T
	MOVEQ	#88,D0
	MOVEQ	#130-30,D1
	LEA	TXT_RESD,A0
	BSR	PRINT_T
	LEA	TXT_PARANO,A0
	MOVEQ	#0,D0
	MOVE	#135,D1
	BSR	PRINT_T
	TST.B	PARANOIA_F
	BEQ.S	.NOPA
	LEA	TXT_YES,A0
	BRA.S	.APPA
.NOPA	LEA	TXT_NO,A0
.APPA
	MOVE	#319-3*16,D0
	MOVE	#135,D1
	BSR	PRINT
	
	CMP	#2,MONTYPE
	BNE.S	.NORGBTXT
	LEA	TXT_RGB,A0
	MOVEQ	#0,D0
	MOVE	#199-40,D1
	BSR	PRINT_T
	LEA	TXT_RGB+21,A0
	MOVEQ	#0,D0
	MOVE	#199-19,D1
	BSR	PRINT_T
.NORGBTXT
	*
	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,BASE
	MOVE.L	A0,ECRANG
	ADD.L	#128000,A0
	BSR	ZOOM_IN

	MOVE.L	#640*(97-30),D6		*CURSEUR 1
	MOVE.L	#640*(127-30),D7	*CURSEUR 2

	MOVE	#319-3*16,D0		*POS DU YES/NO
	MOVE	#135,D1
	MOVEQ	#0,D4
	MOVE.B	PARANOIA_F,D4
	
	BSR	SELEC_OPTION
	MOVE.B	D4,PARANOIA_F
	
	
	*D5=1 OU 2
	CMP	#1,D5
	SEQ	DOUBLE_F

	MOVE.L	BASE,A0
	BSR	FADE_OUT
	
	*INITS DU A DOUBLE
	TST.B	DOUBLE_F
	BNE.S	.NEDBL

	CMP	#2,MONTYPE
	SEQ	DOUBLE_RGB_F
	SNE	DOUBLE_EMUL_F
	MOVE	#HLASERD,HLASER_F
	MOVE	#YMACLIPD,YMACLIP_F
	MOVE	#YMICLIPD,YMICLIP_F
	MOVE	#YTRD,YTR_F
	MOVE	#YVD,YV_F
	MOVE.L	#YV_TBLD,YV_PT
	MOVE.L	#LONECRD,LONECR_F
	MOVE	#YIMG_DD,YIMG_D_F
	MOVE	#60,Y_REC+2
	BRA.S	.APNEDBL
.NEDBL
	ST	DOUBLE_RGB_F
	ST	DOUBLE_EMUL_F
	MOVE	#HLASER,HLASER_F
	MOVE	#YMACLIP,YMACLIP_F
	MOVE	#YMICLIP,YMICLIP_F
	MOVE	#YTR,YTR_F
	MOVE.L	#YV_TBL,YV_PT
	MOVE	#YV,YV_F
	MOVE.L	#LONECR,LONECR_F
	MOVE	#YIMG_D,YIMG_D_F
	MOVE	#120,Y_REC+2
.APNEDBL	
	MOVE	HLASER_F,Y_REC3
	MOVE	YIMG_D_F,Y_REC2+2
	
	JSR	STOP_MUSIC		*PAS PENDANT LE JEU
	JSR	SOV_SOUND
	JSR	INIT_SONS
	*CROSSBAR
	AND	#%1111000011111111,$FFFF8930.W	
	OR	#%0000101100000000,$FFFF8930.W
	
	AND	#%1111111111110000,$FFFF8932.W
	OR	#%1101,$FFFF8932.W
	
	CLR.B	$FFFF8900.W
	*DEMARRE LE JEU
	
	TST.B	DOUBLE_EMUL_F
	BNE.S	.NORMSCR

*LONECRD	EQU	(640*YMACLIPD)+(100-YMACLIPD)*640*2

	MOVE.W	#$8F+4*35+(200-YMACLIPD)*4,$FFFF82A4.W	*VBB - END OF IMAGE - FIN DE VIDEORAM
	MOVE.W	#$8F+4*35,$FFFF82A6.W	*VBE - START OF IMAGE - DEBUT DE VIDEORAM AFFICHE
	MOVE.W	#$8F+4*35,$FFFF82A8.W	*VDB - TOP OVERSC - DEBUT D'ECRAN
	MOVE.W	#$8F+4*35+(200-YMACLIPD)*4,$FFFF82AA.W	*VDE - BOTTOM OVERSC - FIN D'ECRAN

	MOVE.W	#$186+32*3,$FFFF82C0.W	*ECARTEMENT
.NORMSCR


	BSR	INIT_ECRAN
	ST	SEC_VBL
	ST	SEC_VBL_D
	BRA	WAITESP		*BCLE PPALE DU JEU
	
QUIT_GAME
	SF	SEC_VBL
	SF	HUIT_VBLS
	MOVE.L	ECRANG,BASE
	MOVE.L	ECRANG,NEW_ECR
	ST	FLIP_POSSIBLE
	BSR	VSYNC
	BRA	END_OF_GAME
PAUSE_GAME
	SF	SEC_VBL
	BSR	VSYNC
	*RECUPERE ADRESSE ECRAN 
	MOVE.L	VAL_ECRAN,A0
	MOVE.L	LONECR_F,D0
	LSR.L	#2,D0
	SUBQ.L	#1,D0
	MOVE.L	D0,D1
	LEA	(A0),A1
.INV	NOT.L	(A1)+
	DBF	D1,.INV

	*TOUCHE ESPACE
.WAITESP
	TST.B	KEY_TAB+57
	BEQ.S	.WAITESP

.INV2	NOT.L	(A0)+
	DBF	D0,.INV2
	ST	SEC_VBL	
	RTS

GAGNE	*TOUS LES ENNEMIS SONT MORTS
	*APPEL SI GAGNE_F >0
	LEA	TXT_CONG1,A0		*"WELL DONE," COMMANDER"
	MOVEQ	#160-80,D0
	MOVE	YMACLIP_F,D1
	LSR	D1
	BSR	PRINT_T
	LEA	TXT_CONG2,A0
	MOVEQ	#160-9*8,D0
	MOVE	YMACLIP_F,D1
	LSR	D1
	ADD	#17,D1
	BSR	PRINT_T

	*DECREM COMPTEUR
	SUBQ.B	#1,GAGNE_F
	BMI.S	.COMM_AR
	BEQ.S	.COMM_AR
	RTS

	*ARRETE LE JEU
.COMM_AR
	ST	GAGNE_F
	MOVE.L	BASE,A0
	CMP.L	ECRANG,A0
	BEQ.S	.ARR		*CONJONCTION FAVORABLE
	RTS
.ARR
	ADDQ.L	#4,SP		*VIRE UN BSR
	SF	SEC_VBL
	SF	HUIT_VBLS
	MOVE.L	ECRANG,BASE
	MOVE.L	ECRANG,NEW_ECR
	ST	FLIP_POSSIBLE
	BSR	VSYNC

	ADD	#SURVIVAL_SC,SCORE	*ON SURVIT	

	ST	SURVIE_FL

END_OF_GAME
	* FINI
	*DIVERSES PREFERENCES
	LEA	BUF_INF,A0
	MOVE.B	DOUBLE_F,28(A0)
	MOVE.B	DBLH_F,29(A0)
	MOVE.B	DBLVS_F,30(A0)
	MOVE.B  NUM_LEVEL+1,27(A0)
	MOVE.B	PARANOIA_F,26(A0)

	* CALCULE LES POINTS DE SURVIE DES AUTRES
	*EFFACE TABLE HISCORE
	LEA	HI_SCORE_TBL,A0
	MOVEQ	#9,D0
.EFF_TBL
	CLR	(A0)+
	MOVE	#$8000,(A0)+
	CLR	(A0)+
	DBF	D0,.EFF_TBL

	*INCLUSION DANS LA TABLE DU HEROS
	MOVEQ	#0,D4
	MOVE	NBTIRE,D3
	BEQ.S	.NULH
	MOVE	NBTOUC,D4
	MULU	#100,D4
	DIVU	D3,D4
	CMP	#75,D4
	BLT.S	.TST2H
	ADD	#MORE75_SC,SCORE
	ST	MORE75_FL
.TST2H
	CMP	#50,D4
	BLT.S	.NULH
	ADD	#MORE50_SC,SCORE
	ST	MORE50_FL
.NULH
	LEA	HI_SCORE_TBL,A0
	MOVE	#-1,(A0)+		*HEROS
	MOVE	SCORE,(A0)+
	MOVE	D4,(A0)+

	*INIT NOM DU HEROS A PLAYER
	LEA	HEROS_S,A0
	LEA	HEROS,A1
	MOVEQ	#6,D0
.SHER	MOVE	(A0)+,(A1)+
	DBF	D0,.SHER
	

	*DIVERSES INITS
	SF	SEC_VBL
	SF	HUIT_VBLS
	CLR.B	FL_AMIS
	CLR.B	MOUV
	CLR.B	MOUV2


	BSR	APVGA		*INIT SAUF L'ECRAN ET PARAMETRES PHYSIQUES

	MOVE.L	BASE,A0
	BSR	FADE_OUT

	*AFFICHAGE DES BONI
	SF	SEC_VBL_D
	TST.B	DOUBLE_EMUL_F
	BNE.S	.NORMSCR
	MOVE.W	#$3AF,$FFFF82A4.W
	MOVE.W	#$8F,$FFFF82A6.W	*VBE - START OF IMAGE - DEBUT DE VIDEORAM AFFICHE
	MOVE.W	#$8F,$FFFF82A8.W	*VDB - TOP OVERSC - DEBUT D'ECRAN
	MOVE.W	#$3AF,$FFFF82AA.W	*VDE - BOTTOM OVERSC - FIN D'ECRAN
	MOVE.W	#$186,$FFFF82C0.W
.NORMSCR

	BSR	VSYNC		*SUR DE PLUS AVOIR D'HBL
	BSR	RESTORE_SOUND
	JSR	RESTART_MUSIC
	
	LEA	TXT_RESULT,A0		*20 LETTRES
	MOVEQ	#0,D0
	MOVE	#170,D6
	BSR	VAGUE
	
	TST.B	SURVIE_FL
	BEQ.S	.NOSURP
	LEA	TXT_BON3,A0		*14 LETTRES
	MOVE	#160-14*8,D0
	MOVE	#140,D6
	BSR	VAGUE
.NOSURP	
	TST.B	MORE75_FL
	BEQ.S	.NOM75P
	LEA	TXT_BON1,A0		*14 LETTRES
	MOVEQ	#80,D0
	MOVEQ	#110,D6
	BSR	VAGUE
.NOM75P
	TST.B	MORE50_FL
	BEQ.S	.NOM50P
	LEA	TXT_BON2,A0		*14 LETTRES
	MOVEQ	#80,D0
	MOVEQ	#80,D6
	BSR	VAGUE
.NOM50P
	MOVE.B	SURVIE_FL,D0
	OR.B	MORE50_FL,D0
	BNE.S	.YADESBONI
	LEA	TXT_BON4,A0		*NO BONUS
	MOVEQ	#160-64,D0
	MOVEQ	#110,D6
	BSR	VAGUE
.YADESBONI	


	*TESTE LA TABLE DES JOUEURS
	MOVE	NUM_LEVEL,D0
	EXT.L	D0
	MULU	#180,D0
	LEA	(BUF_INF+64,D0.L),A2
	MOVEQ	#9,D1
	MOVE	HI_SCORE_TBL+2,D7
.SEARCHI
	CMP	16(A2),D7
	BLT.S	.NOHISC
	*ON A UN HI SCORE
	*DECALE LA TABLE
	LEA	(BUF_INF+64+18*8,D0.L),A3	*DERNIER
	SUBQ	#1,D1
	BMI.S	.NODEC
.DEC2	MOVEQ	#8,D2
.DEC1	MOVE	(A3),18(A3)
	ADDQ.L	#2,A3
	DBF	D2,.DEC1
	LEA	-18*2(A3),A3
	DBF	D1,.DEC2
.NODEC
	MOVE	HI_SCORE_TBL+2,16(A2)
	MOVE.B	HI_SCORE_TBL+5,15(A2)

	*INPUT DU NOM : PLAC EN A2 ET HEROS
	BSR	INPUT_NAME
	
	BRA.S	.ENDSEARC
.NOHISC
	LEA	18(A2),A2
	DBF	D1,.SEARCHI
.ENDSEARC
	MOVE	NB_AMIS,D0
	SUBQ	#1,D0
	LEA	PILE_AMIS2,A0
.LOPA	
	*CALC DU %
	MOVEQ	#0,D4
	MOVE	30(A0),D3
	BEQ.S	.NULA
	MOVE	28(A0),D4
	MULU	#100,D4
	DIVU	D3,D4
	CMP	#75,D4
	BLT.S	.TST2A
	ADD	#MORE75_SC,26(A0)
.TST2A
	CMP	#50,D4
	BLT.S	.NULA
	ADD	#MORE50_SC,26(A0)
.NULA
	MOVE	D4,30(A0)
	

	CMP	#13,12(A0)
	BEQ.S	.SUITA
	ADD	#SURVIVAL_SC,26(A0)
.SUITA
	BSR	HI_SCORE
	LEA	44(A0),A0
	DBF	D0,.LOPA
	
	MOVE	NB_ENNEMIS,D0
	SUBQ	#1,D0
	LEA	PILE_ENNEMIS2,A0
.LOPE	
	*CALC DU %
	MOVEQ	#0,D4
	MOVE	30(A0),D3
	BEQ.S	.NULE
	MOVE	28(A0),D4
	MULU	#100,D4
	DIVU	D3,D4
	CMP	#75,D4
	BLT.S	.TST2E
	ADD	#MORE75_SC,26(A0)
.TST2E
	CMP	#50,D4
	BLT.S	.NULE
	ADD	#MORE50_SC,26(A0)
.NULE
	MOVE	D4,30(A0)
	CMP	#13,12(A0)
	BEQ.S	.SUITE
	ADD	#SURVIVAL_SC,26(A0)
.SUITE
	BSR	HI_SCORE
	LEA	44(A0),A0
	DBF	D0,.LOPE


	
	MOVE.L	BASE,-(SP)
	MOVE.L	ECRANG,-(SP)
	ADD.L	#128000,ECRANG
	ADD.L	#128000,BASE

	*AFFICHAGE TABLE DES SCORES
	BSR	CLS_FRACT
	*SAUVEGARDE FRACTALE
	MOVE.L	BASE,A0
	LEA	(128000.L,A0),A1
	MOVE	#32000-1,D0
.SOVFRAC
	MOVE.L	(A0)+,(A1)+
	DBF	D0,.SOVFRAC
	
	LEA	TXT_TBL1,A0
	MOVEQ	#0,D1
	MOVEQ	#0,D0
	BSR	PRINT_T

	LEA	TXT_TBL2,A0
	MOVEQ	#0,D0
	MOVE	#199-16,D1
	BSR	PRINT_T

	LEA	HI_SCORE_TBL,A2
	LEA	PF_TBLE,A1
	MOVEQ	#9,D6
	MOVEQ	#17,D1
.AFTBL
	MOVE	(A2)+,D5
	MOVE.L	(A1,D5*4),A0
	MOVEQ	#0,D0
	MOVEM.L	D0-D1/D5-D6/A1-A2,-(SP)
	BSR	PRINT_T
	MOVEM.L	(SP)+,D0-D1/D5-D6/A1-A2
	MOVE	(A2)+,D7
	MOVE	#240,D0
	MOVEM.L	D0-D1/D5-D6/A1-A2,-(SP)
	BSR	PRINT_16T
	MOVEM.L	(SP)+,D0-D1/D5-D6/A1-A2
	MOVE	(A2)+,D7
	MOVE	#240+6*8,D0
	MOVEM.L	D0-D1/D5-D6/A1-A2,-(SP)
	BSR	PRINT_8T
	MOVEM.L	(SP)+,D0-D1/D5-D6/A1-A2
	ADD	#16,D1
	DBF	D6,.AFTBL

	*DEROULE
	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,BASE
	MOVE.L	A0,ECRANG
	ADD.L	#128000,A0
	MOVE.L	A0,SOVREG
	ADD.L	#640,SOVREG
	
	BSR	DEROUL	

	*AFFICHAGE TABLE HI SCORE PERMANENTS POUR LE NIVEAU

	MOVE.L	BASE,-(SP)
	MOVE.L	ECRANG,-(SP)
	ADD.L	#128000,ECRANG
	ADD.L	#128000,BASE

	*REPRISE SAUVEGARDE FRACTALE
	MOVE.L	BASE,A0
	LEA	(128000.L,A0),A1
	MOVE	#32000-1,D0
.RESTFRAC
	MOVE.L	(A1)+,(A0)+
	DBF	D0,.RESTFRAC
	
	MOVE	NUM_LEVEL,D0
	MOVE.L	(PLANS_TXT,D0*4),A0
	MOVEQ	#0,D1
	MOVEQ	#0,D0
	BSR	PRINT_T

	LEA	TXT_TBL2,A0
	MOVEQ	#0,D0
	MOVE	#199-15,D1
	BSR	PRINT_T

	MOVE	NUM_LEVEL,D0
	EXT.L	D0
	MULU	#180,D0
	LEA	(BUF_INF+64,D0.L),A2
	MOVEQ	#9,D6
	MOVEQ	#20,D1
.AFTBL2
	LEA	(A2),A0
	MOVEQ	#14,D0
	MOVEM.L	D0-D1/D5-D6/A1-A2,-(SP)
	BSR	PRINT_T
	MOVEM.L	(SP)+,D0-D1/D5-D6/A1-A2
	LEA	15(A2),A2
	
	MOVEQ	#0,D7
	MOVE.B	(A2)+,D7
	MOVE	#240+6*8,D0
	MOVEM.L	D0-D1/D5-D6/A1-A2,-(SP)
	BSR	PRINT_8T
	MOVEM.L	(SP)+,D0-D1/D5-D6/A1-A2

	MOVE	(A2)+,D7
	MOVE	#240,D0
	MOVEM.L	D0-D1/D5-D6/A1-A2,-(SP)
	BSR	PRINT_16T
	MOVEM.L	(SP)+,D0-D1/D5-D6/A1-A2
	ADD	#16,D1
	DBF	D6,.AFTBL2

	*DEROULE
	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,BASE
	MOVE.L	A0,ECRANG
	ADD.L	#128000,A0
	MOVE.L	A0,SOVREG
	ADD.L	#640,SOVREG
	
	BSR	DEROUL	
		
	TST.B	SURVIE_FL
	BEQ.S	.NEXTLVL
	ADDQ	#1,NUM_LEVEL

	MOVE	#NBPLAN-1,D0
	TST.B	REGISTRE_F
	BNE.S	.TOUS
	MOVEQ	#1,D0		*2 NIVEAUX SI PAS ENREGISTR
.TOUS	CMP	NUM_LEVEL,D0
	BHS.S	.NEXTLVL
	MOVE	D0,NUM_LEVEL
.NEXTLVL

	BRA	RE_GAME		*NOUVEAU JEU
	
WAITESP
	
	BSR	EFFACE_ECRAN
	MOVE.B	DBLH_F2,DBLH_F		*PRISE EN COMPTE MODIF VBL
	MOVE.B	DBLVS_F2,DBLVS_F	*PRISE EN COMPTE MODIF VBL
	
	MOVE.L	#ZTRANS,ZTRANS_P
	MOVE.L	#COORD,COORD_P
	CLR	MURCOUNT
	MOVE.L	#XMIEFF,XMIE_P	
	MOVE.L	#YMIEFF,YMIE_P
	MOVE.L	#XMAEFF,XMAE_P
	MOVE.L	#YMAEFF,YMAE_P
	MOVE.L	#TAMPIMG,P_IMAGE
	CLR	VBLFLAG
	MOVE	DX,DX3
	MOVE	DY,DY3
	MOVE	ANG2,D0
	BSR	MAJ_DX4
	
	TST.B	EVOL_YV
	BEQ.S	.NO_EVOLYV
	SF	EVOL_YV
	*EVOLUTION DE YV
	MOVE.L	YV_PT,A0
	MOVE	(A0)+,D0
	BPL.S	.EVOLYV
	TST.B	DOUBLE_F
	BEQ.S	.YVD
	LEA	YV_TBL,A0
	MOVE	(A0)+,D0
	BRA.S	.EVOLYV
.YVD	LEA	YV_TBLD,A0
	MOVE	(A0)+,D0
.EVOLYV
	MOVE	D0,YV_F
	MOVE.L	A0,YV_PT	
.NO_EVOLYV

	*SEQUENCE D'EVOLUTION DES PORTES
	LEA	PILE_PORTE,A1
	LEA	TBL_PORTE,A0		
	MOVE	NB_PORTE,D2
	SUBQ	#1,D2
.PORTE1
	TST	4(A1)
	BMI.S	.LA
	MOVE.L	(A1),A2			
	BTST	#7,1(A2)	*PERSONNAGE SOUS LA PORTE ?
	BNE.S	.LA		*OUI : PAS D'EVOLUTION
	*1ER MOUVMENT ?
	TST	4(A1)
	BNE.S	.SILENT
	*BRUIT DE PORTE
	MOVEM.L	D0-D2/A0-A1,-(SP)
	LEA	SND_DOOR,A0
	*VOLUME FONCTION DE LA DISTANCE
	MOVE.B	X_POS,D0
	SUB.B	7(A1),D0
	BPL.S	.VALABS
	NEG.B	D0
.VALABS
	MOVE.B	Y_POS,D1
	SUB.B	9(A1),D1
	BPL.S	.VALABS2
	NEG.B	D1
.VALABS2
	ADD.B	D0,D1		*|X|+|Y|
	CMP.B	#8,D1
	BHS.S	.TROP_LOIN
	AND	#$FF,D1
	LSL	#2,D1
	MOVE	D1,D0
	LSL	#3,D1
	LSL.W	#8,D0
	OR.W	D0,D1
	BSR	SOUND
.TROP_LOIN
	MOVEM.L	(SP)+,D0-D2/A0-A1
.SILENT
	ADDQ	#1,4(A1)
	MOVE	4(A1),D0
	TST	(A0,D0*2)			
	BMI.S	.RAZ
	*REND INTRAVERSABLE
	ANDI.B	#%10111111,1(A2)
	CMP	#115,(A0,D0*2)
	BNE.S	.LA
	*REND TRAVERSABLE
	ORI.B	#64,1(A2)
	BRA.S	.LA	
.RAZ	MOVE	#-1,4(A1)	*FIN DE SEQUENCE
.LA	
	LEA	10(A1),A1
	DBF	D2,.PORTE1


	*SEQUENCE D'EVOLUTION DES PERSONNAGE & RECOPIE DES PILES
	*AMIS
	*SYNCRO MODIF VBL
	SF	FLAG_EXCL

	LEA	PILE_AMIS2,A1
	LEA	PILE_AMIS,A2
	MOVE	NB_AMIS,D2
	SUBQ	#1,D2
.AMI1
	MOVEM.L	(A1),D0-D1/D3-D6
	MOVEM.L	D0-D1/D3-D6,(A2)
	MOVEM.L	24(A1),D0-D1/D3-D5
	MOVEM.L	D0-D1/D3-D5,24(A2)
	LEA	44(A2),A2

	TST	12(A1)
	BNE.S	.NOT_LAA	*REPOS
	SUBQ	#1,20(A1)	*DECREMENTE LE COMPTEUR
	BRA	.LAA
.NOT_LAA	
	CMP	#8,12(A1)
	BLT.S	.PASMORT

	CMP	#13,12(A1)
	BEQ	.LAA

	CMP	#12,12(A1)
	BNE.S	.MEURTA			*ON NE PEUT PLUS RIEN POUR LUI
	MOVE	#13,12(A1)
	MOVE.L	PT_MORT,A3
	MOVE.L	(A1),A4
	ORI.B	#128,(A4)
	ANDI.B	#%01111111,1(A4)
	CLR	PLAN2-PLAN(A4)
	MOVE.L	A4,(A3)+
	MOVE.L	4(A1),(A3)+
	CLR	(A3)+		*AMI
	SUBQ	#1,FRIENDS
	ADDQ	#1,NB_MORTS
	MOVE.L	A3,PT_MORT
	BRA	.LAA
.MEURTA
	ADDQ	#1,12(A1)	
	BRA	.LAA
.PASMORT
	CMP	#5,12(A1)
	BLT	.MARCHEA
	*ATTAQUE
	CMP	#6,12(A1)
	BNE	.DEGAINEA		*NON TRAITE
	SUBQ	#1,20(A1)
	BNE	.LAA
	
	*ON BLESSE LA CIBLE 
	MOVE	32(A1),D0	*CIBLE
	CMP	#-1,D0
	BNE.S	.PASHERO
	*MARQUE LE TIREUR
	ST	39(A1)

	*TIR DE PRECISION
	BSR	RND
	CMP	16(A1),D0
	BHI.S	.ENDA
	ADDQ	#1,28(A1)
	BSR	HEROTOUC	*HEROS TOUCH
	BRA.S	.ENDA
.PASHERO
	TST	D0
	BMI.S	.ENNEMIGO
	LEA	PILE_AMIS2,A5
	BRA.S	.AMIGO
.ENNEMIGO	
	LEA	PILE_ENNEMIS2,A5
.AMIGO	
	AND.L	#$7FFF,D0
	SUBQ.L	#2,D0
	ADD.L	D0,A5

*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
	CMP	#8,12(A5)
	BHS.S	.ENDA			*DEJA KAPUTT

	*TIR DE PRECISION
	BSR	RND
	CMP	16(A1),D0
	BHI.S	.RATEA
	
	MOVE	#HIT_SC,D0
	*EST-CE UNE TRAHISON ?
	BTST	#7,32(A1)
	BNE.S	.RIGHTA
	MOVE	#FRIEND_SC,D0
.RIGHTA	
	ADD	D0,26(A1)
	ADDQ	#1,28(A1)
	ADD	#TOUCH_SC,26(A5)
	SUB	#FORCEA,36(A5)
.RATEA
	ST	38(A5)			*MISE A UN DE VIS : AFFICHAGE LASER VALID
	BRA.S	.ENDA
.PASMR	
	CLR	12(A1)
	MOVE	#5,20(A1)		*TEMPS DE REFLEXION APRES ATTAQUE
	BRA.S	.LAA
.DEGAINEA
	SUBQ	#1,20(A1)
	BNE.S	.LAA
.ENDA	MOVE	14(A1),20(A1)
	ADDQ	#1,12(A1)
	CMP	#8,12(A1)
	BEQ.S	.PASMR
	BRA.S	.LAA
.MARCHEA	
	*AVANCE LES JAMBES SI >= 8 VBLS
	TST.B	HUIT_VBLS
	BEQ.S	.LAA	*MOINS DE 8 VBLS POUR L'AFFICHAGE
	ADDQ	#1,12(A1)
	CMP	#5,12(A1)
	BNE.S	.LAA
	MOVE	#1,12(A1)
.LAA
 	LEA	44(A1),A1
	DBF	D2,.AMI1
	*ENNEMIS	
	LEA	PILE_ENNEMIS2,A1
	LEA	PILE_ENNEMIS,A2
	
	MOVE	NB_ENNEMIS,D2
	SUBQ	#1,D2
.ENNEMI1
	MOVEM.L	(A1),D0-D1/D3-D6
	MOVEM.L	D0-D1/D3-D6,(A2)
	MOVEM.L	24(A1),D0-D1/D3-D5
	MOVEM.L	D0-D1/D3-D5,24(A2)
	LEA	44(A2),A2

	TST	12(A1)
	BNE.S	.NOT_LAE	*REPOS
	SUBQ	#1,20(A1)	*DECREMENTE LE COMPTEUR
	BRA	.LAE
.NOT_LAE
	CMP	#8,12(A1)
	BLT.S	.PASMORTE
	CMP	#13,12(A1)
	BEQ	.LAE
	CMP	#12,12(A1)
	BNE.S	.MEURTE			*ON NE PEUT PLUS RIEN POUR LUI
	MOVE	#13,12(A1)
	MOVE.L	PT_MORT,A3
	MOVE.L	(A1),A4
	ORI.B	#128,(A4)
	ANDI.B	#%01111111,1(A4)
	CLR	PLAN2-PLAN(A4)
	MOVE.L	A4,(A3)+
	MOVE.L	4(A1),(A3)+
	MOVE	#1,(A3)+	*ENNEMI
	SUBQ	#1,FOES
	ADDQ	#1,NB_MORTS
	MOVE.L	A3,PT_MORT
	BRA	.LAE
.MEURTE
	ADDQ	#1,12(A1)	
	BRA	.LAE
.PASMORTE

	CMP	#5,12(A1)
	BLT	.MARCHEE
	*ATTAQUE
	CMP	#6,12(A1)
	BNE	.DEGAINEE		*NON TRAITE
	SUBQ	#1,20(A1)
	BNE	.LAE

	*ON BLESSE LA CIBLE 
	MOVE	32(A1),D0	*CIBLE
	CMP	#-1,D0
	BNE.S	.PASHEROE
	*MARQUE LE TIREUR
	ST	39(A1)

	*TIR DE PRECISION
	BSR	RND
	CMP	16(A1),D0
	BHI.S	.ENDE
	ADDQ	#1,28(A1)
	BSR	HEROTOUC	*HEROS TOUCH
	BRA.S	.ENDE
.PASHEROE
	BTST	#15,D0
	BNE.S	.ENNEMIGOE
	LEA	PILE_AMIS2,A5
	BRA.S	.AMIGOE
.ENNEMIGOE
	LEA	PILE_ENNEMIS2,A5
.AMIGOE
	AND.L	#$7FFF,D0
	SUBQ.L	#2,D0
	ADD.L	D0,A5

*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
	CMP	#8,12(A5)
	BHS.S	.ENDE			*DEJA KAPUTT

	*TIR DE PRECISION
	BSR	RND
	CMP	16(A1),D0
	BHI.S	.RATEE

	MOVE	#HIT_SC,D0
	*EST-CE UNE TRAHISON ?
	BTST	#7,32(A1)
	BEQ.S	.RIGHTE
	MOVE	#FRIEND_SC,D0
.RIGHTE
	ADD	D0,26(A1)

	ADDQ	#1,28(A1)
	ADD	#TOUCH_SC,26(A5)
	SUB	#FORCEA,36(A5)			
.RATEE	ST	38(A5)			*MISE A UN DE VIS : AFFICHAGE LASER VALID
	BRA.S	.ENDE
.PASMRE
	CLR	12(A1)		*ATTAQUE FINIE, COUCOU CHAT!
	MOVE	#5,20(A1)
	BRA.S	.LAE
.DEGAINEE
	SUBQ	#1,20(A1)
	BNE.S	.LAE
.ENDE
	MOVE	14(A1),20(A1)
	ADDQ	#1,12(A1)
	CMP	#8,12(A1)
	BEQ.S	.PASMRE
	BRA.S	.LAE
.MARCHEE
	TST.B	HUIT_VBLS
	BEQ.S	.LAE	*MOINS DE 8 VBLS POUR L'AFFICHAGE
	ADDQ	#1,12(A1)
	CMP	#5,12(A1)
	BNE.S	.LAE
	MOVE	#1,12(A1)
.LAE
	LEA	44(A1),A1
	DBF	D2,.ENNEMI1

	ST	FLAG_EXCL	*MOUVEMENT VBL AUTORISE

	*EFFACE FLAG 8 VBLS
	SF	HUIT_VBLS
	
	*CHOIX DU DIR EN FONCTION DE L'ANGLE
	MOVE	ANG2,D0
	MOVE	D0,ANG
	
	*0:135-45   4:315-225 2:135-225 6:RESTE (-45=315 A 45) 

	*0:90+-22.5  4:270+-22.5 2:180+-22.5 6:RESTE 0+-22.5
	*1:135+-22.5  3:225+-22.5 7:45+-22.5   5:315+-22.5
	*  
	CMP	#315*2+45,D0
	BLT.S	.CHX1
	MOVE	#6,DIR
	SUB	#360,ANG
	BRA	.FINCHX
.CHX1
	CMP	#315*2-45,D0
	BLT.S	.CHX2D
	MOVE	#5,DIR
	BRA	.FINCHX
.CHX2D
	CMP	#270*2-45,D0
	BLT.S	.CHX2
	MOVE	#4,DIR	
	BRA	.FINCHX
.CHX2	
	CMP	#225*2-45,D0
	BLT.S	.CHX3D
	MOVE	#3,DIR
	SUB	#180*2,ANG
	BRA.S	.FINCHX
.CHX3D
	CMP	#180*2-45,D0
	BLT.S	.CHX3
	MOVE	#2,DIR
	SUB	#180*2,ANG
	BPL.S	.FINCHX
	ADD	#720,ANG
	BRA.S	.FINCHX
.CHX3	

	CMP	#135*2-45,D0
	BLT.S	.CHX4D
	MOVE	#1,DIR
	BRA.S	.FINCHX

.CHX4D	CMP	#90*2-45,D0
	BLT.S	.CHX4
	CLR	DIR
	BRA.S	.FINCHX
.CHX4	
	CMP	#45*2-45,D0
	BLT.S	.CHX5D
	MOVE	#7,DIR
	ADD	#360,ANG
	BRA.S	.FINCHX
.CHX5D
	MOVE	#6,DIR
	ADD	#360,ANG
.FINCHX
	*AFFICHAGE DES COMPTEURS
	TST.B	DOUBLE_F
	BEQ.S	.NODBLFF
	
	MOVEQ	#3,D0
	MOVE	#171,D1
	MOVE	SCORE,D7
	BSR	PRINT_16
	MOVE	#17*8+6,D0
	MOVE	#171,D1
	MOVE	SHIELD,D7
	BSR	PRINT_16
	MOVE	#29*8,D0
	MOVE	#171-16,D1
	MOVE	FRIENDS,D7
	BSR	PRINT_8
	MOVE	#35*8+2,D0
	MOVE	#171-17,D1
	MOVE	FOES,D7
	BSR	PRINT_8
	*% AGE : 100*NBTOUC/NBTIRE
	MOVE	NBTIRE,D6
	BEQ.S	.NOTIRN
	MOVE	NBTOUC,D7
	AND.L	#$FFFF,D7
	MULU	#100,D7
	AND.L	#$FFFF,D6
	DIVU	D6,D7
	MOVEQ	#7*8+5,D0
	MOVE	#171,D1
	BSR	PRINT_8
.NOTIRN
	BRA.S	.NOTIRD
.NODBLFF
	MOVEQ	#3,D0
	MOVE	#171-YMACLIPD,D1
	MOVE	SCORE,D7
	BSR	PRINT_16
	MOVE	#17*8+6,D0
	MOVE	#171-YMACLIPD,D1
	MOVE	SHIELD,D7
	BSR	PRINT_16
	MOVE	#29*8,D0
	MOVE	#171-16-YMACLIPD,D1
	MOVE	FRIENDS,D7
	BSR	PRINT_8
	MOVE	#35*8+2,D0
	MOVE	#171-17-YMACLIPD,D1
	MOVE	FOES,D7
	BSR	PRINT_8
	*% AGE : 100*NBTOUC/NBTIRE
	MOVE	NBTIRE,D6
	BEQ.S	.NOTIRD
	MOVE	NBTOUC,D7
	AND.L	#$FFFF,D7
	MULU	#100,D7
	AND.L	#$FFFF,D6
	DIVU	D6,D7
	MOVEQ	#7*8+5,D0
	MOVE	#171-YMACLIPD,D1
	BSR	PRINT_8
.NOTIRD
		

	*TESTE SI ON A BUTE TOUT LE MONDE
	TST	FOES
	BNE.S	.PASGAGNE
	TST.B	GAGNE_F
	BNE.S	.PASGAGNE	*SI MAIS DEJA FAIT
	MOVE.B	#50,GAGNE_F	*AFFICHE MESSAGE DU GAGNANT
	*SON DE LA CAVALERIE
	LEA	SND_CHARGE,A0
	MOVEQ	#0,D0
	BSR	SOUND	
	
.PASGAGNE

	IFEQ	INDIC
	
	*AFFICHAGE DE LA DIR CHOISIE
	MOVE.L	BASE,A0
	MOVE	DIR,D0
	SUBQ	#1,D0
	BMI.S	.NOPLOT
.PLOT	MOVE.L	#30,(A0)+
	DBF	D0,.PLOT
.NOPLOT
	MOVEQ	#10,D0
.EFF	CLR.L	(A0)+
	DBF	D0,.EFF
	ENDC
	
	*VUE DE XPOS,YPOS DIRECTION 0
	LEA	PRISE_DE_VUE,A0
	MOVE	DIR,D0				*POINT DE VUE
	MOVE.L	(A0,D0.W*4),A0			
	MOVE.B	(A0)+,D0		*NOMBRE DE CASES
	AND.W	#$FF,D0
	SUBQ	#1,D0
	LEA	PLAN,A1
	MOVE.B	X_POS,D2
	AND.W	#$FF,D2
	ADD	D2,D2
	ADD	D2,A1
	MOVE.B	Y_POS,D2
	AND.W	#$FF,D2
	ASL	#6,D2
	ADD	D2,A1	

	CLR	YTRF
	MOVE	YTR_F,YTRL
	MOVE	#XTR,XTRL
	MOVE	#ZTR,ZTRL
	
	LEA	TABLEDIR,A2
	MOVE	DIR,D7
	JSR	([A2,D7.W*4])	
				*PREPARATION AFFICHAGE
	
	BSR	AFFICHE_SCENE


	*AFFICHAGE DU PISTOLASER
	TST.B	TIR_HEROS
	BEQ	.NORMAL
	ADDQ	#1,NBTIRE
	*SON DU TIR
	*DMA OCCUPE ?
	TST.B	SND_BUSY
	BNE.S	.NOSND
	LEA	SND_LASER,A0
	MOVE	#%0000111111110000,D1
	BSR	SOUND	
.NOSND
	MOVEQ	#0,D7
	BSR	TIR
	*S:D7=LONGUEUR DU TIR
	LEA	LASER,A0	*TC4
	BSR	RND
	MOVE.L	BASE,A1
	TST.B	DOUBLE_F
	BNE.S	.NODBLF
	AND.L	#$3,D0
	ADD.L	#(YMACLIPD-37)*640+320-18,A1	*DEST
	MOVEQ	#38,D1
	BRA.S	.ENCDBLF
.NODBLF
	AND.L	#$7,D0
	ADD.L	#(YMACLIP-75)*640+320-18,A1	*DEST
	MOVEQ	#76,D1		*YLON
.ENCDBLF
	MOVE.L	D0,D2
	MULU	#640,D2
	MOVEQ	#0,D6
	MOVE	D7,D6
	MULU	#640,D6
	ADD.L	D6,A1
	ADD.L	D2,A1
	SUB	D0,D1
	SUB	D7,D1
	MOVE.L	#13*18,D2	*OFFSET
	TST	D7
	BNE.S	.IMPACT
	MOVEQ	#18,D0		*XLON
	BSR	AFF_TRANS
	SF	TIR_HEROS
	TST	QUI_TOUC
	BEQ	.SURNORM
	BRA	.BLESSE
.IMPACT
	MOVE	D7,-(SP)
	TST.B	DOUBLE_F
	BEQ.S	.NDBLF2
	MULU	#18,D7
	BRA.S	.ENCDBLF2
.NDBLF2	
	MULU	#36,D7
.ENCDBLF2
	ADD	D7,D2
	MOVEQ	#18,D0		*XLON
	PEA	(A1)
	BSR	AFF_TRANS
	MOVE.L	(SP)+,A1
	MOVE	(SP)+,D7
	EXT.L	D7
	*FACTEUR DE REDUCTION : 0-33<>1-64    0-16<>1-64 O I
	TST.B	DOUBLE_F
	BEQ.S	.AZE
	NEG	D7
	ADD	#34,D7
	ASL.L	#4,D7
	DIVU	#33,D7
	TST	D7
	BNE.S	.NOPROB
	MOVEQ	#1,D7
.NOPROB
	CMP	#16,D7
	BLT.S	.NOP2
	MOVEQ	#16,D7
.NOP2
	BRA.S	.NOP2D
.AZE
	NEG	D7
	ADD	#17,D7
	BNE.S	.NOPROBD
	MOVEQ	#1,D7
.NOPROBD
	CMP	#16,D7
	BLT.S	.NOP2D
	MOVEQ	#16,D7
.NOP2D
	
	MOVEQ	#32,D6
	DIVU	D7,D6
	MOVEQ	#0,D5
	MOVE	D6,D5
	TST.B	DOUBLE_F
	BNE.S	.EZA
	ASR.L	D5
.EZA
	MULS	#-640,D5
	ADD.L	D5,A1
	ADD	D6,D6
	NEG	D6
	LEA	18(A1,D6),A1
	
	LEA	IMPACT,A0
	MOVEQ	#64,D0
	TST.B	DOUBLE_F
	BEQ.S	.POIL
	MOVEQ	#64,D1
	BRA.S	.APOIL
.POIL
	MOVEQ	#32,D1
.APOIL	
	BSR	AFF_TRANS_ZOOM
	
	SF	TIR_HEROS
	TST	QUI_TOUC
	BEQ	.SURNORM
.BLESSE
	*TRAHISON ?
	CMP	#2,QUI_TOUC
	BNE.S	.AMIT
	ADD	#FRIEND_SC,SCORE
	BRA.S	.ENT
.AMIT
	ADDQ	#HIT_SC,SCORE
.ENT

	*UN TYPE EST TOUCHE - QUI ?
	MOVEQ	#(7*256)/PAS4,D7	*RAYON MAXIMAL
	LEA	PLAN,A6
	MOVE	X_POS,XP_W	*XP DE TRAVAIL
	MOVE	Y_POS,YP_W
.CASE_SUIV		
	MOVE	DX4,D0
	MOVE	DY4,D1
	
		TST	D0
		BPL.S	.XPOSIT
	*XNEG
		NEG	D0
		TST.B	XP_W
		BEQ.S	.TOYMOV
		SUB.B	D0,XP_W+1
		BCC.S	.TOYMOV
		SUBQ.B	#1,XP_W
		BRA.S	.TOYMOV
.XPOSIT
		CMP.B	#31,XP_W
		BEQ.S	.TOYMOV
		ADD.B	D0,XP_W+1
		BCC.S	.TOYMOV
		ADDQ.B	#1,XP_W
.TOYMOV
		TST	D1
		BPL.S	.YPOSIT
*YNEG
		NEG	D1
		TST.B	YP_W
		BEQ.S	.NOJPH
		SUB.B	D1,YP_W+1
		BCC.S	.NOJPH
		SUBQ.B	#1,YP_W
		BRA.S	.NOJPH
.YPOSIT
		CMP.B	#31,YP_W
		BEQ.S	.NOJPH
		ADD.B	D1,YP_W+1
		BCC.S	.NOJPH

		ADDQ.B	#1,YP_W
.NOJPH

	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVE.B	XP_W,D2
	MOVE.B	YP_W,D3
	ADD	D2,D2
	ASL	#6,D3
	ADD	D3,D2
	LEA	(A6,D2),A5
	BTST	#7,1(A5)
	BNE.S	.JAITROUVE
.PASBON
	DBF	D7,.CASE_SUIV
	*DESOLE ! ERREUR QUELQUE PART
	*BREAKPOINT
	
	*NOT.B	$FFFF8209.W	*ON LE SIGNALE
	BRA	.SURNORM
		
.JAITROUVE		
	*VERIFIER QUE C'EST LE BON (AMI OU ENNEMI)
	CMP.L	XYMOI,A5
	BEQ.S	.PASBON		*PAS MOI QUAND MEME
	CMP	#2,QUI_TOUC	*AMI
	BNE.S	.SEREN
	MOVE	PLAN2-PLAN(A5),D1
	BEQ.S	.PASBON
	BTST	#15,D1
	BNE.S	.PASBON
	AND	#$7FFF,D1
	SUBQ	#2,D1			*CORRECTION
	LEA	(PILE_AMIS2,D1),A0	
	
.COMMUN	
	*LE BON ! 
	CMP	#8,12(A0)
	BHS.S	.SURNORM	*DEJA MORT
	*RETIRE 50 AU BOUCLIER
	*SE RETOURNE
	
	CMP	#8,12(A0)
	BHS.S	.NORET
	MOVEM.L	D0-D2/D4/D5/A0/A5,-(SP)
	LEA	(A0),A5
	LEA	X_POS2-4,A0
	*POSITION SOURCE : 4(A5),6(A5)  - CIBLE : 4(A0),6(A0)
	BSR	CALC_DIRANG
	*DIRANG : A0=POINTEUR CIBLE A5=SOURCE D1-2/4-5 UTILISES
	MOVEM.L	(SP)+,D0-D2/D4/D5/A0/A5
.NORET

*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
	SUB	#FORCEH,36(A0)
	ADD	#TOUCH_SC,26(A0)
	ADDQ	#1,NBTOUC

	
	*BPL.S	.SURNORM
	
	*MOVE	#8,12(A0)	*MEURS DONC, INFAME
	
	BRA.S	.SURNORM
.SEREN

	MOVE	PLAN2-PLAN(A5),D1
	BEQ.S	.PASBON
	BTST	#15,D1
	BEQ.S	.PASBON
	AND	#$7FFF,D1
	SUBQ	#2,D1
	LEA	(PILE_ENNEMIS2,D1),A0		

	BRA.S	.COMMUN	
	
.NORMAL
	LEA	LASER,A0	*TC4
	MOVE.L	BASE,A1
	TST.B	DOUBLE_F
	BEQ.S	.FUIL
	ADD.L	#(YMACLIP-12)*640+320-18,A1	*DEST
	MOVEQ	#13,D1		*YLON
	BRA.S	.LUIF
.FUIL
	ADD.L	#(YMACLIPD-6)*640+320-18,A1	*DEST
	MOVEQ	#7,D1
.LUIF
	MOVEQ	#0,D2		*OFFSET
	MOVEQ	#18,D0		*XLON
	BSR	AFF_TRANS
.SURNORM	
	CLR.B	FLAG_EXCL

	*AFFICHAGE EVENTUEL D'UN  TEXTE
	TST.B	TALK_FLAG
	BEQ.S	.NOTALK		
	SF	TALK_FLAG
	MOVE.L	TALK_PTR,A0
	MOVE	#XMICLIP+4,D0
	MOVE	YMACLIP_F,D1
	SUB	#20,D1
	BSR	PRINT_T
.NOTALK
	*AFFICHAGE D'UN MESSAGE DE FIN EVENTUEL
	TST.B	GAGNE_F
	BEQ.S	.NOGAGN
	BSR	GAGNE
.NOGAGN
	********************* GESTION PERSO

	*RECHERCHE DES MORTS QUI S'IGNORENT
	LEA	PILE_AMIS2,A0
	MOVE	NB_AMIS,D0
	SUBQ	#1,D0
.BC1
	TST	36(A0)
	BPL.S	.PA
	CMP	#8,12(A0)
	BHS.S	.PA
	*SON DE LA MORT
	MOVEM.L	D0-D2/A0-A1,-(SP)
	*VOLUME FONCTION DE LA DISTANCE
	MOVE.B	X_POS,D0
	SUB.B	4(A0),D0
	BPL.S	.VALABSA
	NEG.B	D0
.VALABSA
	MOVE.B	Y_POS,D1
	SUB.B	6(A0),D1
	BPL.S	.VALABS2A
	NEG.B	D1
.VALABS2A
	ADD.B	D0,D1		*|X|+|Y|
	CMP.B	#8,D1
	BHS.S	.TROP_LOINA
	AND	#$FF,D1
	LSL	#2,D1
	MOVE	D1,D0
	LSL.W	#8,D0
	LSL.W	#3,D1
	OR.W	D0,D1
	LEA	SND_COUP,A0
	BSR	SOUND
.TROP_LOINA
	MOVEM.L	(SP)+,D0-D2/A0-A1


	MOVE	#8,12(A0)
	CLR	38(A0)
.PA	
	LEA	44(A0),A0
	DBF	D0,.BC1

	LEA	PILE_ENNEMIS2,A0
	MOVE	NB_ENNEMIS,D0
	SUBQ	#1,D0
.BC2
	TST	36(A0)
	BPL.S	.PE
	CMP	#8,12(A0)
	BHS.S	.PE

	*SON DE LA MORT
	MOVEM.L	D0-D2/A0-A1,-(SP)
	*VOLUME FONCTION DE LA DISTANCE
	MOVE.B	X_POS,D0
	SUB.B	4(A0),D0
	BPL.S	.VALABSE
	NEG.B	D0
.VALABSE
	MOVE.B	Y_POS,D1
	SUB.B	6(A0),D1
	BPL.S	.VALABS2E
	NEG.B	D1
.VALABS2E
	ADD.B	D0,D1		*|X|+|Y|
	CMP.B	#8,D1
	BHS.S	.TROP_LOINE
	AND	#$FF,D1
	LSL	#2,D1
	MOVE.W	D1,D0
	LSL.W	#8,D0
	LSL.W	#3,D1
	OR.W	D0,D1
	LEA	SND_COUP,A0
	BSR	SOUND
.TROP_LOINE
	MOVEM.L	(SP)+,D0-D2/A0-A1

	MOVE	#8,12(A0)
	CLR	38(A0)
.PE
	LEA	44(A0),A0
	DBF	D0,.BC2
	
	*ATTAQUE DES PERSONAGES (AVANT EN VBL)
	*SECTION CRITIQUE : PAS DE VBL SVP (SINON TRAVERSE LES MURS)
	
	SF	FLAG_EXCL	*MOUVEMENT VBL INTERDIT
	
	LEA	PLAN,A1
	LEA	PILE_AMIS2,A0
	LEA	PILE_AMIS,A2
	MOVE	NB_AMIS,D7
	SUBQ	#1,D7
	SF	FLAG_EQUIPE	*A 0 = AMI A 1=ENNEMI
	BSR.S	COMMUN_ATTACK
	*ATTAQUE DES ENNEMIS

	LEA	PLAN,A1
	LEA	PILE_ENNEMIS2,A0
	LEA	PILE_ENNEMIS,A2
	MOVE	NB_ENNEMIS,D7
	SUBQ	#1,D7
	ST	FLAG_EQUIPE	*A 0 = AMI A 1=ENNEMI
	BSR.S	COMMUN_ATTACK
	ST	FLAG_EXCL	*MOUVEMENT VBL AUTORISE
	BRA	APRES_LATTAK
COMMUN_ATTACK
*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
	CMP	#5,12(A0)	*ATTAQUE DEJA, MEURT OU MORT
	BHS	.NEXT1
*ON DETERMINE LA POSITION D'UNE EVENTUELLE CIBLE (AMIE OU ENNEMIE)
*EN CAS DE SUCCES, L'ETAT PASSE A 5 ET LE COMPTEUR POSSEDE L'OFFSET
*DANS LE PLAN2 DE LA CIBLE
	MOVE.L	(A0),A6
	MOVE	10(A0),D0
	MOVE.L	(SCRUT_TBL,D0*4),A3		
	MOVEQ	#0,D6
	MOVE.B	(A3)+,D6
	SUBQ	#1,D6
.SCRUT
	MOVE.B	(A3)+,D1
	MOVE.B	(A3)+,D2
	EXT.W	D1
	EXT.W	D2
	ADD	D1,D1
	ASL	#6,D2
	ADD	D2,D1
	BTST	#7,1(A6,D1)
	BNE.S	.TROUVE		*UN PERSO ICI
.WRONG	DBF	D6,.SCRUT	*ON UTILISE CETTE STRUCTURE POUR UTILISER
	BRA	.NEXT1		*LE CACHE INSTRUCTIONS
.TROUVE
	LEA	PLAN2-PLAN(A6),A4

	*Le point vis est-il dans le plan ?
	LEA	(A4,D1),A4
	CMP.L	#PLAN2,A4
	BLO.S	.WRONG
	CMP.L	#PLAN2+32*64,A4
	BHS.S	.WRONG
	
	MOVE	(A4),D2
	BNE.S	.AUTRE			
	*JOUEUR [OU ERREUR] - NON TRAITE
	*METS LA CIBLE A LA VALEUR -1
	MOVEQ	#-1,D2
	*EST-CE UN AMI QUI NS TIRE DESSUS ?
	TST.B	FLAG_EQUIPE
	BNE.S	.COM			
	*TIR DE PARANO
	TST.B	PARANOIA_F
	BEQ.S	.WRONG		*PAS DE PARANO
	MOVE.L	D0,-(SP)
	BSR	RND
	MOVE	D0,D3
	MOVE.L	(SP)+,D0
	CMP	18(A2),D3
	BHI.S	.WRONG		*PAS D'ERREUR
	BRA.S	.COM
.AUTRE
	*BIT 15 A 1=ENNEMIS A 0=AMI
	*MEME EQUIPE ?
	MOVE.B	(A4),D3
	MOVE.B	FLAG_EQUIPE,D4
	EOR.B	D4,D3
	BMI.S	.COM			

	TST.B	PARANOIA_F
	BEQ.S	.WRONG		*PAS DE PARANO
	
	MOVE.L	D0,-(SP)
	BSR	RND
	MOVE	D0,D3
	MOVE.L	(SP)+,D0
	CMP	18(A2),D3
	BHI.S	.WRONG		*PAS D'ERREUR

	*TEST D'ACCESSIBILITE
.COM	MOVE.L	(ACESS_TBL,D0*4),A4	
	MOVE.B	-2(A3),D3
	MOVE.B	-1(A3),D4
	EXT.W	D3		
	EXTB.L	D4			
	ADD	D3,D3
	MOVE	2(A4),D5
	MULS	D5,D4
	ADD	(A4),D4
	ADD	D4,D3
	MOVE	4(A4,D3),D3	*POINTEUR D'ACCES
	MOVE.L	(CHEM_TBL,D0*4),A4	
	LEA	(A4,D3),A4
	MOVE.B	(A4)+,D3
	EXT.W	D3
	BMI	.WRONG		*ERREUR !!!!!!
	BEQ.S	.GO		*BOUT PORTANT
	SUBQ	#1,D3
.CHEMIN
	MOVE.B	(A4)+,D4
	MOVE.B	(A4)+,D5
	EXT.W	D4
	EXT.W	D5
	ADD	D4,D4
	ASL	#6,D5
	ADD	D5,D4
	MOVE	(A6,D4),D4
	*D4 EST-IL TRAVERSABLE PAR UN LASER ?
	TST.B	D4
	BEQ.S	.TRAVER		*VIDE
	*CERTAINS OBJETS
	BTST	#6,D4		*TRAVERSABLE ?
	BNE.S	.TRAVER
		*BTST	#15,D4	*FACULTATIF ?
		*BNE.S	.TRAVER
	BTST	#5,D4		*BIT O
	BEQ	.WRONG		*PORTE FERMEE, MUR OU PERSO
	*LASER TRAVERSABLE NON TRAVER : TABLE 2,TROU 3,OBJET 5
	AND	#%111111100000000,D4
	CMP	#%000001000000000,D4
	BEQ.S	.TRAVER
	CMP	#%000001100000000,D4
	BEQ.S	.TRAVER
	CMP	#%000010100000000,D4
	BNE	.WRONG
.TRAVER	
	DBF	D3,.CHEMIN
.GO	*SELECTION COMME CIBLE VALIDEE
	MOVE	D2,32(A0)	*OFFSET CIBLE
	*SI C'EST PAS LE JOUEUR (KISDEMERDE!) ON SE RETOURNE
	CMP	#-1,D2
	BEQ.S	.KILL
	
	
	TST	D2
	BMI.S	.ENNEMIGO
	LEA	PILE_AMIS2,A5
	BRA.S	.AMIGO
.ENNEMIGO	
	LEA	PILE_ENNEMIS2,A5
.AMIGO	
	AND.L	#$7FFF,D2
	SUBQ.L	#2,D2
	ADD.L	D2,A5
	
*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
	CMP	#8,12(A5)
	BLO.S	.KILLR		*DEJA MORT : PAS D'ATTAQUE
	CLR	32(A0)		*
	CLR	32(A2)
	BRA	.NEXT1
.KILLR	
	*POSITIONNE PARAMETRES LASER
	SF	38(A5)	*AFFICHAGE NON VALID POUR LA CIBLE
	
	MOVE.B	4(A0),D4
	SUB.B	4(A5),D4
	MOVE.B	D4,40(A5)	*INIT DX & DY LASER
	MOVE.B	5(A0),D4
	SUB.B	5(A5),D4
	MOVE.B	D4,41(A5)	*INIT DX & DY LASER
	MOVE.B	6(A0),D4
	SUB.B	6(A5),D4
	MOVE.B	D4,42(A5)	*INIT DX & DY LASER
	MOVE.B	7(A0),D4
	SUB.B	7(A5),D4
	MOVE.B	D4,43(A5)	*INIT DX & DY LASER

	*SI A L'ARRET PASSE EN MARCHE
	TST	12(A5)
	BNE.S	.PASALARET
	MOVE	#1,12(A5)	*MARCHE
.PASALARET
	
	*POSITION SOURCE : 4(A5),6(A5)  - CIBLE : 4(A0),6(A0)
	*ON NE CALCULE QUE L'OCTANT
	BSR	CALC_DIRANG
	*DIRANG : A0=POINTEUR CIBLE A5=SOURCE D1-2/4-5 UTILISES
.KILL
	*VALIDE L'ATTAQUE
	ADDQ	#1,30(A2)	*NB TIRE
	ADDQ	#1,30(A0)	*NB TIRE
				*DEPASSEMENT ?
	BCC.S	.NOOVER
	*DIVISE PAR 16 NB TOUCHE ET NB TIRE
	MOVE	#4096,30(A0)
	MOVE	#4096,30(A2)
	MOVE	28(A0),D4
	LSR	#4,D4
	MOVE	D4,28(A0)
	MOVE	D4,28(A2)
	
.NOOVER				
	MOVE	#5,12(A0)	*ETAT : ATTAQUANT 
	MOVE	#5,12(A2)	*ETAT : ATTAQUANT 
	MOVE	14(A2),20(A0)	*COMPTEUR=REFLEXES 
	MOVE	14(A2),20(A2)	*COMPTEUR=REFLEXES 

.NEXT1
	LEA	44(A0),A0
	LEA	44(A2),A2
	DBF	D7,COMMUN_ATTACK
	RTS
	
APRES_LATTAK
	ST	FLAG_EXCL

	
	IFEQ	INDIC
	*AFFICHAGE DU NOMBRE DE VBLS	
	MOVE.L	BASE,A0
	LEA	640*2(A0),A0
	MOVE	VBLFLAG,D0
	SUBQ	#1,D0
	BMI.S	.NOPLOT2
.PLOT2	MOVE.L	#30*32*64,(A0)+
	ADDQ.L	#2,A0
	DBF	D0,.PLOT2
.NOPLOT2
	MOVE	#200,D0
.EFF2	CLR.L	(A0)+
	DBF	D0,.EFF2
	ENDC

	*AFFICHAGE DU CADRE SI NECESSAIRE
	MOVE.L	BASE,A0
	TST.B	DOUBLE_F
	BNE.S	.NODBLF
	MOVE.L	#XMACLIP*2+YMICLIPD*640+2-640,D0
	MOVE	#(YMACLIPD-YMICLIPD)/8-1,D1
	BRA.S	.ENDCDBLF
.NODBLF
	MOVE.L	#XMACLIP*2+YMICLIP*640+2-640,D0
	MOVE	#(YMACLIP-YMICLIP)/8-1,D1
.ENDCDBLF
	
	LEA	(A0,D0.L),A1
	MOVE	#COULCAD,D0
.VERT	
I	SET	0
	REPT	8
	MOVE	D0,640*I(A1)
I	SET	I+1
	ENDR
	LEA	8*640(A1),A1
	DBF	D1,.VERT

	TST.B	DOUBLE_F
	BNE.S	.NODBLFQ
	MOVE	#((YMACLIPD-YMICLIPD)-8*((YMACLIPD-YMICLIPD)>>3))+1,D1
	BRA.S	.ENCDBLFQ
.NODBLFQ
	MOVE	#((YMACLIP-YMICLIP)-8*((YMACLIP-YMICLIP)>>3))+1,D1
.ENCDBLFQ

.VERT2	MOVE	D0,(A1)
	LEA	640(A1),A1
	DBF	D1,.VERT2
	
	*	FIN_BOUCLE_PPALE *******************************************************


*	MOVE.W	#2,$FFFF8A20.W	*X SRC INC
*	MOVE.W	#2,$FFFF8A22.W	*Y SRC INC
*	MOVE.L	#IMAGE,$FFFF8A24.W	*SRC ADR
*	MOVE.W	#-1,$FFFF8A28.W	*MSK1
*	MOVE.W	#-1,$FFFF8A2A.W	*MSK2
*	MOVE.W	#-1,$FFFF8A2C.W	*MSK3
*	MOVE.W	#2,$FFFF8A2E.W	*X DEST INC
*	MOVE.W	#258,$FFFF8A30.W	*Y DEST INC
*	MOVE.L	DEST,$FFFF8A32.W	*DESTINATION ADR
*	MOVE.W	#192,$FFFF8A36.W	*X COUNT
*	MOVE.W	#100,$FFFF8A38.W		*Y COUNT
	*rvb, vbl<=140; vga vbl<=92
	
*	MOVE.B	#3,$FFFF8A3B.W		*SRCE
*	MOVE.B	#2,$FFFF8A3A.W		*PAS DE HALF-TONE
*	CLR.B	$FFFF8A3D.W
*	MOVE.B	#%11000000,$FFFF8A3C	*DEPART

	
	*FLIP ECRAN
	TST.B	FLIP_POSSIBLE		*MOINS D'UNE VBL POUR LE MUR PRECEDENT->WAIT
	BEQ.S	.NORMAL2
	BSR	VSYNC
.NORMAL2
	MOVE.L	BASE,D0
	MOVE.L	D0,NEW_ECR
	ST	FLIP_POSSIBLE		*FLAG POUR FLIP VBL
	
	CMP.L	ECRANG,D0
	BEQ.S	.FLP1
	
	MOVE.L	ECRANG,D1
	ADD.L	LONECR_F,D1
	CMP.L	D1,D0
	BEQ.S	.FLP0
	
	MOVE.L	ECRANG,D0	
	BRA.S	.FLP2
.FLP1
	MOVE.L	ECRANG,D0
	ADD.L	LONECR_F,D0
	BRA.S	.FLP2
.FLP0	MOVE.L	ECRANG,D0
	ADD.L	LONECR_F,D0
	ADD.L	LONECR_F,D0

.FLP2
	MOVE.L	D0,BASE

*	CLAVIER ET MOUVEMENTS ENREGISTRES EN VBL

	CMP.B	#1,FC02		*ESC
	BEQ	QUIT_GAME
	CMP.B	#25,FC02	*'P'
	BNE.S	.NOPG
	BSR	PAUSE_GAME
.NOPG
	MOVE	X_POS2,X_POS
	MOVE	Y_POS2,Y_POS
	MOVE	ANG32,ANG2
	
	BRA	WAITESP

********************************************** INITS BACK - DEPUIS LE JEU
ENDE	
	BSR	RESTORE_SOUND
ENDE2
	BSR	END_MUSIC
	MOVE.L	SOVCOL0,$FFFF9800.W

	*END DSP
	MOVE.L	#"END",D0
	BSR	DSP_WRITE
	MOVE	#$69,-(SP)
	TRAP	#14
	ADDQ.L	#2,SP		*UNLOCK DSP

	MOVE.L	SOV70,$70.W

	MOVE.B	SOVMFP,$FFFFFA07.W
	MOVE.B	SOVMFP+1,$FFFFFA09.W

	MOVE.L	SOV120,$120.W


	BSR	RELACH
	MOVE	#$13,D0
	BSR	WRITE_IKBD	*PAUSE
	
	
	*BSR 	FLUSH
	
	
	MOVE.L	SOV118,$118.W
	
	MOVE	#$11,D0
	BSR	WRITE_IKBD

	MOVEQ 	#$8,D0			; restore mouse.
	BSR 	WRITE_IKBD
		
	*MOVE	#$2700,SR
	*MFP


	*RECUPERE LES PARAMETRES ECRANS
	MOVE.B	SOVSCR+3,$FFFF8265.W
	MOVE.B	SOVSCR+4,$FFFF8260.W
	MOVE.B	SOVSCR,$FFFF8201.W
	MOVE.B	SOVSCR+1,$FFFF8203.W
	MOVE.B	SOVSCR+2,$FFFF820D.W
	

*	LEA	SOVIDEL,A0
*	MOVE.W	(A0)+,$FFFF820E.W
*	MOVE.W	(A0)+,$FFFF8210.W
*	MOVE.W	(A0)+,$FFFF8266.W
*	MOVE.W	(A0)+,$FFFF8282.W
*	MOVE.W	(A0)+,$FFFF8284.W
*	MOVE.W	(A0)+,$FFFF8286.W
*	MOVE.W	(A0)+,$FFFF8288.W
*	MOVE.W	(A0)+,$FFFF828A.W
*	MOVE.W	(A0)+,$FFFF828C.W
*	MOVE.W	(A0)+,$FFFF828E.W
*	MOVE.W	(A0)+,$FFFF8290.W
*	MOVE.W	(A0)+,$FFFF82A2.W
*	MOVE.W	(A0)+,$FFFF82A4.W
*	MOVE.W	(A0)+,$FFFF82A6.W
*	MOVE.W	(A0)+,$FFFF82A8.W
*	MOVE.W	(A0)+,$FFFF82AA.W
*	MOVE.W	(A0)+,$FFFF82AC.W
*	MOVE.W	(A0)+,$FFFF82C2.W
*	MOVE.W	(A0)+,$FFFF82C0.W
	
	MOVE	SOVSR,D0
	MOVE	D0,SR		*MOVE SOVSR,-(SP)+RTE A EVITER/68030
	RTS
	
CLAV	
	*INTERRUPRION CLAVIER - GERE DIFFERENTES TOUCHES + SOURIS
	MOVE	#$2700,SR
	PEA 	(A0)
	MOVE.L 	D0,-(SP)
	MOVE.L 	D1,-(SP)
		
	MOVE.B 	$FFFFFC00.W,D0
	BTST 	#7,D0			; int req?
	BEQ 	.end			
	BTST 	#0,D0			; 
	BEQ.S 	.end

	LEA 	KEY_TAB(PC),A0
	MOVE.B 	$FFFFFC02.W,D0
	TST.B	FL_JOY
	BEQ.S	.NOJOY
	CLR.B	FL_JOY
	MOVE.B	D0,JOY_STATE
	BRA.S	.end
.NOJOY
		TST.B	M_FLAG
		BEQ.S	.NO_MICE
		CMP.B	#1,M_FLAG
		BNE.S	.DY
		MOVE.B	D0,M_DELTAX
		MOVE.B	#2,M_FLAG
		MOVE.L 	(SP)+,D1
		MOVE.L 	(SP)+,D0
		MOVE.L 	(SP)+,A0
		RTE
.DY		MOVE.B	D0,M_DELTAY
		CLR.B	M_FLAG
		MOVE.L 	(SP)+,D1
		MOVE.L 	(SP)+,D0
		MOVE.L 	(SP)+,A0
		RTE
.NO_MICE
		CMP.B	#$FF,D0		*JOY 1
		BEQ.S	.JOYSTICK
		MOVE.B	D0,D1
		AND.B	#%11111100,D1
		CMP.B	#%11111000,D1
		BEQ.S	.SOURIS
	MOVE.B	 D0,FC02			; store keypress
	BGE.S 	.pressed 			; naff naff ultra naff
.released	
	AND.W 	#$7F,D0
	SF.B 	(A0,D0)
.end	MOVE.L 	(SP)+,D1
	MOVE.L 	(SP)+,D0
	MOVE.L 	(SP)+,A0
	RTE
.pressed
	AND.W 	#$7F,D0
	ST 	(A0,D0)
	MOVE.L 	(SP)+,D1
	MOVE.L 	(SP)+,D0
	MOVE.L 	(SP)+,A0
	RTE
.JOYSTICK
	ST	FL_JOY
	MOVE.L 	(SP)+,D1
	MOVE.L 	(SP)+,D0
	MOVE.L 	(SP)+,A0
	RTE
	
.SOURIS		*RAPPORT DE POSITION
		MOVE.B	#1,M_FLAG
		AND.B	#%11,D0
		MOVE.B	D0,M_BUTTON
		MOVE.L  (SP)+,D1
		MOVE.L 	(SP)+,D0
		MOVE.L  (SP)+,A0
		RTE

			
FC02		DC.W 0
		DC.W	0
KEY_TAB		DS.B 256			; 'held' down table!
M_DELTAX	DC.B	0		*MOUSE DELTAS
M_DELTAY	DC.B	0
M_BUTTON	DC.B	0
M_FLAG		DC.B	0		*0=RIEN, 1=1ER OCTET 2=2EME OC ATTENDU
FL_JOY		DC.B	0
JOY_STATE	DC.B	0		* %T000DGBH
		EVEN
; Flush IKBD

FLUSH		BTST.B #0,$FFFFFC00.W		; any waiting?
		BEQ.S .flok			; exit if none waiting.
		MOVE.B $FFFFFC02.W,D0		; get next in queue
		BRA.S FLUSH			; and continue
.flok		RTS

; Write d0 to IKBD

WRITE_IKBD	BTST.B #1,$FFFFFC00.W
		BEQ.S WRITE_IKBD			; wait for ready
		MOVE.B D0,$FFFFFC02.W		; and send...
		RTS

	


MOVEMENT
	*D0=DX D1=DY
	MOVE.L	XYMOI,A0
		
	TST	D0
	BPL.S	.XPOSIT
*XNEG
	NEG	D0
	TST.B	X_POS2
	BEQ	.TOYMOV

	SUB.B	D0,X_POS2+1
	BCC.S	.NOJUMP
	SUBQ.B	#1,X_POS2
	BRA.S	.TOYMOV

.NOJUMP	CMP.B	#EPAISS,X_POS2+1
	BHS.S	.TOYMOV

	TST.B	640+32*64-1(A0)
	BNE.S	.NOMOV
	MOVE.B	-1(A0),D3
	BEQ.S	.TOYMOV
	BTST	#7,D3
	BNE.S	.NOMOV
	BTST	#6,D3
	BNE.S	.TOYMOV

.NOMOV	MOVE.B	#EPAISS,X_POS2+1
	BRA.S	.TOYMOV
.XPOSIT
	CMP.B	#31,X_POS2
	BEQ.S	.TOYMOV

	ADD.B	D0,X_POS2+1
	BCC.S	.NOJUMP2
	ADDQ.B	#1,X_POS2
	BRA.S	.TOYMOV
.NOJUMP2
	CMP.B	#256-EPAISS,X_POS2+1
	BLS.S	.TOYMOV

	TST.B	640+32*64+3(A0)
	BNE.S	.NOMOV2

	MOVE.B	3(A0),D3
	BEQ.S	.TOYMOV
	BTST	#7,D3
	BNE.S	.NOMOV2
	BTST	#6,D3
	BNE.S	.TOYMOV
	
.NOMOV2	MOVE.B	#256-EPAISS,X_POS2+1
	
.TOYMOV
	
	TST	D1
	BPL.S	.YPOSIT
*YNEG
	NEG	D1
	TST.B	Y_POS2
	BEQ	.NOJPH
	
	SUB.B	D1,Y_POS2+1
	BCC.S	.NOJUMP3
	
	SUBQ.B	#1,Y_POS2
	BRA.S	.NOJPH
.NOJUMP3
	CMP.B	#EPAISS,Y_POS2+1
	BHS.S	.NOJPH

	TST.B	640+32*64-63(A0)
	BNE.S	.NOMOV3

	MOVE.B	-63(A0),D3
	BEQ.S	.NOJPH
	BTST	#7,D3
	BNE.S	.NOMOV3
	BTST	#6,D3
	BNE.S	.NOJPH
.NOMOV3	MOVE.B	#EPAISS,Y_POS2+1
	BRA.S	.NOJPH
.YPOSIT
	CMP.B	#31,Y_POS2
	BEQ.S	.NOJPH

	ADD.B	D1,Y_POS2+1
	BCC.S	.NOJUMP4

	ADDQ.B	#1,Y_POS2
	RTS
.NOJUMP4
	CMP.B	#256-EPAISS,Y_POS2+1
	BLS.S	.NOJPH
	
	TST.B	640+32*64+65(A0)
	BNE.S	.NOMOV4

	MOVE.B	65(A0),D3
	BEQ.S	.NOJPH
	BTST	#7,D3
	BNE.S	.NOMOV4
	BTST	#6,D3
	BNE.S	.NOJPH
.NOMOV4	MOVE.B	#256-EPAISS,Y_POS2+1
.NOJPH
	RTS

MOVEMENT2
	*MOUVEMENT D'UN PERSONNAGE
	*
	*D0=DX D1=DY	A0=ADRESSE DANS LE PLAN
	*A1=ADR DANS LA PILE 4(A1)=XPOS 6(A1)=YPOS
	*FLAG DE COLLISION : D4
	MOVEQ	#0,D4

	TST	D0
	BPL.S	.XPOSIT

*XNEG
	NEG	D0
	TST.B	4(A1)
	BEQ.S	.TOYMOV
	SUB.B	D0,5(A1)
	BCC.S	.NOJUMP
	SUBQ.B	#1,4(A1)
	BRA.S	.TOYMOV

.NOJUMP	CMP.B	#EPAISS,5(A1)
	BHS.S	.TOYMOV

	TST.B	640+32*64-1(A0)
	BNE.S	.NOMOV

	MOVE.B	-1(A0),D3
	BEQ.S	.TOYMOV
	BTST	#7,D3
	BNE.S	.NOMOV
	BTST	#6,D3
	BNE.S	.TOYMOV
.NOMOV	
	MOVEQ	#1,D4
	MOVE.B	#EPAISS,5(A1)
	BRA.S	.TOYMOV
.XPOSIT
	CMP.B	#31,4(A1)
	BEQ.S	.TOYMOV

	ADD.B	D0,5(A1)
	BCC.S	.NOJUMP2
	ADDQ.B	#1,4(A1)
	BRA.S	.TOYMOV
.NOJUMP2
	CMP.B	#256-EPAISS,5(A1)
	BLS.S	.TOYMOV
	
	TST.B	640+32*64+3(A0)
	BNE.S	.NOMOV2

	MOVE.B	3(A0),D3
	BEQ.S	.TOYMOV
	BTST	#7,D3
	BNE.S	.NOMOV2
	BTST	#6,D3
	BNE.S	.TOYMOV
.NOMOV2
	MOVEQ	#1,D4
	MOVE.B	#256-EPAISS,5(A1)
	
.TOYMOV
	
	TST	D1
	BPL.S	.YPOSIT
*YNEG
	NEG	D1
	TST.B	6(A1)
	BEQ.S	.NOJPH
	
	SUB.B	D1,7(A1)
	BCC.S	.NOJUMP3
	
	SUBQ.B	#1,6(A1)
	BRA.S	.NOJPH
.NOJUMP3
	CMP.B	#EPAISS,7(A1)
	BHS.S	.NOJPH

	TST.B	640+32*64-63(A0)
	BNE.S	.NOMOV3

	MOVE.B	-63(A0),D3
	BEQ.S	.NOJPH
	BTST	#7,D3
	BNE.S	.NOMOV3
	BTST	#6,D3
	BNE.S	.NOJPH

.NOMOV3	
	MOVEQ	#1,D4
	MOVE.B	#EPAISS,7(A1)
	BRA.S	.NOJPH
.YPOSIT
	CMP.B	#31,6(A1)
	BEQ.S	.NOJPH

	ADD.B	D1,7(A1)
	BCC.S	.NOJUMP4

	ADDQ.B	#1,6(A1)
	RTS
.NOJUMP4
	CMP.B	#256-EPAISS,7(A1)
	BLS.S	.NOJPH
	
	TST.B	640+32*64+65(A0)
	BNE.S	.NOMOV4

	MOVE.B	65(A0),D3
	BEQ.S	.NOJPH
	BTST	#7,D3
	BNE.S	.NOMOV4
	BTST	#6,D3
	BNE.S	.NOJPH
.NOMOV4	
	MOVEQ	#1,D4
	MOVE.B	#256-EPAISS,7(A1)
.NOJPH
	RTS


MAJ_DX	*MISE A JOUR DE DX&DY A PARTIR DE ANG
	
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	MOVE	ANG2,D3
	MOVE	(A1,D3.W*2),D1	*D1=SIN
	MOVE	(A0,D3.W*2),D0	*D0=COS
	EXT.L	D0
	EXT.L	D1
	MOVE	PAS2_VBL,D2
	NEG	D2
	MULS	D2,D0
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ASR.L	#7,D0	
	ASR.L	#8,D0
	
	MOVE	D0,DX
	MOVE	D1,DY
	RTS

MAJ_DX2	*MISE A JOUR DE DX2&DY2 A PARTIR DE ANG  + SOURIS
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	MOVE	ANG2,D0
	MOVE	(A1,D0.W*2),D1	*D1=SIN
	MOVE	(A0,D0.W*2),D0	*D0=COS
	EXT.L	D0
	EXT.L	D1
	MOVE	PAS2_VBL2,D2

	MULS	D2,D0
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ASR.L	#7,D0	
	ASR.L	#8,D0
	MOVE	D0,DX2
	MOVE	D1,DY2
	RTS
MAJ_DX3	*MISE A JOUR DE DX&DY A PARTIR DE D3 ET METS DANS D0 ET D1
	PEA	(A0)
	PEA	(A1)
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	MOVE	(A1,D3.W*2),D1	*D1=SIN
	MOVE	(A0,D3.W*2),D0	*D0=COS
	EXT.L	D0
	EXT.L	D1
	MULS	#PAS3,D0
	MULS	#-PAS3,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ASR.L	#7,D0	
	ASR.L	#8,D0
	
	MOVE.L	(SP)+,A1
	MOVE.L	(SP)+,A0
	RTS

MAJ_DX4	*MISE A JOUR DE DX&DY A PARTIR DE D0 ET METS DANS DX4&DY4
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	MOVE	ANG2,D0
	MOVE	(A1,D0.W*2),D1	*D1=SIN
	MOVE	(A0,D0.W*2),D0	*D0=COS
	EXT.L	D0
	EXT.L	D1
	MOVE	#PAS4,D2
	NEG	D2
	MULS	D2,D0
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#7,D0	

	ASR.L	#8,D1
	ASR.L	#8,D0
	
	MOVE	D0,DX4
	MOVE	D1,DY4
	RTS


ANTI_ALIA	*IDEM FILTRE SUR TOUT L'ECRAN
		*FILTRE (A0),(A1)
	*CONVOLUTION SELON  0 1 0/ 1 2-3 1 /0 1 0
	
	MOVE	#320*200-1,D7
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
.LOOP
	MOVE	-640(A0),D0
	MOVE	D0,D1
	MOVE	D1,D2
	AND.L	#%1111100000000000,D0
	AND.L	#%0000011111100000,D1
	AND.L	#%0000000000011111,D2
	
	MOVE	-2(A0),D3
	BEQ.S	.SKIP2
	MOVE	D3,D4
	MOVE	D4,D5
	AND	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D5,D2
.SKIP2
	
	MOVE	(A0),D3
	BEQ.S	.SKIP3
	MOVE	D3,D4
	MOVE	D4,D5
	AND	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	
	LSL.L	#2,D3	
	ADD.L	D3,D0
	LSL	#2,D4
	ADD.L	D4,D1
	LSL	#2,D5
	ADD.L	D5,D2
.SKIP3

	MOVE	2(A0),D3
	BEQ.S	.SKIP4
	MOVE	D3,D4
	MOVE	D4,D5
	AND.L	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D5,D2
.SKIP4
	
	MOVE	640(A0),D3
	BEQ.S	.SKIP5
	MOVE	D3,D4
	MOVE	D4,D5
	AND	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D5,D2
.SKIP5
	*SOMME DES COEF=7 > 8 POUR ASSOMBRIR
	LSR.L	#3,D0
	LSR.L	#3,D1
	LSR.L	#3,D2
	AND	#%1111100000000000,D0
	AND	#%0000011111100000,D1
	AND	#%0000000000011111,D2
	
	MOVE	D2,D3
	ADD	D0,D3
	ADD	D1,D3
	MOVE	D3,(A1)+
	
	ADDQ.L	#2,A0
	DBF	D7,.LOOP
	RTS

FILTRE		*FILTRE (A0),(A1)
	*CONVOLUTION SELON  0 1 0/ 1 2-3 1 /0 1 0
	
	TST.B	DOUBLE_F
	BNE.S	.NODBLF
	LEA	XMICLIP*2+YMICLIPD*640(A0),A0
	LEA	XMICLIP*2+YMICLIPD*640(A1),A1
	MOVE	#YMACLIPD-YMICLIPD,D7
	BRA.S	.ENCDBLF
.NODBLF
	LEA	XMICLIP*2+YMICLIP*640(A0),A0
	LEA	XMICLIP*2+YMICLIP*640(A1),A1
	MOVE	#YMACLIP-YMICLIP,D7
.ENCDBLF

	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
.LOOP1
	MOVE	#XMACLIP-XMICLIP,D6
	LEA	(A0),A2
	LEA	(A1),A3
.LOOP2
	MOVE	-640(A0),D0
	MOVE	D0,D1
	MOVE	D1,D2
	AND.L	#%1111100000000000,D0
	AND.L	#%0000011111100000,D1
	AND.L	#%0000000000011111,D2
	
	MOVE	-2(A0),D3
	BEQ.S	.SKIP2
	MOVE	D3,D4
	MOVE	D4,D5
	AND	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D5,D2
.SKIP2
	
	MOVE	(A0),D3
	BEQ.S	.SKIP3
	MOVE	D3,D4
	MOVE	D4,D5
	AND	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	LSL.L	#2,D3	
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D4,D1
	ADD.L	D4,D1
	ADD.L	D5,D2
	ADD.L	D5,D2
	ADD.L	D5,D2
.SKIP3

	MOVE	2(A0),D3
	BEQ.S	.SKIP4
	MOVE	D3,D4
	MOVE	D4,D5
	AND.L	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D5,D2
.SKIP4
	
	MOVE	640(A0),D3
	BEQ.S	.SKIP5
	MOVE	D3,D4
	MOVE	D4,D5
	AND	#%1111100000000000,D3
	AND	#%0000011111100000,D4
	AND	#%0000000000011111,D5
	ADD.L	D3,D0
	ADD.L	D4,D1
	ADD.L	D5,D2
.SKIP5
	*SOMME DES COEF=7 > 8 POUR ASSOMBRIR
	LSR.L	#3,D0
	LSR.L	#3,D1
	LSR.L	#3,D2
	AND	#%1111100000000000,D0
	AND	#%0000011111100000,D1
	AND	#%0000000000011111,D2
	
	MOVE	D2,D3
	ADD	D0,D3
	ADD	D1,D3
	MOVE	D3,(A1)+
	
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2
	LEA	640(A2),A0
	LEA	640(A3),A1
	DBF	D7,.LOOP1
	RTS
	
HADES	*  MORT DU JOUEUR 
	SF	SEC_VBL		*COUPE LE MOUVEMENT VBL
	SF	FLIP_POSSIBLE
	*SON DU MORT
	LEA	SND_FIN,A0
	MOVEQ	#0,D1
	BSR	SOUND
	
	*RECOPIE LES 3 BAS D'ECRANS L'UN SUR L'AUTRE
	MOVE.L	ECRANG,A0
	TST.B	DOUBLE_F
	BNE.S	.DBLF
	ADD.L	#640*YMACLIPD,A0
	MOVE	#(200-2*YMACLIPD)*160-1,D0
	LEA	(LONECRD,A0),A1
	LEA	(2*LONECRD,A0),A2
	BRA.S	.RCPY
.DBLF
	ADD.L	#640*YMACLIP,A0
	MOVE	#(200-YMACLIP)*160-1,D0
	LEA	(128000.L,A0),A1
	LEA	(256000.L,A0),A2

.RCPY	MOVE.L	(A0),(A1)+
	MOVE.L	(A0)+,(A2)+
	DBF	D0,.RCPY
	
.LOOP	
	MOVE.L	NEW_ECR,A0	*SOURCE FILTRE (IMAGE A L'ECRAN)	
	MOVE.L	BASE,A1		*DESTINATION FILTRE

	BSR	FILTRE		*CONVOLUTION
	
	*FIN - FLIP ET GESTION ECRAN
	TST.B	FLIP_POSSIBLE		*MOINS D'UNE VBL POUR LE MUR PRECEDENT->WAIT
	BEQ.S	.NORMAL2
	BSR	VSYNC
.NORMAL2
	MOVE.L	BASE,D0
	MOVE.L	D0,NEW_ECR
	ST	FLIP_POSSIBLE		*FLAG POUR FLIP VBL
	
	CMP.L	ECRANG,D0
	BEQ.S	.FLP1
	MOVE.L	ECRANG,D1
	ADD.L	LONECR_F,D1
	CMP.L	D1,D0
	BEQ.S	.FLP0
	MOVE.L	ECRANG,D0	
	BRA.S	.FLP2
.FLP1
	MOVE.L	ECRANG,D0
	ADD.L	LONECR_F,D0
	BRA.S	.FLP2
.FLP0	MOVE.L	ECRANG,D0
	ADD.L	LONECR_F,D0
	ADD.L	LONECR_F,D0
.FLP2
	MOVE.L	D0,BASE

	*FIN DU REPLAY ?
	TST.B	SND_BUSY
	BNE.S	.LOOP
.QUIT	
	MOVE.L	ECRANG,BASE
	MOVE.L	ECRANG,NEW_ECR
	ST	FLIP_POSSIBLE
	BRA	VSYNC

FADE_OUT
	*EFFACE L'ECRAN EN MENANT AU NOIR UN BALAYAGE
	*TAILLE : 16 PIXELS, DIMINUE DE 2
	*A0=SOURCE ET DESTINATION
	LEA	640(A0),A6	*LIMITE DROITE
	LEA	(A6),A2
	MOVE	#160+15,D6
.SWEEP
	LEA	(A2),A1		*DEBUT
	MOVE	#14,-(SP)	*LARGEUR DU BALAI
	
	MOVE	#%1111100000000000,D7
	MOVE	#%0000011111100000,D0
	MOVE	#%0000000000011111,D1
	MOVEQ	#0,D4
	
.LBALAI	
	CMP.L	A1,A6
	BLS.S	.OUT_OF_SCREEN
	CMP.L	A1,A0
	BHI.S	.OUT_OF_SCREEN

	* ASSOMBRIT COLONNE A1
	MOVE	#199,D5
	LEA	(A1),A3
.ASS
	MOVE	(A3),D4
	MOVE	D4,D3
	MOVE	D4,D2

	AND	D7,D4
	BEQ.S	.DJ01
	SUB.L	#%0010000000000000,D4
	BPL.S	.OK0
	MOVEQ	#0,D4
.OK0
	AND	D7,D4
.DJ01
	AND	D0,D3
	BEQ.S	.DJ02
	SUB	#%0000000100000000,D3
	BPL.S	.OK2
	MOVEQ	#0,D3
.OK2
	AND	D0,D3
.DJ02
	AND	D1,D2
	BEQ.S	.DJ03
	SUBQ	#4,D2
	BPL.S	.OK1
	MOVEQ	#0,D2
.OK1
	AND	D1,D2
.DJ03
	OR	D4,D3
	OR	D2,D3
	MOVE	D3,(A3)
	LEA	640(A3),A3
	DBF	D5,.ASS

.OUT_OF_SCREEN
	
	ADDQ.L	#2,A1
	SUBQ	#1,(SP)
	BPL.S	.LBALAI
	ADDQ.L	#2,SP
	
	BSR	VSYNC
	
	SUBQ.L	#4,A2
	DBF	D6,.SWEEP
	
	BRA	CLS

ENRG	*AFFICHE UN ECRAN POUR SE FAIRE ENREGISTRER
	*SAUVE L'ECRAN
	MOVE.L	BASE,A0
	LEA	([ECRANG],128000.L),A1
	MOVE	#31999,D0
.SAUVSCR	
	MOVE.L	(A0)+,(A1)+
	DBF	D0,.SAUVSCR
	BSR	ZOOM_OUT

	*SAUVE LE BUFFER PRECEDENT
	LEA	BUF_INF,A0
	LEA	TAMP_INF,A1	
	MOVEQ	#12,D0
.SOV_INF
	MOVE	(A0)+,(A1)+
	DBF	D0,.SOV_INF

	
	LEA	ENRG_TXT1,A0
	MOVEQ	#0,D0
	MOVEQ	#0+16,D1
	MOVE	#180,D2
	BSR	PRINT_SINUS
	LEA	ENRG_TXT2,A0
	MOVEQ	#0,D0
	MOVEQ	#24+16,D1
	BSR	PRINT
	LEA	ENRG_TXT3,A0
	MOVEQ	#0,D0
	MOVEQ	#42+16,D1
	BSR	PRINT
	LEA	ENRG_TXT4,A0
	MOVEQ	#0,D0
	MOVEQ	#60+10+16,D1
	BSR	PRINT
	LEA	ENRG_TXT5,A0
	MOVEQ	#0,D0
	MOVEQ	#78+10+16,D1
	BSR	PRINT
	LEA	ENRG_TXT6,A0
	MOVEQ	#0,D0
	MOVE	#96+20+16,D1
	BSR	PRINT
	LEA	ENRG_TXT7,A0
	MOVEQ	#0,D0
	MOVE	#114+20+16,D1
	BSR	PRINT

	MOVEQ	#78+10+16,D1
	LEA	BUF_INF+10,A1
	MOVEQ	#16,D2
	BSR	KBD_INPUT
	MOVE	#114+20+16,D1
	LEA	BUF_INF,A1
	BSR.S	KBD_INPUT_CODE
	

	*TEST DE VALIDITE
	BSR	TST_REGISTRE
	BEQ.S	.CORRECT
	
	LEA	ENRG_TXT8,A0
	MOVEQ	#0,D0
	MOVE	#180,D1
	BSR	PRINT
.WAITESP
	TST.B	KEY_TAB+57
	BEQ.S	.WAITESP

	*ANCIEN CODE :
	LEA	BUF_INF,A0
	LEA	TAMP_INF,A1	
	MOVEQ	#12,D0
.REST_INF
	MOVE	(A1)+,(A0)+
	DBF	D0,.REST_INF

	*REMET L'ANCIEN ECRAN
	
	LEA	([ECRANG],128000.L),A0
	BSR	ZOOM_IN
	
	LEA	KEY_TAB,A6
	BRA	POZEZ
.CORRECT
	RTS
KBD_INPUT_CODE
	*LIT DES DONNEES HEXA AU CLAVIER
	*ECRITURE SUR L'ECRAN LIGNE D1 - EN MEMOIRE (A1)
	*NBRE MAX DE CHIFFRES=20 (10 OCTETS)

	MOVEQ	#0,D3		*NBRE ACTUEL DE CHIFFRES
	MOVE	D1,D5		*POS Y 
	MOVEQ	#0,D4		*POS X ACTUELLE	
	LEA	TAMP_INPUT,A2	*TAMPON ASCII

	*LECT
.NEXT
	BSR	KBD_ASCII
	*
	CMP	#13,D0
	BNE.S	.INTS
	CMP	#20,D3
	BNE.S	.NEXT
	BRA.S	.FIN
.INTS
	CMP	#8,D0
	BNE.S	.INTS2
	TST	D3
	BEQ.S	.NEXT
	SUBQ	#1,D3
	MOVE.B	#" ",-(A2)
	SUB	#16,D4
	MOVE	D4,D0
	LEA	.TXT_BUF,A0
	MOVE.B	#".",(A0)
	MOVE	D5,D1
	MOVEM.L	D2-D5/A1-A2,-(SP)
	BSR	PRINT
	MOVEM.L	(SP)+,D2-D5/A1-A2
	BRA.S	.NEXT
.INTS2
	*CHIFFRE
	CMP2	.CHIFFRE,D0
	BCC.S	.CAROK
	CMP2	.MAJUS,D0
	BCC.S	.CAROK
	CMP2	.MINUS,D0
	BCS.S	.NEXT
	*TRANSFO MAJ>MIN
	SUB	#"a"-"A",D0
.CAROK	
	CMP	#20,D3
	BEQ.S	.NEXT
	ADDQ	#1,D3
	MOVE.B	D0,(A2)+
	LEA	.TXT_BUF,A0
	MOVE.B	D0,(A0)
	MOVE	D4,D0
	MOVE	D5,D1
	MOVEM.L	D2-D5/A1-A2,-(SP)
	BSR	PRINT
	MOVEM.L	(SP)+,D2-D5/A1-A2
	ADD	#16,D4
	BRA	.NEXT
.FIN
	*TRANSCODE ASCII->HEXA
	LEA	TAMP_INPUT,A2
	MOVEQ	#9,D0
.LOOP
	MOVE.B	(A2)+,D1
	CMP.B	#"9",D1
	BLE.S	.NXDG
	SUBQ.B	#"@"-"9",-1(A2)
.NXDG
	MOVE.B	(A2)+,D1
	CMP.B	#"9",D1
	BLE.S	.NXDG2
	SUBQ.B	#"@"-"9",-1(A2)
.NXDG2
	MOVE	-2(A2),D1
	PACK	D1,D2,#$CFD0
	MOVE.B	D2,(A1)+
	DBF	D0,.LOOP
	RTS
.TXT_BUF
	DC.B	32,0
.CHIFFRE
	DC.W	"0","9"
.MINUS	DC.W	"a","f"
.MAJUS	DC.W	"A","F"
	
	RTS

INPUT_NAME
	*INPUT DU NOM : PLAC EN A2 ET HEROS
	PEA	(A2)	
	LEA	TXT_HISC1,A0
	MOVEQ	#0,D0
	MOVE	#199-40,D1
	BSR	PRINT
	LEA	TXT_HISC2,A0
	MOVEQ	#0,D0
	MOVE	#199-16,D1
	BSR	PRINT
	
	MOVE	#199-16,D1
	MOVEQ	#14,D2
	MOVE.L	(SP),A1
	BSR.S	KBD_INPUT
	
	*RECOPIE EN HEROS
	MOVE.L	(SP)+,A1
	LEA	HEROS,A2
	MOVEQ	#6,D2
.REC	MOVE	(A1)+,(A2)+
	DBF	D2,.REC
	RTS
KBD_INPUT
	*LIT LES DONNEES ALHANUM AU CLAVIER
	*ECRITURE SUR L'ECRAN LIGNE D1 - EN MEMOIRE (A1)
	*D2=NBRE MAX DE LETTRES
	
	MOVEQ	#0,D3		*NBRE ACTUEL DE LETTRES	
	MOVE	D1,D5		*POS Y 
	MOVEQ	#0,D4		*POS X ACTUELLE	

	
	*LECT
.NEXT
	BSR	KBD_ASCII
	*
	CMP	#13,D0
	BNE.S	.INTS
	CMP	D2,D3
	BEQ	.FIN
	*REMPLIT LA SUITE AVEC DES ESPACES
	SUB	D3,D2
	SUBQ	#1,D2
.REMP	MOVE.B	#" ",(A1)+
	DBF	D2,.REMP
	BRA	.FIN
.INTS
	CMP	#8,D0
	BNE.S	.INTS2
	TST	D3
	BEQ.S	.NEXT
	SUBQ	#1,D3
	MOVE.B	#" ",-(A1)
	SUB	#16,D4
	MOVE	D4,D0
	LEA	.TXT_BUF,A0
	MOVE.B	#".",(A0)
	MOVE	D5,D1
	MOVEM.L	D2-D5/A1,-(SP)
	BSR	PRINT
	MOVEM.L	(SP)+,D2-D5/A1
	BRA.S	.NEXT
.INTS2
	CMP	#" ",D0
	BEQ.S	.CAROK
	*CHIFFRE
	CMP2	.CHIFFRE,D0
	BCC.S	.CAROK
	CMP2	.MAJUS,D0
	BCC.S	.CAROK
	CMP2	.MINUS,D0
	BCS.S	.NEXT
	*TRANSFO MAJ>MIN
	SUB	#"a"-"A",D0
.CAROK	
	CMP	D2,D3
	BEQ.S	.NEXT
	ADDQ	#1,D3
	MOVE.B	D0,(A1)+
	LEA	.TXT_BUF,A0
	MOVE.B	D0,(A0)
	MOVE	D4,D0
	MOVE	D5,D1
	MOVEM.L	D2-D5/A1,-(SP)
	BSR	PRINT
	MOVEM.L	(SP)+,D2-D5/A1
	ADD	#16,D4
	BRA	.NEXT
.FIN
	RTS
.TXT_BUF
	DC.B	32,0
.CHIFFRE
	DC.W	"0","9"
.MINUS	DC.W	"a","z"
.MAJUS	DC.W	"A","Z"

KBD_ASCII
	*LECTURE BLOQUANTE D'UN CARACTERE AU CLAVIER
	*CODE ASCII DANS D0 - PAS DE MAJ/MIN
	*TOUS REG SAUVEGARDS
	
	MOVEM.L	A5-A6,-(SP)
	*TYPE DE CLAVIER ?
	TST.B	AZERTY_F
	BEQ.S	.QWERTYC
	LEA	.AZERTY,A5
	BRA.S	.COM
.QWERTYC
	LEA	.QWERTY,A5
.COM
	LEA	KEY_TAB,A6
	*ATTENTE DU RELACHEMENT
	MOVE	.LAST,D0
.WAITRE
	TST.B	(A6,D0)
	BNE.S	.WAITRE
	
	*PARCOURS DU TABLEAU A LA RECHERCHE D'UNE TOUCHE
.NOAP
	MOVE	#144,D0
.LOOP
	TST.B	(A5,D0)		*TOUCHE INTERESSANTE ?
	BEQ.S	.NEXT
	TST.B	(A6,D0)
	BNE.S	.APPUI
.NEXT
	DBF	D0,.LOOP
	BRA.S	.NOAP
.APPUI	
	MOVE	D0,.LAST
	MOVE.B	(A5,D0),D0
	AND.L	#$FF,D0
	MOVEM.L	(SP)+,A5-A6
	RTS
.LAST	DC.W	0
.AZERTY
	DC.B	0,0,"1234567890)-",8,9
	DC.B	"AZERTYUIOP^$",13,0
	DC.B	"QSDFGHJKLM`",0,"#"
	DC.B	"WXCVBN,;:=",0,0,0," ",0
	DC.B	0,0,0,0,0,0,0,0,0,0,0,0
	DC.B	0,0,0,"-",0,0,0,"+",0,0,0,0,127
	DC.B	0,0,0,0,0,0,0,0,0,0,0,0,"<",0,0
	DC.B	"()/*7894561230.",13
.QWERTY
	DC.B	0,0,"1234567890)-",8,9
	DC.B	"QWERTYUIOP^$",13,0
	DC.B	"ASDFGHJKL;%`",0,"0"
	DC.B	"ZXCVBNM,:=",0,0,0," ",0
	DC.B	0,0,0,0,0,0,0,0,0,0,0,0
	DC.B	0,0,0,"-",0,0,0,"+",0,0,0,0,127
	DC.B	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DC.B	"()/*7894561230.",13
	EVEN
	
ZOOM_OUT	*EFFACE L'ECRAN PAR VAGUE
	*A0=SOURCE BASE=DESTINATION
	MOVE.L	BASE,A1		*PAS BESOIN DE SOURCE NORMALEMENT
	LEA	VAGUEF,A2
	MOVEQ	#79,D0
.INITVAG
	CLR.L	(A2)+
	DBF	D0,.INITVAG
	
.DEBUTVAG
	MOVEQ	#0,D7		*COMPTEUR DE TERMINAISON
	LEA	VAGUEF,A2
	LEA	(A1),A3
	MOVE	#159,D1
.FORA2
	MOVE	(A2),D2		*OLD VAL
	BSR	RND
	AND	#$F,D0
	ADD	D0,(A2)	
	CMP	#199,(A2)
	BLO.S	.SUIT1
	
	MOVE	#199,(A2) 
	MOVE	#200,D0
	SUB	D2,D0
	ADDQ	#1,D7
.SUIT1
	*CLEAR FROM D2 TO (A2) = D0 TIMES
	SUBQ	#1,D0
	BMI.S	.SUIT2
	EXT.L	D2
	MULU	#640,D2
	LEA	(A3,D2.L),A4
.LOOP
	CLR.L	(A4)
	LEA	640(A4),A4
	DBF	D0,.LOOP
	
.SUIT2	
	ADDQ.L	#2,A2
	ADDQ.L	#4,A3
	DBF	D1,.FORA2
	BSR	VSYNC
	CMP	#160,D7
	BNE.S	.DEBUTVAG
	RTS

ZOOM_IN	*AFFICHE L'ECRAN PAR VAGUE
	*A0=SOURCE BASE=DESTINATION
	MOVE.L	BASE,A1		
	LEA	VAGUEF,A2
	MOVEQ	#79,D0
.INITVAG
	CLR.L	(A2)+
	DBF	D0,.INITVAG
	
.DEBUTVAG
	MOVEQ	#0,D7		*COMPTEUR DE TERMINAISON
	LEA	VAGUEF,A2
	LEA	(A1),A3
	LEA	(A0),A5
	MOVE	#159,D1
.FORA2
	MOVE	(A2),D2		*OLD VAL
	BSR	RND
	AND	#$F,D0
	ADD	D0,(A2)	
	CMP	#199,(A2)
	BLO.S	.SUIT1
	
	MOVE	#199,(A2) 
	MOVE	#200,D0
	SUB	D2,D0
	ADDQ	#1,D7
.SUIT1
	*CLEAR FROM D2 TO (A2) = D0 TIMES
	SUBQ	#1,D0
	BMI.S	.SUIT2
	EXT.L	D2
	MULU	#640,D2
	LEA	(A3,D2.L),A4
	LEA	(A5,D2.L),A6
.LOOP
	MOVE.L	(A6),(A4)
	LEA	640(A4),A4
	LEA	640(A6),A6
	DBF	D0,.LOOP
	
.SUIT2	
	ADDQ.L	#2,A2
	ADDQ.L	#4,A3
	ADDQ.L	#4,A5
	DBF	D1,.FORA2
	BSR	VSYNC
	CMP	#160,D7
	BNE.S	.DEBUTVAG
	RTS

	
ZOOM_IN_ARCHIVE		*AFFICHAGE ZOOM D'UNE IMAGE
	*A0=SOURCE, BASE=DESTINATION

	MOVE.L	#256,D7	*PASX*2
	MOVE.L	#128*640,D6	*PASY*2
	LEA	(128000.L,A0),A5
.LOOP
	MOVE.L	BASE,A1
	
	MOVE.L	#640,D5
	DIVU	D7,D5
	AND.L	#$FFFF,D5
	ANDI.B	#%11111110,D5		*PARITE
	NEG.L	D5
	ADD.L	#320,D5		*X
		
	MOVE.L	#200*640,D4
	DIVU	D6,D4
	AND.L	#$FFFF,D4
	LSR.L	D4
	MULU	#640,D4
	NEG.L	D4
	ADD.L	#100*640,D4	*Y
	ADD.L	D4,D5

	ADD.L	D5,A1
	

	LEA	(A0),A3
.LOOPY
	LEA	640(A3),A4
	LEA	(A1),A2
.LOOPX
	MOVE	(A3),(A2)+
	ADD.L	D7,A3
	CMP.L	A3,A4
	BHI.S	.LOOPX
	LEA	640(A1),A1
	LEA	(-640.W,A4,D6.L),A3
	CMP.L	A3,A5
	BHI.S	.LOOPY

	BSR	VSYNC
	BSR	VSYNC
	
	LSR.L	D6
	LSR.L	D7
	CMP	#2,D7
	BNE.S	.LOOP

	*AFFICHE
	MOVE.L	BASE,A1
	MOVE	#2666,D0
.ENDRECOP	
	MOVEM.L	(A0)+,D1-D7/A2-A6		*48 OCT
	MOVEM.L	D1-D7/A2-A6,(A1)
	LEA	48(A1),A1
	DBF	D0,.ENDRECOP

	RTS



PRESENTATION		*DEROULEMENT DE LA NANA


	LEA	GARDE,A0
	MOVE.L	ECRANG,A1
	ADD.L	#256000,A1
	PEA	(A1)
	BSR	UNSQUEEZE
	MOVE.L	(SP)+,A0
	MOVE.L	A0,SOVREG
	ADD.L	#640,SOVREG
DEROUL			*DEROULEMENT D'UNE IMAGE
	*A0=SOURCE, BASE=DESTINATION
	BSR	WAITBLIT
	*PARAM COMMUNS
	MOVE.W	#2,$FFFF8A20.W	*X SRC INC
	MOVE.W	#640,$FFFF8A22.W	*Y SRC INC
	MOVE.W	#-1,$FFFF8A28.W	*MSK1
	MOVE.W	#-1,$FFFF8A2A.W	*MSK2
	MOVE.W	#-1,$FFFF8A2C.W	*MSK3
	MOVE.W	#2,$FFFF8A2E.W	*X DEST INC
	MOVE.W	#640,$FFFF8A30.W	*Y DEST INC
	MOVE.B	#2,$FFFF8A3A.W		*PAS DE HALF-TONE
	CLR.B	$FFFF8A3D.W

	MOVEQ	#0,D7
.LOOP2	
	MOVE.L	BASE,A1		*DESTINATION FILTRE
	LEA	(A1),A4
	ADD	D7,A1
	
	MOVE	#2*ROUL-1,D6
	LEA	(A0),A3
	LEA	(A3),A6		*SOURCE
	LEA	(A1),A5		*DEST
	LEA	ROUL_TBL,A2
.LOOP1
	CMP.L	A4,A5
	BLO.S	.NOAFF
	MOVE.L	#640,D0
	ADD.L	A4,D0
	CMP.L	D0,A5
	BHI.S	.JPCLIP
	BSR.S 	DRAW_ROUL
.JPCLIP
	MOVE.L	(A2)+,D0
	ADD.L	D0,A6
	SUBQ.L	#2,A5
	DBF	D6,.LOOP1		
.NOAFF
	LEA	-4*ROUL(A1),A5
	CMP.L	A4,A5
	BLO.S	.NODR
	LEA	-4*ROUL(A0),A6
	BSR.S	DRAW_ROUL
.NODR
	ADDQ.L	#2,A0
	BSR	WAITBLIT
	BSR	VSYNC
	ADDQ	#2,D7
	CMP	#640+ROUL*4,D7
	BNE.S	.LOOP2

	LEA	KEY_TAB,A6		
POZEZ	
	TST.B	1(A6)		*ESC
	BNE.S	.ENDE
	*TESTE LES TOUCHES F1+F10
	TST.B	REGSCR_F	*DROIT ?
	BEQ.S	.SHAA
	TST.B	59(A6)
	BEQ.S	.SHAA
	TST.B	68(A6)
	BNE	ENRG
	*LANCE L'ECRAN D'ENREGISTREMENT
.SHAA	
	TST.B	57(A6)			*ESPACE
	BEQ.S	POZEZ
	RTS
.ENDE	MOVE.L	NIVEAU0,SP		*NIVEAU BCLE PPALE
	BRA	ENDE2
	*NE PAS SEPARER
DRAW_ROUL
	*A6		*SOURCE
	*A5		*DEST

	CMP.L	SOVREG,A6
	BLO.S	.TRUE

	BSR	WAITBLIT
	MOVE.L	A5,$FFFF8A32.W		*DESTINATION ADR
	MOVE.W	#1,$FFFF8A36.W		*X COUNT
	MOVE.W	#200,$FFFF8A38.W	*Y COUNT
	CLR.B	$FFFF8A3B.W		*ALL 0
	MOVE.B	#%11000000,$FFFF8A3C.W	*DEPART

	RTS
.TRUE
	BSR	WAITBLIT
	MOVE.L	A6,$FFFF8A24.W	*SRC ADR
	MOVE.L	A5,$FFFF8A32.W		*DESTINATION ADR
	MOVE.W	#1,$FFFF8A36.W		*X COUNT
	MOVE.W	#200,$FFFF8A38.W		*Y COUNT
	
	MOVE.B	#3,$FFFF8A3B.W		*SRCE
	MOVE.B	#%11000000,$FFFF8A3C.W	*DEPART
	RTS


IRQ	*******************
	*MOVE.L	#-1,$FFFF9800.W
	
	TST.B	DOUBLE_RGB_F
	BNE.S	.NOCHGE
	TST.B	SEC_VBL_D
	BEQ.S	.NOCHGE
	MOVE.W	#%001,$FFFF82C2.W	*VCO - MODE : DBLE LIGNE
	BSR	AHBL2
.NOCHGE	

	ADDQ	#1,VBLFLAG
	TST.B	FLIP_POSSIBLE
	BEQ.S	.FIN
	SF	FLIP_POSSIBLE
	MOVE.L	NEW_ECR,-(SP)
	MOVE.L	NEW_ECR,VAL_ECRAN
	MOVE.B	2(SP),$FFFF8203.W
	MOVE.B	1(SP),$FFFF8201.W
	MOVE.B	3(SP),$FFFF820D.W
	ADDQ.L	#4,SP
.FIN	

	MOVEM.L	D0-A6,-(SP)

	TST.B	LETS_ROCK
	BEQ.S	.NO_ROCK

	jsr	replay+12

.NO_ROCK
	LEA	$FFFF890B.W,A0
	MOVEP	(A0),D0
	CMP	OLD_DMAPT,D0
	BEQ.S	.SNDPLAY
	MOVE	D0,OLD_DMAPT
	BRA.S	.RESTO
.SNDPLAY
	CLR.B	SND_BUSY
.RESTO
	TST.B	SEC_VBL
	BNE.S	.SECVBL
	*clr.L	$FFFF9800.W
	MOVEM.L	(SP)+,D0-A6
	RTE
.SECVBL
	NOT.B	MOUV	*1 VBL  / 2
	BEQ.S	.SECONDE
	*clr.L	$FFFF9800.W
	MOVEM.L	(SP)+,D0-A6
	RTE

.SECONDE
	
	*INCREMENT DES BOUCLIERS
	SUBQ	#1,COMPINC
	BPL	.NOINC
	MOVE	#FREQINC,COMPINC
	ADDQ	#1,SHIELD
	CMP	#SHILD,SHIELD
	BLS.S	.OTHERS_P
	MOVE	#SHILD,SHIELD				*A PROTEGER
.OTHERS_P
	LEA	PILE_AMIS2,A0
	LEA	PF_TBLE,A1
	MOVE	NB_AMIS,D0
	SUBQ	#1,D0
.FOR_OP
	CMP	#8,12(A0)
	BHS.S	.NEXT_OP
	MOVE.W	34(A0),D1
	MOVE.W	([A1,D1*4],28.W),D1
	CMP	36(A0),D1
	BEQ.S	.NEXT_OP
	ADDQ	#1,36(A0)
.NEXT_OP
	LEA	44(A0),A0
	DBF	D0,.FOR_OP

	LEA	PILE_ENNEMIS2,A0
	MOVE	NB_ENNEMIS,D0
	SUBQ	#1,D0
.FOR_OE
	CMP	#8,12(A0)
	BHS.S	.NEXT_OE
	MOVE.W	34(A0),D1
	MOVE.W	([A1,D1*4],28.W),D1
	CMP	36(A0),D1
	BEQ.S	.NEXT_OE
	ADDQ	#1,36(A0)
.NEXT_OE
	LEA	44(A0),A0
	DBF	D0,.FOR_OE
*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
		
.NOINC
	*CALCUL DES PAS
	MOVE	#PAS,PAS_VBL
	MOVE	#PAS2,PAS2_VBL
	
	*GESTION DES TOUCHES

	*TOUCHES DU CURSEUR - MOUVEMENT
	
	*SAUVEGARDE DE X_POS2,Y_POS2
	MOVE	X_POS2,-(SP)
	MOVE	Y_POS2,-(SP)

	LEA	PLAN,A1
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	X_POS2,D0
	MOVE.B	Y_POS2,D1
	ADD	D0,D0
	ASL	#6,D1
	ADD.L	D1,D0
	ADD.L	D0,A1		*A1=PLAN A L'ENDROIT DU JOUEUR
	MOVE.L	A1,XYMOI
	ANDI.B	#%01111111,1(A1)	*EFFACE LA POSITION JOUEUR
	
	*SOURIS
	BTST	#0,M_BUTTON	*BOUTON DR & JOYSTICK
	BEQ.S	.NON
	ST	TIR_HEROS
	BRA.S	.AU_DELA
.NON
	LEA	KEY_TAB,A6
	TST.B	54(A6)		*SHIFT D
	BEQ.S	.AU_DELA
	ST	TIR_HEROS
.AU_DELA	
	LEA	KEY_TAB,A6
	TST.B	57(A6)		*ESPACE
	BEQ.S	.NORB
*.OUVRE	
	*TENTE D'OUVRIR UNE PORTE
	*LEA	TBL_DEVANT,A0
	MOVE	DIR,D0
	ADD	(TBL_DEVANT,D0*2),A1			
	* TEST SI C'EST UNE PORTE
	CMP.B	#16,1(A1)		*A1 MODIFIE !
	BEQ.S	.NORB
	BTST	#4,1(A1)
	BEQ.S	.NORB
	*C'EN EST UNE
	LEA	PILE_PORTE,A0
	MOVE.L	A1,D1
	MOVEQ	#10,D3
	MOVE	NB_PORTE,D2
	BSR	STACK_SEARCH
	BNE.S	.NORB		*ERREUR
	TST	4(A0)
	BPL.S	.NORB		*DEJA EN ROUTE
	CLR	4(A0)		*LANCE LA SEQUENCE D'OUVERTURE
	
.NORB
	TST.B	59(A6)	*F1
	BEQ.S	.NO_F1
	SF	DBLH_F2
	BRA.S	.NO_F2
.NO_F1	TST.B	60(A6)	*F2
	BEQ.S	.NO_F2
	ST	DBLH_F2
.NO_F2
	TST.B	61(A6)	*F3
	BEQ.S	.NO_F3
	SF	DBLVS_F2
	BRA.S	.NO_F4
.NO_F3	TST.B	62(A6)	*F4
	BEQ.S	.NO_F4
	ST	DBLVS_F2
.NO_F4

	*TEXTE
	TST.B	20(A6)		*'T'
	BEQ	.NOTALK

	*TENTE DE PARLER A UN MEC
	MOVE	DIR,D0
	ADD	(TBL_DEVANT,D0*2),A1			
	* TEST LE TYPE DE MEC
	MOVE	PLAN2-PLAN(A1),D2
	BEQ.S	.SOLILOQUE
	BTST	#15,D2
	BNE.S	.KILL_HIM
	*IL SE CASSE
	SUBQ	#2,D2
	LEA	(PILE_AMIS2,D2),A0
	CMP	#8,12(A0)
	BHS.S	.NOKASS
	PEA	(A0)
	LEA	(A0),A5
	LEA	X_POS2-4,A0
	BSR	CALC_DIRANG_KS
	*SRCE = A5 CIBLE=A0 (OPPOS)
	MOVE.L	(SP)+,A0
	MOVE	12(A0),D0
	CMP2.W	.CMP2_V,D0	*ENTRE 1 ET 4 ?
	BCC.S	.ALREADY
	MOVE	#1,12(A0)	*SE MET A MARCHER
.ALREADY
	MOVE	#LONG_CHEMIN,20(A0)	*LONGTEMPS
.NOKASS	
	LEA	TXT_KASS,A0
	BRA.S	.AFTER_TALK
.CMP2_V	DC.W	1,4
.KILL_HIM
	*IL SE RETOURNE
	AND	#$7FFF,D2
	SUBQ	#2,D2
	LEA	(PILE_ENNEMIS2,D2),A0

	CMP	#8,12(A0)
	BHS.S	.NORET
	LEA	(A0),A5
	LEA	X_POS2-4,A0
	*POSITION SOURCE : 4(A5),6(A5)  - CIBLE : 4(A0),6(A0)
	BSR	CALC_DIRANG
	*DIRANG : A0=POINTEUR CIBLE A5=SOURCE D1-2/4-5 UTILISES
.NORET
	LEA	TXT_INJ,A0
	BRA.S	.AFTER_TALK
.SOLILOQUE
	LEA	TXT_SOL,A0
.AFTER_TALK
	MOVE.L	A0,TALK_PTR
	ST	TALK_FLAG
	
.NOTALK
	TST.B	M_DELTAX
	BEQ.S	.NOMX
	MOVE.B	M_DELTAX,D0
	
	* SENSIBILITE EN FONCTION DE L'ECART
	LEA	M_S_TBL,A0
	EXT	D0
	SMI	D1
	BPL.S	.NEG_DEP_X
	NEG	D0
.NEG_DEP_X
	CMP	(A0),D0
	BLT.S	.SORTIE_MS
	ADDQ.L	#4,A0
	BRA.S	.NEG_DEP_X
	
.SORTIE_MS	
	MOVE	2(A0),D2
	ASL	D2,D0

	TST.B	D1
	BEQ.S	.RENEG
	NEG	D0
.RENEG

	ADD	D0,ANG32
	BPL.S	.AUTTEST
	ADD	#720,ANG32
	BRA.S	.MISAJ0
.AUTTEST
	CMP	#720,ANG32
	BLT.S	.MISAJ0
	SUB	#720,ANG32
	
.MISAJ0
	*METS A JOUR DX ET DY
	BSR	MAJ_DX	
.NOMX
	TST.B	M_DELTAY
	BEQ.S	.NOMY
	ST	EVOL_YV
	
	MOVE.B	M_DELTAY,D0
	EXT	D0
	ASL	#M_SENSY,D0
	MOVE	D0,PAS2_VBL2
	BSR	MAJ_DX2
	MOVE	DX2,D0
	MOVE	DY2,D1
	BSR	MOVEMENT

	*PLUS BESOIN
	CLR.B	M_DELTAX
	CLR.B	M_DELTAY

	BRA	.NOINS		*PASSE LE TEST CLAVIER
.NOMY


	*PLUS BESOIN
	CLR.B	M_DELTAX
	CLR.B	M_DELTAY


	*CLAVIER	
	LEA	KEY_TAB,A6
	
	TST.B	75(A6)
	BEQ.S	.NOG
	ST	EVOL_YV
	MOVE	DY,D0
	MOVE	DX,D1
	NEG	D1
	BSR	MOVEMENT

.NOG
	TST.B	77(A6)
	BEQ.S	.NOD
	ST	EVOL_YV
	MOVE	DY,D0
	NEG	D0
	MOVE	DX,D1
	BSR	MOVEMENT

.NOD
	BTST	#1,M_BUTTON	*BOUTON GAUCHE
	BNE.S	.AVANCE

	BTST	#0,JOY_STATE
	BNE.S	.AVANCE

	TST.B	72(A6)
	BEQ.S	.NOH
.AVANCE
	ST	EVOL_YV
	MOVE	DX,D0
	MOVE	DY,D1
	BSR	MOVEMENT

.NOH	
	BTST	#1,JOY_STATE
	BNE.S	.JOY_B

	TST.B	80(A6)
	BEQ.S	.NOB
.JOY_B
	ST	EVOL_YV
	MOVE	DX,D0
	MOVE	DY,D1
	NEG	D0
	NEG	D1
	BSR	MOVEMENT

.NOB
	BTST	#3,JOY_STATE
	BNE.S	.JOY_D

	TST.B	71(A6)	
	BEQ.S	.NOCLR
.JOY_D
	MOVE	PAS_VBL,D0
	ADD	D0,ANG32
	CMP	#720,ANG32
	BLT.S	.MISAJ
	SUB	#720,ANG32
.MISAJ
	*METS A JOUR DX ET DY
	BSR	MAJ_DX	
.NOCLR
	BTST	#2,JOY_STATE
	BNE.S	.JOY_G

	TST.B	82(A6)	
	BEQ.S	.NOINS
.JOY_G
	MOVE	PAS_VBL,D0
	SUB	D0,ANG32
	BPL.S	.MISAJ2
	ADD	#720,ANG32
.MISAJ2
	*METS A JOUR DX ET DY
	BSR	MAJ_DX
.NOINS
	*TEST DE COLLISION -SECURITE
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	X_POS2,D0
	MOVE.B	Y_POS2,D1
	ASL	#6,D1
	LEA	PLAN,A1
	ADD	D0,D0
	ADD	D1,A1
	ADD	D0,A1
	MOVE.B	1(A1),D0
	BEQ.S	.OK
	BTST	#6,D0
	BNE.S	.OK
	MOVE.W	(SP),Y_POS2
	MOVE.W	2(SP),X_POS2
	MOVE.L	XYMOI2,A1
.OK
	ADDQ.L	#4,SP

	*MARQUE LA POSITION JOUEUR
	ORI.B	#128,1(A1)	*MET LA POSITION JOUEUR
	MOVE.L	A1,XYMOI2
.AFTER
	NOT.B	MOUV2
	BEQ.S	ATTACK
	*UNE VBL SUR 4
	*MOUVEMENT DES AUTRES PERSONNAGES
	*AMIS
	TST.B	FLAG_EXCL	*PERIODE DE MODIF CRITIQUE
	BEQ.S	.FINIRQ

	ST	F_AMI
	LEA	PILE_AMIS2,A1
	MOVE	NB_AMIS,D7
	BSR	GESTION_AUTRE
	*ENNEMIS
	SF	F_AMI
	LEA	PILE_ENNEMIS2,A1
	MOVE	NB_ENNEMIS,D7
	BSR	GESTION_AUTRE
.FINIRQ
	MOVEM.L	(SP)+,D0-A6
	*clr.L	$FFFF9800.W
	RTE
ATTACK	*1 VBL SUR 4
	NOT.B	FL_AMIS
	BEQ.S	.ATTACK_ENNEMIS
	MOVEM.L	(SP)+,D0-A6
	RTE
.ATTACK_ENNEMIS
	ST	HUIT_VBLS	*FLAG INDIQUANT UN CHGT D'ETAT POSSIBLE
	MOVEM.L	(SP)+,D0-A6
	RTE


VSYNC
	MOVE	VBLFLAG,D0	
.WAIT	
	CMP	VBLFLAG,D0
	BEQ.S	.WAIT
	RTS
CALC_DIRANG_KS	*IDEM CALC_DIRANG MAIS A L'OPPOS
	MOVE.B	4(A0),D4
	MOVE.B	6(A0),D5	
	SUB.B	4(A5),D4
	SUB.B	6(A5),D5
	NEG.B	D4
	NEG.B	D5
	BRA.S	CALC_COMM
CALC_DIRANG 	*: A0=POINTEUR CIBLE A5=SOURCE D1-2/4-5 UTILISES
	MOVE.B	4(A0),D4
	MOVE.B	6(A0),D5	
	SUB.B	4(A5),D4
	SUB.B	6(A5),D5
CALC_COMM
	*ROTATION DE PI/8
	NEG.B	D5	*INVERSION DE L'AXE DES Y
	EXTB.L	D4	
	EXTB.L	D5
	MOVE.L	D4,D1
	MULS	#30273,D1	*D1=XCOS
	MOVE.L	D5,D2
	MULS	#12540,D2	*D2=YSIN
	MULS	#30273,D5	*D5=YCOS
	MULS	#12540,D4	*D4=XSIN
	SUB.L	D2,D1		*D1=X
	ADD.L	D5,D4		*D4=Y
	*ASR.L	#8+7,D1&4	POUR CALCUL EXACT (ON S'EN FOUT)
	TST.L	D1
	BPL.S	.XP
	TST.L	D4
	BPL.S	.XNYP
	CMP.L	D1,D4
	BGT.S	.XNYND4
*XNYND1
	MOVEQ	#5,D2
	BRA.S	.FINISH
.XNYND4
	MOVEQ	#6,D2
	BRA.S	.FINISH
.XNYP
	NEG.L	D1		*VAL ABSO
	CMP.L	D1,D4
	BGT.S	.XNYPD4
*XNYPD1	
	MOVEQ	#7,D2		
	BRA.S	.FINISH
.XNYPD4
	MOVEQ	#0,D2
	BRA.S	.FINISH
.XP
	TST.L	D4
	BPL.S	.XPYP
*XPYN	
	NEG.L	D4		*VAL ABSO
	CMP.L	D1,D4
	BGT.S	.XPYND4
*XPYND1	
	MOVEQ	#3,D2
	BRA.S	.FINISH
.XPYND4	
	MOVEQ	#4,D2
	BRA.S	.FINISH
.XPYP
	CMP.L	D1,D4
	BGT.S	.XPYPD4
*XPYPD1
	MOVEQ	#2,D2
	BRA.S	.FINISH
.XPYPD4
	MOVEQ	#1,D2
.FINISH	
	MOVE	D2,10(A5)
	*CALCUL L'ANGLE CORRESPONDANT DS 8(A5)
	MOVEQ	#2,D1
	SUB	D2,D1
	AND	#%111,D1
	MULU	#90,D1
	MOVE	D1,8(A5)
	MOVE	D1,D3
	BSR	MAJ_DX3
	MOVE	D0,22(A5)
	MOVE	D1,24(A5)
	RTS

ANGLE_PPE	*CALCULE DANS D0 L'ANGLE VERS LE PLUS PROCHE ENNEMI
	*ENTREE : A1=ENDROIT PILE PERSO
	*F_AMI=TRUE OU FALSE SELON L'EQUIPE

*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS

	MOVEM.L	D1-D5/A0-A2,-(SP)
	TST.B	F_AMI
	BEQ	.ENNEMIS
*AMIS
	LEA	PILE_ENNEMIS2,A0
	MOVE	NB_ENNEMIS,D2
	SUBQ	#1,D2
	MOVE	#$7FFF,D1	*DISTANCE
	LEA	-1.W,A2
	*CALCULE DISTANCE	
.LOOP
	CMP	#8,12(A0)
	BHS.S	.PASSE
	MOVE.B	4(A0),D3
	SUB.B	4(A1),D3
	BPL.S	.VABS
	NEG.B	D3
.VABS
	MOVE.B	6(A0),D4
	SUB.B	6(A1),D4
	BPL.S	.VABS2
	NEG.B	D4
.VABS2
	EXT	D3
	EXT	D4
	ADD	D3,D4
	CMP	D4,D1
	BLO.S	.PASSE
	MOVE	D4,D1
	LEA	(A0),A2
.PASSE
	LEA	44(A0),A0
	DBF	D2,.LOOP
	CMP.L	#-1,A2		*PAS TROUV = TOUS MORTS
	BEQ	.ERROR
	CMP.L	#0,A2		*HEROS
	BNE.S	.PERSO
	*HEROS
	
	MOVE.B	X_POS2,D4
	MOVE.B	Y_POS2,D5	
	SUB.B	4(A1),D4
	SUB.B	6(A1),D5
	BRA.S	.COM
.PERSO
	*A2 CONTIENT LA CIBLE
	MOVE.B	4(A2),D4
	MOVE.B	6(A2),D5	
	SUB.B	4(A1),D4
	SUB.B	6(A1),D5
.COM

	*ROTATION DE PI/8
	NEG.B	D5	*INVERSION DE L'AXE DES Y
	EXTB.L	D4	
	EXTB.L	D5
	MOVE.L	D4,D1
	MULS	#30273,D1	*D1=XCOS
	MOVE.L	D5,D2
	MULS	#12540,D2	*D2=YSIN
	MULS	#30273,D5	*D5=YCOS
	MULS	#12540,D4	*D4=XSIN
	SUB.L	D2,D1		*D1=X
	ADD.L	D5,D4		*D4=Y
	*ASR.L	#8+7,D1&4	POUR CALCUL EXACT (ON S'EN FOUT)
	TST.L	D1
	BPL.S	.XP
	TST.L	D4
	BPL.S	.XNYP
	CMP.L	D1,D4
	BGT.S	.XNYND4
*XNYND1
	MOVEQ	#5,D2
	BRA.S	.FINISH
.XNYND4
	MOVEQ	#6,D2
	BRA.S	.FINISH
.XNYP
	NEG.L	D1		*VAL ABSO
	CMP.L	D1,D4
	BGT.S	.XNYPD4
*XNYPD1	
	MOVEQ	#7,D2		
	BRA.S	.FINISH
.XNYPD4
	MOVEQ	#0,D2
	BRA.S	.FINISH
.XP
	TST.L	D4
	BPL.S	.XPYP
*XPYN	
	NEG.L	D4		*VAL ABSO
	CMP.L	D1,D4
	BGT.S	.XPYND4
*XPYND1	
	MOVEQ	#3,D2
	BRA.S	.FINISH
.XPYND4	
	MOVEQ	#4,D2
	BRA.S	.FINISH
.XPYP
	CMP.L	D1,D4
	BGT.S	.XPYPD4
*XPYPD1
	MOVEQ	#2,D2
	BRA.S	.FINISH
.XPYPD4
	MOVEQ	#1,D2
.FINISH	
	*D2 =DIR
	*MOVE	D2,10(A1)
	*CALCUL L'ANGLE CORRESPONDANT DS 8(A1)
	MOVEQ	#2,D1
	SUB	D2,D1
	AND	#%111,D1
	MULU	#90,D1
	
	MOVE	D1,D0
	
*	MOVE	D1,8(A1)
*	MOVE	D1,D3
*	BSR	MAJ_DX3
*	MOVE	D0,22(A1)
*	MOVE	D1,24(A1)
*	RTS

	MOVEM.L	(SP)+,D1-D5/A0-A2
	RTS
	
.ENNEMIS
	LEA	PILE_AMIS2,A0
	MOVE	NB_AMIS,D2
	SUBQ	#1,D2
	*INIT AVEC DISTANCE PERSO
	MOVE.B	X_POS2,D3
	SUB.B	4(A1),D3
	BPL.S	.VABSE
	NEG.B	D3
.VABSE
	MOVE.B	Y_POS2,D4
	SUB.B	6(A1),D4
	BPL.S	.VABS2E
	NEG.B	D4
.VABS2E
	EXT	D3
	EXT	D4
	ADD	D3,D4
	MOVE	D4,D1
	LEA	0.W,A2
	BRA	.LOOP

.ERROR
	BSR	RND
	AND	#$3FF,D0
	CMP	#720,D0
	BHS.S	.ERROR
	MOVEM.L	(SP)+,D1-D5/A0-A2
	RTS
	


DET_DIR	*E : D0=ANGLE S:D0=DIR

	DIVS	#-90,D0
	ADDQ	#2,D0
	AND	#%111,D0
	RTS
GESTION_AUTRE
	*A1=PILE, D7=NOMBRE	
	SUBQ	#1,D7
.AMI1
	TST	12(A1)
	BNE.S	.NOREPOS	*REPOS
	TST	20(A1)		*DECREMENT EN BCLE PPALE
	BMI.S	.EOR
	MOVE	20(A1),D0
	AND	#%1111,D0
	BNE	.LAA		*PAS DE ROTATION
	*ROTATION SUR LUI-MEME 8(A1)=ANGLE 
	MOVE	8(A1),D0
	ADD	#90,D0		*1/8EME DE TOUR
	CMP	#720,D0
	BLT.S	.VPLE
	SUB	#720,D0
.VPLE
	MOVE	D0,8(A1)
	BSR.S	DET_DIR
	MOVE	D0,10(A1)
	*CHOIX DE DX ET DE DY
	MOVE	8(A1),D3
	BSR	MAJ_DX3
	MOVE	D0,22(A1)
	MOVE	D1,24(A1)
	
	BRA	.LAA
.EOR	MOVE	#1,12(A1)	*MARCHE
	BSR	RND
	AND	#$FF,D0
	MOVE	D0,20(A1)

	*ANGLE FONCTION DE L'ENNEMI LE PLUS PROCHE
	
.AUTRE	

	BSR	ANGLE_PPE
	*BSR	RND
	*AND	#$3FF,D0
	*CMP	#720,D0
	*BHS.S	.AUTRE

	MOVE	D0,8(A1)
	BSR.S	DET_DIR
	MOVE	D0,10(A1)
	*CHOIX DE DX ET DE DY
	MOVE	8(A1),D3
	BSR	MAJ_DX3
	MOVE	D0,22(A1)
	MOVE	D1,24(A1)
	BRA	.LAA
.NOREPOS	
	CMP	#5,12(A1)
	BHS	.LAA		*NON TRAITE
	
	*DEPLACEMENT
	MOVE.L	4(A1),-(SP)
	
	MOVE	22(A1),D0
	MOVE	24(A1),D1
	MOVE.L	(A1),A0
	ANDI.B	#%01111111,1(A0)	*EFFACE JOUEUR
	MOVE	PLAN2-PLAN(A0),SOV_REG
	CLR	PLAN2-PLAN(A0)
	
	BSR	MOVEMENT2

	*TEST DE COLLISION -SECURITE
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	4(A1),D0
	MOVE.B	6(A1),D1
	ASL	#6,D1
	LEA	PLAN,A2
	ADD	D0,D0
	ADD	D1,A2
	ADD	D0,A2
	MOVE.B	1(A2),D0
	BEQ.S	.OKA
	BTST	#7,D0
	BNE.S	.PASOKA
	BTST	#6,D0
	BNE.S	.OKA
.PASOKA	MOVE.L	(SP),4(A1)
	MOVE.L	(A1),A2
	MOVEQ	#1,D4
.OKA
	ADDQ.L	#4,SP
	ORI.B	#128,1(A2)
	MOVE	SOV_REG,PLAN2-PLAN(A2)
	MOVE.L	A2,(A1)
	
	*CHANGEMENT DE DIRECTION ?
	TST	D4
	BEQ.S	.NOCHGE

	MOVE	8(A1),D1
	BSR	RND
	AND	#$F,D0
	LSL	#4,D0
	SUB	#128,D0
	ADD	D0,D1
	BPL.S	.VPPAL
	ADD	#720,D1
	BRA.S	.VPPALOK
.VPPAL
	CMP	#720,D1
	BLT.S	.VPPALOK
	SUB	#720,D1
.VPPALOK
	MOVE	D1,8(A1)
	MOVE	D1,D0
	BSR	DET_DIR
	MOVE	D0,10(A1)
	MOVE	D1,D3
	BSR	MAJ_DX3
	MOVE	D0,22(A1)
	MOVE	D1,24(A1)
	
.NOCHGE
	*DEVANT UNE PORTE ?
		*TENTE D'OUVRIR UNE PORTE
		MOVE.L	(A1),A2
		*LEA	TBL_DEVANT,A0
		MOVE	10(A1),D0
		ADD	(TBL_DEVANT,D0*2),A2			
		* TEST SI C'EST UNE PORTE
		CMP.B	#16,1(A2)		*A1 MODIFIE !
		BEQ.S	.NORB
		BTST	#4,1(A2)
		BEQ.S	.NORB
		*C'EN EST UNE
		LEA	PILE_PORTE,A0
		MOVE.L	A2,D1
		MOVEQ	#10,D3
		MOVE	NB_PORTE,D2
		BSR	STACK_SEARCH
		BNE.S	.NORB		*ERREUR
		TST	4(A0)
		BPL.S	.NORB		*DEJA EN ROUTE
		CLR	4(A0)		*LANCE LA SEQUENCE D'OUVERTURE
		*IMMOBILISE LE TYPE
		CLR	12(A1)
		MOVE	#10,20(A1)	*8 MOUVEMENTS AVT L'OUVERTURE
		BRA.S	.LAA
.NORB

	*FIN DE DEPLACEMENT
	SUBQ	#1,20(A1)
	BPL.S	.LAA
	CLR	12(A1)	*REPOS
	BSR	RND
	AND	#$1F,D0
	MOVE	D0,20(A1)	
	
.LAA
	LEA	44(A1),A1
	DBF	D7,.AMI1
	RTS

GESTEFF	***************************************************************
	*MUR : PARALLELOGRAMME - CALCUL DU RECTANGLE ENGLOBANT
	*(D0,D1)-(D2,D3)-(D4,D5)-(D6,D7)

	CMP	D0,D4
	BLT.S	.NOEX0
	EXG	D0,D4
.NOEX0
	CMP	D2,D6
	BEQ.S	.D4ID0	*MUR
	*SOL : AUTRES EXTREMA
	BLT.S	.NOEX1
	EXG	D2,D6
.NOEX1
	CMP	D0,D2
	BLT.S	.NOEX2
	EXG	D0,D2
.NOEX2
	CMP	D4,D6
	BGT.S	.NOEX3
	EXG	D4,D6
.NOEX3
	*D4<D0 D6<D2 D2<D0 D4<D6 -> D4<D6<D2<D0
	
.D4ID0	
	*CLIPPING
	CMP	#XMICLIP,D4
	BGT.S	.OK1
	MOVE	#XMICLIP,D4
.OK1	CMP	#XMICLIP,D0
	BGT.S	.OK2
	MOVE	#XMICLIP,D0
.OK2
	CMP	#XMACLIP,D4
	BLT.S	.OK3
	MOVE	#XMACLIP,D4
.OK3	CMP	#XMACLIP,D0
	BLT.S	.OK4
	MOVE	#XMACLIP,D0
.OK4		

	MOVE.L	XMAE_P,A0
	MOVE	D0,(A0)+
	MOVE.L	A0,XMAE_P
	MOVE.L	XMIE_P,A0
	MOVE	D4,(A0)+
	MOVE.L	A0,XMIE_P
	
	*TROUVER LE MIN ET MAX DE D1,D3,D5,D7
	MOVE	D1,D0	*MIN
	MOVE	D1,D2	*MAX
	
	CMP	D3,D0
	BLT.S	.T1
	MOVE	D3,D0
.T1	CMP	D5,D0
	BLT.S	.T2
	MOVE	D5,D0
.T2	CMP	D7,D0
	BLT.S	.T3
	MOVE	D7,D0
.T3
	CMP	D3,D2
	BGT.S	.T4
	MOVE	D3,D2
.T4	CMP	D5,D2
	BGT.S	.T5
	MOVE	D5,D2
.T5	CMP	D7,D2
	BGT.S	.T6
	MOVE	D7,D2
.T6

	*CLIPPING
	CMP	YMICLIP_F,D2
	BGT.S	.OK1Y
	MOVE	YMICLIP_F,D2
.OK1Y	CMP	YMICLIP_F,D0
	BGT.S	.OK2Y
	MOVE	YMICLIP_F,D0
.OK2Y
	CMP	YMACLIP_F,D2
	BLT.S	.OK3Y
	MOVE	YMACLIP_F,D2
	ADDQ	#1,D2
.OK3Y	CMP	YMACLIP_F,D0
	BLT.S	.OK4Y
	MOVE	YMACLIP_F,D0
	ADDQ	#1,D0
.OK4Y	
	MOVE.L	YMIE_P,A0
	MOVE	D0,(A0)+
	MOVE.L	A0,YMIE_P
	
	MOVE.L	YMAE_P,A0
	MOVE	D2,(A0)+
	MOVE.L	A0,YMAE_P
	RTS

EFFACE_ECRAN	***************************************************************************
	MOVE.L	BASE,A1
	TST.B	DOUBLE_F
	BNE.S	.NODBLF
	LEA	((2+XMACLIP*2+640*YMACLIPD).L,A1),A2
	LEA	XMICLIP*2+640*YMICLIPD(A1),A1
	LEA	DEGRADE_FONDD,A0
	MOVE	#(1+YMACLIPD-YMICLIPD),D0
	BRA.S	.NEXT
.NODBLF
	LEA	((2+XMACLIP*2+640*YMACLIP).L,A1),A2
	LEA	XMICLIP*2+640*YMICLIP(A1),A1
	LEA	DEGRADE_FOND,A0
	MOVE	#(1+YMACLIP-YMICLIP),D0
.NEXT	
	TST.B	PLAFOND
	BNE.S	.PLAFOND

	*EFFACE TOUT NOIR
	
	BSR	WAITBLIT
	MOVE.W	#2,$FFFF8A2E.W		*X DEST INC
	MOVE.W	#640-(XMACLIP-XMICLIP)*2,$FFFF8A30.W	*Y DEST INC
	MOVE.B	#0,$FFFF8A3A.W		*PAS DE HALF-TONE
	MOVE.L	A1,$FFFF8A32.W		*DESTINATION ADR
	MOVE.L	#-1,$FFFF8A28.W
	MOVE	#-1,$FFFF8A2C.W
	
	MOVE.W	#1+(XMACLIP-XMICLIP),$FFFF8A36.W		*X COUNT
	MOVE	D0,D3
	EXT.L	D3
	MULU	#5,D3
	* 1/2 = 68K<BLIT  1/3:68K>BLIT  5/12 68K>BLIT
	DIVU	#12,D3
	SUB	D3,D0
	SUBQ	#1,D0
	MOVE.W	D3,$FFFF8A38.W	*Y COUNT
	CLR.B	$FFFF8A3B.W		*ALL 0
	MOVE.B	#%10000000,$FFFF8A3C.W	*DEPART
	* EFFACE EGALEMENT AU 68030
.EF268030
	MOVE	#(XMACLIP-XMICLIP)/2,D1	
.EFF68030
	CLR.L	-(A2)
	DBF	D1,.EFF68030
	SUB.L	#2*XMICLIP+640-2*XMACLIP-2,A2
	DBF	D0,.EF268030
	RTS

.PLAFOND

	MOVE	(A0)+,D0
	BMI.S	.ARRETE_LA
	SUBQ	#1,D0
	MOVE	(A0),D1
	SWAP	D1
	MOVE	(A0)+,D1
	BEQ.S	.TONULL
	
.YPLOT	

	MOVE	#(XMACLIP-XMICLIP)-16*((XMACLIP-XMICLIP)/16),D2
.REST	MOVE	D1,(A1)+
	DBF	D2,.REST
	MOVE	#(XMACLIP-XMICLIP)/8-1,D2		
.PLOT	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A1)+
	DBF	D2,.PLOT
	LEA	-2+(320-XMACLIP+XMICLIP)*2(A1),A1

	*USED D0,A0,A1;D1=MOTIF
	*114 LONGS=9.5*12
	
	DBF	D0,.YPLOT
	BRA.S	.PLAFOND

.ARRETE_LA	
	RTS
.TONULL

	MOVE	#(XMACLIP-XMICLIP)/8-1,D2		
.NPLOT	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A1)+
	DBF	D2,.NPLOT

	MOVE	#(XMACLIP-XMICLIP)-16*((XMACLIP-XMICLIP)/16),D2
.NREST	CLR	(A1)+
	DBF	D2,.NREST
	LEA	-2+(320-XMACLIP+XMICLIP)*2(A1),A1

	*USED D0,A0,A1;D1=MOTIF
	*114 LONGS=9.5*12
	
	DBF	D0,.TONULL
	BRA.S	.PLAFOND
	
PREPA_DEG
	*TEST SI PAS DEJA FAIT
	TST	.FLAG_DEJA_FAIT(PC)
	BNE.S	.ARRETE_LA
	ST	.FLAG_DEJA_FAIT
	
	LEA	DEGRADE_FONDD,A0
	BSR.S	.NEXT
	LEA	DEGRADE_FOND,A0
.NEXT
	MOVE	(A0)+,D0
	BMI.S	.ARRETE_LA
	MOVE	(A0),D1
	MOVEQ	#FONB,D3
	MULU	D1,D3
	LSR	#5,D3
	MOVEQ	#FONG,D4
	MULU	D1,D4
	AND	#%01111100000,D4
	ADD	D4,D4
	MOVEQ	#FONR,D5
	MULU	D1,D5
	AND	#%01111100000,D5
	LSL	#6,D5
	OR	D5,D4
	OR	D4,D3
	AND	#%1111111111011110,D3
	MOVE	D3,(A0)+
	BRA.S	.NEXT
.ARRETE_LA	
	RTS
.FLAG_DEJA_FAIT
	DC.W	0
	
AFFICHE_MORT
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#
	SUB	#80,ZTRF

	MOVE.L	P_IMAGE,A0
	TST	D6		*AMI ?
	BNE.S	.ENNEMI
	MOVE.L	AMIS,(A0)
	ADD.L	#9636*8*5+9636*4,(A0)+
	MOVE.L	#PAL_MORTA,(A0)+
	BRA.S	.PAREIL
.ENNEMI
	MOVE.L	ENNEMIS,(A0)
	ADD.L	#9636*8*5+9636*4,(A0)+
	MOVE.L	#PAL_MORTE,(A0)+

.PAREIL
	*CHOIX DE LA DIRECTION

	MOVE.W	#"PE",(A0)+	*PERSONNAGE
	MOVE.L	A0,P_IMAGE
	CLR.L	OF_HG
	
	BRA	COMMUN_PERSO

AFFICHE_OBJET	*`
*	MEMORISATION POUR AFFICHAGE - SEUL P_IMAGE,COORD ET ZTRANS SONT MULTI-MURAUX
*
*	ENTREE : A6=X_REC
*		 A5=Y_REC
*		 [D7=Z_REC] > 0
*	XTRF,...   XTRL,...
*

	CLR.L	OF_HG
		
	SUB	#80,ZTRF
	
	BTST	#7,D1
	BEQ	OOBJET
	*PERSONNAGE==========================================================
	*EST-CE NOUS ?
	MOVE.L	XYMOI2,D1
	CMP.L	XYCUR,D1		*EST-CE NOUS ?
	BNE.S	.NON
.FINI	RTS
.NON	
	BSR	LASER_EVENTUEL		*LASER INTER-JOUEUR

	MOVE.L	P_IMAGE,A0
	TST	D6		*AMI ?
	BNE.S	.ENNEMI
	MOVE.L	AMIS,(A0)+
	MOVE.L	#PALS_AMIS,(A0)+
	BRA.S	.PAREIL
.ENNEMI
	MOVE.L	ENNEMIS,(A0)+
	MOVE.L	#PALS_ENNEMIS,(A0)+

.PAREIL
	*CHOIX DE LA DIRECTION
	MOVE.L	PERSO_P,A1

	CMP	#13,12(A1)	*MORT ET ENTERRE
	BEQ.S	.FINI

	*OFFSET
	*	=(DIRP-DIR+12) MOD 8 
	MOVE	10(A1),D1
	SUB	DIR,D1
	ADD	#12,D1
	AND	#7,D1
	
	
	*D1 MULT PAR 9636 POUR LE DESSIN
	MOVE	D1,D2
	EXT.L	D2
	MULU	#9636,D2
	
	*D1 / 4 MULT PAR 32*32 POUR LA PALETTE
	AND.L	#%100,D1
	*ROTATION A G DE 10 = ROT A D DE 7
	LSL	#8,D1
	ADD	D1,D1
	ADD.L	D1,-4(A0)
	ADD.L	D2,-8(A0)
	
	*CHOIX DE LA POSITION DES JAMBES
	TST	12(A1)
	BEQ	.REPOS	   *0=REPOS, 1-4=MARCHE, 5-7=ATTAQUE, 8-13=MORT
	CMP	#8,12(A1)
	BLT.S	.PASMORT
	CMP	#13,12(A1)
	BNE.S	.PASDERREUR
	*DEJA TOUT MORT : QUE FAIT-IL DANS L'AFFICHAGE ?
	*MOVE.L	(A1),A1
	*ANDI.B	#%01111111,1(A1)
	*CLR	PLAN2-PLAN(A1)	*DISPARITION PURE & SIMPLE
	* PAS DROIT A LA PILE DES MORTS. PAS D'ENTERREMENT
	NOT.B	$FFFF8209.W	*SIGNALER L'ERREUR D'ALGO.
	RTS	
.PASDERREUR
	SUB.L	D2,-8(A0)
	SUB.L	D1,-4(A0)
	MOVEQ	#0,D1
	MOVE	12(A1),D1
	SUBQ	#8,D1
	MULU	#9636,D1
	ADD.L	#9636*8*5,D1
	ADD.L	D1,-8(A0)	
	MOVE.L	#2*32*32*10,D1
	CMP	#12,12(A1)
	BNE.S	.PASDER
	ADD.L	#2*32*32,D1
.PASDER
	ADD.L	D1,-4(A0)
	BRA.S	.REPOS

.PASMORT
	CMP	#5,12(A1)
	BHS.S	.ATTAK	
	MOVEQ	#0,D1
	MOVE	12(A1),D1
	MOVE.L	D1,D2
	MULU	#9636*4,D1	*CHOIX DU JEU DE JAMBES
	ADD.L	D1,D1
	ADD.L	D1,-8(A0)
	*2 PALETTES PAR JEU >D2X2*32*32*2
	LSL.L	#8,D2
	LSL.L	#4,D2
	ADD.L	D2,-4(A0)
	BRA.S	.REPOS	
.ATTAK				*ATTAQUE
	*SI PAS FACE A L'OBSERVO = REPOS
	*CMP	#5,12(A1)
	*BEQ.S	.REPOS
	TST.L	D2
	BNE.S	.REPOS		*NON ZERO
		SUB.L	D2,-8(A0)
		SUB.L	D1,-4(A0)
		MOVEQ	#0,D1
		MOVE	12(A1),D1
		SUBQ	#5,D1
		CMP	#2,D1
		BNE.S	.STAB
		MOVEQ	#1,D1
	.STAB:
		MULU	#9636,D1
		ADD.L	#9636*8*5+9636*5,D1
		ADD.L	D1,-8(A0)	
		MOVE.L	#2*32*32*11,D1
		ADD.L	D1,-4(A0)
.REPOS
	MOVE.W	#"PE",(A0)+	*PERSONNAGE
	MOVE.L	A0,P_IMAGE
				*					      |
	BSR.S	COMMUN_PERSO	*PAS CONFONDRE AVEC MORT OU OBJET A CAUSE DE \|/
	BRA	JOUEUR_ATTACK	*POSSIBILITE D'ATTAQUE DU HEROS
	
COMMUN_PERSO
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	LEA	XCOOR,A2
	LEA	YCOOR,A3
	LEA	ZCOOR,A4
			
	* ROTATIONS AUTOUR DE Y DU POINT CENTRAL X+80
	*
	*XR=X0+(X-X0)*COSA-(Z-Z0)*SINA
	*ZR=Z0+(Z-Z0)*COS(A)+(X-X0)*SINA
	*PUIS TRANSFO :X=XV+(XV-X)*ZV(Z-ZV)...
	
	MOVE	(A6),D1
	ADD	XTRF,D1
	ADD	#40,D1		*CAR OBJET DE TAILLE FIXE
		
	SUB	#X0,D1
	EXT.L	D1
	MOVE	(A0,D0.W),D2
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ADD	#X0,D1
	
	MOVE	ZTRF,D2
	ADD	#80,D2
	
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A1,D0.W),D3
	MULS	D3,D2
	ASR.L	#7,D2
	ASR.L	#8,D2
	SUB	D2,D1
	*D1=XR
	
	MOVE	ZTRF,D2
	ADD	#80,D2
	
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A0,D0.W),D3
	MULS	D3,D2
	ASR.L	#8,D2
	ASR.L	#7,D2
	ADD	#Z0,D1
	MOVE	(A6),D3
	ADD	#40,D3
	
	ADD	XTRF,D3
	SUB	#X0,D3
	EXT.L	D3
	MOVE	(A1,D0.W),D4
	MULS	D4,D3
	ASR.L	#8,D3
	ASR.L	#7,D3
	ADD	D3,D2
	*D2=ZR
	*
	MOVE	(A5),D3		*Y
	ADD	YTRF,D3
	
	ADD	XTRL,D1
	ADD	YTRL,D3
	ADD	ZTRL,D2

	*REDECALE X
	SUB	#40,D1
	SUB	#80,D2

	BRA	COMMUN_O

OOBJET	
	MOVE.L	P_IMAGE,A0
	MOVEQ	#0,D1
	MOVE.B	ACTUEL,D1
	ANDI.B	#%01111111,D1
	SUBQ	#1,D1
	ASL	#2,D1 
	LEA	OBJET,A1
	MOVE.L	(A1,D1.W),(A0)+
	LEA	PALS_OBJET,A1	*2*32*32=2048
	ASL	#8,D1
	LEA	(A1,D1.W*2),A1

	MOVE.L	A1,(A0)+
	MOVE.W	#"OB",(A0)+	*OBJET
	MOVE.L	A0,P_IMAGE

	*------------ELEVATION----------------*
	TST.B	DOUBLE_F
	BEQ.S	.DOUBLEOK
	LEA	ELEV_TBL,A4
	BRA.S	.ENDCDBL
.DOUBLEOK
	LEA	ELEV_TBL_D,A4
.ENDCDBL
	MOVE	([XYCUR],(640+32*64).W),D1
	AND	#%11110000,D1
	BEQ.S	.NOELEV
	BTST	#4,D1
	BNE.S	.ELEVA
	MOVE.B	#"0",-1(A0)	*EN BAS
.ELEVA	*ELEVATION 
	LSR	#4,D1
	MOVE	(A4,D1*2),OF_HG
.NOELEV	
	*-------------------------------------*


	LEA	COSTBL,A0
	LEA	SINTBL,A1
	LEA	XCOOR,A2
	LEA	YCOOR,A3
	LEA	ZCOOR,A4
			
	* ROTATIONS AUTOUR DE Y DU POINT CENTRAL X+80
	*
	*XR=X0+(X-X0)*COSA-(Z-Z0)*SINA
	*ZR=Z0+(Z-Z0)*COS(A)+(X-X0)*SINA
	*PUIS TRANSFO :X=XV+(XV-X)*ZV(Z-ZV)...
	
	MOVE	(A6),D1
	ADD	XTRF,D1
	ADD	#80,D1		*CAR OBJET DE TAILLE FIXE
		
	SUB	#X0,D1
	EXT.L	D1
	MOVE	(A0,D0.W),D2
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ADD	#X0,D1
	
	MOVE	ZTRF,D2
	ADD	#80,D2
	
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A1,D0.W),D3
	MULS	D3,D2
	ASR.L	#7,D2
	ASR.L	#8,D2
	SUB	D2,D1
	*D1=XR
	
	MOVE	ZTRF,D2
	ADD	#80,D2
	
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A0,D0.W),D3
	MULS	D3,D2
	ASR.L	#8,D2
	ASR.L	#7,D2
	ADD	#Z0,D1
	MOVE	(A6),D3
	ADD	#80,D3
	
	ADD	XTRF,D3
	SUB	#X0,D3
	EXT.L	D3
	MOVE	(A1,D0.W),D4
	MULS	D4,D3
	ASR.L	#8,D3
	ASR.L	#7,D3
	ADD	D3,D2
	*D2=ZR
	*
	MOVE	(A5),D3		*Y
	ADD	YTRF,D3
	
	ADD	XTRL,D1
	ADD	YTRL,D3
	ADD	ZTRL,D2

	SUB	OF_HG,D3
	
	*REDECALE X
	SUB	#80,D1
	SUB	#80,D2

COMMUN_O	

	MOVE	D1,(A2)
	MOVE	D3,(A3)
	MOVE	D2,(A4)
	
	ADDQ.L	#2,A5
	ADDQ.L	#2,A6
	
	LEA	14(A2),A2
	LEA	14(A3),A3
	LEA	14(A4),A4

	*2EME POINT
	
	ADD	(A6),D1
	SUB	-2(A6),D1
	MOVE	D1,(A2)

	MOVE	(A5),D3		*Y
	ADD	YTRF,D3
	ADD	YTRL,D3
	
	SUB	OF_HG,D3	

	MOVE	D3,(A3)
	MOVE	D2,(A4)	
		
	
**********************************************
*	TRANSFORMATION ESPACE-PLAN
*	GESTION DE ZTRANS

	MOVEQ	#1,D5	*2 POINTS
	
	LEA	XCOOR,A2
	LEA	YCOOR,A3
	LEA	ZCOOR,A4
	MOVE.L	COORD_P,A6	*EVOLUE DE 32 OCTETS	(COMPATIBILITE)
	MOVE.L	ZTRANS_P,A5	* "  "     16   "
		
POINTS2_O

	MOVE	(A2),D1
	MOVE	(A3),D3
	MOVE	(A4),D2
	*CLIPPING 1 : SI D2<-256,D2=-256
	CMP	#-250,D2
	BGT.S	.CLIPFAIL
	MOVE	#-250,D2


.CLIPFAIL	
	MOVE	D2,(A5)
	
	*PUIS TRANSFO :X=XV+(X-XV)*(ZV)/(ZV+Z)...
	*	       Y=YV+(Y-YV)*ZV/ZV+Z
	SUB	#XV,D1
	SUB	YV_F,D3 
	EXT.L	D1
	EXT.L	D3
	ASL.L	#8,D1
	ASL.L	#8,D3
	ADD	#256,D2
	DIVS	D2,D1
	DIVS	D2,D3
	ADD	#XV,D1
	ADD	YV_F,D3
	*(D1,D3) A AFFICHER
	MOVE	D1,(A6)+
	MOVE	D3,(A6)+
	
	LEA	14(A2),A2
	LEA	14(A3),A3
	LEA	14(A4),A4
	LEA	14(A5),A5
	DBF	D5,POINTS2_O


	*RECTANGLE ENGLOBANT : (COORD,COORD+2)-(COORD+4,+6)
	MOVE.L	COORD_P,A4
	
	MOVE	(A4),D0
	MOVE	2(A4),D1
	MOVE	4(A4),D4
	MOVE	6(A4),D5
	MOVE	D4,D2
	MOVE	D1,D3
	MOVE	D0,D6
	MOVE	D5,D7
	BSR	GESTEFF			*PEUT ETRE SIMPLIFIE	68030
					*  ----------------------^ uniquement un repre
	ADD.L	#32,COORD_P	*POUR COMPATIBILITE
	ADD.L	#16,ZTRANS_P
	ADDQ.W	#1,MURCOUNT
	RTS

LASER_EVENTUEL		*LORS DE L'AFFICHAGE D'UN PERSO, AFFICHE EVNTUELLEMENT UN LASER

	MOVEM.L	D0-A6,-(SP)
	
	*TIR LASER A AFFICHER ?

	TST.B	([PERSO_P],38.W)
	BEQ	.NOLAZER_DUTOUT
	CLR.B	([PERSO_P],PILE_AMIS2-PILE_AMIS+38)	*EFFACE FLAG VIS DANS PILE_2
	CLR.B	([PERSO_P],38.W)			*EFFACE FLAG VIS DANS PILE_2
	

		LEA 	X_REC2,A6
		LEA	Y_REC3,A5
	*CALCULE LES COORDONNEES DE LA DROITE
		LEA	COSTBL,A0
		LEA	SINTBL,A1
		LEA	XCOOR,A2
		LEA	YCOOR,A3
		LEA	ZCOOR,A4
			
		* ROTATIONS AUTOUR DE Y DU POINT CENTRAL X+80
	*
	*XR=X0+(X-X0)*COSA-(Z-Z0)*SINA
	*ZR=Z0+(Z-Z0)*COS(A)+(X-X0)*SINA
	*PUIS TRANSFO :X=XV+(XV-X)*ZV(Z-ZV)...
		MOVE	(A6),D1
		ADD	XTRF,D1
		ADD	#40,D1		*CAR LASER DE TAILLE FIXE
			
		SUB	#X0,D1
		EXT.L	D1
		MOVE	(A0,D0.W),D2
		MULS	D2,D1
		ASR.L	#7,D1
		ASR.L	#8,D1
		ADD	#X0,D1
		
		MOVE	ZTRF,D2
		ADD	#80,D2
		
		SUB	#Z0,D2
		EXT.L	D2
		MOVE	(A1,D0.W),D3
		MULS	D3,D2
		ASR.L	#7,D2
		ASR.L	#8,D2
		SUB	D2,D1
		*D1=XR
	
		MOVE	ZTRF,D2
		ADD	#80,D2
	
		SUB	#Z0,D2
		EXT.L	D2
		MOVE	(A0,D0.W),D3
		MULS	D3,D2
		ASR.L	#8,D2
		ASR.L	#7,D2
		ADD	#Z0,D1
		MOVE	(A6),D3
		ADD	#40,D3
	
		ADD	XTRF,D3
		SUB	#X0,D3
		EXT.L	D3
		MOVE	(A1,D0.W),D4
		MULS	D4,D3
		ASR.L	#8,D3
		ASR.L	#7,D3
		ADD	D3,D2
		*D2=ZR
		*
		MOVE	(A5),D3		*Y
		ADD	YTRF,D3
		
		ADD	XTRL,D1
		ADD	YTRL,D3
		ADD	ZTRL,D2
	
		*REDECALE X
		*SUB	#40,D1	
		SUB	#80,D2
		
		*ORIGINE DE LA DROITE
		MOVE	D1,(A2)		*/PAS DIT QUE CA RESTE MMORIS- SI EN FAIT
		MOVE	D3,(A3)
		MOVE	D2,(A4)		

		*PARTIE A FAIRE D'ABORD (ATTENTION A A6 ET D0)
		
		MOVE.L	PERSO_P,A6
		MOVE.B	40(A6),D1
		EXTB.L	D1
		MULU	#160,D1
		MOVE.B	41(A6),D2
		AND.L	#$FF,D2
		MULS	#160,D2
		ASR.L	#8,D2
		ADD.L	D2,D1		*D1=DX
		MOVE.B	42(A6),D2
		EXTB.L	D2
		MULS	#160,D2
		MOVE.B	43(A6),D3
		AND.L	#$FF,D3
		MULU	#160,D3
		ASR.L	#8,D3
		ADD.L	D3,D2		*D2=DY
		MOVE	ANG2,D0
		MOVE	(A0,D0*2),D3	
		MOVE.L	D2,D4
		MULS	D3,D4	*D4=DY COS
		MOVE.L	D1,D5
		MULS	D3,D5	*D5=DX COS
		MOVE	(A1,D0*2),D3	
		MOVE.L	D2,D6
		MULS	D3,D6	*D6=DY SIN
		MOVE.L	D1,D7
		MULS	D3,D7	*D7=DX SIN
		*DX'=DX sin ANG2 - DY cos ANG2
		*DY'=DY sin ANG2 + DX cos ANG2
			
		SUB.L	D4,D7	*D7=DX'		
		ADD.L	D5,D6	*D6=DY'
		ASR.L	#8,D7
		ASR.L	#7,D7
		ASR.L	#8,D6
		ASR.L	#7,D6

		*AFFICHAGE SI Z>0 IE DY<0
*		TST.L	D6
*		BPL	.NOLAZER_CIBLE		
		NEG.L	D6	*INVERSE SENS DES Z
		ADD	(A2),D7
		MOVE	D7,2(A2)		*PAS DIT QUE CA RESTE MMORIS
		MOVE	(A3),2(A3)
		ADD	(A4),D6
		MOVE	D6,2(A4)		

	*	TRANSFO ESPACE-PLAN 

		MOVEQ	#1,D5	*2 POINTS
	
		*LEA	XCOOR,A2
		*LEA	YCOOR,A3
		*LEA	ZCOOR,A4
		MOVE.L	COORD_P,A6	*EVOLUE DE 32 OCTETS	(COMPATIBILITE)
		*MOVE.L	ZTRANS_P,A5	* "  "     16   "
			
	.POINTS2_L:

		MOVE	(A2)+,D1
		MOVE	(A3)+,D3
		MOVE	(A4)+,D2
		*CLIPPING 1 : SI D2<-256,D2=-256
		CMP	#-250,D2
		BGT.S	.CLIPFAIL
		MOVE	#-250,D2


	.CLIPFAIL:
		*PUIS TRANSFO :X=XV+(X-XV)*(ZV)/(ZV+Z)...
		*	       Y=YV+(Y-YV)*ZV/ZV+Z
		SUB	#XV,D1
		SUB	YV_F,D3 
		EXT.L	D1
		EXT.L	D3
		ASL.L	#8,D1
		ASL.L	#8,D3
		ADD	#256,D2
		DIVS	D2,D1
		DIVS	D2,D3
		ADD	#XV,D1
		ADD	YV_F,D3
		*(D1,D3) A AFFICHER
		MOVE	D1,(A6)+
		MOVE	D3,(A6)+
		DBF	D5,.POINTS2_L

		*LIGNE LASER : (COORD,COORD+2)-(COORD+4,+6)
		MOVE.L	COORD_P,A4
		*MET L'INFO DANS L'ENTETE DE P_IMAGE
		MOVE.L	P_IMAGE,A5
		MOVE.L	(A4)+,(A5)+
		MOVE.L	(A4)+,(A5)+
		MOVE	#"LA",(A5)
		ADD.L	#10,P_IMAGE
		*TYPE DE LASER : DROITE
		MOVE.L	#"DROI",([COORD_P])
		ADD.L	#32,COORD_P
		ADD.L	#16,ZTRANS_P
		ADDQ.W	#1,MURCOUNT
		ADDQ.L	#2,XMIE_P	
		ADDQ.L	#2,YMIE_P	
		ADDQ.L	#2,XMAE_P	
		ADDQ.L	#2,YMAE_P	
.NOLAZER_DUTOUT
	MOVEM.L	(SP)+,D0-A6
	RTS

JOUEUR_ATTACK 	*TEST SI LE JOUEUR EST ATTAQUE
	MOVEM.L	D0-A6,-(SP)

	TST.B	([PERSO_P],39.W)
	BEQ	.NOLAZER_DUTOUT
	CLR.B	([PERSO_P],39.W)
	CLR.B	([PERSO_P],PILE_AMIS2-PILE_AMIS+39)

	*RECUPERE VALEURS DU JOUEUR
	*RECTANGLE ENGLOBANT : (COORD,COORD+2)
	MOVEM	([COORD_P],-32.W),D0-D3
	
	ADD	D2,D0
	ASR	D0		*MOYENNE
	MOVE	D3,D4
	SUB	D1,D4	*HAUTEUR
	EXT.L	D4
	TST.B	DOUBLE_F
	BEQ.S	.GHER
	MULS	#(HLASER*256)/120,D4
	BRA.S	.REHG
.GHER
	MULS	#(HLASERD*256)/60,D4
.REHG
	ASR.L	#8,D4
	ADD	D4,D1
	
	*COUPE Y A HLASER/120
		*MET L'INFO DANS L'ENTETE DE P_IMAGE
		MOVE.L	P_IMAGE,A5
		MOVE	D0,(A5)+
		MOVE	D1,(A5)+
		*JOUEUR
		BSR	RND
		AND	#$7F,D0
		ADD	#XV-64,D0
		MOVE	D0,(A5)+
		MOVE	YMACLIP_F,D0
		ADD	#10,D0
		MOVE	D0,(A5)+
		MOVE	#"LA",(A5)
		ADD.L	#10,P_IMAGE
		*TYPE DE LASER : POLYGONE
		MOVE.L	#"POLY",([COORD_P])
		ADD.L	#32,COORD_P
		ADD.L	#16,ZTRANS_P
		ADDQ.W	#1,MURCOUNT
		ADDQ.L	#2,XMIE_P	
		ADDQ.L	#2,YMIE_P	
		ADDQ.L	#2,XMAE_P	
		ADDQ.L	#2,YMAE_P	
	
.NOLAZER_DUTOUT
	MOVEM.L	(SP)+,D0-A6
	RTS


STACK_SEARCH	*RECHERCHE DE 
	*D1.L DANS LA PILE A0 DE TAILLE ELEMENTAIRE D3
	*ET DE LONGEUR D2
	*ADRESSE RETOURNEE DANS A0
	SUBQ	#1,D2
	BMI.S	.ERR
.LOOP
	CMP.L	(A0),D1
	BEQ.S	.END
	ADD.L	D3,A0
	DBF	D2,.LOOP
.ERR	AND	#%11111011,CCR
	RTS
.END	
	OR	#%00000100,CCR
	RTS
DOOR_SEARCH	*RECHERCHE DANS LA PILE DE LA PORTE QUI NOUS FAIT FACE
		*D0/A6/A5 INCHANGES

	*COORD DE LA PORTE DANS XYCUR

	LEA	PILE_PORTE,A0
	MOVE.L	XYCUR,D1
	MOVE	NB_PORTE,D2
	MOVEQ	#10,D3
	BSR.S	 STACK_SEARCH
	BNE.S	.ERROR
	MOVE	4(A0),O_PORTE
	BPL.S	.FIN
	CLR	O_PORTE
.FIN	
	OR	#%00000100,CCR
	RTS
.ERROR	
	AND	#%11111011,CCR
	RTS
PERSO_SEARCH	*RECHERCHE DANS LA PILE DES PERSO QUI NOUS FAIT FACE
		*D0/A6/A5 INCHANGES
		*D4=OFF X D5=OFF Y DU PERSO MODIFIE
		*D6=0 AMI / D6<>0 ENNEMI

	MOVE.L	XYCUR,A0
	MOVE	PLAN2-PLAN(A0),D1
	BEQ	.ERROR
	BTST	#15,D1
	BNE.S	.ENNEMIS
	AND	#$7FFF,D1
	SUBQ	#2,D1
	LEA	(PILE_AMIS,D1),A0		

	MOVEQ	#0,D6
	MOVE.L	A0,PERSO_P
	MOVE.B	5(A0),D4
	MOVE.B	7(A0),D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5

	OR	#%00000100,CCR
	RTS

.ENNEMIS
	MOVEQ	#1,D6
	AND	#$7FFF,D1
	SUBQ	#2,D1
	LEA	(PILE_ENNEMIS,D1),A0	

	MOVE.L	A0,PERSO_P
	MOVE.B	5(A0),D4
	MOVE.B	7(A0),D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5

	OR	#%00000100,CCR
	RTS
.ERROR	
	AND	#%11111011,CCR
	RTS

MORT_SEARCH	*RECHERCHE DANS LA PILE DES MORTS CELUI QUI NOUS FAIT FACE
		*D0/A6/A5 INCHANGES
		*D4=OFF X D5=OFF Y DU PERSO MODIFIE
		*D6=0 AMI / D6<>0 ENNEMI
	TST.B	ENC_MOR
	BNE.S	.SUITE
	LEA	PILE_MORTS,A0
	MOVE.L	XYCUR,D1
	MOVE	NB_MORTS,D2
	MOVEQ	#10,D3
	ST	ENC_MOR
.CONV
	BSR	STACK_SEARCH
	BNE.S	.ERROR
	MOVE	8(A0),D6
	MOVE.L	A0,PERSO_P
	MOVE	D2,NBM_C
	MOVE.B	5(A0),D4
	MOVE.B	7(A0),D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5
	OR	#%00000100,CCR
	RTS
.ERROR	
	AND	#%11111011,CCR
	RTS
.SUITE	MOVE.L	PERSO_P,A0
	MOVE	NBM_C,D2
	MOVEQ	#10,D3
	ADD.L	D3,A0
	MOVE.L	XYCUR,D1
	BRA.S	.CONV		

AFFICHE_MUR	*
*********************************
*
*	MEMORISATION POUR AFFICHAGE - SEUL P_IMAGE,COORD ET ZTRANS SONT MULTI-MURAUX
*
*	ENTREE : A6=X_REC
*		 A5=Y_REC  D0=ANGLE
*		 [D7=Z_REC] => 0
*	XTRF,...   XTRL,...
*
	BTST	#4,D1	*TEST SI C'EST UNE PORTE
	BEQ.S	.NOPORTE
	*PORTE
	
	SUB	#80,ZTRF
	*RECHERCHE DE O_PORTE DANS LA TABLE
	BSR	DOOR_SEARCH
	BEQ.S	.NOERROR
	RTS
.NOERROR
	MOVE.L	P_IMAGE,A0
	LEA	TBL_PORTE,A1
	MOVE	O_PORTE,D1
	ADD	D1,D1
	MOVE	(A1,D1),D2
	MOVE	D2,D1
	EXT.L	D2
	BEQ.S	.PAS0
	SUBQ.L	#1,D2
.PAS0
	MULU	#XLARG,D2
	LEA	PORTE,A1
	ADD.L 	D2,A1

	TST.B	DOUBLE_F
	BNE.S	.GHER
	ASR	D1
.GHER
	NEG	D1
	ADD	YIMG_D_F,D1
	MOVE	D1,2(A5)
	
	MOVE.L	A1,(A0)+
	MOVE.L	#PALPORTE,(A0)+
	MOVE.B	O_PORTE+1,(A0)+
	MOVE.B	#"P",(A0)+
	MOVE.L	A0,P_IMAGE
	
	BRA.S	.COMMUN

.NOPORTE
	SUB	#80,ZTRF
	
	
	MOVE.L	P_IMAGE,A0
	MOVEQ	#0,D1
	MOVE.B	ACTUEL,D1
	ANDI.B	#%01111111,D1
	SUBQ	#1,D1
	ASL	#2,D1 
	LEA	IMAGE,A1
	MOVE.L	(A1,D1.W),(A0)+
	LEA	PALS,A1	*2*32*32=1024
	ASL	#8,D1
	LEA	(A1,D1.W*2),A1
	MOVE.L	A1,(A0)+
	MOVE.W	#"MU",(A0)+
	MOVE.L	A0,P_IMAGE
.COMMUN	
	*------------ELEVATION----------------*
	CLR.L	OF_HG
	TST.B	DOUBLE_F
	BEQ.S	.DOUBLEOK
	LEA	ELEV_TBL,A4
	BRA.S	.ENDCDBL
.DOUBLEOK
	LEA	ELEV_TBL_D,A4
.ENDCDBL
	MOVE	([XYCUR],(640+32*64).W),D1
	AND	#%11110000,D1
	BEQ.S	.NOELEV
	BTST	#4,D1
	BNE.S	.ELEV
	*DEUX MURS A AFFICHER...
	MOVEM.L	D0/D1/A5/A6,-(SP)
	BSR.S	.NOELEV	*LE PREMIER
	MOVEM.L	(SP)+,D0/D1/A5/A6
	*LE SECOND
	MOVE.L	P_IMAGE,A0
	MOVEQ	#0,D1
	MOVE.B	ACTUEL,D1
	ANDI.B	#%01111111,D1
	SUBQ	#1,D1
	ASL	#2,D1 
	LEA	IMAGE,A1
	MOVE.L	(A1,D1.W),(A0)+
	LEA	PALS_B,A1	*2*32*32=1024
	ASL	#8,D1
	LEA	(A1,D1.W*2),A1
	MOVE.L	A1,(A0)+
	MOVE.W	#"MB",(A0)+		
	MOVE.L	A0,P_IMAGE
	TST.B	DOUBLE_F
	BEQ.S	.DEUXDB
	MOVE	#-YIMG_D,OF_HG
	BRA.S	.NOELEV
.DEUXDB
	MOVE	#-YIMG_DD,OF_HG
	BRA.S	.NOELEV
.ELEV	
	*ELEVATION 
	LSR	#4,D1
	MOVE	(A4,D1*2),OF_HG
.NOELEV	
	*-------------------------------------*

	MOVEQ	#1,D5	*2 POINTS
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	LEA	XCOOR,A2
	LEA	YCOOR,A3
	LEA	ZCOOR,A4
			
	* ROTATIONS AUTOUR DE Y
	*
	*XR=X0+(X-X0)*COSA-(Z-Z0)*SINA
	*ZR=Z0+(Z-Z0)*COS(A)+(X-X0)*SINA
	*PUIS TRANSFO :X=XV+(XV-X)*ZV(Z-ZV)...
	
POINTS
	MOVE	(A6),D1
	ADD	XTRF,D1
	
	SUB	#X0,D1
	EXT.L	D1
	MOVE	(A0,D0.W),D2
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ADD	#X0,D1

 	MOVE	ZTRF,D2
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A1,D0.W),D3
	MULS	D3,D2
	ASR.L	#7,D2
	ASR.L	#8,D2
	SUB	D2,D1
	*D1=XR
	
	MOVE	ZTRF,D2
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A0,D0.W),D3
	MULS	D3,D2
	ASR.L	#8,D2
	ASR.L	#7,D2
	ADD	#Z0,D1
	MOVE	(A6),D3
	ADD	XTRF,D3
	SUB	#X0,D3
	EXT.L	D3
	MOVE	(A1,D0.W),D4
	MULS	D4,D3
	ASR.L	#8,D3
	ASR.L	#7,D3
	ADD	D3,D2
	*D2=ZR
	*
	MOVE	(A5),D3		*Y
	ADD	YTRF,D3
	
	ADD	XTRL,D1
	ADD	YTRL,D3
	ADD	ZTRL,D2
	SUB	OF_HG,D3		*ELEVATION

	MOVE	D1,(A2)
	MOVE	D3,(A3)
	MOVE	D2,(A4)
	
	ADDQ.L	#2,A5
	ADDQ.L	#2,A6
	*ADDQ.L	#2,D7
	LEA	14(A2),A2
	LEA	14(A3),A3
	LEA	14(A4),A4
	
	DBF	D5,POINTS
**********************************************
*		REPRISE DES RESULTATS - INTERPOLATION DE ?COOR
*
*	XCOOR(I=1,2,3,4,5,6)=XCOOR(0)+(XCOOR(7)-XCOOR(0))*(I MOD 4)/3
*	YCOOR(I=1,2,3,4,5,6)=YCOOR(0)*(I<=3)+YCOOR(7)*(I>3)
*       ZCOOR(I=1,2,3,4,5,6)=ZCOOR(0)+(ZCOOR(7)-ZCOOR(0))*(I MOD 4)/3
*
	LEA	XCOOR,A0
	LEA	YCOOR,A1
	LEA	ZCOOR,A2
	
	MOVE	14(A0),D0
	SUB	(A0),D0
	EXT.L	D0
	DIVS	#3,D0
	MOVE	(A0),2(A0)
	ADD	D0,2(A0)
	MOVE	2(A0),4(A0)
	ADD	D0,4(A0)
	MOVE	14(A0),6(A0)
	MOVE.L	(A0),8(A0)
	MOVE.L	4(A0),12(A0)
	
	MOVE	(A1),D0
	MOVE	D0,2(A1)
	MOVE	D0,4(A1)
	MOVE	D0,6(A1)
	MOVE	14(A1),D0
	MOVE	D0,8(A1)
	MOVE	D0,10(A1)
	MOVE	D0,12(A1)
	
	MOVE	14(A2),D0
	SUB	(A2),D0
	EXT.L	D0
	DIVS	#3,D0
	MOVE	(A2),2(A2)
	ADD	D0,2(A2)
	MOVE	2(A2),4(A2)
	ADD	D0,4(A2)
	MOVE	14(A2),6(A2)
	MOVE.L	(A2),8(A2)
	MOVE.L	4(A2),12(A2)
	
************************************************
*	TRANSFORMATION ESPACE-PLAN
*	GESTION DE ZTRANS

	MOVEQ	#7,D5	*8 POINTS
	
	LEA	XCOOR,A2
	LEA	YCOOR,A3
	LEA	ZCOOR,A4
	MOVE.L	COORD_P,A6	*EVOLUE DE 32 OCTETS
	MOVE.L	ZTRANS_P,A5	* "  "     16   "
		
POINTS2

	MOVE	(A2)+,D1
	MOVE	(A3)+,D3
	MOVE	(A4)+,D2
	*CLIPPING 1 : SI D2<-256,D2=-256
	CMP	#-250,D2
	BGT.S	.CLIPFAIL
	MOVE	#-250,D2


.CLIPFAIL	
	MOVE	D2,(A5)+
	
	*PUIS TRANSFO :X=XV+(X-XV)*(ZV)/(ZV+Z)...
	*	       Y=YV+(Y-YV)*ZV/ZV+Z
	SUB	#XV,D1
	SUB	YV_F,D3 
	EXT.L	D1
	EXT.L	D3
	ASL.L	#8,D1
	ASL.L	#8,D3
	ADD	#256,D2
	DIVS	D2,D1
	DIVS	D2,D3
	ADD	#XV,D1
	ADD	YV_F,D3
	*(D1,D3) A AFFICHER
	MOVE	D1,(A6)+
	MOVE	D3,(A6)+
	
	DBF	D5,POINTS2


	*RECTANGLE ENGLOBANT : (COORD,COORD+2)-(COORD+16,+18)-(COORD+12,+14)(COORD+28,COORD+30)
	MOVE.L	COORD_P,A4
	
	MOVE	(A4),D0
	MOVE	2(A4),D1
	MOVE	12(A4),D2
	MOVE	14(A4),D3
	MOVE	16(A4),D6
	MOVE	18(A4),D7
	MOVE	28(A4),D4
	MOVE	30(A4),D5
	BSR	GESTEFF
	
	ADD.L	#32,COORD_P
	ADD.L	#16,ZTRANS_P
	ADDQ.W	#1,MURCOUNT
	RTS

AFFICHE_SOL	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
*********************************
*
*	MEMORISATION POUR AFFICHAGE 
*
*		 D0=ANGLE
*	XTRF,...   XTRL,...

	*(A5) = NV SOL + ELEV
	
	SUB	#80,ZTRF
	MOVE.L	P_IMAGE,A6

	MOVE	(A5),D1
	LSR	#8,D1
	SUBQ	#1,D1
	BMI.S	.RTS
	CMP	#15,D1
	BNE.S	.UNSOL
.RTS	RTS
.UNSOL
	LSL	#2,D1
	LEA	SOLS,A1
	MOVE.L	(A1,D1.W),(A6)+
	LEA	PALS_SOL,A1	*2*32*32=1024
	ASL	#8,D1
	LEA	(A1,D1.W*2),A1
	MOVE.L	A1,(A6)+
	MOVE.W	#"SO",(A6)+
	MOVE.L	A6,P_IMAGE

	*GESTION DE L'ELEVATION : OFFSET Y DE CHAQUE COIN DANS OF_HG, OF_HD, OF_BG, OF_BD
	TST.B	DOUBLE_F
	BEQ.S	.DOUBLEOK
	LEA	ELEV_TBL,A4
	BRA.S	.ENDCDBL
.DOUBLEOK
	LEA	ELEV_TBL_D,A4
.ENDCDBL
	MOVE	(A5),D1
	AND	#%11110000,D1
	BEQ	.NOELEV
	*ELEVATION : SOL DIFFERENT
	MOVE	#"SE",-2(A6)
	LSR	#4,D1
	BTST	#0,D1	*SI A 0, ALORS CREUX
	BNE.S	.HAUTEUR
	*SOL BAS
	MOVE	#"SB",-2(A6)
	BRA.S	.TRAVER
.HAUTEUR
	CMP	#SEUIL_SOL,D1
	BLO.S	.TRAVER		*TRAVERSABLE LASER
	ADD.L	#PALS_SOL_E-PALS_SOL,-6(A6)	*NON TRAVERSABLE
.TRAVER
	MOVE	(A4,D1*2),D1
	MOVE	D1,OF_HG
	MOVE	D1,OF_HD
	MOVE	D1,OF_BG
	MOVE	D1,OF_BD

	MOVE	(A5),D1
	BTST	#0,D1
	BEQ.S	.NEXT1
	MOVE	-2(A5),D2
	AND	#%11110000,D2
	LSR	#4,D2
	MOVE	(A4,D2*2),D2
	MOVE	D2,OF_HG
	MOVE	D2,OF_BD
	BRA.S	.NEXT4
.NEXT1
	BTST	#1,D1
	BEQ.S	.NEXT2
	MOVE	64(A5),D2
	AND	#%11110000,D2
	LSR	#4,D2
	MOVE	(A4,D2*2),D2
	MOVE	D2,OF_BG
	MOVE	D2,OF_BD
	BRA.S	.NEXT4
	
.NEXT2	BTST	#2,D1
	BEQ.S	.NEXT3
	MOVE	2(A5),D2
	AND	#%11110000,D2
	LSR	#4,D2
	MOVE	(A4,D2*2),D2
	MOVE	D2,OF_HD
	MOVE	D2,OF_BG
	BRA.S	.NEXT4

.NEXT3	BTST	#3,D1
	BEQ.S	.NEXT4
	MOVE	-64(A5),D2
	AND	#%11110000,D2
	LSR	#4,D2
	MOVE	(A4,D2*2),D2
	MOVE	D2,OF_HG
	MOVE	D2,OF_HD
.NEXT4	
	*ORIENTATION
	MOVE.W	DIR,D1
	JMP	([.ROUT,PC,D1*4])
	
.ROUT	DC.L	.D0,.D0,.D2,.D2,.D4,.D4,.D6,.D6

.D0	MOVE	OF_HG,OA *0=HG 12=HD 16=BD 28=BG
	MOVE	OF_HD,OB
	MOVE	OF_BD,OD
	MOVE	OF_BG,OC
	BRA	.JOIN

.D6	MOVE	OF_HG,OB
	MOVE	OF_HD,OC
	MOVE	OF_BD,OA
	MOVE	OF_BG,OD
	BRA.S	.JOIN

.D4	MOVE	OF_HG,OC
	MOVE	OF_HD,OD
	MOVE	OF_BD,OB
	MOVE	OF_BG,OA

	BRA.S	.JOIN
.D2	MOVE	OF_HG,OD
	MOVE	OF_HD,OA
	MOVE	OF_BD,OC
	MOVE	OF_BG,OB
	BRA.S	.JOIN
.NOELEV
	CLR.L	OA	*A&B
	CLR.L	OD	*D&C
.JOIN


	LEA	XCOOR+12,A6		*BUFFER GENERIQUE
	
	MOVEQ	#1,D5	*2 POINTS
	
	LEA	COSTBL,A0
	LEA	SINTBL,A1
	LEA	X_RECS,A2
			
	* ROTATIONS AUTOUR DE Y
	*
	*XR=X0+(X-X0)*COSA-(Z-Z0)*SINA
	*ZR=Z0+(Z-Z0)*COS(A)+(X-X0)*SINA
	*PUIS TRANSFO :X=XV+(XV-X)*ZV(Z-ZV)...
	
.POINTSOL
	MOVE	(A2),D1	
	ADD	XTRF,D1
	
	SUB	#X0,D1
	EXT.L	D1
	MOVE	(A0,D0.W),D2
	MULS	D2,D1
	ASR.L	#7,D1
	ASR.L	#8,D1
	ADD	#X0,D1

 	MOVE	ZTRF,D2
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A1,D0.W),D3
	MULS	D3,D2
	ASR.L	#7,D2
	ASR.L	#8,D2
	SUB	D2,D1
	*D1=XR
	
	MOVE	ZTRF,D2
	SUB	#Z0,D2
	EXT.L	D2
	MOVE	(A0,D0.W),D3
	MULS	D3,D2
	ASR.L	#8,D2
	ASR.L	#7,D2
	ADD	#Z0,D1
	MOVE	(A2),D3
	ADD	XTRF,D3
	SUB	#X0,D3
	EXT.L	D3
	MOVE	(A1,D0.W),D4
	MULS	D4,D3
	ASR.L	#8,D3
	ASR.L	#7,D3
	ADD	D3,D2
	*D2=ZR
	*
	*Y=0
	MOVE	YTRF,D3
	TST.B	DOUBLE_F
	BEQ.S	.HYRT
	ADD	#120,D3
	BRA.S	.TRYH
.HYRT
	ADD	#60,D3
.TRYH
	ADD	XTRL,D1
	ADD	YTRL,D3
	ADD	ZTRL,D2

	MOVE	D1,(A6)+
	MOVE	D3,(A6)+
	MOVE	D2,(A6)+
	
	ADDQ.L	#2,A2
	DBF	D5,.POINTSOL

**********************************************
*		REPRISE DES RESULTATS - INTERPOLATION : ROTATION DE 90 DEGRES
*
*	ENTREE : X3,Y3,Z3 - X4,Y4,Z4 -> 1&2
*		A=90
*		X1=X3-(Z4-Z3)
*		Y1=Y3=Y4
*		Z1=Z3+(X4-X3)
*		A=-90
*		X2=X4-(Z4-Z3)
*		Y2=Y4=Y3
*		Z2=Z4+(X4-X3)
*
	LEA	XCOOR,A6
	LEA	12(A6),A5
	MOVE	(A5),D0		*X3
	MOVE	10(A5),D1	*Z4
	SUB	4(A5),D1	*Z3
	SUB	D1,D0		*D1=Z4-Z3
	MOVE	D0,(A6)+
	MOVE	2(A5),(A6)+
	MOVE	4(A5),D0	*Z3
	MOVE	6(A5),D2	*X4
	SUB	(A5),D2		*X3
	ADD	D2,D0		*D2=X4-X3
	MOVE	D0,(A6)+
	MOVE	6(A5),D0
	SUB	D1,D0
	MOVE	D0,(A6)+
	MOVE	2(A5),(A6)+
	MOVE	10(A5),D0
	ADD	D2,D0
	MOVE	D0,(A6)

************************************************
*	TRANSFORMATION ESPACE-PLAN
*	GESTION DE ZTRANS

	MOVEQ	#3,D5	*4 POINTS
	
	LEA	XCOOR,A2
	MOVE.L	COORD_P,A6	*EVOLUE DE 32 OCTETS
	MOVE.L	ZTRANS_P,A5	* "  "     16   "
	LEA	OA,A4
		
.POINTS2SOL

	MOVE	(A2)+,D1
	MOVE	(A2)+,D3
	SUB	(A4)+,D3
	MOVE	(A2)+,D2
	*CLIPPING 1 : SI D2<-256,D2=-256
	CMP	#-250,D2
	BGT.S	.CLIPFAIL
	MOVE	#-250,D2
.CLIPFAIL	
	MOVE	D2,(A5)+
	
	*PUIS TRANSFO :X=XV+(X-XV)*(ZV)/(ZV+Z)...
	*	       Y=YV+(Y-YV)*ZV/ZV+Z
	SUB	#XV,D1
	SUB	YV_F,D3 
	EXT.L	D1
	EXT.L	D3
	ASL.L	#8,D1
	ASL.L	#8,D3
	ADD	#256,D2
	DIVS	D2,D1
	DIVS	D2,D3
	ADD	#XV,D1
	ADD	YV_F,D3
	*(D1,D3) A AFFICHER
	MOVE	D1,(A6)+
	MOVE	D3,(A6)+
	DBF	D5,.POINTS2SOL
	
	MOVE.L	COORD_P,A4
	MOVE.L	ZTRANS_P,A5
	
	*TRANSFO POUR CORRESPONDRE
	*0-3->0-4
	*12-15 -> 28-31
	*4-7 -> 12-15
	*8-11 -> 16-19
	MOVE.L	12(A4),28(A4)
	MOVE.L	4(A4),12(A4)
	MOVE.L	8(A4),16(A4)

	*TRANSFO ZTRANS PR CORRESPONDRE FACES CACHEES
	*6-8  -> 14-15 : MIN ET MAX
	MOVE	(A5),D0
	MOVE	2(A5),D1
	MOVE	4(A5),D2
	MOVE	6(A5),D3
	CMP	D1,D0
	BLT.S	.MINW1
	MOVE	D1,D0
.MINW1
	CMP	D2,D0
	BLT.S	.MINW2
	MOVE	D2,D0
.MINW2
	CMP	D3,D0
	BLT.S	.MINW3
	MOVE	D3,D0
.MINW3
	MOVE	D0,(A5)

	CMP	D0,D3
	BGT.S	.MAXW1
	MOVE	D0,D3
.MAXW1
	CMP	D1,D3
	BGT.S	.MAXW2
	MOVE	D1,D3
.MAXW2
	CMP	D2,D3
	BGT.S	.MAXW3
	MOVE	D2,D3
.MAXW3
	MOVE	D3,14(A5)
	
	*RECTANGLE ENGLOBANT : (COORD,COORD+2)-(COORD+12,+14)-(COORD+28,+30)(COORD+16,COORD+18)
	
	MOVE	(A4),D0
	MOVE	2(A4),D1
	MOVE	12(A4),D2
	MOVE	14(A4),D3
	MOVE	16(A4),D6
	MOVE	18(A4),D7
	MOVE	28(A4),D4
	MOVE	30(A4),D5
	BSR	GESTEFF
	
	ADD.L	#32,COORD_P
	ADD.L	#16,ZTRANS_P
	ADDQ.W	#1,MURCOUNT
	RTS
	
*********************************************************************************

*                        P A R T I E     A F F I C H A G E

*********************************************************************************
AFFICHE_SCENE
	*GESTION DE V_ECLINT ET V_ECLSUB
	TST.B	TIR_HEROS
	BEQ.S	.NORMAL
	MOVE	#ECLINT2,V_ECLINT
	MOVE	#ECLSUB2,V_ECLSUB
	BRA.S	.SURNO
.NORMAL
	MOVE	#ECLINT,V_ECLINT
	MOVE	#ECLSUB,V_ECLSUB
.SURNO


	MOVE.L	#TAMPIMG,P_IMAGE
	*ELIMINATION DES FACES CACHEES
	LEA	ZTRANS,A0
	LEA	COORD,A1
	LEA	XMIEFF,A2
	LEA	XMAEFF,A3
	LEA	YMIEFF,A4
	LEA	YMAEFF,A5
	MOVE	MURCOUNT,D7
	BNE.S	.JUSTE_POUR_VOIR
	RTS
.JUSTE_POUR_VOIR	
	ADD	D7,D7	
	
	
	*A CHANGER 68030 (SI COURAGE)
	
	*RESET INDICE 1
	MOVEQ	#0,D6	*INDICE DE ?M?EFF No 1
	*MOVEQ	#2,D5	*"                "  2
	*MOVE.L	#TAMPIMG,P_IMAGE	*CONSIDERE C. IND 2
	MOVEQ	#0,D4	*INDICE DE COORD (No 1)
	MOVEQ	#0,D1	*INDICE DE COORD (No 2)
	MOVEQ	#0,D3	*INDICE DE ZTRANS 1
	*MOVEQ	#16,D2	*INDICE DE ZTRANS 2
	

	* D6 DE 0 A D7-2 PAR PAS DE 2
	* D5 DE 0 A D7-2 PAR PAS DE 2
	* D4=D6*16
	* D3=D6*8
	* D2=D5*8
.FOR_D6
	*RESET INDICE 2 A PARTIR DU 1
	MOVEQ	#0,D5
	MOVEQ	#0,D2
	MOVEQ	#0,D1
	MOVE.L	#TAMPIMG,P_IMAGE	
	
	*PASSE LES LASERS
	CMP.L	#"POLY",(A1,D4)
	BEQ	.NEXT_D6
	CMP.L	#"DROI",(A1,D4)
	BEQ	.NEXT_D6
	
	*ELIMINATION DES FACES NEGATIVES
	MOVE	(A0,D3),D0
	ADD	14(A0,D3),D0
	CMP	#-500,D0
	BLE	.ELIMINATION
	
.FOR_D5	
	CMP	D5,D6
	BEQ	.NEXT_D5	*D5<>D6
	CMP.W	#"LA",([P_IMAGE],8.W)	*LASER
	BEQ	.NEXT_D5
	CMP.L	#"NEPH",(A1,D1)
	BEQ.S	.NEXT_D5	*N'EXISTE PLUS
	*TEST SI IL NE S'AGIT PAS D'UN MUR
	MOVE	([P_IMAGE],8.W),D0
	CMP.W	#"MU",D0
	BEQ.S	.MUR
	CMP.W	#"MB",D0
	BEQ.S	.MUR
	CMP.B	#"P",D0
	BNE.S	.NEXT_D5
.MUR
	MOVE	(A0,D2),D0
	ADD	14(A0,D2),D0
	CMP	#-500,D0
	BLE.S	.NEXT_D5	*VA ETRE ELIMINE
	
	*SI LA FACE POINTEE PAR 1 EST OCCULTEE PAR LA FACE 2
	*ON SUPPRIME 1 ET ON PASSE A LA SUITE
*1 :	*1c2 SI XMIN1>=XMIN2 ET XMAX1<=XMAX2, DE MEME EN Y
	MOVE	(A2,D5),D0
	SUBQ	#2,D0	*TOLERANCE
	CMP	(A2,D6),D0
	BGT.S	.NEXT_D5
	
	MOVE	(A3,D5),D0
	ADDQ	#2,D0
	CMP	(A3,D6),D0
	BLT.S	.NEXT_D5
	
	MOVE	(A4,D5),D0
	SUBQ	#2,D0
	CMP	(A4,D6),D0
	BGT.S	.NEXT_D5
	
	MOVE	(A5,D5),D0
	ADDQ	#2,D0		
	CMP	(A5,D6),D0
	BLT.S	.NEXT_D5

*2 : SI ZMOY1>ZMOY2 ON SUPPRIME	
	MOVE	(A0,D2),D0
	ADD	14(A0,D2),D0
	
	SUB	(A0,D3),D0
	SUB	14(A0,D3),D0
	
	*SI D0<0 1>2
	ADDQ	#4,D0	*TOLERANCE
	BPL.S	.NEXT_D5
.ELIMINATION	
	*SUPPRIMER LA FACE
	MOVE.L	#"NEPH",(A1,D4)
	BRA.S	.NEXT_D6

*  AUGMENTATION INDICE 2
.NEXT_D5
	ADD	#16,D2
	ADD	#32,D1
	ADD.L	#10,P_IMAGE
	ADDQ	#2,D5
	CMP	D7,D5
	BLT	.FOR_D5
.NEXT_D6
	*AUGMENTATION INDICE 1 
	ADD	#16,D3
	ADD	#32,D4
	ADDQ	#2,D6
	CMP	D7,D6
	BLT	.FOR_D6



	MOVE.L	#COORD,COORD_P
	MOVE.L	#ZTRANS,ZTRANS_P
	MOVE.L	#TAMPIMG,P_IMAGE
	SF	PORTE_F
	
	*ECLAIRAGE = ZTRANS -> ZTRANS+6

	*SOL : 3 PASSES
	*AFFICHAGE SOL SOUS-ELEV

	ST	MURBAS_F

	MOVE	MURCOUNT,-(SP)
SOLB_SUIVANT
	MOVE.L	P_IMAGE,A4
	CMP.L	#"NEPH",([COORD_P])
	BEQ.S	.INC_PARAM
	CMP	#"MB",8(A4)
	BEQ.S	.MUR_BAS
	CMP	#"O0",8(A4)
	BEQ.S	.OBJ_BAS
	CMP	#"SB",8(A4)
	BNE.S	.INC_PARAM
	
	BSR	SOL_DISPLAY	
	
.INC_PARAM
	ADD.L	#32,COORD_P
	ADD.L	#16,ZTRANS_P
	ADD.L	#10,P_IMAGE
	SUBQ.W	#1,(SP)
	BNE.S	SOLB_SUIVANT
	ADDQ.L	#2,SP
	BRA.S	.SOL0
	
.MUR_BAS
	MOVE	#"MU",8(A4)
	BSR	MUR_BAS
	MOVE	#"MB",([P_IMAGE],8.W)
	BRA.S	.INC_PARAM		
.OBJ_BAS
	MOVE	#"OB",8(A4)
	BSR	MUR_BAS
	MOVE	#"O0",([P_IMAGE],8.W)
	BRA.S	.INC_PARAM
.SOL0	
	SF	MURBAS_F
	MOVE.L	#COORD,COORD_P
	MOVE.L	#ZTRANS,ZTRANS_P
	MOVE.L	#TAMPIMG,P_IMAGE
	MOVE.L	#POLYBUF,P_POLY

	*AFFICHAGE LIE AU SOL
	MOVE	MURCOUNT,-(SP)
SOL_SUIVANT
	MOVE.L	P_IMAGE,A4
	CMP	#"SO",8(A4)
	BNE.S	.INC_PARAM
	CMP.L	#"NEPH",([COORD_P])
	BEQ.S	.INC_PARAM
	
	BSR	SOL_DISPLAY	
	
.INC_PARAM
	ADD.L	#32,COORD_P
	ADD.L	#16,ZTRANS_P
	ADD.L	#10,P_IMAGE
	SUBQ.W	#1,(SP)
	BNE.S	SOL_SUIVANT
	ADDQ.L	#2,SP

	MOVE.L	#COORD,COORD_P
	MOVE.L	#ZTRANS,ZTRANS_P
	MOVE.L	#TAMPIMG,P_IMAGE
	MOVE.L	#POLYBUF,P_POLY
	

MUR_SUIVANT
	SF	PORTE_F
	MOVE.L	P_IMAGE,A4
	CMP	#"LA",8(A4)
	BEQ	LASERS	
	CMP	#"SO",8(A4)
	BEQ	MUR_CACHE		*RELATIF AU SOL
	CMP	#"SB",8(A4)
	BEQ	MUR_CACHE		*RELATIF AU SOL
	CMP	#"MB",8(A4)
	BEQ	MUR_CACHE		*MUR BAS
	CMP	#"O0",8(A4)
	BEQ	MUR_CACHE
	CMP.L	#"NEPH",([COORD_P])
	BEQ	MUR_CACHE
	CMP	#"SE",8(A4)		*SOL ELEVE A AFFICHER
	BEQ	SOL_ELEVE

MUR_BAS	*POINT D'ENTREE DE L'AFFICHAGE D'UN MUR BAS
	MOVE.L	ZTRANS_P,A5
	
	MOVE	(A5),D0
	
	SUB	V_ECLSUB,D0
	EXT.L	D0
	MOVE	V_ECLINT,D2
	DIVS	D2,D0
	TST	D0
	BPL.S	.CHK1
	MOVEQ	#0,D0
.CHK1
	CMP	#30,D0
	BLO.S	.CHK2
	MOVEQ	#30,D0
.CHK2
	MOVE	D0,ECLDEB

	*******************************
	*ROUTAGE SUR AFFICHAGE OBJET SI NECESSAIRE
	MOVE	#XIMG,X_IMG
	MOVE	#XLARG,X_LARG
	MOVE	#YIMG,Y_IMG
	CMP.W	#"MU",8(A4)
	BEQ.S	.MUR
	CMP.B	#"P",9(A4)
	BEQ.S	.PORTE
	CMP.W	#"PE",8(A4)
	BNE	ZOOM_TRANS		*ZOOM TRANSPARENT
	*PERSO
	MOVE	#80,X_LARG
	MOVE	#80,X_IMG
	BRA	ZOOM_TRANS
.PORTE
	*ON Y VA POUR LA PORTE
	ST	PORTE_F
	MOVEQ	#0,D7
	MOVE.B	8(A4),D7
	MOVE	(TBL_PORTE,D7*2),D7	
	MOVE	#YIMG,D6
	SUB	D7,D6
	MOVE	D6,Y_IMG

	*********************************
.MUR	
	MOVE	6(A5),D1
	
	SUB	V_ECLSUB,D1
	EXT.L	D1
		*MOVE	V_ECLINT,D2
	DIVS	D2,D1
	TST	D1
	BPL.S	.CHK12
	MOVEQ	#0,D1
.CHK12
	CMP	#30,D1
	BLO.S	.CHK22
	MOVEQ	#30,D1
.CHK22

	MOVE	D1,ECLFIN
	
	
	***************************************
	
	LEA	BITMAP,A5
	
	*DECOUPE EN 3
	MOVE	X_IMG,D0
	EXT.L	D0
	DIVU	#3,D0
	CLR.L	(A5)+	
	MOVE	D0,(A5)+
	MOVE	Y_IMG,D2
	SUBQ	#1,D2
	MOVE	D2,(A5)+

	MOVE	ECLFIN,D2
	SUB	ECLDEB,D2
	EXT.L	D2
	DIVS	#3,D2
	
	MOVE	ECLDEB,D1
	MOVE	D1,(A5)+
	ADD	D2,D1
	MOVE	D1,(A5)+

	ADDQ	#1,D0
	MOVE	D0,(A5)+
	CLR	(A5)+
	ADD	D0,D0
	MOVE	D0,(A5)+
	MOVE	Y_IMG,D3
	SUBQ	#1,D3
	MOVE	D3,(A5)+
	MOVE	D1,(A5)+
	ADD	D2,D1
	MOVE	D1,(A5)+
	
	ADDQ	#1,D0
	MOVE	D0,(A5)+
	CLR	(A5)+
	MOVE	X_IMG,D0
	SUBQ	#1,D0
	MOVE	D0,(A5)+
	MOVE	Y_IMG,D0
	SUBQ	#1,D0
	MOVE	D0,(A5)+
	*ECLAIRAGE
	MOVE	D1,(A5)+
	MOVE	ECLFIN,(A5)+

	
	*RENDU BITMAP
	LEA	BITMAP,A5
	MOVE.L	COORD_P,A6
	MOVEQ	#2,D0
DECOUP3
	MOVE	D0,-(SP)
	MOVE	(A6),XA
	MOVE	2(A6),YA
	MOVE	4(A6),XB
	MOVE	6(A6),YB
	MOVE	16(A6),XD
	MOVE	18(A6),YD
	MOVE	20(A6),XC
	MOVE	22(A6),YC

	MOVE	(A5),XAP
	MOVE	2(A5),YAP
	MOVE	4(A5),XCP
	MOVE	6(A5),YCP
	MOVE	8(A5),DEBECL
	MOVE	10(A5),FINECL

	BSR	TEST_CLIP	*1ER CLIPPING
	BEQ	FIN_AFF

	TST.B	DBLH_F
	BEQ.S	.DBLH_ENDCX
	MOVE	4(A6),D0
	ADD	(A6),D0
	ASR	D0
	BCC.S	.NOAPP
	ADDQ	#1,D0
.NOAPP
	MOVE	D0,XB
	MOVE	D0,XD
.DBLH_ENDCX

*******************************************************
******  PASSAGE DE PARAMETRES AU DSP
	MOVE.L	#"MUR",D0
	BSR	DSP_WRITE	*ROUTE SUR AFFICHAGE MUR
	MOVEQ	#0,D0
	MOVE	YMICLIP_F,D0
	BSR	DSP_WRITE
	MOVE	YMACLIP_F,D0
	BSR	DSP_WRITE
	MOVE.L	BASE,D0
	BSR	DSP_WRITE
	MOVE	Y_IMG,D0
	SUBQ	#1,D0
	EXT.L	D0
	BSR	DSP_WRITE
	MOVE.L	X_LARG-2,D0
	BSR	DSP_WRITE
	MOVE.L	([P_IMAGE]),D0
	ADD.L	#36,D0
	BSR	DSP_WRITE
	MOVE.L	([P_IMAGE],4.W),D0
	BSR	DSP_WRITE

***** INIT DES PARAMETRES STRETCH

	*ECLAIRAGE
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	ECLFIN,D7
	LSL	#6,D7
	MOVE	DEBECL,D3
	LSL	#6,D3

	MOVE	XB,D2
	SUB	XA,D2
	BPL.S	.VABS0
	NEG	D2
.VABS0	
	ADDQ	#1,D2
	BNE.S	.NOZERO0
	MOVEQ	#1,D2
.NOZERO0
	MOVEQ	#64,D6
	MOVE	FINECL,D1
	SUB	DEBECL,D1
	BPL.S	.INCPO
	MOVEQ	#-64,D6
	NEG	D1
.INCPO
	EXT.L	D1
	DIVU	D2,D1
	MOVE	D1,D4
	ASL	#6,D4
	SWAP	D1
	TST	D6
	BPL.S	.UNBEL
	NEG	D4
.UNBEL
	*D4.W=QUOTIENT
	*D1.W=RESTE
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1
*	MOVEM	D0-D4/D6-D7,JEUREG4
	
	EXT.L	D0
	BSR	DSP_WRITE
	EXT.L	D1
	BSR	DSP_WRITE_D1
	EXT.L	D2
	BSR	DSP_WRITE_D2
	EXT.L	D3
	BSR	DSP_WRITE_D3
	EXT.L	D4
	BSR	DSP_WRITE_D4
	EXT.L	D6
	BSR	DSP_WRITE_D6
	EXT.L	D7
	BSR	DSP_WRITE_D7

********************* pour les droites : boucle sur DX uniquement > quotient

	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D7=INC X
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	YA,D3
	MOVE	XA,D0
	
	MOVE	D0,XCOL	*INIT XCOL
	EXT.L	D0
	BSR	DSP_WRITE
	
	TST.B	DBLH_F
	BEQ.S	.DBLH_ELSE
	MOVEQ	#2,D7
	BRA.S	.DBLH_ENDC
.DBLH_ELSE
	MOVEQ	#1,D7
.DBLH_ENDC
	
	MOVE	XB,D2
	SUB	XA,D2
	BPL.S	.VABS1

	TST.B	DBLH_F
	BEQ.S	.DBLH_ELSE2
	MOVEQ	#-2,D7
	BRA.S	.DBLH_ENDC2
.DBLH_ELSE2
	MOVEQ	#-1,D7
.DBLH_ENDC2
	NEG	D2
.VABS1	
	ADDQ	#1,D2
	BNE.S	.NOZERO1
	MOVEQ	#1,D2
.NOZERO1
	MOVEQ	#1,D6
	MOVE	YB,D1
	SUB	YA,D1
	BEQ.S	.ZER
	BPL.S	.INCPO1
	MOVEQ	#-1,D6
	NEG	D1
	BRA.S	.INCPO1
.ZER	MOVEQ	#0,D6
.INCPO1
	EXT.L	D1
	DIVU	D2,D1
	MOVE	D1,D4
	MOVE	D2,D5	*D5=I
	SUBQ	#1,D5		
	SWAP	D1
	TST	D6
	BPL.S	.UNBEL1
	NEG	D4
.UNBEL1
	*D4.W=QUOTIENT
	*D1.W=RESTE
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1
*	MOVEM	D0-D4/D6-D7,JEUREG1

	EXT.L	D5
	BSR	DSP_WRITE_D5
	TST	D5
	BMI	FIN_AFF	

	EXT.L	D0
	BSR	DSP_WRITE
	EXT.L	D1
	BSR	DSP_WRITE_D1
	EXT.L	D2
	BSR	DSP_WRITE_D2
	EXT.L	D3
	BSR	DSP_WRITE_D3
	EXT.L	D4
	BSR	DSP_WRITE_D4
	EXT.L	D6
	BSR	DSP_WRITE_D6
	EXT.L	D7
	BSR	DSP_WRITE_D7
	
NEWLOCAL

	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D7=INC X
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	YD,D3

	MOVE	XB,D2
	SUB	XA,D2
	
	BPL.S	.VABS1
	NEG	D2
.VABS1	
	ADDQ	#1,D2
	BNE.S	.NOZERO1
	MOVEQ	#1,D2
.NOZERO1
	MOVEQ	#1,D6
	MOVE	YC,D1
	SUB	YD,D1
	BEQ.S	.ZER
	BPL.S	.INCPO1
	MOVEQ	#-1,D6
	NEG	D1
	BRA.S	.INCPO1
.ZER	MOVEQ	#0,D6
.INCPO1
	EXT.L	D1
	DIVU	D2,D1
	MOVE	D1,D4
		
	SWAP	D1
	TST	D6
	BPL.S	.UNBEL1
	NEG	D4
.UNBEL1
	*D4.W=QUOTIENT
	*D1.W=RESTE
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1
*	MOVEM	D0-D4/D6,JEUREG2

	EXT.L	D0
	BSR	DSP_WRITE
	EXT.L	D1
	BSR	DSP_WRITE_D1
	EXT.L	D2
	BSR	DSP_WRITE_D2
	EXT.L	D3
	BSR	DSP_WRITE_D3
	EXT.L	D4
	BSR	DSP_WRITE_D4
	EXT.L	D6
	BSR	DSP_WRITE_D6

	*INITIALISATION DU POINTEUR MOTIF
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	XAP,D3
	MOVE	XB,D2
	SUB	XA,D2
	BPL.S	.VABS
	
	*TRAITEMENT D'UNE PORTE ?
	TST.B	PORTE_F
	BNE.S	.PORT		*AUTORISER VERSO
	*Sortie directe ! mur non visible - ABORT
	MOVEQ	#-1,D0
	BSR	DSP_WRITE
	ADDQ.L	#2,SP
	BRA	MUR_CACHE
.PORT	NEG	D2
.VABS	
	ADDQ	#1,D2
	BNE.S	.NOZERO
	MOVEQ	#1,D2
.NOZERO

	MOVE	XCP,D1
	SUB	XAP,D1
	EXT.L	D1
	DIVU	D2,D1
	MOVE	D1,D4
	SWAP	D1
	*D4.W=QUOTIENT
	*D1.W=RESTE
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1
*	MOVEM	D0-D4,JEUREG3	

	EXT.L	D0
	BPL.S	.OKPO
	MOVEQ	#0,D0		*<0=ABORT
.OKPO
	BSR	DSP_WRITE
	EXT.L	D1
	BSR	DSP_WRITE_D1
	EXT.L	D2
	BSR	DSP_WRITE_D2
	EXT.L	D3
	BSR	DSP_WRITE_D3
	EXT.L	D4
	BSR	DSP_WRITE_D4
	
***********************************************
*	RECUP DES PARAMS DSP
***********************************************

	MOVEQ	#0,D7
	MOVE.L	#640,D6
	*A0,A1,A2,A3,A4,A5,A6 PRIS
	LEA	$FFFFA202.W,A1		*PAS POUR DEBUGGER
	LEA	$FFFFA204.W,A2

FORI	
	BTST	#0,(A1)
	BEQ.S	FORI
	MOVE.L	(A2),A4		*BASE PALETTE

.WAITM2
	BTST	#0,(A1)	
	BEQ.S	.WAITM2
	MOVE.L	(A2),A3		*BASE ECRAN

.WAITM3
	BTST	#0,(A1)
	BEQ.S	.WAITM3
	MOVE.L	(A2),D4		*NOMBRE DE LIGNES
	EXT.L	D4
	BMI.S	.FIN_LIGNE
	
	*SELON DBLH_F
	
	TST.B	DBLH_F
	BEQ.S	.AUTRE_DBLH
	
	SUB.L	D6,A3
.PERF
	MOVE.L	(A2),A0
	ADD.L	D6,A3
	
	MOVE.B	(A0),D7
	MOVE.L	(A4,D7.W*4),(A3)	
	DBF	D4,.PERF
	
	BRA.S	.FIN_LIGNE

.AUTRE_DBLH
	SUB.L	D6,A3
.PERF2
	MOVE.L	(A2),A0
	
	ADD.L	D6,A3
	MOVE.B	(A0),D7
	MOVE	(A4,D7.W*4),(A3)	
	DBF	D4,.PERF2
.FIN_LIGNE

***************************************	
	DBF	D5,FORI

FIN_AFF	
	ADDQ.L	#4,A6
	LEA	12(A5),A5
	MOVE	(SP)+,D0
	DBF	D0,DECOUP3

MUR_CACHE
	*TESTE SI ON AVAIT DEMAND UN MUR_BAS
	TST.B	MURBAS_F
	BEQ.S	.TERMNORM	*NON
	RTS	
.TERMNORM
	ADD.L	#32,COORD_P
	ADD.L	#16,ZTRANS_P
	ADD.L	#10,P_IMAGE
	SUBQ.W	#1,MURCOUNT

	BNE	MUR_SUIVANT


	*POLYGONES DES LASERS

	MOVE.L	P_POLY,A5
	MOVE.L	BASE,A0
	MOVE	#-1,(A5)+
	LEA	POLYBUF,A5
.AUTRE
	MOVEM	(A5)+,D0-D3
	TST	D0
	BMI.S	.RTS
	BSR	DRAW_POLY
	BRA.S	.AUTRE
.RTS	
	RTS
	
SOL_ELEVE
	BSR	SOL_DISPLAY	
	BRA.S	MUR_CACHE
	
LASERS
	*AFFICHE LE LASER
	MOVEM	([P_IMAGE]),D0-D3
	MOVE.L	BASE,A0
	CMP.L	#"POLY",([COORD_P])
	BEQ.S	.POLYGONE
	BSR	DRAW_LINE
	BRA	MUR_CACHE
.POLYGONE
	*MEMORISE LE LASER (AFFICH A LA FIN SEULEMENT)
	MOVE.L	P_POLY,A0
	MOVEM	D0-D3,(A0)
	ADDQ.L	#8,P_POLY
	BRA	MUR_CACHE
	
TEST_CLIP_SOL
	*CLIPPING DU TOUT CACHE POUR UN SOL
	*Z=1 OK Z=0 : NE PAS AFFICHER
	MOVE	XA,D0
	MOVE	XB,D1
	CMP	D0,D1
	BGE.S	.NOEX1
	EXG	D0,D1		*D1=MAX(A,B) D0=MIN(A,B)
.NOEX1
	CMP	XC,D0
	BLT.S	.NOEX2
	MOVE	XC,D0		*D0=MIN(A,B,C)
.NOEX2
	CMP	XD,D0
	BLT.S	.NOEX3
	MOVE	XD,D0		*D0=MIN(A,B,C,D)
.NOEX3
	CMP	XC,D1
	BGT.S	.NOEX4
	MOVE	XC,D1
.NOEX4
	CMP	XD,D1
	BGT.S	.NOEX5
	MOVE	XD,D1
.NOEX5
	BRA.S	COMMUN_TST_CLIP
TEST_CLIP	*CLIPPING DU TOUT CACHE
	*Z=1 : OK ; 	Z=0 : NE PAS AFFICHER
	
	*RECHERCHE D'EXTREMA DE XA ET XB DANS D0(m) ET D1(M)
	MOVE	XA,D0
	MOVE	XB,D1
	CMP	D0,D1
	BGE.S	.OK
	EXG	D0,D1
.OK
COMMUN_TST_CLIP
	CMP	#XMICLIP,D1
	BLT.S	.ZAU
	CMP	#XMACLIP,D0
	BGT.S	.ZAU
	
	*RECHERCHE D'EXTREMA DE YA,YB,YC,YD DANS D0(m) ET D1 (M)
	MOVE	YA,D0
	MOVE	YB,D1
	MOVE	YC,D2
	MOVE	YD,D3
	
	CMP	D0,D1
	BGE.S	.OK2
	EXG	D0,D1
.OK2	CMP	D2,D0
	BLE.S	.OK3
	MOVE	D2,D0
.OK3	CMP	D3,D0
	BLE.S	.OK4
	MOVE	D3,D0
.OK4	
	CMP	D2,D1
	BGE.S	.OK5
	MOVE	D2,D1
.OK5	CMP	D3,D1
	BGE.S	.OK6
	MOVE	D3,D1
.OK6
	
	CMP	YMICLIP_F,D1
	BLT.S	.ZAU
	CMP	YMACLIP_F,D0
	BGT.S	.ZAU

	AND	#%11111011,CCR
	RTS
.ZAU	
	OR	#%00000100,CCR

	RTS

ZOOM_TRANS	*`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\`\
	
	*RENDU BITMAP
	* ENGLOBANT : (COORD,COORD+2)-(COORD+4,+6)
	
	MOVE.L	COORD_P,A6
	
	MOVE	(A6),XA		*A LAISSER EN L'ETAT (COMPATIBILITE)
	MOVE	2(A6),YA
	MOVE	4(A6),XC
	MOVE	6(A6),YC
	MOVE	(A6),XD
	MOVE	6(A6),YD
	MOVE	4(A6),XB
	MOVE	2(A6),YB

	CLR	XAP
	CLR	YAP
	MOVE	X_IMG,D0
	SUBQ	#1,D0
	MOVE	D0,XCP
	MOVE	Y_IMG,D0
	SUBQ	#1,D0
	MOVE	D0,YCP
	*ECLAIRAGE : ECLDEB

	BSR	TEST_CLIP	*1ER CLIPPING (TJRS VALABLE)
	BEQ	FIN_AFF_O

	TST.B	DBLH_F
	BEQ.S	.DBLH_ENDCY
	MOVE	4(A6),D0
	ADD	(A6),D0
	ASR	D0
	BCC.S	.NOAPP
	ADDQ	#1,D0
.NOAPP
	MOVE	D0,XB
	MOVE	D0,XD
.DBLH_ENDCY

*******************************************************
***** INIT DES PARAMETRES STRETCH

	*ECLAIRAGE
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	ECLDEB,D3
	LSL	#6,D3
	MOVE.L	([P_IMAGE],4.W),A4
	*LEA 	PALS,A4
	ADD	D3,A4		*ECLAIRAGE

********************* pour les droites : boucle sur DX uniquement > quotient
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D7=INC X
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1

	MOVE	XA,XCOL	*INIT XCOL
	TST.B	DBLH_F
	BNE.S	.DBLH_ELSE
	MOVEQ	#1,D7
	BRA.S	.DBLH_ENDC
.DBLH_ELSE
	MOVEQ	#2,D7
.DBLH_ENDC
	
	MOVE	XB,D2
	SUB	XA,D2
	BPL.S	.VABS1
	
	TST.B	DBLH_F
	BNE.S	.DBLH_ELSE2
	MOVEQ	#-1,D7
	BRA.S	.DBLH_ENDC2
.DBLH_ELSE2
	MOVEQ	#-2,D7
.DBLH_ENDC2
	NEG	D2
.VABS1	
	SUB	D7,XCOL
	TST	D2
	BNE.S	.NOZERO1
	MOVEQ	#1,D2
.NOZERO1
	MOVE	D2,D5	*D5=I
	
	MOVE	YA,D4
	MOVE	D4,TOPCOL
	EXT.L	D4
	MULS	#640,D4
	MOVE.L	D4,JEUREG2

	MOVE	YD,BOTCOL
	MOVE	D7,JEUREG1

	*PRES POUR SIMULATION CLIPPING
	MOVE.L	BASE,A0
	

	MOVE.L	([P_IMAGE]),A1

	LEA	4+32(A1),A1

	MOVE	BOTCOL,D4
	SUB	TOPCOL,D4
	*INITIALISATION DU POINTEUR LIGNE VERT
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	Y_IMG,D1
	SUBQ	#1,D1
	EXT.L	D1
	DIVU	D4,D1

	MOVE	D1,D6
	EXT.L	D6
	MOVE.L	X_LARG-2,D2
	MULU	D2,D6	*OPTIMIS SUR UN 68030
	SWAP	D1
	SUBQ	#1,D1
	*D6.W=QUOTIENT
	*D1.W=RESTE
	MOVE	D4,D2
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1

	MOVE	YMACLIP_F,D7
	CMP	BOTCOL,D7
	BGT.S	.CLIPOK
	MOVE	D7,D4
	SUB	TOPCOL,D4
	MOVE	D7,BOTCOL
	
	*RIEN A AFFICHER ?
	CMP	#YMACLIP,TOPCOL
	BGT	FIN_AFF_O
	
.CLIPOK
	MOVE	YMICLIP_F,D7
	CMP	TOPCOL,D7
	BLT.S	.NO_CLIP
	*RIEN A AFFICHER ?
	CMP	BOTCOL,D7
	BGT	FIN_AFF_O
	
	*LE PLUS COMPLIQUE DES CAS : MANGE EN HAUT
	MOVE	YMICLIP_F,D3
	SUB	TOPCOL,D3
	MOVE	YMICLIP_F,TOPCOL
	
	SUB	D3,D4
	MOVE	D3,D7
	
	EXT.L	D3
	MULU	#640,D3
	ADD.L	D3,A0
	*MISE A JOUR DU POINTEUR DE MOTIF
	MOVE.L	X_LARG-2,A3
.PERFSIM
	ADD.L	D6,A1
	ADD	D1,D0
	BMI.S	.WEND3SIM
	SUB	D2,D0
	ADD.L	A3,A1
.WEND3SIM
	DBF	D7,.PERFSIM

.NO_CLIP

	*OPTIMISATION HORIZONTALE : SCANNE LA PREMIERE LIGNE

	*MISE A JOUR DU POINTEUR DE MOTIF
		MOVE.L	X_LARG-2,A3
.PERFSIM2
		BTST	#6,(A1)
		BEQ.S	.SORTIE
		LEA	640(A0),A0
		ADDQ	#1,TOPCOL
		ADD.L	D6,A1
		ADD	D1,D0
		BMI.S	.WEND3SIM2
		SUB	D2,D0
		ADD.L	A3,A1
.WEND3SIM2
		DBF	D4,.PERFSIM2
		BRA	FIN_AFF_O
.SORTIE

	MOVE.L	A1,JEUREG2+4
	ADD.L	JEUREG2,A0
	MOVE.L	A0,JEUREG2
	MOVEM	D0-D2/D4/D6,JEUREG1+4

	LEA	640.W,A2
	MOVE.L	X_LARG-2,A3
	
	*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


	*INITIALISATION DU POINTEUR MOTIF
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	XAP,D3
	MOVE	XB,D2
	SUB	XA,D2
	BPL.S	.VABS
	NEG	D2
.VABS	
	TST	D2
	BNE.S	.NOZERO
	MOVEQ	#1,D2
.NOZERO

	MOVE	XCP,D1
	SUB	XAP,D1
	EXT.L	D1
	DIVU	D2,D1
	MOVE	D1,D4
	SWAP	D1
	*D4.W=QUOTIENT
	*D1.W=RESTE
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1
	MOVEM	D0-D4,JEUREG3	


	SUBQ	#2,D5
FORI_O	

	MOVE.W	JEUREG1,D7
	ADD	D7,XCOL


	*LIGNE HAUT/BAS MOTIF
	
	MOVEM.W	JEUREG3,D0-D4
		*A CHAQUE IT TQ D0>=0 D0-=D2 D3+=D4 FINTQ D0+=D1

	ADD	D4,D3
	
	ADD	D1,D0
	BMI.S	.WEND2
	SUB	D2,D0
	ADDQ	#1,D3
.WEND2
	
	MOVEM.W	D0-D4,JEUREG3
	*VALEUR COURANTE CONTENUE DANS JEUREG3+6
	
	*---------------------------------------------------------PLOT XCOL,TOPCOL->BOTCOL
 
	MOVE.L	JEUREG2,A0
	MOVE	XCOL,D0
	ADD	D0,D0
	ADD	D0,A0

		*VALEUR COURANTE MOTIF CONTENUE DANS JEUREG3+6
	
	MOVE.L	JEUREG2+4,A1
	MOVEQ	#0,D3
	MOVE	JEUREG3+6,D3
	ADD.L	D3,A1

	*LIGNE VIDE ?
	BTST	#7,(A1)
	BNE	.FIN_LIGNE		*LIGNE VIDE
	
	MOVEM	JEUREG1+4,D0-D2/D4/D6

********************************
	MOVE	XCOL,D3
	CMP	#XMICLIP,D3
	BLT	.FIN_LIGNE
	CMP	#XMACLIP,D3
	BGT	.FIN_LIGNE

	MOVEQ	#0,D7
	*REGISTRES LIBRES : D3 
	TST.B	DBLH_F
	BEQ.S	.AUTRE_DBLH

	ADDQ	#1,D4	
	BTST	#0,D4
	BEQ.S	.PAIR

	MOVE.B	(A1),D7
	BEQ.S	.TRANSP1
	MOVE.L	(A4,D7.W*4),(A0)	
.TRANSP1
	ADD.L	A2,A0
	ADD.L	D6,A1

	ADD	D1,D0
	BMI.S	.PAIR
	SUB	D2,D0
	ADD.L	A3,A1
.PAIR
	ASR	D4
	SUBQ	#1,D4
	BMI.S	.FIN_LIGNE
.PERF
	MOVE.B	(A1),D7
	BEQ.S	.TRANSP
	MOVE.L	(A4,D7.W*4),(A0)	
.TRANSP
	ADD.L	A2,A0
	ADD.L	D6,A1

	ADD	D1,D0
	BMI.S	.WEND3
	SUB	D2,D0
	ADD.L	A3,A1
.WEND3
	MOVE.B	(A1),D7
	BEQ.S	.TRANSP2L
	MOVE.L	(A4,D7.W*4),(A0)	
.TRANSP2L
	ADD.L	A2,A0
	ADD.L	D6,A1

	ADD	D1,D0
	BMI.S	.WEND4
	SUB	D2,D0
	ADD.L	A3,A1
.WEND4
	DBF	D4,.PERF
	BRA.S	.FIN_LIGNE

.AUTRE_DBLH
	ADDQ	#1,D4	
	BTST	#0,D4
	BEQ.S	.PAIR

	MOVE.B	(A1),D7
	BEQ.S	.TRANSP12
	MOVE	(A4,D7.W*4),(A0)	
.TRANSP12
	ADD.L	A2,A0
	ADD.L	D6,A1

	ADD	D1,D0
	BMI.S	.PAIR2
	SUB	D2,D0
	ADD.L	A3,A1
.PAIR2
	ASR	D4
	SUBQ	#1,D4
	BMI.S	.FIN_LIGNE
.PERF2
	MOVE.B	(A1),D7
	BEQ.S	.TRANSP2
	MOVE	(A4,D7.W*4),(A0)	
.TRANSP2
	ADD.L	A2,A0
	ADD.L	D6,A1

	ADD	D1,D0
	BMI.S	.WEND32
	SUB	D2,D0
	ADD.L	A3,A1
.WEND32
	MOVE.B	(A1),D7
	BEQ.S	.TRANSP22
	MOVE	(A4,D7.W*4),(A0)	
.TRANSP22
	ADD.L	A2,A0
	ADD.L	D6,A1

	ADD	D1,D0
	BMI.S	.WEND42
	SUB	D2,D0
	ADD.L	A3,A1
.WEND42
	DBF	D4,.PERF2

.FIN_LIGNE

***************************************	
	DBF	D5,FORI_O
FIN_AFF_O	
	TST.B	MURBAS_F
	BEQ.S	.TERMNORM	*NON
	RTS	
.TERMNORM
	ADD.L	#32,COORD_P
	ADD.L	#16,ZTRANS_P
	ADD.L	#10,P_IMAGE
	SUBQ.W	#1,MURCOUNT

	BNE	MUR_SUIVANT
	RTS

SOL_DISPLAY	*WMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWM
		*M		   AFFICHE LE SOL		    W
		*WMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWM

	MOVE.L	SP,CLIP_TOT_SOL
 	*RENDU BITMAP
	MOVE.L	COORD_P,A6
	MOVE.L	ZTRANS_P,A5

	MOVE.W	DIR,D0
	JMP	([.ROUT,PC,D0*4])
	
.ROUT	DC.L	.D0,.D0,.D2,.D2,.D4,.D4,.D6,.D6

.D0	MOVE	(A6),XA
	MOVE	2(A6),YA
	MOVE	12(A6),XB
	MOVE	14(A6),YB
	MOVE	16(A6),XD
	MOVE	18(A6),YD
	MOVE	28(A6),XC
	MOVE	30(A6),YC
	BRA	.JOIN

.D6	MOVE	(A6),XD
	MOVE	2(A6),YD
	MOVE	12(A6),XA
	MOVE	14(A6),YA
	MOVE	16(A6),XC
	MOVE	18(A6),YC
	MOVE	28(A6),XB
	MOVE	30(A6),YB
	BRA.S	.JOIN

.D4	MOVE	(A6),XC
	MOVE	2(A6),YC
	MOVE	12(A6),XD
	MOVE	14(A6),YD
	MOVE	16(A6),XB
	MOVE	18(A6),YB
	MOVE	28(A6),XA
	MOVE	30(A6),YA

	BRA.S	.JOIN
.D2	MOVE	(A6),XB
	MOVE	2(A6),YB
	MOVE	12(A6),XC
	MOVE	14(A6),YC
	MOVE	16(A6),XA
	MOVE	18(A6),YA
	MOVE	28(A6),XD
	MOVE	30(A6),YD

.JOIN
	CLR	XAP
	CLR	YAP
	MOVE	#BIT_SOLX-1,XCP		*TAILLE SOL
	MOVE	#BIT_SOLY-1,YCP


	*ECLAIRAGE : ECLDEB DEJA FAIT A PARTIR DE (A5)
	MOVE	(A5),D0
	MOVE	14(A5),D1
	
	CMP	D1,D0
	BGT.S	.NORM
	EXG	D0,D1
.NORM
	
	*D0=DEBUT
	SUB	V_ECLSUB,D0
	EXT.L	D0
	MOVE	V_ECLINT,D2
	DIVS	D2,D0
	TST	D0
	BPL.S	.CHK1
	MOVEQ	#0,D0
.CHK1
	CMP	#30,D0
	BLO.S	.CHK2
	MOVEQ	#30,D0
.CHK2
	MOVE	D0,ECLDEB
	*D1=FIN
	
	SUB	V_ECLSUB,D1
	EXT.L	D1
	DIVS	D2,D1
	TST	D1
	BPL.S	.CHK12
	MOVEQ	#0,D1
.CHK12
	CMP	#30,D1
	BLO.S	.CHK22
	MOVEQ	#30,D1
.CHK22

	MOVE	D1,ECLFIN


	BSR	TEST_CLIP_SOL	*1ER CLIPPING 
	BEQ	FIN_AFF_S

	MOVE.L	BASE,A0
	MOVE.L	P_IMAGE,A1
	MOVE.L	(A1)+,A6		*BITMAP
	MOVE.L	(A1)+,A5		*PALETTE
	LEA	4+32(A6),A6
	
	MOVE.L	A6,LIM_MOT
	MOVE.L	A6,D0
	ADD.L	#BIT_SOLX*BIT_SOLX-2,D0
	MOVE.L	D0,LIM_MOT+4

	********************************************************
	*EGALITES NON TRAITEES
	*SHADOWISE POUR CIRCULARITE
	MOVE.L	XD,XDSOV	*(XD&YD)
	MOVE.L	XA,XASOV
	MOVE	XAP,XDP
	MOVE	YCP,YDP
	MOVE	XCP,XBP
	MOVE	YAP,YBP
	MOVE.L	XAP,XAPSOV
	MOVE.L	XDP,XDPSOV
	*
	*DETERMINE L'ORDRE DES Y
	*
	MOVE	YA,D0
	MOVE	YB,D1
	MOVE	YC,D2
	MOVE	YD,D3
	MOVEQ	#0,D4
	CMP	D0,D1	*YA>YB ?
	BGE.S	.WRGTST1
	MOVEQ	#1,D4
.WRGTST1
	CMP	D0,D2
	BGE.S	.WRGTST2
	ORI.B	#2,D4
.WRGTST2
	CMP	D0,D3
	BGE.S	.WRGTST3
	ORI.B	#4,D4
.WRGTST3
	CMP	D1,D2
	BGE.S	.WRGTST4
	ORI.B	#8,D4
.WRGTST4
	CMP	D1,D3
	BGE.S	.WRGTST5
	ORI.B	#16,D4
.WRGTST5
	CMP	D2,D3
	BGE.S	.WRGTST6
	ORI.B	#32,D4
.WRGTST6
	MOVE.B	(ORDRE,D4.W),D3
	MOVE.B	D3,D0
	AND	#$C0,D0		*D0=ORD1
	LSR	#6,D0
	MOVE.B	D3,D1
	AND	#$30,D1
	LSR	#4,D1		*D1=ORD2
	MOVE.B	D3,D2
	AND	#$C,D2		*D2=ORD3
	LSR	#2,D2
	AND	#$3,D3		*D3=ORD4
	
	LEA	LET,A1
	CLR.L	(A1,D0*4)
	MOVE.L	#4,(A1,D1*4)
	MOVE.L	#8,(A1,D2*4)
	MOVE.L	#12,(A1,D3*4)
	
	*
	*PASSE 1
	*
	*ECLAIRAGE
	*D0=COMPTEUR D1=VALEUR A ATTEINDRE D2=NBRE D'ITERATIONS D3=VAL ACTUELLE D4=INCR
	*D0 INIT A D1 - A CHAQUE IT TQ D0>=0 D0-=2D2 D3+=D4 FINTQ D0+=2D1
	MOVE	ECLFIN,D7
	LSL	#6,D7
	MOVE	ECLDEB,D3
	LSL	#6,D3

	MOVE	([A1],YA),D2
	SUB	([12.W,A1],YA),D2
	BPL.S	.VABS0EC
	NEG	D2
.VABS0EC
	ADDQ	#1,D2
	BNE.S	.NOZERO0
	MOVEQ	#1,D2
.NOZERO0
	MOVEQ	#64,D6
	MOVE	ECLFIN,D1
	SUB	ECLDEB,D1
	BPL.S	.INCPO
	MOVEQ	#-64,D6
	NEG	D1
.INCPO
	EXT.L	D1
	DIVU	D2,D1
	MOVE	D1,D4
	ASL	#6,D4
	SWAP	D1
	TST	D6
	BPL.S	.UNBEL
	NEG	D4
.UNBEL
	*D4.W=QUOTIENT
	*D1.W=RESTE
	ADD	D2,D2
	MOVE	D1,D0
	ADD	D1,D1
	MOVEM	D0-D4/D6-D7,JEUREG4




	*PE SUR (1,PRED 1) L  L
	
	MOVE	([A1],YA),D3
	MOVE	D3,YE
	MOVE	([A1],XA),D1
	MOVE	D1,XPE
	ADD	D1,XPE
	MOVE	([A1],XA-4),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSPE
	NEG	D0
	MOVEQ	#-2,D2
.VABSPE
	MOVE	D0,DXPE
	ADD	D0,DXPE
	MOVE	D2,S1PE
	MOVE	([A1],YA-4),D1
	SUB	D3,D1			*D3=YE
	ADD	D1,D1
	MOVE	D1,DYPE
	SUB	D0,D1		
	MOVE	D1,EPE		
	
	* QE SR 1,SUCC 1 L  L
	
	MOVE	([A1],XA),D0
	MOVE	D0,XQE
	ADD	D0,XQE
	MOVEQ	#2,D1
	MOVE	([A1],XA+4),D2
	SUB	D0,D2
	BPL.S	.VABSQE
	NEG	D2
	MOVEQ	#-2,D1
.VABSQE
	MOVE	D2,DXQE
	ADD	D2,DXQE
	MOVE	D1,S1QE
	MOVE	([A1],YA+4),D0
	SUB	D3,D0
	ADD	D0,D0
	MOVE	D0,DYQE
	SUB	D2,D0		*d7
	MOVE	D0,EQE
	
	*INITU EN (1',PRED 1') ARRIVE EN PRED 1' EN DYE IT
	
	MOVE	([A1],XAP),D0
	MOVE	D0,XU
	MOVE	([A1],XAP-4),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSU
	NEG	D0
	MOVEQ	#1,D2
.VABSU
	MOVE	D0,DXU
	BNE.S	.NOZERO1
	MOVEQ	#0,D2
.NOZERO1
	MOVE	D2,S1U
	MOVE	([A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YU
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([A1],YAP-4),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSUY
	NEG	D2
	NEG	D1
.VABSUY
	BNE.S	.NOZERO2
	MOVEQ	#0,D2
.NOZERO2
	MOVE	D2,S2U
	ADD	D1,D0
	MOVE	D0,AU
	MOVE	D1,DYU
	MOVE	([A1],YA-4),D0
	SUB	YE,D0
	MOVE	D0,NU
	LSR	D0
	MOVE	D0,COMPU
	
	*INITV
	*V EN 1' SUR (1',SUCC 1') - ARRIVE EN SUCC1' EN DYE IT 
	MOVE	([A1],XAP),D0
	MOVE	D0,XVV
	MOVE	([A1],XAP+4),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSV
	NEG	D0
	MOVEQ	#1,D2
.VABSV
	MOVE	D0,DXV
	BNE.S	.NOZEROV1
	MOVEQ	#0,D2
.NOZEROV1
	MOVE	D2,S1V
	MOVE	([A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YVV
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([A1],YAP+4),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSVY
	NEG	D2
	NEG	D1
.VABSVY
	BNE.S	.NOZEROV2
	MOVEQ	#0,D2
.NOZEROV2
	MOVE	D2,S2V
	ADD	D1,D0
	MOVE	D0,AV
	MOVE	D1,DYV
	MOVE	([A1],YA+4),D0
	SUB	YE,D0
	MOVE	D0,NV
	LSR	D0
	MOVE	D0,COMPV
	
	*INIT BASE ECRAN
	MOVE	YE,D1
	EXT.L	D1
	MULS	#640,D1
	ADD.L	D1,A0
	
	
	MOVE	([4.W,A1],YA),D1
	CMP	([A1],YA),D1
	BEQ.S	.PASSE2

	BSR	LINE_HORIZ_PERFORM_2
.PASSE2

	*SELECTION SELON LES CAS
	MOVE.L	4(A1),D0
	LSR	#2,D0
	ADDQ	#1,D0
	AND.B	#%11,D0
	LSL	#2,D0
	CMP.L	8(A1),D0
	BEQ	.CAS1
	
	MOVE.L	4(A1),D1
	LSR	#2,D1
	SUBQ.B	#1,D1
	AND.B	#%11,D1
	LSL	#2,D1
	CMP.L	8(A1),D1
	BEQ	.CAS2

	CMP.L	12(A1),D0
	BEQ	.CAS3
	
*CAS4 (FORCEMENT !)
	MOVE	([4.W,A1],XA),D1
	MOVE	D1,XPE
	ADD	D1,XPE
	MOVE	([12.W,A1],XA),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSPEK4
	NEG	D0
	MOVEQ	#-2,D2
.VABSPEK4
	MOVE	D0,DXPE
	ADD	D0,DXPE
	MOVE	D2,S1PE
	MOVE	([12.W,A1],YA),D1
	SUB	YE,D1			
	ADD	D1,D1
	MOVE	D1,DYPE
	SUB	D0,D1		
	MOVE	D1,EPE		
	
	*INIT U
	MOVE	([4.W,A1],XAP),D0
	MOVE	D0,XU
	MOVE	([12.W,A1],XAP),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSUK4
	NEG	D0
	MOVEQ	#1,D2
.VABSUK4
	MOVE	D0,DXU
	BNE.S	.NOZERO1K4
	MOVEQ	#0,D2
.NOZERO1K4
	MOVE	D2,S1U
	MOVE	([4.W,A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YU
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([12.W,A1],YAP),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSUYK4
	NEG	D2
	NEG	D1
.VABSUYK4
	BNE.S	.NOZERO2K4
	MOVEQ	#0,D2
.NOZERO2K4
	MOVE	D2,S2U
	ADD	D1,D0
	MOVE	D0,AU
	MOVE	D1,DYU
	MOVE	([12.W,A1],YA),D0
	SUB	YE,D0
	MOVE	D0,NU
	LSR	D0
	MOVE	D0,COMPU

	BRA	.JOIN_K1
.CAS1
	MOVE	([4.W,A1],XA),D1
	MOVE	D1,XQE
	ADD	D1,XQE
	MOVE	([8.W,A1],XA),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSQEK1
	NEG	D0
	MOVEQ	#-2,D2
.VABSQEK1
	MOVE	D0,DXQE
	ADD	D0,DXQE
	MOVE	D2,S1QE
	MOVE	([8.W,A1],YA),D1
	SUB	YE,D1			
	ADD	D1,D1
	MOVE	D1,DYQE
	SUB	D0,D1		
	MOVE	D1,EQE		
	
	*INIT V
	MOVE	([4.W,A1],XAP),D0
	MOVE	D0,XVV
	MOVE	([8.W,A1],XAP),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSVK1
	NEG	D0
	MOVEQ	#1,D2
.VABSVK1
	MOVE	D0,DXV
	BNE.S	.NOZEROV1K1
	MOVEQ	#0,D2
.NOZEROV1K1
	MOVE	D2,S1V
	MOVE	([4.W,A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YVV
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([8.W,A1],YAP),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSVYK1
	NEG	D2
	NEG	D1
.VABSVYK1
	BNE.S	.NOZEROV2K1
	MOVEQ	#0,D2
.NOZEROV2K1
	MOVE	D2,S2V
	ADD	D1,D0
	MOVE	D0,AV
	MOVE	D1,DYV
	MOVE	([8.W,A1],YA),D0
	SUB	YE,D0
	MOVE	D0,NV
	LSR	D0
	MOVE	D0,COMPV
	BRA	.JOIN_K1

.CAS2
	MOVE	([4.W,A1],XA),D1
	MOVE	D1,XPE
	ADD	D1,XPE
	MOVE	([8.W,A1],XA),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSPEK2
	NEG	D0
	MOVEQ	#-2,D2
.VABSPEK2
	MOVE	D0,DXPE
	ADD	D0,DXPE
	MOVE	D2,S1PE
	MOVE	([8.W,A1],YA),D1
	SUB	YE,D1			
	ADD	D1,D1
	MOVE	D1,DYPE
	SUB	D0,D1		
	MOVE	D1,EPE		
	
	*INIT U
	MOVE	([4.W,A1],XAP),D0
	MOVE	D0,XU
	MOVE	([8.W,A1],XAP),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSUK2
	NEG	D0
	MOVEQ	#1,D2
.VABSUK2
	MOVE	D0,DXU
	BNE.S	.NOZERO1K2
	MOVEQ	#0,D2
.NOZERO1K2
	MOVE	D2,S1U
	MOVE	([4.W,A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YU
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([8.W,A1],YAP),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSUYK2
	NEG	D2
	NEG	D1
.VABSUYK2
	BNE.S	.NOZERO2K2
	MOVEQ	#0,D2
.NOZERO2K2
	MOVE	D2,S2U
	ADD	D1,D0
	MOVE	D0,AU
	MOVE	D1,DYU
	MOVE	([8.W,A1],YA),D0
	SUB	YE,D0
	MOVE	D0,NU
	LSR	D0
	MOVE	D0,COMPU
	BRA	.JOIN_K1
	
.CAS3
	MOVE	([4.W,A1],XA),D1
	MOVE	D1,XQE
	ADD	D1,XQE
	MOVE	([12.W,A1],XA),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSQEK3
	NEG	D0
	MOVEQ	#-2,D2
.VABSQEK3
	MOVE	D0,DXQE
	ADD	D0,DXQE
	MOVE	D2,S1QE
	MOVE	([12.W,A1],YA),D1
	SUB	YE,D1			
	ADD	D1,D1
	MOVE	D1,DYQE
	SUB	D0,D1		
	MOVE	D1,EQE		
	
	*INIT V
	MOVE	([4.W,A1],XAP),D0
	MOVE	D0,XVV
	MOVE	([12.W,A1],XAP),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSVK3
	NEG	D0
	MOVEQ	#1,D2
.VABSVK3
	MOVE	D0,DXV
	BNE.S	.NOZEROV1K3
	MOVEQ	#0,D2
.NOZEROV1K3
	MOVE	D2,S1V
	MOVE	([4.W,A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YVV
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([12.W,A1],YAP),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSVYK3
	NEG	D2
	NEG	D1
.VABSVYK3
	BNE.S	.NOZEROV2K3
	MOVEQ	#0,D2
.NOZEROV2K3
	MOVE	D2,S2V
	ADD	D1,D0
	MOVE	D0,AV
	MOVE	D1,DYV
	MOVE	([12.W,A1],YA),D0
	SUB	YE,D0
	MOVE	D0,NV
	LSR	D0
	MOVE	D0,COMPV

.JOIN_K1
	
	MOVE	([8.W,A1],YA),D1
	BSR	LINE_HORIZ_PERFORM_2

*.PASSE3
	
	MOVE.L	4(A1),D0
	LSR	#2,D0
	ADDQ	#1,D0
	AND.B	#%11,D0
	LSL	#2,D0
	CMP.L	8(A1),D0
	BEQ	.CAS14
	
	MOVE.L	8(A1),D1
	LSR	#2,D1
	ADDQ	#1,D1
	AND.B	#%11,D1
	LSL	#2,D1
	CMP.L	12(A1),D1
	BEQ	.CAS14
	*
	*CAS 2&3 (FORCEMENT)	

	MOVE	([8.W,A1],XA),D1
	MOVE	D1,XPE
	ADD	D1,XPE
	MOVE	([12.W,A1],XA),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSPEK23
	NEG	D0
	MOVEQ	#-2,D2
.VABSPEK23
	MOVE	D0,DXPE
	ADD	D0,DXPE
	MOVE	D2,S1PE
	MOVE	([12.W,A1],YA),D1
	SUB	YE,D1			
	ADD	D1,D1
	MOVE	D1,DYPE
	SUB	D0,D1		
	MOVE	D1,EPE		
	
	*INIT U
	MOVE	([8.W,A1],XAP),D0
	MOVE	D0,XU
	MOVE	([12.W,A1],XAP),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSUK23
	NEG	D0
	MOVEQ	#1,D2
.VABSUK23
	MOVE	D0,DXU
	BNE.S	.NOZERO1K23
	MOVEQ	#0,D2
.NOZERO1K23
	MOVE	D2,S1U
	MOVE	([8.W,A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YU
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([12.W,A1],YAP),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSUYK23
	NEG	D2
	NEG	D1
.VABSUYK23
	BNE.S	.NOZERO2K23
	MOVEQ	#0,D2
.NOZERO2K23
	MOVE	D2,S2U
	ADD	D1,D0
	MOVE	D0,AU
	MOVE	D1,DYU
	MOVE	([12.W,A1],YA),D0
	SUB	YE,D0
	MOVE	D0,NU
	LSR	D0
	MOVE	D0,COMPU


	BRA	.JOIN_K2

.CAS14
	MOVE	([8.W,A1],XA),D1
	MOVE	D1,XQE
	ADD	D1,XQE
	MOVE	([12.W,A1],XA),D0
	MOVEQ	#2,D2
	SUB	D1,D0
	BPL.S	.VABSQEK14
	NEG	D0
	MOVEQ	#-2,D2
.VABSQEK14
	MOVE	D0,DXQE
	ADD	D0,DXQE
	MOVE	D2,S1QE
	MOVE	([12.W,A1],YA),D1
	SUB	YE,D1			
	ADD	D1,D1
	MOVE	D1,DYQE
	SUB	D0,D1		
	MOVE	D1,EQE		
	
	*INIT V
	MOVE	([8.W,A1],XAP),D0
	MOVE	D0,XVV
	MOVE	([12.W,A1],XAP),D1
	MOVEQ	#-1,D2
	SUB	D1,D0
	BPL.S	.VABSVK14
	NEG	D0
	MOVEQ	#1,D2
.VABSVK14
	MOVE	D0,DXV
	BNE.S	.NOZEROV1K14
	MOVEQ	#0,D2
.NOZEROV1K14
	MOVE	D2,S1V
	MOVE	([8.W,A1],YAP),D3	*D3=YU
	MOVE	D3,D4
	EXT.L	D4
	MULU	#BIT_SOLX,D4
	MOVE	D4,YVV
	
	MOVEQ	#BIT_SOLX,D2
	MOVE	([12.W,A1],YAP),D1
	SUB	D3,D1			*D3=YU/80
	BPL.S	.VABSVYK14
	NEG	D2
	NEG	D1
.VABSVYK14
	BNE.S	.NOZEROV2K14
	MOVEQ	#0,D2
.NOZEROV2K14
	MOVE	D2,S2V
	ADD	D1,D0
	MOVE	D0,AV
	MOVE	D1,DYV
	MOVE	([12.W,A1],YA),D0
	SUB	YE,D0
	MOVE	D0,NV
	LSR	D0
	MOVE	D0,COMPV
.JOIN_K2
	MOVE	([12.W,A1],YA),D1
	CMP	([8.W,A1],YA),D1
	BEQ.S	FIN_AFF_S
	BRA.S	LINE_HORIZ_PERFORM_2			*&RTS
		
	********************************************************
	
	
FIN_AFF_S
	RTS


LINE_HORIZ_PERFORM_2		*ENTREE : D1=YE DE TERMINAISON
	PEA	(A1)
	PEA	(A5)
	PEA	(A6)
	MOVE	D1,-(SP)		*TERMINAISON
	
	*LIMITES DU MOTIF DANS LIM_MOT (POUR CMP2)


	LEA	$FFFFA204.W,A3
	LEA	$FFFFA202.W,A1
	
	MOVE.L	#"SOL",D0
	BSR	DSP_WRITE
	EXT.L	D1
	BSR	DSP_WRITE_D1
	MOVE.L	A5,D0
	BSR	DSP_WRITE
	MOVE.L	A6,D0
	BSR	DSP_WRITE
	MOVE	YMICLIP_F,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	YMACLIP_F,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4+2,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4+4,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4+6,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4+8,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4+10,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	JEUREG4+12,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	YE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	XU,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	YU,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	XVV,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	YVV,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	XPE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	XQE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE.L	A0,D0
	BSR	DSP_WRITE
	MOVE.B	DBLVS_F,D0
	EXTB.L	D0
	MOVE.L	D0,(A3)
	MOVE	DYPE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	EPE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	S1PE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	S1QE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	DXPE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	DXQE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	DYQE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	EQE,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	NU,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	S1U,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	AU,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	S2U,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	COMPU,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	NV,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	S1V,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	COMPV,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	AV,D0
	EXT.L	D0
	MOVE.L	D0,(A3)
	MOVE	S2V,D0
	EXT.L	D0
	MOVE.L	D0,(A3)

.LOOP_PASS1

	BSR	DSP_READ_L	*LECTURE DANS A2
	CMP.L	#0,A2
	BEQ	.CLIP_TOTAL
	BMI.S	.CLIP_1
	
	
	*REOIT DU DSP D0
.WAIT1	BTST	#0,(A1)
	BEQ.S	.WAIT1
	MOVE.L	(A3),A4

.WAIT2	BTST	#0,(A1)
	BEQ.S	.WAIT2
	MOVE.L	(A3),A5

	MOVEQ	#0,D7	
	
	TST.B	DBLVS_F
	BEQ.S	.FORGD0

.FORGD0VS
	************ 1 LIGNE /2
	BTST	#0,(A1)
	BEQ.S	.FORGD0VS
	MOVE.L	(A3),A6
	CMP2.L	LIM_MOT,A6
	BCS.S	.NO_PLOT0VS

	MOVE.B	(A6),D7

	MOVE.W	(A5,D7*4),(A2)+
	MOVE	-2(A2),640-2(A2)
	CMP.L	A2,A4
	BHS.S	.FORGD0VS		
	BRA.S	.CLIP_1	
.NO_PLOT0VS
	ADDQ.L	#2,A2
	CMP.L	A2,A4
	BHS.S	.FORGD0VS		
	BRA.S	.CLIP_1	

	************* TOUTES LES LIGNES *****	
.FORGD0					

	BTST	#0,(A1)
	BEQ.S	.FORGD0
	MOVE.L	(A3),A6
	CMP2.L	LIM_MOT,A6
	BCS.S	.NO_PLOT0
	
	MOVE.B	(A6),D7

	MOVE.W	(A5,D7*4),(A2)+
	CMP.L	A2,A4
	BHS.S	.FORGD0
	BRA.S	.CLIP_1		
.NO_PLOT0
	ADDQ.L	#2,A2
	CMP.L	A2,A4
	BHS.S	.FORGD0
	

*---------------------------------------*
.CLIP_1
	
	ADDQ	#1,YE
	MOVE	YE,D0
	CMP	(A7),D0
	BLE	.LOOP_PASS1
	SUBQ	#1,YE
	ADDQ.L	#2,SP
	*LECTURE DES PARAMETRES DSP
	BSR	DSP_READ_W
	MOVE.L	D0,A0
	MOVE.L	(A3),D0
	MOVE	D0,JEUREG4
	MOVE.L	(A3),D0
	MOVE	D0,JEUREG4+6
	MOVE.L	(A3),D0
	MOVE	D0,XPE
	MOVE.L	(A3),D0
	MOVE	D0,EPE
	MOVE.L	(A3),D0
	MOVE	D0,XQE
	MOVE.L	(A3),D0
	MOVE	D0,EQE
	MOVE.L	(A3),D0
	MOVE	D0,XU
	MOVE.L	(A3),D0
	MOVE	D0,YU
	MOVE.L	(A3),D0
	MOVE	D0,COMPU
	MOVE.L	(A3),D0
	MOVE	D0,XVV
	MOVE.L	(A3),D0
	MOVE	D0,YVV
	MOVE.L	(A3),D0
	MOVE	D0,COMPV

	MOVE.L	(SP)+,A6
	MOVE.L	(SP)+,A5
	MOVE.L	(SP)+,A1
	RTS
.CLIP_TOTAL
	*ABANDONNE SOL_DISPLAY
	MOVE.L	CLIP_TOT_SOL,SP
	RTS
		
*************************************************	
HEROTOUC	*LE HEROS EST TOUCH
	ADD	#TOUCH_SC,SCORE
	SUB	#FORCEA,SHIELD
	BPL.S	.END
	*ON EST MORT
	ADDQ.L	#4,SP	*ON PERD UN NIVEAU DE SS PRG
	BSR	HADES
	BRA	END_OF_GAME
	
.END	
	RTS
INIT_ECRAN	*AFFICHE LE CADRE ETC
	*CADRE
	*DECOMPRESSE LE CADRE
	LEA	CADREI,A0
	MOVE.L	ECRANG,A1
	ADD.L	LONECR_F,A1
	BSR	UNSQUEEZE
	*RECOPIE EN ECRANG
	MOVE.L	ECRANG,A0
	*LEA	([LONECR_F],A0),A1	*ASSEMBLE NE METS PAS EN .L
	MOVE.L	A0,A1
	ADD.L	LONECR_F,A1

	TST.B	DOUBLE_F
	BEQ.S	.NDBLF
	MOVE	#320*100-1,D0
.RECOP_CADRE
	MOVE.L	(A1)+,(A0)+
	DBF	D0,.RECOP_CADRE
	BRA.S	.ENCDBLF
.NDBLF
	LEA	(A0),A2
	MOVE	#YMACLIPD-1,D1
.MOV2	MOVE	#160-1,D0
.MOV	MOVE.L	(A1)+,(A2)+
	DBF	D0,.MOV
	LEA	640(A1),A1
	DBF	D1,.MOV2
	MOVE	#320*(100-YMACLIPD)-1,D0
.MOV3	MOVE.L	(A1)+,(A2)+
	DBF	D0,.MOV3
.ENCDBLF
	
	MOVE.L	ECRANG,A0
	BSR	TRACE_CADRE
	MOVE.L	ECRANG,A0
	ADD.L	LONECR_F,A0
	BSR	TRACE_CADRE
	MOVE.L	ECRANG,A0
	ADD.L	LONECR_F,A0
	ADD.L	LONECR_F,A0
	BSR	TRACE_CADRE
	RTS
RELACH	*ATTEND QUE TOUTES LES TOUCHES SOIENT RELACHES
	LEA	KEY_TAB+1,A6
	MOVEQ	#112,D0
.LOOP	TST.B	(A6)+
	BNE.S	RELACH
	DBF	D0,.LOOP
	RTS
	
INITIALISATIONS	*

	MOVE	SR,D0
	MOVE	D0,SOVSR
	MOVE.L	$70.W,SOV70
	MOVE.L	$118.W,SOV118
	MOVE.L	$120.W,SOV120

	CLR	NUM_LEVEL
	MOVE.B	BUF_INF+27,NUM_LEVEL+1

	*SAUVE VIDEL	
*	LEA	SOVIDEL,A0
*	MOVE.W	$FFFF820E.W,(A0)+
*	MOVE.W	$FFFF8210.W,(A0)+
*	MOVE.W	$FFFF8266.W,(A0)+
*	MOVE.W	$FFFF8282.W,(A0)+
*	MOVE.W	$FFFF8284.W,(A0)+
*	MOVE.W	$FFFF8286.W,(A0)+
*	MOVE.W	$FFFF8288.W,(A0)+
*	MOVE.W	$FFFF828A.W,(A0)+
*	MOVE.W	$FFFF828C.W,(A0)+
*	MOVE.W	$FFFF828E.W,(A0)+
*	MOVE.W	$FFFF8290.W,(A0)+
*	MOVE.W	$FFFF82A2.W,(A0)+
*	MOVE.W	$FFFF82A4.W,(A0)+
*	MOVE.W	$FFFF82A6.W,(A0)+
*	MOVE.W	$FFFF82A8.W,(A0)+
*	MOVE.W	$FFFF82AA.W,(A0)+
*	MOVE.W	$FFFF82AC.W,(A0)+
*	MOVE.W	$FFFF82C2.W,(A0)+
*	MOVE.W	$FFFF82C0.W,(A0)+

	*CHANGE RESOLUTION
*	CMP	#2,MONTYPE
*	BEQ.S	.VGA
*	*NON VGA : PAL (MONOCHR ET TV NON IMPLANTE)
*	MOVE	#$20+0+4,-(SP)
*	MOVE	#$58,-(SP)
*	TRAP	#14
*	ADDQ.L	#4,SP
*	MOVE	D0,OLDRES
*
*	BRA.S	.APVGA
*.VGA
*	MOVE	#$10+0+4,-(SP)
*	MOVE	#$58,-(SP)
*	TRAP	#14
*	ADDQ.L	#4,SP
*	MOVE	D0,OLDRES
*.APVGA	

	MOVE	#$13,D0		*ARRET SOURIS
	BSR	WRITE_IKBD

	MOVE.L	#CLAV,$118.W

	MOVE	#$11,D0		*REPRISE SOURIS
	BSR	WRITE_IKBD

	MOVE.L	#IRQ,$70.W
	MOVEQ	#$12,D0
	BSR	WRITE_IKBD
	MOVE	#$2300,SR

	MOVEQ 	#$11,D0			* resume sending
	BSR 	WRITE_IKBD
	MOVEQ	#$14,D0
	BSR	WRITE_IKBD		*JOYSTICK
	MOVEQ 	#$8,D0			* MODE RELATIF
	BSR 	WRITE_IKBD
	BSR 	FLUSH

	*MOVE	#$2700,SR
	*MFP
	MOVE.B	$FFFFFA07.W,SOVMFP
	MOVE.B	$FFFFFA09.W,SOVMFP+1
	MOVE	#-1,OLD_DMAPT

	*SAUVEGARDE LES PARAMETRES ECRANS
		
	MOVE.B	$FFFF8201.W,SOVSCR
	MOVE.B	$FFFF8203.W,SOVSCR+1
	MOVE.B	$FFFF820D.W,SOVSCR+2
	MOVE.B	$FFFF8265.W,SOVSCR+3
	MOVE.B	$FFFF8260.W,SOVSCR+4


	*MFP : EFFACE ITS SAUF LE CLAVIER & TIMER A
	
	MOVE.B	#%01000000,$FFFFFA09.W
	CLR.B	$FFFFFA07.W
	
	ANDI.B	#%11110111,$FFFFFA17.W	*AEI

*
* load .TCR   196*160
*
*

	*passage mode 320*100, true color !
	* POSITIONNE LES ADRESSES ECRAN
	BSR	VSYNC
	MOVE.L	ECRANG,-(SP)
	MOVE.L	ECRANG,NEW_ECR
	MOVE.B	2(SP),$FFFF8203.W
	MOVE.B	1(SP),$FFFF8201.W
	MOVE.B	3(SP),$FFFF820D.W
	ADDQ.L	#4,SP
	
	CMP	#2,MONTYPE
	BEQ.S	VGA
	*NON VGA : PAL (MONOCHR ET TV NON IMPLANTE)

	*PROGRAMMATION DU VIDEL POUR UN MONTIEUR PAL

	*CLR	$FFFF820E.W		*OFFSET TO NEXT LINE
	MOVE.W	#$140,$FFFF8210.W	*LINEWIDTH IN WORDS
	MOVE.W	#$100,$FFFF8266.W	*MODE - PEU TESTE - DANGER
	MOVE.W	#$FE,$FFFF8282.W	*HHT-SYNC - DEBUT HORIZONTAL + ECLAIRCISSEMENT - DANGER
	MOVE.W	#$CB,$FFFF8284.W	*HBB - END OF LINE - FIN DE LGNE HORIZ
	MOVE.W	#$27,$FFFF8286.W	*HBE - START OF LINE - DEBUT DE LIGNE HORIZ
	MOVE.W	#$2E,$FFFF8288.W	*HDB - LEFT OVERSCAN (DEBUT HORIZONTAL ECRAN-
	*-8 si screen blaster
	MOVE.W	#$8F,$FFFF828A.W	*HDE - RIGHT OVERSCAN (FIN HORIZONTALE)
	*+8 si screen blaster
	MOVE.W	#$D8,$FFFF828C.W	*HSS - SYNCRO - SYNCRO HORIZONTALE ECRAN - DANGER
	CLR.W	$FFFF828E.W		*HFS - SANS EFFET
	CLR.W	$FFFF8290.W		*HEE - SANS EFFET
	MOVE.W	#$271,$FFFF82A2.W	*VFT - SYNCRO - SYNCRO VERTICALE DEBUT ECRAN - DANGER
	MOVE.W	#$265,$FFFF82A4.W	*VBB - END OF IMAGE - FIN DE VIDEORAM
	MOVE.W	#$2F,$FFFF82A6.W	*VBE - START OF IMAGE - DEBUT DE VIDEORAM AFFICHE
	MOVE.W	#$7F,$FFFF82A8.W	*VDB - TOP OVERSC - DEBUT D'ECRAN
	MOVE.W	#$20F,$FFFF82AA.W	*VDE - BOTTOM OVERSC - FIN D'ECRAN
	MOVE.W	#$26B,$FFFF82AC.W	*VSS - SYNCRO - ? - DANGER 

	CLR	$FFFF82C2.W
	BRA.S	APVGA


VGA	
	*PROGRAMMATION DU VIDEL POUR UN MONITEUR VGA
	*320*200 TRUE COLOR
	CLR	$FFFF820E.W		*OFFSET TO NEXT LINE
	MOVE.W	#$140,$FFFF8210.W	*LINEWIDTH IN WORDS
	MOVE.W	#$100,$FFFF8266.W	*MODE - PEU TESTE - DANGER
	MOVE.W	#$C6,$FFFF8282.W	*HHT-SYNC - DEBUT HORIZONTAL + ECLAIRCISSEMENT - DANGER
	MOVE.W	#$8D,$FFFF8284.W	*HBB - END OF LINE - FIN DE LGNE HORIZ
	MOVE.W	#$15,$FFFF8286.W	*HBE - START OF LINE - DEBUT DE LIGNE HORIZ
	MOVE.W	#$2AC,$FFFF8288.W	*HDB - LEFT OVERSCAN (DEBUT HORIZONTAL ECRAN-
	MOVE.W	#$90,$FFFF828A.W	*HDE - RIGHT OVERSCAN (FIN HORIZONTALE, NE PAS ALLER TROP LOIN)
	MOVE.W	#$96,$FFFF828C.W	*HSS - SYNCRO - SYNCRO HORIZONTALE ECRAN - DANGER
	CLR.W	$FFFF828E.W		*HFS - SANS EFFET
	CLR.W	$FFFF8290.W		*HEE - SANS EFFET
	MOVE.W	#$419,$FFFF82A2.W	*VFT - SYNCRO - SYNCRO VERTICALE DEBUT ECRAN - DANGER

	MOVE.W	#$3AF,$FFFF82A4.W
	MOVE.W	#$8F,$FFFF82A6.W	*VBE - START OF IMAGE - DEBUT DE VIDEORAM AFFICHE
	MOVE.W	#$8F,$FFFF82A8.W	*VDB - TOP OVERSC - DEBUT D'ECRAN
	MOVE.W	#$3AF,$FFFF82AA.W	*VDE - BOTTOM OVERSC - FIN D'ECRAN
	MOVE.W	#$186,$FFFF82C0.W

	MOVE.W	#$415,$FFFF82AC.W	*VSS - SYNCRO - ? - DANGER 
	MOVE.W	#%101,$FFFF82C2.W	*VCO - MODE -   dble pixel=bit 2
					*		skip line=bit1
					*		dble line=0
					

	
APVGA
	MOVE	#$2300,SR
	*FLAGS
	MOVE	#FREQINC,COMPINC
	MOVE.B	BUF_INF+29,DBLH_F2
	MOVE.B	BUF_INF+29,DBLH_F
	MOVE.B	BUF_INF+30,DBLVS_F2
	MOVE.B	BUF_INF+30,DBLVS_F
	
	SF	TALK_FLAG
	SF	TIR_HEROS
	SF	FLIP_POSSIBLE
	BSR	MAJ_DX
	CLR	NB_MORTS
	MOVE.L	#PILE_MORTS,PT_MORT
	MOVE	#XIMG,X_IMG
	MOVE	#YIMG,Y_IMG
	MOVE.L	#XLARG,X_LARG-2

	MOVE	#180,ANG32	
	MOVE	#180,ANG2	
	MOVE	#180,ANG	
	CLR	DIR	

	MOVE	#SHILD/2,D0
	ADD	D0,D0		*POUR PAS TROP SIMPLE A 'TRAINER' (PAR RECHERCHE DE LA VALEUR)
	MOVE	D0,SHIELD
					
	CLR	SCORE
	CLR	NBTIRE
	CLR	NBTOUC

	CLR	DX	
	MOVE	#-PAS2,DY

	*INIT POINTS DE VUE
	LEA	PDV_0,A0
	LEA	PDV_2,A1
	LEA	PDV_4,A2
	LEA	PDV_6,A3
	MOVE.B	(A0)+,D0
	MOVE.B	D0,(A1)+
	MOVE.B	D0,(A2)+
	MOVE.B	D0,(A3)+
	AND	#$FF,D0
	SUBQ	#1,D0
.MEDIANES	
	MOVE.B	1(A0),(A1)
	NEG.B	(A1)+
	MOVE.B	(A0),(A1)+
	
	MOVE.B	1(A0),(A3)+
	MOVE.B	(A0),(A3)
	NEG.B	(A3)+
	
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	DBF	D0,.MEDIANES
	
	LEA	PDV_1,A0
	LEA	PDV_3,A1
	LEA	PDV_5,A2
	LEA	PDV_7,A3

	MOVE.B	(A0)+,D0
	MOVE.B	D0,(A1)+
	MOVE.B	D0,(A2)+
	MOVE.B	D0,(A3)+
	AND	#$FF,D0
	SUBQ	#1,D0
.DIAGONALES	
	MOVE.B	1(A0),(A1)
	NEG.B	(A1)+
	MOVE.B	(A0),(A1)+
	
	MOVE.B	1(A0),(A3)+
	MOVE.B	(A0),(A3)
	NEG.B	(A3)+
	
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	DBF	D0,.DIAGONALES

	*INIT TABLE DE SCRUTAGE
	
	LEA	SCRUT_0,A0
	LEA	SCRUT_2,A1
	LEA	SCRUT_4,A2
	LEA	SCRUT_6,A3
	MOVE.B	(A0)+,D0
	MOVE.B	D0,(A1)+
	MOVE.B	D0,(A2)+
	MOVE.B	D0,(A3)+
	AND	#$FF,D0
	SUBQ	#1,D0
.MEDIANESC
	MOVE.B	1(A0),(A1)
	NEG.B	(A1)+
	MOVE.B	(A0),(A1)+
	
	MOVE.B	1(A0),(A3)+
	MOVE.B	(A0),(A3)
	NEG.B	(A3)+
	
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	DBF	D0,.MEDIANESC
	
	LEA	SCRUT_1,A0
	LEA	SCRUT_3,A1
	LEA	SCRUT_5,A2
	LEA	SCRUT_7,A3

	MOVE.B	(A0)+,D0
	MOVE.B	D0,(A1)+
	MOVE.B	D0,(A2)+
	MOVE.B	D0,(A3)+
	AND	#$FF,D0
	SUBQ	#1,D0
.DIAGONALESC
	MOVE.B	1(A0),(A1)
	NEG.B	(A1)+
	MOVE.B	(A0),(A1)+
	
	MOVE.B	1(A0),(A3)+
	MOVE.B	(A0),(A3)
	NEG.B	(A3)+
	
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	MOVE.B	(A0)+,(A2)
	NEG.B	(A2)+
	DBF	D0,.DIAGONALESC
	
	*TABLES D'ACCESSIBILITES
	LEA	ACESS_0+2,A0
	LEA	ACESS_2,A1
	*POUR UNE EVOLUTION ORIGIN DE (1,0) (0,1) DE (0,0)
	*ON A UNE EVOLUTION TOURNEE DE (0,1) (-1,0)  DE (4,0)
	MOVE	#2*10,(A1)+	*NVELLE ORG
	MOVE	(A0)+,D0
	MOVE	D0,(A1)+	*TAILLE INCHANGE
	ADDQ.L	#8,A1		*HAUT A DROITE
	BSR	MATROT		*ROTATION DE MAT A0=S A1=D D0=TAILLE
	
	LEA	ACESS_2+2,A0
	LEA	ACESS_4,A1
	MOVE	#4,(A1)+	*NVELLE ORG
	MOVE	(A0)+,D0
	MOVE	D0,(A1)+	*TAILLE INCHANGE
	ADDQ.L	#8,A1		*HAUT A DROITE
	BSR	MATROT		*ROTATION DE MAT A0=S A1=D D0=TAILLE

	LEA	ACESS_4+2,A0
	LEA	ACESS_6,A1
	MOVE	#8+2*10,(A1)+	*NVELLE ORG
	MOVE	(A0)+,D0
	MOVE	D0,(A1)+	*TAILLE INCHANGE
	ADDQ.L	#8,A1		*HAUT A DROITE
	BSR	MATROT		*ROTATION DE MAT A0=S A1=D D0=TAILLE

	*LES MEMES EN DIAGONALES
	LEA	ACESS_1+2,A0
	LEA	ACESS_3,A1
	*POUR UNE EVOLUTION ORIGIN DE (1,0) (0,1) DE (0,0)
	*ON A UNE EVOLUTION TOURNEE DE (0,1) (-1,0)  DE (6,0)
	MOVE	#2*14+4,(A1)+	*NVELLE ORG
	MOVE	(A0)+,D0
	MOVE	D0,(A1)+	*TAILLE INCHANGE
	LEA	12(A1),A1	*HAUT A DROITE
	BSR	MATROT		*ROTATION DE MAT A0=S A1=D D0=TAILLE
	
	LEA	ACESS_3+2,A0
	LEA	ACESS_5,A1
	MOVE	#8+14*2,(A1)+	*NVELLE ORG
	MOVE	(A0)+,D0
	MOVE	D0,(A1)+	*TAILLE INCHANGE
	LEA	12(A1),A1	*HAUT A DROITE
	BSR	MATROT		*ROTATION DE MAT A0=S A1=D D0=TAILLE

	LEA	ACESS_5+2,A0
	LEA	ACESS_7,A1
	MOVE	#8+4*14,(A1)+	*NVELLE ORG
	MOVE	(A0)+,D0
	MOVE	D0,(A1)+	*TAILLE INCHANGE
	LEA	12(A1),A1	*HAUT A DROITE
	BSR	MATROT		*ROTATION DE MAT A0=S A1=D D0=TAILLE

	*CHEMINS
	LEA	CBASE,A0
	LEA	CHEM_2,A1
	MOVEQ	#24,D0
	*-Y,X
	*COEFFICIENTS : x=X*D1+Y*D2   y=X*D3+Y*D4
	MOVEQ	#0,D1
	MOVEQ	#-1,D2
	MOVEQ	#1,D3
	MOVEQ	#0,D4
	BSR	ROTA90	*D1-D4 INCHANGES; D0=NB DE CASES; A0=S A1=D
	LEA	DBS,A0
	LEA	CHEM_3,A1
	MOVEQ	#29,D0
	*-Y,X
	BSR	ROTA90

	LEA	CBASE,A0
	LEA	CHEM_4,A1
	MOVEQ	#24,D0
	*-X,-Y
	*COEFFICIENTS : x=X*D1+Y*D2   y=X*D3+Y*D4
	MOVEQ	#-1,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#-1,D4
	BSR	ROTA90	*D1-D4 INCHANGES; D0=NB DE CASES; A0=S A1=D
	LEA	DBS,A0
	LEA	CHEM_5,A1
	MOVEQ	#29,D0
	*-X,-Y
	BSR	ROTA90

	LEA	CBASE,A0
	LEA	CHEM_6,A1
	MOVEQ	#24,D0
	*Y,-X
	*COEFFICIENTS : x=X*D1+Y*D2   y=X*D3+Y*D4
	MOVEQ	#0,D1
	MOVEQ	#1,D2
	MOVEQ	#-1,D3
	MOVEQ	#0,D4
	BSR	ROTA90	*D1-D4 INCHANGES; D0=NB DE CASES; A0=S A1=D
	LEA	DBS,A0
	LEA	CHEM_7,A1
	MOVEQ	#29,D0
	*Y,-X
	BSR	ROTA90
	
	

	*INIT PALETTES
	BSR	PREPA_DEG
	
	LEA	PALS,A0
	LEA	IMAGE,A1
	MOVE	#NBMUR,-(SP)	*COMPTEUR D'IMAGES
.IMAGESLOOP
	BSR	PAL_PERFORM
	
	ADDQ.L	#4,A1	*IMAGE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.IMAGESLOOP
	ADDQ.L	#2,SP

	LEA	PALS_SOL,A0
	LEA	SOLS,A1
	MOVE	#NBSOL,-(SP)	*COMPTEUR D'IMAGES
.SOLLOOP
	BSR	PAL_PERFORM
	
	ADDQ.L	#4,A1	*IMAGE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.SOLLOOP
	ADDQ.L	#2,SP

	*RECOPIE PALS_SOL DANS PALS_SOLS_E
	LEA	PALS_SOL,A0
	LEA	PALS_SOL_E,A1
	MOVE	#NBSOL*32*16-1,D0
.SOLRECOP
	MOVE.L	(A0)+,(A1)+
	DBF	D0,.SOLRECOP

	*RECOPIE PALS DANS PALS_B
	LEA	PALS,A0
	LEA	PALS_B,A1
	MOVE	#NBMUR*32*16-1,D0
.MURRECOP
	MOVE.L	(A0)+,(A1)+
	DBF	D0,.MURRECOP

	LEA	PALS_OBJET,A0
	LEA	OBJET,A1
	MOVE	#NBOBJ,-(SP)	*COMPTEUR D'IMAGES
.IMAGESLOOP_O
	BSR	PAL_PERFORM
	
	ADDQ.L	#4,A1	*IMAGE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.IMAGESLOOP_O
	ADDQ.L	#2,SP


	LEA	PALPORTE,A0
	LEA	PORTE,A1
	BSR	PAL_PERFORM_SEUL

	LEA	PALS_AMIS,A0
	MOVE.L	AMIS,A1
	MOVE	#12,-(SP)	*COMPTEUR D'IMAGES
.IMAGESLOOP_OAMI
	BSR	PAL_PERFORM_SEUL
	
	LEA	(9636*4,A1),A1	*PLANCHE SUIVANTE	
	SUBQ	#1,(SP)
	BNE.S	.IMAGESLOOP_OAMI
	ADDQ.L	#2,SP

	LEA	PALS_ENNEMIS,A0
	MOVE.L	ENNEMIS,A1
	MOVE	#12,-(SP)	*COMPTEUR D'IMAGES
.IMAGESLOOP_OENN
	BSR	PAL_PERFORM_SEUL
	
	LEA	(9636*4,A1),A1	*PLANCHE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.IMAGESLOOP_OENN
	ADDQ.L	#2,SP
	
	*REPRISE DES PALETTES AVEC SEMANTIQUE DES BITS.
	LEA	PALS_SOL_E,A0
	MOVE	#NBSOL,D0
	MOVEQ	#1,D1
	BSR	SETPALBIT
	
	LEA	PALS,A0
	MOVEQ	#NBMUR,D0	*NB
	MOVEQ	#1,D1	*BIT 0&5A METTRE A 1
	BSR	SETPALBIT
	LEA	PALS_OBJET,A0
	MOVEQ	#NBOBJ,D0
	MOVEQ	#1,D1
	BSR	SETPALBIT
	LEA	PALPORTE,A0
	MOVEQ	#1,D0
	MOVEQ	#1,D1
	BSR	SETPALBIT
	LEA	PALS_AMIS,A0
	MOVEQ	#12,D0
	MOVEQ	#%100000,D1
	BSR	SETPALBIT
	LEA	PALS_ENNEMIS,A0
	MOVEQ	#12,D0
	MOVEQ	#%100001,D1
	BSR	SETPALBIT
	*RECOPIE DE PAL_ENNEMIS+32*32*11*2 DANS PAL_MORTE
	LEA	PALS_AMIS+2*32*32*11,A0
	LEA	PAL_MORTA,A1
	MOVE	#2*32*16-1,D1
.FG	MOVE	(A0)+,D0
	AND	#%1111111111011110,D0
	MOVE	D0,(A1)+
	DBF	D1,.FG

	LEA	PALS_ENNEMIS+2*32*32*11,A0
	LEA	PAL_MORTE,A1
	MOVE	#2*32*16-1,D1
.FG2	MOVE	(A0)+,D0
	AND	#%1111111111011110,D0
	MOVE	D0,(A1)+
	DBF	D1,.FG2
	*NEUTRALISE LA PALETTE DE CERTAINS OBJETS
	LEA	PALS_OBJET+32*32*2,A0	*TABLE
	BSR	NEUTRALIZ
	LEA	PALS_OBJET+2*32*32*2,A0	*TABOURET
	BSR	NEUTRALIZ
	LEA	PALS_OBJET+3*32*32*2,A0	*TROU
	BSR	NEUTRALIZ
	LEA	PALS_OBJET+6*32*32*2,A0	*BROUILLARD
	BSR	NEUTRALIZ
	*NEUTRALISE LES SOLS & MUR BAS
	MOVE	#NBMUR,-(SP)
	LEA	PALS_B,A0
.NTZZS
	PEA	(A0)
	BSR	NEUTRALIZ
	MOVE.L	(SP)+,A0
	LEA	32*32*2(A0),A0
	SUBQ.W	#1,(SP)
	BNE.S	.NTZZS
	ADDQ.L	#2,SP
	
	MOVE	#NBSOL,-(SP)
	LEA	PALS_SOL,A0
.NTZS
	PEA	(A0)
	BSR	NEUTRALIZ
	MOVE.L	(SP)+,A0
	LEA	32*32*2(A0),A0
	SUBQ.W	#1,(SP)
	BNE.S	.NTZS
	ADDQ.L	#2,SP
	
	BSR	COMPACTE
	
	*INITS VARIABLES
	
	MOVE.L	ECRANG,BASE

	CLR.L	$FFFF9800.W	*COULEUR 0
	RTS
A_KARINE
	*AFFICHE DEDICACE
	LEA	([BASE],(88*2+(71*640)).L),A0
	LEA	([ECRANG],128000.L),A2		*SORTIE
	LEA	(A2),A6
	MOVEQ	#0,D4			*NOMBRE D'ADRESSES
	LEA	DEDICACE+4,A1
	MOVEQ	#57,D1		*Y
.FORY
	MOVEQ	#(144/8)-1,D0	*X
.FORX
	MOVE.B	(A1)+,D2
	MOVEQ	#7,D3		*I
	LEA	16(A0),A0
.FORI
	LSR.B	D2
	BCC.S	.NEXT
	MOVE.L	A0,(A2)+
	ADDQ	#1,D4
.NEXT	
	SUBQ.L	#2,A0
	DBF	D3,.FORI
	LEA	16(A0),A0
	DBF	D0,.FORX
	LEA	(640-(18*16))(A0),A0
	DBF	D1,.FORY	
	SUBQ	#1,D4

	*AFFICHAGE MULTICOLORE
	MOVEQ	#1,D5
	MOVEQ	#0,D1
	MOVEQ	#45,D3
.FORFRA
	LEA	(A6),A2
	MOVE	D4,D0
	MOVE	D1,D2
	MOVE	D2,D7
	CMP	#32,D7
	BLT.S	.DISP
	MOVEQ	#31,D7
		
.DISP	MOVE	D7,([A2])
	ADDQ.L	#4,A2
	SUBQ	#1,D3
	BNE.S	.NEXTD
	MOVEQ	#45,D3
	TST	D2
	BEQ.S	.NEXTD
	SUBQ	#1,D2
	MOVE	D2,D7
	CMP	#32,D7
	BLT.S	.NEXTD
	MOVEQ	#31,D7
.NEXTD
	DBF	D0,.DISP
	BSR	VSYNC
	ADD	D5,D1
	
	TST	D5
	BMI.S	.NEGA
	CMP	#64,D1
	BNE.S	.FORFRA
	BRA.S	.CHGT
.NEGA
	TST	D1
	BPL.S	.FORFRA
	BRA.S	.TEMPO
.CHGT
	MOVEQ	#100,D1
.POZ	BSR	VSYNC
	DBF	D1,.POZ
	MOVEQ	#63,D1
	MOVEQ	#-1,D5
	BRA.S	.FORFRA

.TEMPO	RTS
	
CLS
	*EFFACE VIDEORAM
	MOVE	#23999,D0
	MOVE.L	ECRANG,A0
.EFFAC	REPT	4
	CLR.L	(A0)+
	ENDR
	DBF	D0,.EFFAC
	RTS

CLS_FRACT
	*EFFACE VIDEORAM AVEC FACTALE SUR LE 1ER ECRAN
	*EFFACE VIDEORAM
	MOVE	#15999,D0
	MOVE.L	ECRANG,A0
.EFFAC	REPT	4
	CLR.L	(A0)+
	ENDR
	DBF	D0,.EFFAC


	MOVE.L	ECRANG,A0			*A0-A6/A5-A4
	LEA	64(A0),A0
	*BORNES
	LEA	(512.W,A0),A6
	LEA	(163840.L,A0),A5
	LEA	(163840.L,A6),A4
	
	*POSITIONNE LES 4 COINS
	BSR	RND
	AND	#$FF,D0
	MOVE	D0,(A0)
	BSR	RND
	AND	#$FF,D0
	MOVE	D0,(A6)
	BSR	RND
	AND	#$FF,D0
	MOVE	D0,(A5)
	BSR	RND
		*ROR	#5,D0
	AND	#$FF,D0
	MOVE	D0,(A4)
	
	*
	MOVEQ	#7,D7		*256=2^8
	MOVE.L	#128,D6		*PAS DE D'OFFSET=1/2 PAS DE PARCOURS
.LOOP
	*VALEURS DU MILIEU / DIAGONALES PRISES
	MOVE.L	D6,D5
	ADD.L	D5,D5
	PEA	(A0,D5.L)
	
	MOVE.L	D6,D4
	MULU	#640,D4
	MOVE.L	D5,D3
	ADD.L	D4,D3		*D3=+1,+1
	MOVE.L	D5,D2
	SUB.L	D4,D2		*D2=+1,-1
	MOVE.L	D4,D1
	SUB.L	D5,D1		*D1=-1,+1
	NEG.L	D5
	SUB.L	D4,D5		*D5=-1,-1
	
	LEA	(A0,D3.L),A1
.MILDIY
	LEA	(A1),A2
	MOVE.L	(SP),A3
.MILDIX
	MOVE	(A2,D3.L),D4
	ADD	(A2,D2.L),D4
	ADD	(A2,D1.L),D4
	ADD	(A2,D5.L),D4
	BSR	RND
	AND	#$3F,D0
	*SUB	#128,D0
	ADD	D0,D4
	LSR	#2,D4
	MOVE	D4,(A2)
	MOVE.L	D6,D4
	LSL.L	#2,D4
	ADD.L	D4,A2
	ADD.L	D4,A3
	CMP.L	A3,A6
	BHI.S	.MILDIX
	MOVE.L	D6,D4
	MULU	#2*640,D4
	ADD.L	D4,A1
	CMP.L	A1,A5
	BHI.S	.MILDIY
	
	ADDQ.L	#4,SP
	
	*VALEURS DU BORD SUPERIEUR
	MOVE.L	D6,D5
	ADD.L	D5,D5		*D5=+1X (INDICE)
	MOVE.L	D5,D4
	NEG.L	D4		*D4=-1X
	MOVE.L	D6,D3
	MULU	#640,D3		*D3=+1Y
	LEA	(A0,D5.L),A1
.SUP	
	MOVE	(A1,D4.L),D1
	ADD	(A1,D5.L),D1
	ADD	(A1,D3.L),D1
	BSR	RND
	AND	#$3F,D0
	*SUB	#128,D0
	ADD	D0,D1
	EXT.L	D1
	DIVU	#3,D1
	MOVE	D1,(A1)
	ADD.L	D5,A1
	ADD.L	D5,A1
	CMP.L	A1,A6
	BHI.S	.SUP
		
	*VALEURS DU BORD INFERIEUR
	MOVE.L	D6,D5
	ADD.L	D5,D5		*D5=+1X (INDICE)
	MOVE.L	D5,D4
	NEG.L	D4		*D4=-1X
	MOVE.L	D6,D3
	MULS	#-640,D3	*D3=-1Y
	LEA	(A5,D5.L),A1
.INF	
	MOVE	(A1,D4.L),D1
	ADD	(A1,D5.L),D1
	ADD	(A1,D3.L),D1
	BSR	RND
	AND	#$3F,D0
	*SUB	#128,D0
	ADD	D0,D1
	EXT.L	D1
	DIVU	#3,D1
	MOVE	D1,(A1)
	ADD.L	D5,A1
	ADD.L	D5,A1
	CMP.L	A1,A4
	BHI.S	.INF

	*VALEURS DU BORD GAUCHE
	MOVE.L	D6,D5
	ADD.L	D5,D5		*D5=+1X (INDICE)
	MOVE.L	D6,D4
	MULU	#640,D4		*D4=+1Y
	MOVE.L	D4,D3
	NEG.L	D3		*D3=-1Y
	
	LEA	(A0,D4.L),A1
.GAU	
	MOVE	(A1,D4.L),D1
	ADD	(A1,D5.L),D1
	ADD	(A1,D3.L),D1
	BSR	RND
	AND	#$3F,D0
	*SUB	#128,D0
	ADD	D0,D1
	EXT.L	D1
	DIVU	#3,D1
	MOVE	D1,(A1)
	ADD.L	D4,A1
	ADD.L	D4,A1
	CMP.L	A1,A5
	BHI.S	.GAU

	*VALEURS DU BORD DROIT
	MOVE.L	D6,D5
	NEG.L	D5
	ADD.L	D5,D5		*D5=-1X (INDICE)
	MOVE.L	D6,D4
	MULU	#640,D4		*D4=+1Y
	MOVE.L	D4,D3
	NEG.L	D3		*D3=-1Y
	
	LEA	(A6,D4.L),A1
.DRO
	MOVE	(A1,D4.L),D1
	ADD	(A1,D5.L),D1
	ADD	(A1,D3.L),D1
	BSR	RND
	AND	#$3F,D0
	*SUB	#128,D0
	ADD	D0,D1
	EXT.L	D1
	DIVU	#3,D1
	MOVE	D1,(A1)
	ADD.L	D4,A1
	ADD.L	D4,A1
	CMP.L	A1,A4
	BHI.S	.DRO

	*POINTS MILIEUX MEDIANS
	CMP	#7,D7	*1ERE FOIS
	BEQ.S	.NOFIRS

	*VALEURS DU MILIEU / MEDIANES PRISES
	MOVE.L	D6,D5
	ADD.L	D5,D5		*D5=+1X
	MOVE.L	D6,D4
	MULU	#640,D4		*D4=+1Y
	MOVE.L	D5,D3
	MOVE.L	D4,D2
	NEG.L	D3		*D3=-1X
	NEG.L	D2		*D2=-1Y
	
	LEA	(A0,D5.L),A1
	ADD.L	D5,A1
	PEA	(A1)
	ADD.L	D4,A1

.MILMEY
	LEA	(A1),A2
	MOVE.L	(SP),A3
.MILMEX
	MOVE	(A2,D5.L),D1
	ADD	(A2,D4.L),D1
	ADD	(A2,D3.L),D1
	ADD	(A2,D2.L),D1
	BSR	RND
	AND	#$3F,D0
	*SUB	#128,D0
	ADD	D0,D1
	LSR	#2,D1
	MOVE	D1,(A2)
	
	ADD.L	D5,A2
	ADD.L	D5,A2
	ADD.L	D5,A3
	ADD.L	D5,A3
	
	CMP.L	A3,A6
	BHI.S	.MILMEX
	BNE.S	.PPILE_DESSUS
	SUB.L	D5,A1
	SUB.L	D5,(SP)
	BRA.S	.COM
.PPILE_DESSUS
	ADD.L	D5,A1
	ADD.L	D5,(SP)
.COM
	ADD.L	D4,A1
	
	CMP.L	A1,A5
	BHI.S	.MILMEY
	ADDQ.L	#4,SP

.NOFIRS	*PAS LA 1ERE FOIS

	*PAS D6 DIVISE PAR 2
	LSR	#1,D6

	DBF	D7,.LOOP

	*RE-ORDONNANCEMENT
	MOVE.L	ECRANG,A0
	LEA	(128000.L,A0),A1
	ADDQ.L	#1,A0
	MOVE.L	#320*200-1,D0
.REOR
	BTST	#5,(A0)
	BEQ.S	.NOCHG
	MOVE.B	(A0),D1
	MOVE.B	D1,D2
	AND.B	#31,D1
	NEG	D1
	ADD	#31,D1
	AND.B	#%11100000,D2
	OR.B	D1,D2
	MOVE.B	D2,(A0)
	OR.B	#%01010000,-1(A0)
	
.NOCHG	
	MOVE.W	-1(A0),(A1)+
	ADDQ.L	#2,A0
	DBF	D0,.REOR

	MOVE.L	ECRANG,A1
	LEA	(128000.L,A1),A0
	BRA	ANTI_ALIA
	
NEUTRALIZ	*A0=PAL
	MOVE	#32*16-1,D0
.LOOP
	AND.L	#%11111111110111101111111111011110,(A0)+
	DBF	D0,.LOOP
	RTS
SETPALBIT	*A0=PAL, D0=NB PAL, D1=BIT A MODIFIER

	SUBQ	#1,D0
.LOOP2
	MOVE	#32*16-1,D7
.LOOP	MOVE	(A0),D6
	AND	#%1111111111011110,D6
	OR	D1,D6
	MOVE	D6,(A0)+
	MOVE	D6,(A0)+
	DBF	D7,.LOOP
	DBF	D0,.LOOP2
	RTS

PAL_PERFORM_SEUL
	PEA	(A0)
	MOVE	#31,-(SP)
	MOVEM.L	4(A1),D0-D7
	BRA.S	COMMUN
PAL_PERFORM	*DECREMENTE PALETTE D'UNE IMAGE	
	PEA	(A0)
	MOVE	#31,-(SP)	*COMPTEUR
	MOVEM.L	 ([A1],4.W),D0-D7		

COMMUN
	MOVEM.L	D0-D7,(A0)

	LEA	32(A0),A0
	
	*BAISSE LE NIVEAU DE 1
.LOOP2	MOVEM.L D0-D7,(A0)
	
	MOVEQ	#15,D7	*16 COULEURS

.LOOP1	MOVE.W	(A0),D0
	MOVE	D0,D1
	MOVE	D0,D2
	AND	#%1111100000000000,D0
	AND	#%0000011111100000,D1
	AND	#%0000000000011111,D2
	ROL	#5,D0
	LSR	#5,D1
	SUBQ	#1,D0
	BPL.S	.OK1
	MOVEQ	#0,D0
.OK1	SUBQ	#2,D1
	BPL.S	.OK2
	MOVEQ	#0,D1
.OK2	SUBQ	#1,D2
	BPL.S	.OK3
	MOVEQ	#0,D2
.OK3
	ROR	#5,D0
	LSL	#5,D1
	OR	D2,D1
	OR	D1,D0
	MOVE	D0,(A0)+
	DBF	D7,.LOOP1

	MOVEM.L	-32(A0),D0-D7	*RECUPERE LES NOUVEAUX NIVEAUX
	
	SUBQ	#1,(SP)
	BNE.S	.LOOP2
	ADDQ.L	#2,SP

	*DEDOUBLE LA PALETTE
	MOVE.L	(SP),A0
	LEA	32*32*2(A0),A2
	LEA	32*32-2(A0),A0
	MOVE	#32*16-1,D0
.DEDOUB
	MOVE	(A0),-(A2)
	MOVE	(A0),-(A2)
	SUBQ.L	#2,A0
	DBF	D0,.DEDOUB
	MOVE.L	(SP)+,A0
	LEA	32*32*2(A0),A0
	RTS


TRACE_CADRE	**************** TRACE UN CADRE - ECRAN DANS A0


	*COPIE L'IMAGE DU CADRE
	MOVE.L	ECRANG,A1
	LEA	(A0),A2
	TST.B	DOUBLE_F
	BEQ.S	.NDBLF
	MOVE	#160*200-1,D0
	BRA.S	.MOV
.NDBLF
	MOVE	#LONECRD/4-1,D0
	
.MOV	MOVE.L	(A1)+,(A2)+
	DBF	D0,.MOV

	TST.B	DOUBLE_F
	BNE.S	.NWXC		
	MOVE.L	#XMICLIP*2+YMICLIPD*640-2-640,D0
	MOVE.L	#XMICLIP*2+YMACLIPD*640-2+640,D2
	BRA.S	.ECXW
.NWXC
	MOVE.L	#XMICLIP*2+YMICLIP*640-2-640,D0
	MOVE.L	#XMICLIP*2+YMACLIP*640-2+640,D2
.ECXW
	MOVE	#(XMACLIP-XMICLIP)+2,D1
	LEA	(A0,D0.L),A1
	LEA	(A0,D2.L),A2
.HORIZ	MOVE	#COULCAD,(A1)+
	MOVE	#COULCAD,(A2)+
	DBF	D1,.HORIZ
	
	TST.B	DOUBLE_F
	BNE.S	.NQSDF
	MOVE.L	#XMACLIP*2+YMICLIPD*640+2-640,D2
	MOVE	#(YMACLIPD-YMICLIPD)+1,D1
	BRA.S	.EFDSQ
.NQSDF
	MOVE.L	#XMACLIP*2+YMICLIP*640+2-640,D2
	MOVE	#(YMACLIP-YMICLIP)+1,D1
.EFDSQ
	LEA	(A0,D0.L),A1
	LEA	(A0,D2.L),A2
.VERT	MOVE	#COULCAD,(A1)
	MOVE	#COULCAD,(A2)
	LEA	640(A1),A1
	LEA	640(A2),A2
	DBF	D1,.VERT
	RTS	

WAITBLIT
	BTST	#7,$FFFF8A3C.W	*BUSY
	BNE.S	WAITBLIT
	RTS
MATROT
	*POUR UNE EVOLUTION ORIGIN DE (1,0) (0,1) DE (0,0)
	*ON A UNE EVOLUTION TOURNEE DE (0,1) (-1,0)  DE (4,0)
	*ROTATION DE MAT A0=S A1=D D0=TAILLE
	MOVE	D0,D7	*SAUVEGARDE
	MOVE	D7,D6	*SAUV LOOP COUNTER
	ASR	D6
	SUBQ	#1,D6
	MOVE	D6,D0
.FY
	LEA	(A1),A2
	MOVE	D6,D1
.FX	MOVE	(A0)+,(A2)
	LEA	(A2,D7.W),A2
	DBF	D1,.FX
	SUBQ.L	#2,A1
	DBF	D0,.FY
	
	RTS
ROTA90	*ROTATION DES CHEMINS
	*D1-D4 INCHANGES; D0=NB DE CASES-1; A0=S A1=D
	*COEFFICIENTS : x=X*D1+Y*D2   y=X*D3+Y*D4
	MOVEQ	#0,D5
	MOVE.B	(A0)+,D5
	MOVE.B	D5,(A1)+
	BMI.S	.NEXT
	BEQ.S	.NEXT
	SUBQ	#1,D5
.FOR	
	MOVE.B	(A0)+,D6
	MOVE.B	(A0)+,D7
	EXTB.L	D6		
	EXTB.L	D7
	*COEFFICIENTS : x=X*D1+Y*D2   y=X*D3+Y*D4
	MOVE.L	D6,-(SP)
	MOVE.L	D7,-(SP)
	MULS	D1,D6
	MULS	D2,D7
	ADD.L	D7,D6
	MOVE.B	D6,(A1)+
	MOVE.L	(SP)+,D7
	MOVE.L	(SP)+,D6
	MULS	D3,D6
	MULS	D4,D7
	ADD.L	D7,D6
	MOVE.B	D6,(A1)+
	DBF	D5,.FOR
	
	
.NEXT	DBF	D0,ROTA90
	RTS
COMPACTE
* "COMPACTE" LES OBJETS ---------------------------------

	LEA	OBJET,A1
	MOVE	#7,-(SP)	*COMPTEUR D'IMAGES
	*VERTICALEMENT
.COMPSLOOP_O
	LEA	([A1],36.W),A0
	*MOVE.L	(A1),A0
	*LEA	36(A0),A0
	
	MOVE	#159,D0
.XCOUNT
	MOVEQ	#119,D2
	
	MOVEQ	#0,D1
	MOVEQ	#0,D3
.YCOUNT
	OR.B	(A0,D3.W),D1
	ADD	#160,D3
	DBF	D2,.YCOUNT
	
	TST.B	D1
	BNE.S	.NEXTS
		MOVEQ	#0,D3
		MOVEQ	#119,D2
.CMPC		ORI.B	#128,(A0,D3)
		ADD	#160,D3
		DBF	D2,.CMPC
.NEXTS
	ADDQ.L	#1,A0	
	DBF	D0,.XCOUNT

	*HORIZONTALEMENT
	MOVE.L	(A1),A0
	LEA	36(A0),A0
	MOVEQ	#119,D2
	MOVEQ	#0,D1	*COMPTEUR
.LO1
	MOVE	#159,D0
.LO2
	MOVE.B	(A0)+,D3
	AND.B	#%1111111,D3
	DBNE	D0,.LO2
	TST	D0
	BPL.S	.EXIT
	ADDQ	#1,D1
	ORI.B	#64,-160(A0)
	DBF	D2,.LO1
.EXIT
	MOVE	D1,([A1])

	ADDQ.L	#4,A1	*IMAGE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.COMPSLOOP_O
	ADDQ.L	#2,SP

* "COMPACTE" LES BONHOMMES ---------------------------------

	MOVE.L	AMIS,A1
	MOVE	#47,-(SP)	*COMPTEUR D'IMAGES
.COMPSLOOP_O1
	LEA	36(A1),A0
	
	MOVE	#79,D0
.XCOUNT1
	MOVEQ	#119,D2
	
	MOVEQ	#0,D1
	MOVEQ	#0,D3
.YCOUNT1
	OR.B	(A0,D3.W),D1
	ADD	#80,D3
	DBF	D2,.YCOUNT1
	
	TST.B	D1
	BNE.S	.NEXTS1
		MOVEQ	#0,D3
		MOVEQ	#119,D2
.CMPC2		ORI.B	#128,(A0,D3)
		ADD	#80,D3
		DBF	D2,.CMPC2
.NEXTS1
	ADDQ.L	#1,A0	
	DBF	D0,.XCOUNT1

	*HORIZONTALEMENT
	LEA	36(A1),A0
	MOVEQ	#119,D2
	MOVEQ	#0,D1	*COMPTEUR
.LO11
	MOVEQ	#79,D0
.LO21
	MOVE.B	(A0)+,D3
	AND.B	#%1111111,D3
	DBNE	D0,.LO21
	TST	D0
	BPL.S	.EXIT1
	ADDQ	#1,D1
	ORI.B	#64,-80(A0)
	DBF	D2,.LO11
.EXIT1
	MOVE	D1,(A1)		



	ADD.L	#9636,A1	*IMAGE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.COMPSLOOP_O1
	ADDQ.L	#2,SP


	MOVE.L	ENNEMIS,A1
	MOVE	#47,-(SP)	*COMPTEUR D'IMAGES
.COMPSLOOP_O2
	LEA	36(A1),A0
	
	MOVE	#79,D0
.XCOUNT2
	MOVEQ	#119,D2
	
	MOVEQ	#0,D1
	MOVEQ	#0,D3
.YCOUNT2
	OR.B	(A0,D3.W),D1
	ADD	#80,D3
	DBF	D2,.YCOUNT2
	
	TST.B	D1
	BNE.S	.NEXTS2
		MOVEQ	#0,D3
		MOVEQ	#119,D2
.CMPC3		ORI.B	#128,(A0,D3)
		ADD	#80,D3
		DBF	D2,.CMPC3
.NEXTS2
	ADDQ.L	#1,A0	
	DBF	D0,.XCOUNT2

	*HORIZONTALEMENT
	LEA	36(A1),A0
	MOVEQ	#119,D2
	MOVEQ	#0,D1	*COMPTEUR
.LO12
	MOVEQ	#79,D0
.LO22
	MOVE.B	(A0)+,D3
	AND.B	#%1111111,D3
	DBNE	D0,.LO22
	TST	D0
	BPL.S	.EXIT2
	ADDQ	#1,D1
	ORI.B	#64,-80(A0)
	DBF	D2,.LO12
.EXIT2
	MOVE	D1,(A1)		


	ADD.L	#9636,A1	*IMAGE SUIVANTE
	SUBQ	#1,(SP)
	BNE.S	.COMPSLOOP_O2
	ADDQ.L	#2,SP
	RTS

AFF_DIR0	*AFFICHAGE DIRECTION 0
************************************************************	
.AFFSCENE
	MOVE.B	(A0)+,D2
	MOVE.B	(A0)+,D3
	EXT.W	D2			*D2=DX D3=DY
	EXT.W 	D3
	MOVE	D3,D1	
	ASL	#6,D1		*32 CARACTERES POUR LE PLAN
	ADD	D2,D1
	ADD	D2,D1
	
	PEA	(A1,D1.W)
	MOVE.L	(SP)+,XYCUR
	
	MOVE.B	(A1,D1.W),ACTUEL
	MOVE.B	1(A1,D1.W),D1
	BTST	#7,ACTUEL
	BNE.S	.AFF
	CMP.B	#16,D1
	BEQ	.RAF
.AFF	
	*MULTIPLICATION PAR LES VALEURS ECRANS : D2*160,-D3*160
	EXT.L	D2
	EXT.L	D3
	MULS	#160,D2
	MULS	#-160,D3

	MOVE.B	X_POS+1,D4
	MOVE.B	Y_POS+1,D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5
	SUB	D4,D2
	ADD	D5,D3

	
	TST.B	D1
	BNE.S	.NOSOL			*RIEN D'AUTRE A AFFICHER QU'UN MUR
	BSR	.SOL
	BTST	#7,ACTUEL
	BNE.S	.NOSOL
	BRA	.RAF	
.NOSOL		
	*AFFICHE SOL S'IL Y LIEU : OBJETS
	BTST	#5,D1
	BEQ.S	.NOSOL2
	BSR	.SOL
	BRA.S	.NOSOL3
.NOSOL2
	CMP.B	#128,D1
	BNE.S	.NOSOL3
	BSR	.SOL
.NOSOL3

	BTST	#4,D1
	BEQ	.VRAI_MUR
	*PORTE
	BSR	.SOL
	
	MOVE.B	D1,D4
	AND.B	#$F,D4
	CMP.B	#1,D4
	BNE.S	.VERTI
	*MUR -

	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENT2OP
	ADD	#720,D0
.VALENT2OP
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	ADD	#80,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	*AFFICHE MORT OU PERSO
	

	BRA.S	.VRAI_MUR
	
.VERTI	*PORTE I

	*AFFICHER UN MUR D'ANGLE A+90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D3,XTRF
	
	*CLR	YTRF
	MOVE	D2,ZTRF
	SUB	#80,ZTRF
	NEG	ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1

.VRAI_MUR

	BTST	#7,ACTUEL
	BEQ.S	.PASMOR

	SF	ENC_MOR
.ENC	MOVEM.L	D0-D3/A0-A1,-(SP)
	BSR	MORT_SEARCH
	BNE.S	.ERRO		*ERREUR OU PLUS DE MORT A AFFICHER

	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3
	
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENT2OMO
	ADD	#720,D0
.VALENT2OMO
	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF

	ADD	D4,XTRF
	SUB	D5,ZTRF

	BSR	AFFICHE_MORT
	MOVEM.L	(SP)+,D0-D3/A0-A1
	BRA.S	.ENC	
.ERRO	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	
.PASMOR
	BTST	#7,D1
	BEQ.S	.VRAI_DE_VRAI
	*PERSONNAGE

	MOVEM.L	D0-D3/A0-A1,-(SP)
	BSR	PERSO_SEARCH
	BNE.S	.ERR		*ERREUR

	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3
	
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENT2OM
	ADD	#720,D0
.VALENT2OM
	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF

	ADD	D4,XTRF
	SUB	D5,ZTRF

	BSR	AFFICHE_OBJET
.ERR	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.VRAI_DE_VRAI
	
	BTST	#4,D1
	BNE	.RAF

	BTST	#5,D1
	BEQ.S	.MUR
	*OBJET
	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENT2O
	ADD	#720,D0
.VALENT2O
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	ANDI.B	#%01111111,D1
	BSR	AFFICHE_OBJET
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	BRA	.RAF	
.MUR

	BTST	#0,D1		
	BEQ.S	.SUIT1
	*MUR G
	TST	D2
	BMI.S	.SUIT1		*PAS VISIBLE SI DX<0	
	BEQ.S	.SUIT1
	*AFFICHER UN MUR D'ANGLE A+180
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	#360,D0
	CMP	#720,D0
	BLT.S	.VALENT1
	SUB	#720,D0
.VALENT1
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	
	MOVE	D3,XTRF
	NEG	XTRF
	*CLR	YTRF
	MOVE	D2,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT1
	BTST	#1,D1
	BEQ.S	.SUIT2
	*MUR B
	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENT2
	ADD	#720,D0
.VALENT2
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT2
	BTST	#2,D1
	BEQ.S	.SUIT3
	*MUR D
	TST	D2
	BPL.S	.SUIT3
	*AFFICHER UN MUR D'ANGLE A
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D3,XTRF
	
	*CLR	YTRF
	MOVE	D2,ZTRF
	NEG	ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	
.SUIT3
.RAF
	DBF	D0,.AFFSCENE
	RTS
.SOL	*SOL

	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENTS2
	ADD	#720,D0
.VALENTS2
	ADD	D0,D0
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	MOVE.L	XYCUR,A6

	LEA	640+32*64(A6),A5	*A5 = ADRESSE DS LE PLANSOL
	BSR	AFFICHE_SOL
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	RTS


AFF_DIR2
************************************************************************
.AFFSCENE
	MOVE.B	(A0)+,D2
	MOVE.B	(A0)+,D3
	EXT.W	D2			*D2= D3=DY
	EXT.W 	D3
	MOVE	D3,D1	
	ASL	#6,D1			*64 OCTETS POUR LE PLAN
	ADD	D2,D1
	ADD	D2,D1

	PEA	(A1,D1.W)
	MOVE.L	(SP)+,XYCUR

	MOVE.B	(A1,D1.W),ACTUEL
	MOVE.B	1(A1,D1.W),D1
	BTST	#7,ACTUEL
	BNE.S	.AFF
	CMP.B	#16,D1
	BEQ	.RAF
.AFF

	*MULTIPLICATION PAR LES VALEURS ECRANS : D2*160,-D3*160
	EXT.L	D2
	EXT.L	D3
	MULS	#160,D2
	MULS	#160,D3
	EXG	D2,D3
	
	MOVE.B	X_POS+1,D4
	MOVE.B	Y_POS+1,D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5
	SUB	D5,D2
	SUB	D4,D3

	TST.B	D1
	BNE.S	.NOSOL			*RIEN D'AUTRE A AFFICHER QU'UN MUR
	BSR	.SOL
	BTST	#7,ACTUEL
	BNE.S	.NOSOL
	BRA	.RAF	
.NOSOL		
	*AFFICHE SOL S'IL Y LIEU : OBJETS
	BTST	#5,D1
	BEQ.S	.NOSOL2
	BSR	.SOL
	BRA.S	.NOSOL3
.NOSOL2
	CMP.B	#128,D1
	BNE.S	.NOSOL3
	BSR	.SOL
.NOSOL3

	BTST	#4,D1
	BEQ	.VRAI_MUR
	*PORTE
	BSR	.SOL
	MOVE.B	D1,D4
	AND.B	#$F,D4
	CMP.B	#1,D4
	BNE.S	.VERTI
	*MUR -

	*AFFICHER UN MUR D'ANGLE A+90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	#180,D0
	CMP	#720,D0
	BLT.S	.VALENT2P
	SUB	#720,D0
.VALENT2P
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D3,XTRF
	
	*CLR	YTRF
	MOVE	D2,ZTRF
	SUB	#80,ZTRF
	NEG	ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1


	BRA.S	.VRAI_MUR
.VERTI	*MUR I

	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#540+180,D0
	BPL.S	.VALENT2PI
	ADD	#720,D0
.VALENT2PI
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	ADD	#80,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*


.VRAI_MUR

	BTST	#7,ACTUEL
	BEQ.S	.PASMOR
	SF	ENC_MOR
.ENC	MOVEM.L	D0-D3/A0-A1,-(SP)
	
	BSR	MORT_SEARCH
	BNE.S	.ERRO		*ERREUR

	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3

	*D4 ET D5 POSSEDE L'OFFSET DE POSITION
	*D6=0 SI AMIS, 1 SI ENNEMIS
	MOVE	ANG,D0

	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	
	ADD	D4,ZTRF
	ADD	D5,XTRF
	
	BSR	AFFICHE_MORT
	MOVEM.L	(SP)+,D0-D3/A0-A1
	BRA.S	.ENC	
.ERRO	MOVEM.L	(SP)+,D0-D3/A0-A1
	
	*
.PASMOR
	BTST	#7,D1
	BEQ.S	.VRAI_DE_VRAI
	*PERSONNAGE

	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	
	BSR	PERSO_SEARCH
	BNE.S	.ERR		*ERREUR
	MOVEM.L	(SP),D0-D3
	*D4 ET D5 POSSEDE L'OFFSET DE POSITION
	*D6=0 SI AMIS, 1 SI ENNEMIS
	MOVE	ANG,D0

	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	
	ADD	D4,ZTRF
	ADD	D5,XTRF
	
	BSR	AFFICHE_OBJET
.ERR	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

	
.VRAI_DE_VRAI
	BTST	#4,D1
	BNE	.RAF

	BTST	#5,D1
	BEQ.S	.MUR
	*OBJET
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)

	MOVE	ANG,D0

	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	ANDI.B	#%01111111,D1
	BSR	AFFICHE_OBJET
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

	BRA	.RAF	
.MUR

	BTST	#3,D1		
	BEQ.S	.SUIT1
	*MUR G-H
	TST	D2
	BMI.S	.SUIT1		*PAS VISIBLE SI DX<0	
	BEQ.S	.SUIT1
	*AFFICHER UN MUR D'ANGLE A+270
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	#540,D0
	CMP	#720,D0
	BLT.S	.VALENT1
	SUB	#720,D0
.VALENT1
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	
	MOVE	D3,XTRF
	NEG	XTRF
	*CLR	YTRF
	MOVE	D2,ZTRF
       	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT1
	BTST	#0,D1
	BEQ.S	.SUIT2
	*MUR B-G
	*AFFICHER UN MUR D'ANGLE A
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT2
	BTST	#1,D1
	BEQ.S	.SUIT3
	*MUR D-B
	TST	D2
	BPL.S	.SUIT3
	*AFFICHER UN MUR D'ANGLE A+90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	#180,D0
	CMP	#720,D0
	BLT.S	.VALENT2
	SUB	#720,D0
.VALENT2
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D3,XTRF
	
	*CLR	YTRF
	MOVE	D2,ZTRF
	NEG	ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	
.SUIT3
*	BTST	#2,D1
*	BEQ.S	.SUIT4
*	*MUR H-D
*	BRA.S	.SUIT4	*PAS DE MUR
*.SUIT4
.RAF	DBF	D0,.AFFSCENE

	RTS

.SOL	*SOL
	*AFFICHER UN MUR D'ANGLE A
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	D0,D0
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	MOVE.L	XYCUR,A6
	LEA	640+32*64(A6),A5	*A5 = ADRESSE DS LE PLANSOL
	BSR	AFFICHE_SOL
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	RTS	


AFF_DIR4
************************************************************	DIR 4
.AFFSCENE
	MOVE.B	(A0)+,D2
	MOVE.B	(A0)+,D3
	EXT.W	D2			*D2=DX D3=DY
	EXT.W 	D3
	MOVE	D3,D1	
	ASL	#6,D1			*64 OCTETS POUR LE PLAN
	ADD	D2,D1
	ADD	D2,D1
	PEA	(A1,D1.W)
	MOVE.L	(SP)+,XYCUR
	MOVE.B	(A1,D1.W),ACTUEL
	MOVE.B	1(A1,D1.W),D1
	BTST	#7,ACTUEL
	BNE.S	.AFF
	CMP.B	#16,D1
	BEQ	.RAF
.AFF
	*MULTIPLICATION PAR LES VALEURS ECRANS : D2*160,-D3*160
	EXT.L	D2
	EXT.L	D3
	MULS	#-160,D2
	MULS	#160,D3

	MOVE.B	X_POS+1,D4
	MOVE.B	Y_POS+1,D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5
	ADD	D4,D2
	SUB	D5,D3

	TST.B	D1
	BNE.S	.NOSOL			*RIEN D'AUTRE A AFFICHER QU'UN MUR
	BSR	.SOL
	BTST	#7,ACTUEL
	BNE.S	.NOSOL
	BRA	.RAF	
.NOSOL		
	*AFFICHE SOL S'IL Y LIEU : OBJETS
	BTST	#5,D1
	BEQ.S	.NOSOL2
	BSR	.SOL
	BRA.S	.NOSOL3
.NOSOL2
	CMP.B	#128,D1
	BNE.S	.NOSOL3
	BSR	.SOL
.NOSOL3

	BTST	#4,D1
	BEQ	.VRAI_MUR
	*PORTE
	BSR	.SOL
	MOVE.B	D1,D4
	AND.B	#$F,D4
	CMP.B	#1,D4
	BNE.S	.VERTI
	*MUR -

	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#540,D0
	BPL.S	.VALENT2P
	ADD	#720,D0
.VALENT2P
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	ADD	#80,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*


	BRA.S	.VRAI_MUR
.VERTI	*MUR I
	*AFFICHER UN MUR D'ANGLE A+180-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	*MOVE.L	#Z_REC,D7
	
	MOVE	D3,XTRF
	NEG	XTRF
	*CLR	YTRF
	MOVE	D2,ZTRF
	ADD	#80,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

.VRAI_MUR
	BTST	#7,ACTUEL
	BEQ.S	.PASMOR

	SF	ENC_MOR
.ENC	MOVEM.L	D0-D3/A0-A1,-(SP)
	BSR	MORT_SEARCH
	BNE.S	.ERRO		*ERREUR
	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3

	MOVE	ANG,D0
	SUB	#540,D0
	BPL.S	.VALENT2OMO
	ADD	#720,D0
.VALENT2OMO
	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF

	SUB	D4,XTRF
	ADD	D5,ZTRF

	BSR	AFFICHE_MORT
	MOVEM.L	(SP)+,D0-D3/A0-A1
	BRA.S	.ENC	
.ERRO	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.PASMOR
	BTST	#7,D1
	BEQ.S	.VRAI_DE_VRAI
	*PERSONNAGE

	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	BSR	PERSO_SEARCH
	BNE.S	.ERR		*ERREUR
	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3

	
	MOVE	ANG,D0
	SUB	#540,D0
	BPL.S	.VALENT2OM
	ADD	#720,D0
.VALENT2OM
	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF

	SUB	D4,XTRF
	ADD	D5,ZTRF

	BSR	AFFICHE_OBJET
.ERR	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

.VRAI_DE_VRAI
	BTST	#4,D1
	BNE	.RAF

	BTST	#5,D1
	BEQ.S	.MUR
	*OBJET
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#540,D0
	BPL.S	.VALENT2O
	ADD	#720,D0
.VALENT2O
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	ANDI.B	#%01111111,D1
	BSR	AFFICHE_OBJET
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

	BRA	.RAF	
.MUR

	BTST	#2,D1		
	BEQ.S	.SUIT1
	*MUR G	-D
	TST	D2
	BMI.S	.SUIT1		*PAS VISIBLE SI DX<0	
	BEQ.S	.SUIT1
	*AFFICHER UN MUR D'ANGLE A+180-180
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	
	MOVE	D3,XTRF
	NEG	XTRF
	*CLR	YTRF
	MOVE	D2,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT1
	BTST	#3,D1
	BEQ.S	.SUIT2
	*MUR B-H
	*AFFICHER UN MUR D'ANGLE A-90-180
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#540,D0
	BPL.S	.VALENT2
	ADD	#720,D0
.VALENT2
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT2
	BTST	#0,D1
	BEQ.S	.SUIT3
	*MUR D-G
	TST	D2
	BPL.S	.SUIT3
	*AFFICHER UN MUR D'ANGLE A-180
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#360,D0
	BPL.S	.VALENT1
	ADD	#720,D0
.VALENT1
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D3,XTRF
	
	*CLR	YTRF
	MOVE	D2,ZTRF
	NEG	ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	
.SUIT3
*	BTST	#1,D1
*	BEQ.S	.SUIT4
*	*MUR H-B
*	BRA.S	.SUIT4	*PAS DE MUR
*.SUIT4
.RAF
	DBF	D0,.AFFSCENE

	RTS

.SOL	*SOL
	*
	*AFFICHER UN MUR D'ANGLE A-90-180
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#540,D0
	BPL.S	.VALENT2S
	ADD	#720,D0
.VALENT2S
	ADD	D0,D0
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	MOVE.L	XYCUR,A6
	LEA	640+32*64(A6),A5	*A5 = ADRESSE DS LE PLANSOL
	BSR	AFFICHE_SOL
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	RTS	


AFF_DIR6
*********************************************
.AFFSCENE
	MOVE.B	(A0)+,D2
	MOVE.B	(A0)+,D3
	EXT.W	D2			*D2=DX D3=DY
	EXT.W 	D3
	MOVE	D3,D1	
	ASL	#6,D1			*64 OCTETS POUR LE PLAN
	ADD	D2,D1
	ADD	D2,D1
	PEA	(A1,D1.W)
	MOVE.L	(SP)+,XYCUR
	MOVE.B	(A1,D1.W),ACTUEL
	MOVE.B	1(A1,D1.W),D1
	BTST	#7,ACTUEL
	BNE.S	.AFF
	CMP.B	#16,D1
	BEQ	.RAF
.AFF
	*MULTIPLICATION PAR LES VALEURS ECRANS : D2*160,-D3*160
	EXT.L	D2
	EXT.L	D3
	MULS	#-160,D2
	MULS	#-160,D3
	EXG	D2,D3

	MOVE.B	X_POS+1,D4
	MOVE.B	Y_POS+1,D5
	AND.L	#$FF,D4
	AND.L	#$FF,D5
	SUB.L	#128,D4
	SUB.L	#128,D5
	MULS	#160,D4
	MULS	#160,D5
	ASR	#8,D4
	ASR	#8,D5
	ADD	D5,D2
	ADD	D4,D3

	TST.B	D1
	BNE.S	.NOSOL			*RIEN D'AUTRE A AFFICHER QU'UN MUR
	BSR	.SOL
	BTST	#7,ACTUEL
	BNE.S	.NOSOL
	BRA	.RAF	
.NOSOL		
	*AFFICHE SOL S'IL Y LIEU : OBJETS
	BTST	#5,D1
	BEQ.S	.NOSOL2
	BSR	.SOL
	BRA.S	.NOSOL3
.NOSOL2
	CMP.B	#128,D1
	BNE.S	.NOSOL3
	BSR	.SOL
.NOSOL3

	BTST	#4,D1
	BEQ	.VRAI_MUR
	*PORTE
	BSR	.SOL
	MOVE.B	D1,D4
	AND.B	#$F,D4
	CMP.B	#1,D4
	BNE.S	.VERTI
	*MUR -
	*AFFICHER UN MUR D'ANGLE A+180-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	#180,D0
	CMP	#720,D0
	BLT.S	.VALENT1P
	SUB	#720,D0
.VALENT1P
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	*MOVE.L	#Z_REC,D7
	
	MOVE	D3,XTRF
	NEG	XTRF
	*CLR	YTRF
	MOVE	D2,ZTRF
	ADD	#80,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

	BRA.S	.VRAI_MUR
.VERTI	*MUR I

	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180+180,D0
	BPL.S	.VALENT2OP
	ADD	#720,D0
.VALENT2OP
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC2,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	ADD	#80,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*


.VRAI_MUR
	BTST	#7,ACTUEL
	BEQ.S	.PASMOR
	SF	ENC_MOR
.ENC	MOVEM.L	D0-D3/A0-A1,-(SP)
	BSR	MORT_SEARCH
	BNE.S	.ERRO		*ERREUR
	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3

	MOVE	ANG,D0
	SUB	#180*2,D0
	BPL.S	.VALENT2OMO
	ADD	#720,D0
.VALENT2OMO

	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	
	SUB	D5,XTRF
	SUB	D4,ZTRF

	BSR	AFFICHE_MORT
	MOVEM.L	(SP)+,D0-D3/A0-A1
	BRA.S	.ENC	
.ERRO	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

.PASMOR
	BTST	#7,D1
	BEQ.S	.VRAI_DE_VRAI
	*PERSONNAGE

	MOVEM.L	D0-D3/A0-A1,-(SP)
	BSR	PERSO_SEARCH
	BNE.S	.ERR		*ERREUR
	MOVE.L	(SP),D0
	MOVE.L	4(SP),D1
	MOVE.L	8(SP),D2
	MOVE.L	12(SP),D3

	MOVE	ANG,D0
	SUB	#180*2,D0
	BPL.S	.VALENT2OM
	ADD	#720,D0
.VALENT2OM

	ADD	D0,D0
	LEA	X_REC2,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	
	SUB	D5,XTRF
	SUB	D4,ZTRF

	BSR	AFFICHE_OBJET
.ERR	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
*
	
.VRAI_DE_VRAI
	BTST	#4,D1
	BNE	.RAF

	BTST	#5,D1
	BEQ.S	.MUR
	*OBJET
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180*2,D0
	BPL.S	.VALENT2O
	ADD	#720,D0
.VALENT2O

	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	MOVE	D2,XTRF
	MOVE	D3,ZTRF
	ANDI.B	#%01111111,D1
	BSR	AFFICHE_OBJET
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*

	BRA	.RAF	
.MUR
	
	BTST	#1,D1		
	BEQ.S	.SUIT1
	*MUR G-B
	TST	D2
	BMI.S	.SUIT1		*PAS VISIBLE SI DX<0	
	BEQ.S	.SUIT1
	*AFFICHER UN MUR D'ANGLE A+180-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	ADD	#180,D0
	CMP	#720,D0
	BLT.S	.VALENT1
	SUB	#720,D0
.VALENT1
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	
	MOVE	D3,XTRF
	NEG	XTRF
	*CLR	YTRF
	MOVE	D2,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT1
	BTST	#2,D1
	BEQ.S	.SUIT2
	*MUR B-D
	*AFFICHER UN MUR D'ANGLE A-90-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180*2,D0
	BPL.S	.VALENT2
	ADD	#720,D0
.VALENT2
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
.SUIT2
	BTST	#3,D1
	BEQ.S	.SUIT3
	*MUR D-H
	TST	D2
	BPL.S	.SUIT3
	*AFFICHER UN MUR D'ANGLE A-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180,D0
	BPL.S	.VALENT0
	ADD	#720,D0
.VALENT0
	ADD	D0,D0
	LEA	X_REC,A6
	LEA	Y_REC,A5
	*MOVE.L	#Z_REC,D7
	MOVE	D3,XTRF
	
	*CLR	YTRF
	MOVE	D2,ZTRF
	NEG	ZTRF
	BSR	AFFICHE_MUR
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	
.SUIT3
.RAF
	DBF	D0,.AFFSCENE

	RTS

.SOL	*SOL
	*
	*AFFICHER UN MUR D'ANGLE A-90-90
	*
	MOVEM.L	D0-D3/A0-A1,-(SP)
	MOVE	ANG,D0
	SUB	#180*2,D0
	BPL.S	.VALENT2S
	ADD	#720,D0
.VALENT2S
	ADD	D0,D0
	MOVE	D2,XTRF
	*CLR	YTRF
	MOVE	D3,ZTRF
	MOVE.L	XYCUR,A6
	LEA	640+32*64(A6),A5	*A5 = ADRESSE DS LE PLANSOL
	BSR	AFFICHE_SOL
	MOVEM.L	(SP)+,D0-D3/A0-A1
	*
	RTS	


VAGUE	*SCROLLING D'UN MESSAGE EN SINUS (BAS VERS HAUT)
	*A0 POINTE SUR LE TEXTE
	*D0 LA POSITION X  D6 LE NOMBRE D'ITER
	
	MOVE	#200,D1
.SL
	*AFFICHAGE TEST D'UN TEXTE EN SPIRALE
	MOVE	#179,D7
	MOVEQ	#0,D2		*ANGLE
.SPIRTST
	BSR.S	PRINT_SINUS
	ADDQ	#8,D2
	SUBQ	#1,D1
	MOVE	D0,-(SP)
	BSR	VSYNC
	MOVE	(SP)+,D0
	SUBQ	#1,D6
	BMI.S	.SORT
	DBF	D7,.SPIRTST
	BRA.S	.SL
.SORT	RTS
	
PRINT_SINUS	*AFFICHE TEXTE EN SINUS
	*A0 POINTE SUR LE TEXTE, D0 POS X, D1 POS Y
	*D2 SUR L'ANGLE DE DEPART
	MOVEM.L	D0-A6,-(SP)
	MOVE.L	BASE,A1
	EXT.L	D1
	EXT.L	D0
	MULU	#640,D1
	ADD.L	D0,D0
	ADD.L	D0,D1
	ADD.L	D1,A1
	
	LEA	(COSTBL,D2*2),A6
	LEA	FONT,A2

.LOOP	MOVE.B	(A0)+,D0
	BEQ	.END
	SUB.B	#" ",D0
	EXT	D0
	ASL	#7,D0	*16*8=128 OCTETS
	LEA	36(A2,D0),A3

	MOVEQ	#7,D6	*COLONNES
.FORX
	LEA	(A1),A5
	*TRANSFO DE A1
	MOVE	(A6),D1
	EXT.L	D1
	ASR.L	#8,D1
	ASR.L	#4,D1
	MULS	#640,D1
	ADD.L	D1,A1	
	LEA	16(A6),A6
	CMP.L	#COSTBL+720*2,A6
	BLO.S	.FORY1
	SUB.L	#720*2,A6
.FORY1
	MOVEQ	#0,D1
I	SET	0
	REPT	15
	MOVE.B	8*I(A3),D1
	LSR.B	#4,D1
	MOVE	4(A2,D1*2),640*I(A1)
I	SET	I+1
	ENDR

	CLR	640*16(A1)
	CLR	640*17(A1)

	LEA	2(A5),A1
	
	*TRANSFO DE A1
	MOVE	(A6),D1
	EXT.L	D1
	ASR.L	#8,D1
	ASR.L	#4,D1
	MULS	#640,D1
	ADD.L	D1,A1	

	LEA	16(A6),A6
	CMP.L	#COSTBL+720*2,A6
	BLO.S	.FORY2

	SUB.L	#720*2,A6

.FORY2
I	SET	0
	REPT	15
	MOVE.B	8*I(A3),D1
	AND	#%1111,D1
	MOVE	4(A2,D1*2),640*I(A1)
I	SET	I+1
	ENDR
	
	CLR	640*16(A1)
	CLR	640*17(A1)

	LEA	4(A5),A1
	ADDQ.L	#1,A3
	
	DBF	D6,.FORX
	
	
	BRA	.LOOP
.END
	MOVEM.L	(SP)+,D0-A6
	RTS

PRINT_T	*AFFICHAGE DU TEXTE EN TRANSPARENT
	*POINTE PAR A0 (FIN PAR 0) POSITION D0,D1 (PIXELS)
	MOVE.L	BASE,A1
	EXT.L	D1
	EXT.L	D0
	MULU	#640,D1
	ADD.L	D0,D0
	ADD.L	D0,D1
	ADD.L	D1,A1
	LEA	FONT,A2
.LOOP	MOVE.B	(A0)+,D0
	BEQ.S	.END
	SUB.B	#" ",D0
	EXT	D0
	ASL	#7,D0	*16*8=128 OCTETS
	LEA	36(A2,D0),A3
	MOVEQ	#14,D6
.FORY
	MOVEQ	#7,D7
.FORX
	MOVE.B	(A3)+,D1
	MOVE	D1,D2
	AND	#%11110000,D1
	AND	#%1111,D2
	LSR	#4,D1
	MOVE	4(A2,D1*2),D3
	BEQ.S	.TRA1
	CLR	2(A1)
	CLR	640(A1)
	MOVE	D3,(A1)
.TRA1	ADDQ.L	#2,A1
	MOVE	4(A2,D2*2),D3
	BEQ.S	.TRA2
	CLR	2(A1)
	CLR	640(A1)
	MOVE	D3,(A1)
	
.TRA2	ADDQ.L	#2,A1
	DBF	D7,.FORX
	ADD.L	#640-32,A1
	DBF	D6,.FORY
	SUB.L	#15*640-32,A1
	BRA.S	.LOOP
.END
	RTS

PRINT	*AFFICHAGE DU TEXTE POINTE PAR A0 (FIN PAR 0) POSITION D0,D1 (PIXELS)
	MOVE.L	BASE,A1
	EXT.L	D1
	EXT.L	D0
	MULU	#640,D1
	ADD.L	D0,D0
	ADD.L	D0,D1
	ADD.L	D1,A1
	LEA	FONT,A2
.LOOP	MOVE.B	(A0)+,D0
	BEQ.S	.END
	SUB.B	#" ",D0
	EXT	D0
	ASL	#7,D0	*16*8=128 OCTETS
	LEA	36(A2,D0),A3
	MOVEQ	#14,D6
.FORY
	MOVEQ	#7,D7
.FORX
	MOVE.B	(A3)+,D1
	MOVE	D1,D2
	AND	#%11110000,D1
	AND	#%1111,D2
	LSR	#4,D1
	MOVE	4(A2,D1*2),(A1)+
	MOVE	4(A2,D2*2),(A1)+
	DBF	D7,.FORX
	ADD.L	#640-32,A1
	DBF	D6,.FORY
	SUB.L	#15*640-32,A1
	BRA.S	.LOOP
.END
	RTS
PRINT_16T
	ST	TRANSP_FL
	BRA.S	PRINT_16C
PRINT_8T
	ST	TRANSP_FL
	BRA.S	PRINT_8C
PRINT_8
	SF	TRANSP_FL
PRINT_8C
	*AFFICHAGE D'UN NOMBRE 8 BITS UNSIGNED
	*D7=NBRE, D0,D1=POS XY
	LEA	CHIF_BUF,A0

	AND.L	#$FF,D7
	DIVU	#100,D7
	MOVE	D7,D6
	ADD	#'0',D6
	MOVE.B	D6,(A0)
	SWAP	D7
	AND.L	#$FFFF,D7
	DIVU	#10,D7
	MOVE	D7,D6
	ADD	#'0',D6
	MOVE.B	D6,1(A0)
	SWAP	D7
	AND.L	#$FFFF,D7
	ADD	#'0',D7
	MOVE.B	D7,2(A0)
	CLR.B	3(A0)
	*ELIMINATION DES 0 SUPERFLUS DEVANT
	CMP.B	#'0',(A0)
	BNE.S	PRINT_CHIFFRES
	MOVE.B	#':',(A0)
	CMP.B	#'0',1(A0)
	BNE.S	PRINT_CHIFFRES
	MOVE.B	#':',1(A0)
	BRA.S	PRINT_CHIFFRES

PRINT_16
	SF	TRANSP_FL
PRINT_16C
	*AFFICHAGE D'UN NOMBRE 16 BITS SIGNED
	*D7=NBRE, D0,D1=POS XY
	LEA	CHIF_BUF,A0
	TST	D7
	BPL.S	.ABSO
	CLR	D7		*PAS D'AFFICHAGE SI NEGATIF - POUR L'INSTANT
.ABSO
	EXT.L	D7
	MOVE.L	#10000,D5
	MOVEQ	#4,D4
.DIV	
	DIVU	D5,D7
	MOVE	D7,D6
	ADD	#'0',D6
	MOVE.B	D6,(A0)+
	SWAP	D7
	AND.L	#$FFFF,D7
	DIVU	#10,D5
	AND.L	#$FFFF,D5
	DBF	D4,.DIV
	LEA	CHIF_BUF,A0
	MOVEQ	#3,D4
	*ELIMINATION DES 0 SUPERFLUS DEVANT
.ELIM	CMP.B	#'0',(A0)
	BNE.S	PRINT_CHIFFRES
	MOVE.B	#':',(A0)+
	DBF	D4,.ELIM
*NE PAS SEPARER LES 3 ROUTINES SVP !!!!!!
PRINT_CHIFFRES	
	LEA	CHIF_BUF,A0
	*AFFICHAGE DU TEXTE POINTE PAR A0 (FIN PAR 0) POSITION D0,D1 (PIXELS)
	*CARACTERES RECONNUS = 013456789:  ; 8*16 
	MOVE.L	BASE,A1
	EXT.L	D1
	EXT.L	D0
	MULU	#640,D1
	ADD.L	D0,D0
	ADD.L	D0,D1
	ADD.L	D1,A1
	LEA	CHIFFRES,A2
.LOOP	MOVE.B	(A0)+,D0
	BEQ.S	.END
	SUB.B	#"0",D0		*':'=UN BLANC
	EXT	D0
	ASL	#6,D0	*16*4=64 OCTETS
	LEA	36(A2,D0),A3
	MOVEQ	#14,D6
.FORY
	MOVEQ	#3,D7
.FORX
	MOVE.B	(A3)+,D1
	MOVE	D1,D2
	AND	#%11110000,D1
	AND	#%1111,D2
	LSR	#4,D1
	TST.B	TRANSP_FL
	BNE.S	.TRANSAFF
	MOVE	4(A2,D1*2),(A1)+
	MOVE	4(A2,D2*2),(A1)+
	BRA.S	.COM
.TRANSAFF
	TST	D1
	BEQ.S	.SKIP1
	MOVE	4(A2,D1*2),(A1)
.SKIP1	ADDQ.L	#2,A1
	TST	D2
	BEQ.S	.SKIP2
	MOVE	4(A2,D2*2),(A1)
.SKIP2	ADDQ.L	#2,A1
.COM
	DBF	D7,.FORX
	ADD.L	#640-16,A1
	DBF	D6,.FORY
	SUB.L	#15*640-16,A1
	BRA.S	.LOOP
.END
	RTS
	
AFFICHE_PLAN	*AFFICHAGE DU PLAN
	LEA	PLAN,A0
	MOVE.L	BASE,A1
	MOVEQ	#31,D7
.FORY
	MOVEQ	#31,D6
	LEA	(A1),A3
.FORX
	MOVE	(A0)+,D0
	BNE.S	.PAS0
	*SURELEVE ?
	MOVE.B	(639+32*64)(A0),D0
	BEQ.S	.TTNOIR
	LEA	ELEIT,A2
	BRA.S	.DRAW
.TTNOIR
	CMP.B	#16,(638+32*64)(A0)		*TYPE DE SOL ?
	BEQ.S	.NEXTX			*SOL CARTE TRANSPARENT
	LEA	NOIR,A2
	BRA.S	.DRAW
.PAS0
	BTST	#5,D0
	BNE.S	.OBJET
	BTST	#4,D0
	BNE.S	.PORTE
.MUR
	LSR	#8,D0
	MOVE.L	(ITEMS_M,D0*4),A2	*DESCRIPTION DE 25 MOTS TCR DU MOTIF
	BRA.S	.DRAW
.PORTE
	AND	#15,D0
	BEQ.S	.INTER
	SUBQ	#1,D0
	MOVE.L	(ITEMS_P,D0*4),A2
	BRA.S	.DRAW
.INTER	*MUR INTERIEUR
	MOVE	-2(A0),D0
	BRA.S	.MUR
.OBJET
	LSR	#8,D0
	MOVE.L	(ITEMS_O,D0*4),A2
.DRAW
	MOVEQ	#0,D0
.FOR0	MOVE.L	(A2)+,(A1,D0)
	MOVE.L	(A2)+,4(A1,D0)
	MOVE	(A2)+,8(A1,D0)
	ADD	#640,D0
	CMP	#640*5,D0
	BNE.S	.FOR0
.NEXTX	
	LEA	10(A1),A1
	DBF	D6,.FORX
	LEA	640*5(A3),A1
	DBF	D7,.FORY
	RTS
	
	
CREE_PERSO	
*A0=PLAN, A1=PILE_,D7=NOMBRE-1,D3=0 AMI 2^15 ENNEMI
*A6=POINTEUR POSITION
*A4=POINTEUR SUR PF_TBL

	LEA	(A1),A3
.PASOK
	MOVE.B	(A6)+,D0
	AND	#31,D0
	MOVE	D0,D6	*X
	MOVE	D0,D5	
	ADD	D5,D5
	MOVE.B	(A6)+,D0
	AND	#31,D0	
	MOVE	D0,D4	*Y
	ASL	#6,D0	
	ADD	D0,D5
	LEA	(A0,D5),A2	*XY


	*AFFICHE SUR LE PLAN
	MOVEM.L	D3/D6/A2/A6,-(SP)
	MOVE.L	BASE,A6
	MOVEQ	#0,D0
	MOVE	D4,D0
	EXT.L	D6
	MULU	#640*5,D0
	MULU	#10,D6
	ADD.L	D6,D0
	ROL	#1,D3
	MOVE.L	(ITEMS_J,D3*4),A2	*SRCE
	ADD.L	D0,A6	*DEST
	MOVEQ	#0,D0
.FOR0	MOVE.L	(A2)+,(A6,D0)
	MOVE.L	(A2)+,4(A6,D0)
	MOVE	(A2)+,8(A6,D0)
	ADD	#640,D0
	CMP	#640*5,D0
	BNE.S	.FOR0
	MOVEM.L	(SP)+,D3/D6/A2/A6
	
	ORI.B	#128,1(A2)	*METS UN PERSO ICI
	*OFFSET DS LA PILE POUR LES 15 PREMIERS BITS + 0 SI AMI,
	*1 SI ENNEMI POUR LE 16EME
	MOVE.L	A1,D0
	SUB.L	A3,D0
	ADDQ	#2,D0		*POUR QUE LE 1ER SOIT NON NUL
	AND.W	#$7FFF,D0
	OR	D3,D0
	MOVE	D0,PLAN2-PLAN(A2)
	MOVE.L	A2,(A1)+	*XY
	LSL	#8,D6
	LSL	#8,D4
	MOVE.B	#127,D6
	MOVE.B	#127,D4
	MOVE	D6,(A1)+	*XPOS
	MOVE	D4,(A1)+	*YPOS
	CLR	(A1)+		*ANG
	MOVE	#2,(A1)+	*DIR
	CLR	(A1)+		*ETAT=0 <=> IMMOBILE
	TST.L	(A4)
	BPL.S	.PASLAFIN
	SUBQ.L	#4,A4		*BLOQUE SUR LE DERNIER
.PASLAFIN
	MOVE.L	(A4)+,A5
	
	MOVE	22(A5),(A1)+	*REFLEXES (NB DE VBLS ENTRE CHAQUE POSITION DE TIR)
	MOVE	24(A5),(A1)+	*PRECISION
	MOVE	26(A5),(A1)+	*PARANOIA

	BSR.S	RND
	AND	#$1F,D0
	MOVE	D0,(A1)+	*COMPTEUR

	CLR.L	(A1)+		*DX&DY
	MOVE	#BASE_SC,(A1)+	*SCORE
	CLR.W	(A1)+		*NB TOUC
	CLR.L	(A1)+		*NB TIRE ET CIBLE
	MOVE	20(A5),(A1)+	*NOM
	MOVE	28(A5),(A1)+	*SHIELD
	CLR	(A1)+		*FLAG_VIS
	CLR.L	(A1)+		*DX&DY LASER
	DBF	D7,.PASOK
	RTS

RND	*RETOURNE UN NOMBRE ALEATOIRE 15 BITS DANS D0
	MOVE	D1,-(SP)
	MOVE	D2,-(SP)
	MOVE	RANDOM,D0
	MOVE	D0,D1
	MOVE	D0,D2
	AND	#%0100000000000000,D1
	AND	#%0010000000000000,D2
	ROL	#2,D1
	ROL	#3,D2
	EOR	D1,D2
	LSR	D2
	ROXL	D0
	AND	#$7FFF,D0
	MOVE	D0,RANDOM
	BEQ.S	.ABSORB
	MOVE	(SP)+,D2
	MOVE	(SP)+,D1
	RTS
.ABSORB	*0 EST ABSORBANT
	MOVE.B	$FFFF8209.W,RANDOM	*NOUVELLE GRAINE
	MOVE.B	$FFFF8207.W,RANDOM+1
	MOVE	RANDOM,D0
	AND	#$7FFF,D0
	MOVE	D0,RANDOM
	MOVE	(SP)+,D2
	MOVE	(SP)+,D1
	RTS
SAUVE	*SAUVE FICHIER A5 - DEBUT A6 TAILLE D7
	
	CLR	-(SP)
	PEA	(A5)
	MOVE	#$3C,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	MOVE.L	D0,D6
	BNE.S	.WRITE
	*EXISTE DEJA
	MOVE	#1,-(SP)
	PEA	(A5)
	MOVE	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	MOVE.L	D0,D6
	BEQ.S	.ERROR
.WRITE
	PEA	(A6)
	MOVE.L	D7,-(SP)
	MOVE	D6,-(SP)
	MOVE	#$40,-(SP)
	TRAP	#1
	LEA	12(SP),SP
	
	MOVE	D6,-(SP)
	MOVE	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP
		
.ERROR	RTS	


SELEC_OPTION	*CHOIX D'UNE OPTION ENTRE DEUX : 640*D6 & D7*640
		*RETOUR DANS D5
	*D0,D1 = POS DU YES/NO - RETOUR DANS D4 (=0 : NO =1 : YES)
	*D4=ETAT INITIAL DU YES/NO
	
	MOVEM	D0-D1,JEUREG1
	
	MOVE.L	D6,D5
	LEA	([BASE],D5.L),A0
	*AFFICHAGE DU CURSEUR

	LEA	(A0),A1
	MOVE	#3199+160,D0
.INV	NOT.L	(A1)+
	DBF	D0,.INV
	LEA	KEY_TAB,A6
	
.LOOP
	TST.B	1(A6)
	BEQ.S	.NOESC
	MOVE.L	NIVEAU0,SP		*NIVEAU BCLE PPALE
	BRA	ENDE2
.NOESC	TST.B	57(A6)
	BEQ.S	.NOESP
	CMP.L	D5,D6
	BEQ.S	.CHOIX1
	CMP.L	D5,D7
	BNE.S	.LOOP
	*CHOIX2
	MOVEQ	#2,D5
	RTS
.CHOIX1	MOVEQ	#1,D5
	RTS
.NOESP
	TST.B	21(A6)		*'Y'
	BEQ.S	.NOY
	MOVEM.L	D5-D7/A0/A6,-(SP)
	LEA	TXT_YES,A0
	MOVEM	JEUREG1,D0-D1
	BSR	PRINT
	MOVEM.L	(SP)+,D5-D7/A0/A6
	MOVEQ	#1,D4
.NOY
	TST.B	49(A6)		*'N'
	BEQ.S	.NON
	MOVEM.L	D5-D7/A0/A6,-(SP)
	LEA	TXT_NO,A0
	MOVEM	JEUREG1,D0-D1
	BSR	PRINT
	MOVEM.L	(SP)+,D5-D7/A0/A6
	MOVEQ	#0,D4
.NON
	TST.B	72(A6)
	BEQ.S	.JPOV
	ST	.HAUT_FL
	SF	.BAS_FL
.JPOV
	TST.B	80(A6)
	BEQ.S	.JPOV2
	ST	.BAS_FL
	SF	.HAUT_FL
.JPOV2

	TST.B	.HAUT_FL		*HAUT
	BEQ.S	.NOH
	CMP.L	D5,D6
	BHS	.LOOP
	LEA	-640(A0),A0
	SUB.L	#640,D5
	LEA	(A0),A1
	BSR.S	.INV_LINE
	LEA	21*640(A0),A1
	BSR.S	.INV_LINE
	BSR	VSYNC
	BRA	.LOOP	

.NOH
	TST.B	.BAS_FL			*BAS
	BEQ	.LOOP
	CMP.L	D5,D7
	BLS	.LOOP
	LEA	640(A0),A0
	ADD.L	#640,D5
	LEA	-640(A0),A1
	BSR.S	.INV_LINE
	LEA	20*640(A0),A1
	BSR.S	.INV_LINE
	BSR	VSYNC
	BRA	.LOOP

.INV_LINE	
	MOVE	#159,D0
.GO	NOT.L	(A1)+
	DBF	D0,.GO
	RTS
.HAUT_FL	DS.B	1
.BAS_FL		DS.B	1

TST_REGISTRE
	*Z A UN SI CORRECT
	LEA	TXT_REG2+2,A0		*SORTIE
	LEA	BUF_INF,A1		*ENTREE
	LEA	BUF_DEC,A2
	*DECODE L'ENTREE
	MOVEQ	#0,D0	*I
.DECOD
	MOVE.B	(A1)+,D1
	ROR.B	D1
	NOT.B	D1
	EOR.B	D0,D1
	MOVE.B	D1,(A2)+
	ADDQ	#1,D0
	CMP	#10,D0
	BNE.S	.DECOD	
	
	LEA	BUF_DEC,A1
	BFEXTU	(A1){0:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){5:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){10:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){15:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){20:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){25:5},D1
	MOVE.B	D1,(A0)+
	ADDQ.L	#3,A1
	BFEXTU	(A1){6:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){11:5},D1
	MOVE.B	D1,(A0)+
	ADDQ.L	#2,A1
	
	BFEXTU	(A1){0:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){5:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){10:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){15:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){20:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){25:5},D1
	MOVE.B	D1,(A0)+
	ADDQ.L	#3,A1
	BFEXTU	(A1){6:5},D1
	MOVE.B	D1,(A0)+
	BFEXTU	(A1){11:5},D1
	MOVE.B	D1,(A0)+

	LEA	TXT_REG2+2,A0		*ENTREE/SORTIE
	LEA	BUF_INF+10,A1		*ENTREE
	MOVEQ	#15,D1
.DECOD2
	MOVE.B	(A0),D0
	CMP.B	#26,D0
	BNE.S	.NOESP
	MOVE.B	#32,D0
	BRA.S	.APESP
.NOESP
	ADD.B	#65,D0
.APESP
	MOVE.B	D0,(A0)+
	CMP.B	(A1)+,D0
	DBNE	D1,.DECOD2
	TST	D1
	BPL.S	.ERROR
	*CORRECT
	*RECOPIE LE NOM
	LEA	TXT_REG1,A0
	LEA	T_REG1,A1
	BSR.S	.RECOP
	LEA	TXT_REG2,A0
	LEA	T_REG2,A1
.RECOP
	MOVE.B	(A0)+,(A1)+
	BNE.S	.RECOP
	ST	REGISTRE_F
	OR	#%00000100,CCR
	RTS
.ERROR	*INCORRECT
	*ON NE PERD PAS REGISTRE_F SI IL ETAIT A UN
	AND	#%11111011,CCR
	RTS
	
IS_THERE?	*TESTE SI NOM A5 EST LA.
	CLR	-(SP)
	PEA	(A5)
	MOVE	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	TST.L	D0
	BMI.S	.ERROR

	MOVE	D0,-(SP)
	MOVE	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP
	TST.L	D0
.ERROR	RTS	

SAUVE_INF	
	*SAUVEGARDE DU FICHIER .INF
	MOVE	#1,-(SP)
	PEA	NOM_INF
	MOVE	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	MOVE.L	D0,D6
	BMI.S	.ERREUR
	PEA	BUF_INF
	PEA	LONG_INF
	MOVE	D6,-(SP)
	MOVE	#$40,-(SP)
	TRAP	#1
	LEA	12(SP),SP
	TST.L	D0
	BMI.S	.ERREUR
	MOVE	D6,-(SP)
	MOVE	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP
	TST.L	D0
	BMI.S	.ERREUR
	MOVEQ	#0,D0		*PAS D'ERREUR
.ERREUR	RTS
	
CHARGE_INF
	CLR	-(SP)
	PEA	NOM_INF
	MOVE	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	MOVE.L	D0,D6
	BMI.S	.ERREUR
	PEA	BUF_INF
	PEA	LONG_INF
	MOVE	D6,-(SP)
	MOVE	#$3F,-(SP)
	TRAP	#1
	LEA	12(SP),SP
	TST.L	D0
	BMI.S	.ERREUR
	MOVE	D6,-(SP)
	MOVE	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP
	TST.L	D0
	BMI.S	.ERREUR
	MOVEQ	#0,D0		*PAS D'ERREUR
.ERREUR	RTS
	
CHARGE	*CHARGE A A6 LA LISTE DE NOMS DE TAILLE D7 POINTEE PAR A5
	SUBQ	#1,D7

.LOOP
	CLR	-(SP)
	PEA	(A5)
	MOVE	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	MOVE.L	D0,D6
	BMI.S	.ERREUR
	PEA	(A6)
	PEA	9636*47
	MOVE	D6,-(SP)
	MOVE	#$3F,-(SP)
	TRAP	#1
	LEA	12(SP),SP
	TST.L	D0
	BMI.S	.ERREUR
	MOVE	D6,-(SP)
	MOVE	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP
	TST.L	D0
	BMI.S	.ERREUR
	LEA	9636(A6),A6
	*EVOLUION DE A5 :
.EVO	TST.B	(A5)+
	BNE.S	.EVO

	DBF	D7,.LOOP
	
	MOVEQ	#0,D0		*PAS D'ERREUR
.ERREUR	RTS
	
DRAW_LINE
	*PROCEDURE DE TRACE DE LIGNE - COULEUR DU LASER DANS COLASER (EQU)
	*CLIPPING COMPRIS
	*BASE ECRAN DANS A0
	*(D0,D1)-(D2,D3)
	*TOUS REGISTRES SAUVES
	MOVEM.L	D0-D7/A1,-(SP)

	*CLIPPING TOTAL
	CMP	#XMACLIP,D0
	BLO.S	.TOXCLIP
	CMP	#XMACLIP,D2
	BGE	.RET
.TOXCLIP
	CMP	#XMICLIP,D0
	BGT.S	.TOYCLIP
	CMP	#XMICLIP,D2
	BLE	.RET
.TOYCLIP
	CMP	YMICLIP_F,D1
	BGT.S	.TOYCLP
	CMP	YMICLIP_F,D3
	BLE	.RET
.TOYCLP
	CMP	YMACLIP_F,D1
	BLT.S	.NOCLIP
	CMP	YMACLIP_F,D3
	BGE	.RET
.NOCLIP

	*ALGO DE BRESENHAM EVIDEMENT
	EXT.L	D0
	EXT.L	D1
	EXT.L	D2
	EXT.L	D3
	MOVE.L	D0,D7
	ADD.L	D0,D7		*D7=XC
	MOVE.L	D1,D6
	MULS	#640,D6		*D6=YC
	
	SUB.L	D0,D2		*D2=DX
	BPL.S	.ABS1
	NEG.L	D2
	MOVEQ	#-2,D0
	BRA.S	.ABS2
.ABS1	MOVEQ	#2,D0		*D0=SX
.ABS2	
	SUB.L	D1,D3		*D3=DY
	BPL.S	.ABS3
	NEG.L	D3
	MOVE.L	#-640,D1	*D1=SY
	BRA.S	.ABS4
.ABS3	MOVE.L	#640,D1
.ABS4
	*TEST SI DX=DY=0
	MOVE	D3,D4
	OR	D2,D4
	BEQ.S	.RET
	SUBA.L	A1,A1		*A1=INTERCHANGE
	CMP.L	D2,D3		*DY>DX ?
	BLS.S	.INTER0		*NON
	LEA	1.W,A1
	EXG.L	D3,D2
.INTER0	
	MOVE.L	D2,D4		*D4=I
	ADD.L	D3,D3		*DY*2
	MOVE.L	D3,D5		*D5=E
	SUB.L	D2,D5
	ADD.L	D2,D2		*DX*2
	
	*INITS FAITES
	
	CMP.L	#0,A1
	BEQ.S	INTER_0
	*INTERCHANGE=1
	
	*PLOT (A0,D6,D7)
	*CLIP
.FORI
	CMP.L	#XMICLIP*2,D7			*OPTIMISABLE, MAIS LA ROUTINE
	BLT.S	.NOPLOT				*N'EST PAS CRITIQUE !
	CMP.L	#XMACLIP*2,D7
	BGT.S	.NOPLOT

	TST.B	DOUBLE_F
	BNE.S	.NODBLF
	CMP.L	#YMICLIPD*640,D6
	BLT.S	.NOPLOT
	CMP.L	#YMACLIPD*640,D6
	BGT.S	.NOPLOT
	BRA.S	.ENCDBLF
.NODBLF
	CMP.L	#YMICLIP*640,D6
	BLT.S	.NOPLOT
	CMP.L	#YMACLIP*640,D6
	BGT.S	.NOPLOT
.ENCDBLF
	
	LEA	(A0,D6.L),A1
	MOVE	#COLASER,(A1,D7.L)
.NOPLOT	
	TST.L	D5
	BMI.S	.ENEG
	ADD.L	D0,D7
	SUB.L	D2,D5
.ENEG
	ADD.L	D1,D6
	ADD.L	D3,D5
	DBF	D4,.FORI		
.RET
	MOVEM.L	(SP)+,D0-D7/A1
	RTS
INTER_0
.FORI
	CMP.L	#XMICLIP*2,D7			*OPTIMISABLE, MAIS LA ROUTINE
	BLT.S	.NOPLOT				*N'EST PAS CRITIQUE !
	CMP.L	#XMACLIP*2,D7
	BGT.S	.NOPLOT

	TST.B	DOUBLE_F
	BNE.S	.NODBLF
	CMP.L	#YMICLIPD*640,D6
	BLT.S	.NOPLOT
	CMP.L	#YMACLIPD*640,D6
	BGT.S	.NOPLOT
	BRA.S	.ENCDBLF
.NODBLF
	CMP.L	#YMICLIP*640,D6
	BLT.S	.NOPLOT
	CMP.L	#YMACLIP*640,D6
	BGT.S	.NOPLOT
.ENCDBLF
	LEA	(A0,D6.L),A1
	MOVE	#COLASER,(A1,D7.L)
.NOPLOT	
	TST.L	D5
	BMI.S	.ENEG
	ADD.L	D1,D6
	SUB.L	D2,D5
.ENEG
	ADD.L	D0,D7
	ADD.L	D3,D5
	DBF	D4,.FORI		
	MOVEM.L	(SP)+,D0-D7/A1
	RTS

DRAW_POLY
	*PROCEDURE DE TRACE DE LASER
	* - COULEUR DU LASER DANS COLASER (EQU)
	*CLIPPING COMPRIS
	*BASE ECRAN DANS A0
	*(D0,D1)-(D2,D3)
	*TOUS REGISTRES SAUVES
	*ALGO DE BRESENHAM EVIDEMENT
	
	MOVEQ	#5,D7
.LOOP
	BSR	DRAW_LINE
	ADDQ	#1,D2
	DBF	D7,.LOOP
	RTS
		
	
AHBL
	CLR.B	$FFFFFA21.W
	CLR.B	$FFFFFA1B.W
	MOVE.L	#HBL,$120.W
	MOVE.B	#%00000001,$FFFFFA13.W
	MOVE.B	#%00000001,$FFFFFA07.W
	MOVE.B	#2,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	RTS

HBL	*******************
	MOVE	#$2700,SR
	MOVE.L	D0,-(SP)
	PEA	(A0)
	CLR.B	$FFFFFA1B.W		* ARRET DU TIMER
	LEA	$FFFF8203.W,A0
	MOVE.L	VAL_ECRAN,D0
	MOVEP.L	D0,(A0)
	MOVE.B	#$8,$FFFFFA1B.W
	ADD.L	#640,VAL_ECRAN
	MOVE.L	(SP)+,A0
	MOVE.L	(SP)+,D0
	RTE
VAL_ECRAN
	DS.L	1

AHBL2
	CLR.B	$FFFFFA21.W
	CLR.B	$FFFFFA1B.W
	MOVE.L	#HBL2,$120.W
	MOVE.B	#%00000001,$FFFFFA13.W
	MOVE.B	#%00000001,$FFFFFA07.W
	MOVE.B	YMACLIP_F+1,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	RTS

HBL2	*******************
	CLR	$FFFF82C2.W	*VCO - MODE : DBLE LIGNE
	RTE
AFF_TRANS	*AFFICHE TC4 A0 - LONX D0 LONY D1 A A1 - TRANSPARENT 		
	LEA	36(A0),A2
	ADD.L	D2,A2
	ADDQ.L	#4,A0
	MOVEQ	#0,D2
	SUBQ	#1,D1
.YLOOP	
	MOVE	D0,D3
	SUBQ	#1,D3
.XLOOP
	MOVE.B	(A2)+,D2
	BEQ.S	.TRANS
	ADD	D2,D2
	MOVE	(A0,D2.W),(A1)
.TRANS	ADDQ.L	#2,A1
	DBF	D3,.XLOOP
	TST.B	DOUBLE_F
	BNE.S	.ENDCDBLF
	LEA	(A2,D0.W),A2
.ENDCDBLF
	SUB.L	D0,A1
	SUB.L	D0,A1
	LEA	640(A1),A1
	DBF	D1,.YLOOP
	RTS

AFF_TRANS_ZOOM	*D7=FACTEUR DE ZOOM

		*AFFICHE TC4 A0 - LONX D0 LONY D1 A A1 - TRANSPARENT 		
	EXT.L	D7
	MOVE.L	D7,D6
	MULU	D0,D6
	TST.B	DOUBLE_F
	BNE.S	.DUWM
	ADD.L	D6,D6
.DUWM
	SUB	D0,D6
	
	LEA	36(A0),A2
	ADD.L	D2,A2
	ADDQ.L	#4,A0
	MOVEQ	#0,D2
	SUBQ	#1,D1
.YLOOP	
	MOVE	D0,D3
	SUBQ	#1,D3
	LEA	(A1),A3
.XLOOP
	MOVE.B	(A2),D2
	BEQ.S	.TRANS
	ADD	D2,D2
	MOVE	(A0,D2.W),(A1)
.TRANS	
	ADD.L	D7,A2
	ADDQ.L	#2,A1
	SUB	D7,D3
	BPL.S	.XLOOP
	ADD.L	D6,A2
	LEA	640(A3),A1
	SUB	D7,D1
	BPL.S	.YLOOP
	RTS
	
TIR	*S:D7=LONGUEUR DU TIR EN MOINS
	CLR	QUI_TOUC	*PERSONNE N'EST TOUCHE
	MOVE.L	BASE,A0

	TST.B	DOUBLE_F
	BEQ.S	.GHZE
	ADD.L	#(YMACLIP-20)*640+320,A0
	MOVEQ	#54-1,D0
	BRA.S	.EZHG
.GHZE
	ADD.L	#(YMACLIPD-10)*640+320,A0
	MOVEQ	#27-1,D0
.EZHG
	MOVE	D0,D6
	*A0=BASE DU TIR D0=LONGUEUR MAX
	LEA	BUFTIR,A1
	MOVEQ	#0,D2
	MOVEQ	#0,D3	*RIEN POUR L'INSTANT
	MOVEQ	#0,D4	*NOMBRE DE CHGTS
		
.LOOP	MOVE	(A0),D1
	MOVE	D1,D5
	AND	#%1,D1
	AND	#%100000,D5
	LSR	#4,D5
	OR	D5,D1
	CMP	#1,D1
	BEQ.S	.MUR
	CMP	#2,D1
	BEQ.S	.AMI
	CMP	#3,D1
	BEQ.S	.ENNEMI

	*RIEN
	TST	D3	*DEJA RIEN AVANT ?
	BNE.S	.CHGT1
	*OUI
	ADDQ	#1,D2	*COMPTEUR
	BRA.S	.NEXT
.CHGT1	
	ADDQ	#1,D4
	MOVE	D2,(A1)+	*STOCKE NOMBRE
	MOVE	D3,(A1)+	*STOCKE ANCIEN TYPE
	MOVEQ	#0,D3		*CHOIX DU NOUVEAU TYPE
	MOVEQ	#0,D2		*RAZ COMPTEUR
	BRA.S	.NEXT
.MUR
	CMP	#1,D3	*DEJA MUR AVANT ?
	BNE.S	.CHGT2
	*OUI
	ADDQ	#1,D2	*COMPTEUR
	BRA.S	.NEXT
.CHGT2	
	ADDQ	#1,D4
	MOVE	D2,(A1)+	*STOCKE NOMBRE
	MOVE	D3,(A1)+	*STOCKE ANCIEN TYPE
	MOVEQ	#1,D3		*CHOIX DU NOUVEAU TYPE
	MOVEQ	#0,D2		*RAZ COMPTEUR
	BRA.S	.NEXT

.AMI	CMP	#2,D3		*DEJA AMI AVANT ?
	BNE.S	.CHGT3
	*OUI
	ADDQ	#1,D2	*COMPTEUR
	BRA.S	.NEXT
.CHGT3	
	ADDQ	#1,D4
	MOVE	D2,(A1)+	*STOCKE NOMBRE
	MOVE	D3,(A1)+	*STOCKE ANCIEN TYPE
	MOVEQ	#2,D3		*CHOIX DU NOUVEAU TYPE
	MOVEQ	#0,D2		*RAZ COMPTEUR
	BRA.S	.NEXT

.ENNEMI	CMP	#3,D3		*DEJA ENNEMI AVANT ?
	BNE.S	.CHGT4
	*OUI
	ADDQ	#1,D2	*COMPTEUR
	BRA.S	.NEXT
.CHGT4	
	ADDQ	#1,D4
	MOVE	D2,(A1)+	*STOCKE NOMBRE
	MOVE	D3,(A1)+	*STOCKE ANCIEN TYPE
	MOVEQ	#3,D3		*CHOIX DU NOUVEAU TYPE
	MOVEQ	#0,D2		*RAZ COMPTEUR

.NEXT	LEA	-640(A0),A0
	DBF	D0,.LOOP
	MOVE	D2,(A1)+	*SAUVE LE RESTE
	MOVE	D3,(A1)+
	MOVE	#-1,(A1)	*INDIQUE LA FIN
	
	LEA	BUFTIR,A2
	*EXPLOITATION DES RESULTATS
	TST	D4		*PAS DE CHGT : TJRS RIEN
	BEQ.S	.FACILE	
	*Y A T-IL UN COUP DANS UN PERSO ?
	LEA	BUFTIR,A3
	MOVEQ	#0,D0
.SEARCH_P
	CMP	#2,2(A3)	*AMI
	BEQ.S	.TOUCHE
	CMP	#3,2(A3)	*ENNEMI
	BEQ.S	.TOUCHE
	ADD	(A3),D0
	ADDQ.L	#4,A3
	TST	(A3)
	BPL.S	.SEARCH_P
	
	*LE DERNIER EST-IL DANS LE VIDE ? (OBSTACLE TRAVERSES)
	TST	-2(A1)
	BEQ.S	.FACILE

	*SINON DERNIER OBJET TOUCHE
	
	SUB	-4(A1),D0
	BRA.S	.PAS_MORT
.TOUCHE
	MOVE	2(A3),QUI_TOUC
.PAS_MORT

	TST.B	DOUBLE_F
	BEQ.S	.MAGSE
	ADD	#10,D0
.MAGSE	ADD	#10,D0

	SUB	D0,D6
	BMI.S	.FACILE
	MOVE	D6,D7
	RTS
.FACILE	MOVEQ	#0,D7
	RTS

INIT_SONS
	PEA	$00000001.W
	PEA	$00080000
	PEA	$008B0000
	trap	#$0e
	LEA	$c(SP),SP
	clr.w	-(a7)
	move.w	#$0084,-(a7)
	trap	#$0e
	addq.l	#4,a7
	PEA	$00020040
	move.w	#$0082,-(a7)
	trap	#$0e
	move.w	#$0003,2(a7)
	trap	#$0e
	addq.l	#6,a7
	PEA	$00060003
	move.w	#$0082,-(a7)
	trap	#$0e
	move.w	#$0004,2(a7)
	trap	#$0e
	move.w	#$0005,2(a7)
	trap	#$0e
	addq.w	#6,a7

	RTS
	
SOV_SOUND	*SAUVE PARAMETRES SONS
	LEA	SOV_SND,A0
	*ADRESSES MODIFIEES PAR LA ROUTINE SON
	MOVE.B	$FFFF8935.W,(A0)+
	MOVE.B	$FFFF8936.W,(A0)+
	MOVE.B	$FFFF8937.W,(A0)+
	MOVE.B	$FFFF8938.W,(A0)+
	MOVE.B	$FFFF8903.W,(A0)+
	MOVE.B	$FFFF8905.W,(A0)+
	MOVE.B	$FFFF8907.W,(A0)+
	MOVE.B	$FFFF890F.W,(A0)+
	MOVE.B	$FFFF8911.W,(A0)+
	MOVE.B	$FFFF8913.W,(A0)+
	MOVE.B	$FFFF8921.W,(A0)+
	MOVE.B	$FFFF8920.W,(A0)+
	MOVE.B	$FFFF8939.W,(A0)+
	MOVE.B	$FFFF893A.W,(A0)+
	MOVE.B	$FFFF893B.W,(A0)+
	MOVE.B	$FFFF8901.W,(A0)+
	MOVE.B	$FFFF8900.W,(A0)+
	RTS
RESTORE_SOUND	*RESTORE LES PARAMETRES SONS
	LEA	SOV_SND,A0
	*ADRESSES MODIFIEES PAR LA ROUTINE SON
	MOVE.B	(A0)+,$FFFF8935.W	
	MOVE.B	(A0)+,$FFFF8936.W
	MOVE.B	(A0)+,$FFFF8937.W
	MOVE.B	(A0)+,$FFFF8938.W
	MOVE.B	(A0)+,$FFFF8903.W
	MOVE.B	(A0)+,$FFFF8905.W
	MOVE.B	(A0)+,$FFFF8907.W
	MOVE.B	(A0)+,$FFFF890F.W
	MOVE.B	(A0)+,$FFFF8911.W
	MOVE.B	(A0)+,$FFFF8913.W
	MOVE.B	(A0)+,$FFFF8921.W
	MOVE.B	(A0)+,$FFFF8920.W
	MOVE.B	(A0)+,$FFFF8939.W
	MOVE.B	(A0)+,$FFFF893A.W
	MOVE.B	(A0)+,$FFFF893B.W
	MOVE.B	(A0)+,$FFFF8901.W
	MOVE.B	(A0)+,$FFFF8900.W
	RTS

SOUND	*JOUE UN SON POINTE PAR A0
	*(A0).B = FREQUENCE
	*2(A0).L=FIN
	*A0+4 = DEBUT
	*D1.W=VOLUME LR

	CLR.B	$FFFF8901.W

	*DMA TRK CONTROL
	LSL	#6,D0
	CLR	$FFFF8920.W
	
	MOVE.B	#%11,$FFFF8937.W

	*FREQUENCY
	MOVE.B	(A0),$FFFF8935.W
	
	*SOUNDCHIP
	MOVE.B	#%11,$FFFF8938.W
	*AMPLIFICATION
	MOVE.B	#$FF,$FFFF8939.W
	*CHANNEL ATTENUATION
	MOVE.W	D1,$FFFF893A.W

	*START
	LEA	6(A0),A1
	MOVE.L	A1,D1
	LEA	$FFFF8905.W,A2
	MOVEP.W	D1,(A2)
	SWAP	D1
	MOVE.B	D1,-2(A2)
	*END
	MOVE.L	2(A0),D1
	LEA	$FFFF8911.W,A2
	MOVEP.W	D1,(A2)
	SWAP	D1
	MOVE.B	D1,-2(A2)
	*SND CONTROL
	MOVE.B	#%10000000,$FFFF8921.W
	*DMA CONTROL
	MOVE.B	#%00000001,$FFFF8901.W
	ST	SND_BUSY
	RTS
	
	
	*TABLE DES HISCORES
HI_SCORE
*MORE50_SC POINTS POUR UN % >50
*MORE75_SC "	"	    >75
*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS
	*ENTREE : A0=PERSO
	*D0 INTOUCH
	MOVEQ	#9,D1
	MOVE	26(A0),D2
	
	LEA	HI_SCORE_TBL,A1
.LOOP	
	CMP	2(A1),D2
	BLT.S	.PASINTER
	*INSERE LE PERSO
	*DECALE
	LEA	HI_SCORE_TBL+9*6,A2	*FIN DE TBLE
	MOVE	D1,D3
.SCROLL
	MOVE.L	-6(A2),(A2)
	MOVE	-2(A2),4(A2)
	SUBQ.L	#6,A2
	DBF	D3,.SCROLL
	MOVE	D2,2(A1)
	MOVE	34(A0),(A1)
	MOVE	30(A0),4(A1)
	RTS
.PASINTER
	ADDQ.L	#6,A1
	DBF	D1,.LOOP
	RTS

UNSQUEEZE	*DCOMPRESSION DE DONNES %%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Dcompacteur
* A0 zone  dcompacter
* A1 zone o dcompacter
* D0=0 si erreur
* D0=longueur dcompresse sinon

	MOVEM.L	A0-A6/D1-D7,-(SP)
	CMPI.L	#'Diwi',(A0)
	BEQ.s	.OK

	MOVEQ	#0,D0
	MOVEM.L	(SP)+,A0-A6/D1-D7
	RTS

.OK
	ADDQ	#4,A0
	LEA	8(A0),A6
	ADDA.L	(A0),A1
	ADDA.L	4(A0),A0
	
	TST	-(A0)
	BPL.S	.EVEN
	SUBQ	#1,A0
.EVEN
	MOVE.B	-(A0),D0
.NEXT_BIT
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE
	BCC.S	.NO_COPY
	MOVEQ	#0,D1
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_2
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_2
	BCC.S	.COPY_IT
	MOVEQ	#4,D3
.LOOP
	MOVE	D3,D5
	ADD	D5,D5
	MOVEQ	#0,D1
	MOVE	.TBL_COPY(PC,D5),D2
	MOVEQ	#-1,D4
	LSL	D2,D4
	NOT	D4
	SUBQ	#1,D2
.GET_BIT
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_3
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_3
	ADDX	D1,D1
	DBF	D2,.GET_BIT
	CMP	D1,D4
	DBNE	D3,.LOOP
	ADD	.TBL_COPY+10(PC,D5),D1
	BRA.S	.COPY_IT
.TBL_COPY
	DC	13,10,3,2,2
	DC	1037,14,7,4,1

.COPY_IT
	MOVE.B	-(A0),-(A1)
	DBF	D1,.COPY_IT
.NO_COPY
	CMPA.L	A0,A6
	BEQ	.FIN
	MOVEQ	#3,D2
.GET_LENGTH
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_4
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_4
	DBCC	D2,.GET_LENGTH
	MOVEQ	#0,D1
	MOVEQ	#0,D3
	MOVE.b	.TBL_LENGTH+1(PC,D2),D3
	BMI.S	.NO_GET
.GET_VALUE
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_5
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_5
	ADDX	D1,D1
	DBF	D3,.GET_VALUE
	MOVEQ	#0,D3
.NO_GET
	MOVE.B	.TBL_LENGTH+6(PC,D2),D3
	ADD	D3,D1
	CMPI	#2,D1
	BEQ.S	.DIST_2
	MOVEQ	#1,D3
	BRA.S	.GET_DIST
.TBL_LENGTH
	DC.B	9,1,0,-1,-1
	DC.B	10,6,4,3,2
.GET_DIST
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_6
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_6
	DBCC	D3,.GET_DIST
	MOVEQ	#0,D2
	MOVEQ	#0,D4
	MOVE.B	.TBL_DIST+1(PC,D3),D4
.GET_VALUE_2
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_7
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_7
	ADDX	D2,D2
	DBF	D4,.GET_VALUE_2
	ADD	D3,D3
	ADD	.TBL_DIST+6(PC,D3),D2
	BRA.S	.MOVE_IT
.TBL_DIST
	DC.B	11,4,7,0
	DC	$120,0,$20,0
.DIST_2
	MOVEQ	#0,D2
	MOVEQ	#5,D3
	MOVEQ	#0,D4
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_8
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_8
	BCC.S	.KEEP_CONFIG
	MOVEQ	#8,D3
	MOVEQ	#64,D4
.KEEP_CONFIG
	ADD.B	D0,D0
	BNE.S	.KEEP_BYTE_9
	MOVE.B	-(A0),D0
	ADDX.B	D0,D0
.KEEP_BYTE_9
	ADDX	D2,D2
	DBF	D3,.KEEP_CONFIG
	ADD	D4,D2
.MOVE_IT
	LEA	(A1,D2),A2
	EXT.L	D1
	ADDA.L	D1,A2
	SUBQ	#1,D1
.DO_IT
	MOVE.B	-(A2),-(A1)
	DBF	D1,.DO_IT
	BRA	.NEXT_BIT

.FIN
	MOVEM.L	(SP)+,A0-A6/D1-D7
	MOVE.L	4(A0),D0
	RTS

INIT_LEVEL	*INITIALISE LE PLAN

	LEA	PLAN,A0
	MOVE	NUM_LEVEL,D0
	MOVE.L	(PLANS,D0*8),A1
	LEA	PLAN2,A2
	MOVE	#16*32-1,D0
.SOVPLAN
	MOVE.L	(A1)+,(A0)+
	CLR.L	(A2)+
	DBF	D0,.SOVPLAN
	MOVE	#160+16*32-1,D0
.SOVPLAN2
	MOVE.L	(A1)+,(A0)+
	DBF	D0,.SOVPLAN2
	
	ST	PLAFOND

	*REND TRAVERSABLE CERTAINS OBJETS
	* + REPERE LES PORTES (MAX : 200 PORTES)
	* + REPERE LES MURS SURELEVES
	
	*3 (TABOURET) 6 (FINE COLONNE) 7 (BROUILLARD)

	LEA	PILE_PORTE,A1
	CLR	NB_PORTE
	
	LEA	PLAN,A0
	MOVEQ	#31,D0
.POUR2	MOVEQ	#31,D1
.POUR1	MOVE	D1,D2
	ASL	#6,D2
	MOVE	D0,D3
	ADD	D3,D3
	ADD	D3,D2
	TST.B	((641+32*64).W,A0,D2.W)
	BEQ.S	.NOELEV
	BTST	#4,((641+32*64).W,A0,D2.W)
	BEQ.S	.NOELEV		*NIVEAU INFRIEUR
	TST.B	(A0,D2)
	BEQ.S	.NOELEV
	SF	PLAFOND
.NOELEV
	CMP.B	#16,1(A0,D2)
	BEQ.S	.SUIV
	BTST	#4,1(A0,D2)
	BNE.S	.PORTE
	BTST	#5,1(A0,D2)
	BEQ.S	.SUIV
	CMP.B	#3,(A0,D2)
	BEQ.S	.VAZY
	CMP.B	#6,(A0,D2)
	BEQ.S	.VAZY
	CMP.B	#7,(A0,D2)
	BEQ.S	.VAZY
	BRA.S	.SUIV
.PORTE
	ADDQ	#1,NB_PORTE
	MOVE.L	A0,D3
	EXT.L	D2
	ADD.L	D2,D3
	
	MOVE.L	D3,(A1)+		*XY
	MOVE	#-1,(A1)+		*O_PORTE
	*X PORTE
	MOVE	D0,(A1)+
	*Y PORTE
	MOVE	D1,(A1)+
	BRA.S	.SUIV
.VAZY
	ORI.B	#64,1(A0,D2)
.SUIV
	DBF	D1,.POUR1
	DBF	D0,.POUR2	
	RTS
	
	*^^^^^^^^^^^^^^^^^^^^ DSP HANDLING ^^^^^^^^^^^^^^^^^^
DSP_EXEC	
	*EXECUTE MODULE DSP
	MOVE	#$68,-(SP)	*LOCK
	TRAP	#14
	
	MOVE	#$73,-(SP)	*FLUSH
	TRAP	#14
	ADDQ.L	#4,SP
	
	MOVE	#$71,-(SP)	*REQUEST UNIQ ABIL
	TRAP	#14
	ADDQ.L	#2,SP
	
	MOVE	D0,-(SP)
	PEA	(FIN_DSP-PROG_DSP)/3
	PEA	PROG_DSP
	MOVE	#$6D,-(SP)	*DSP_EXEC_PROG
	TRAP	#14
	LEA	12(SP),SP
	RTS

DSP_WRITE	*ENVOI DES 24 BITS DE POIDS FAIBLE DE D0
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D0,$FFFFA204.W
	RTS
DSP_WRITE_D1
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D1,$FFFFA204.W
	RTS
DSP_WRITE_D2
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D2,$FFFFA204.W
	RTS
DSP_WRITE_D3
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D3,$FFFFA204.W
	RTS
DSP_WRITE_D4
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D4,$FFFFA204.W
	RTS
DSP_WRITE_D5
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D5,$FFFFA204.W
	RTS
DSP_WRITE_D6
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D6,$FFFFA204.W
	RTS
DSP_WRITE_D7
.WAIT
	BTST	#1,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	D7,$FFFFA204.W
	RTS

DSP_READ_L	*RECEPTION DANS A2.L (SIGNE ETENDU)
	*REOIT DU DSP D0
.WAIT
*	NOT.B	$FFFF8209.W	*SIGNALER L'ERREUR D'ALGO.
	BTST	#0,$FFFFA202.W
	BEQ.S	.WAIT 
	MOVE.L	$FFFFA204.W,D0
	MOVE.L	D0,-(SP)
	BTST	#23,D0
	SNE	(SP)
	MOVE.L	(SP)+,A2
	RTS	

DSP_READ_W	*RECEPTION DANS D0
	*REOIT DU DSP D0
.WAIT
*	NOT.B	$FFFF8209.W	*SIGNALER L'ERREUR D'ALGO.
	BTST	#0,$FFFFA202.W
	BEQ.S	.WAIT
	MOVE.L	$FFFFA204.W,D0
	RTS	
		*********************************************************
		*               50KHz    REPLAY   ROUT		        *
		*********************************************************

; Ninja III ProReplayer v2.2/v3.42
* - RAPIDE QUE MUDU, MAIS - BUGG...

; NB: This routine uses Timer D, so therefore:
; Always ensure that Timer D is NOT turned off otherwise you get bugger
; all !!

; Values for registers:
; ---------------------
;
; D0 = 
;
; $1388 = 5.0Khz			5000
; $2134 = 8.5 khz			8500
; $2ee0 = 12 khz			12000
; $36b0 = 15.0 khz			15000
; $5208 = 21 khz 			21000
;	non limit (max 50Khz)
;
; D1 = 
;
; 0 = takes a bit of processor time (all volume changes)
; 2 = takes a little bit less (no volume changes ?)
; 3 = Shit !! Write an intro with this value !!
;
; D2 = 
;
; 0 = takes a bit of processor time (all pitch changes ?)
; 2 = takes a little bit less (no pitch changes ?)

INSTALL_MUSIC
	move.w	#FREQU,d0
	moveq.l	#2,d1			; volume variation ?
	moveq.l	#2,d2			; 
	lea	music,a0
	jsr	replay
RESTART_MUSIC
	ST	LETS_ROCK
	jMP	replay+4


STOP_MUSIC	
	SF	LETS_ROCK
	CLR.B	$FFFF8901.W		*STOPPE DMA
	RTS
	
END_MUSIC
	SF	LETS_ROCK
	move.w	#3,replay+28
	bsr.s	replay+8
	rts

; NINJA342.BIN = v3.2

replay	incbin	'C:\680X0\SOURCES\ninja342.bin'
	even


	
	******************
	** DATA SECTION **
	****************************************************
	SECTION	DATA
 
music	incbin	"C:\680X0\SOURCES\DLDH.MOD"
	ds.b	6300
	
TXT_KASS
	DC.B	"GET LOST !",0
TXT_INJ
	DC.B	"THAMAL !",0
TXT_SOL	
	DC.B	"GONNA GRILL'EM",0

TXT_TITRE1
	DC.B	"   CHOOSE",0
TXT_TITRE2
	DC.B	"    YOUR",0
TXT_TITRE3
	DC.B	"    LEVEL",0
TXT_PLAN0
	DC.B	"DEMO LEVEL",0
TXT_PLAN1
	DC.B	"LEVEL ONE",0
TXT_PLAN2
	DC.B	"LEVEL TWO",0
TXT_PLAN3
	DC.B	"LEVEL THREE",0
TXT_PLAN4
	DC.B	"LEVEL FOUR",0
TXT_PLAN5
	DC.B	"LEVEL FIVE",0
TXT_PLAN6
	DC.B	"LEVEL SIX",0
TXT_PLAN7
	DC.B	"LEVEL SEVEN",0
TXT_PLAN8
	DC.B	"LEVEL EIGHT",0
TXT_PLAN9
	DC.B	"LEVEL NINE",0
TXT_PLAN10
	DC.B	"LEVEL TEN",0
TXT_PLAN11
	DC.B	"LEVEL ELEVEN",0
TXT_PLAN12
	DC.B	"LEVEL TWELVE",0
TXT_PLAN13
	DC.B	"LEVEL THIRTEEN",0
TXT_PLAN14
	DC.B	"LEVEL FOURTEEN",0

TXT_CONG1
	DC.B	"WELL DONE,",0
TXT_CONG2
	DC.B	"COMMANDER",0
TXT_TBL1
	DC.B	"  NAME       SCORE %",0
TXT_TBL2
	DC.B	"    <PRESS SPACE>   ",0
TXT_BON1
	DC.B	">75% BONUS",0
TXT_BON2
	DC.B	">50% BONUS",0
TXT_BON3
	DC.B	"SURVIVAL BONUS",0	
TXT_BON4
	DC.B	"NO BONUS",0
TXT_RESULT
	DC.B	"RESULT OF THIS LEVEL",0
TXT_SEL_RES	
	DC.B	"CHOOSE YOUR RES.",0
TXT_RESN	
	DC.B	"320 X 200",0
TXT_RESD
	DC.B	"320 X 100",0
TXT_PARANO
	DC.B	"PARANOIA (Y/N) :",0
TXT_YES	DC.B	"YES",0
TXT_NO	DC.B	"NO ",0

TXT_RGB
	DC.B	"  YOU'D BETTER USE  ",0
	DC.B	"    A RGB MONITOR   ",0
TXT_HISC1
	DC.B	"ENTER YOUR NAME",0
TXT_HISC2
	DC.B	"..............",0

AVERTISSEMENT
	DC.B	" OF LASERS AND MEN  ",0
	DC.B	"               V1.0 ",0
	DC.B	"                    ",0
T_REG1	DC.B	"     UNREGISTERED   ",0
T_REG2	DC.B	"       VERSION      ",0
	DC.B	"                    ",0
	DC.B	"THIS IS A SHAREWARE ",0
	DC.B	"                    ",0
	DC.B	"I AM SORRY ABOUT THE",0
	DC.B	"   VERY UNCOMPLETE  ",0
	DC.B	"      GRAPHISMS     ",0
	DC.B	"                    ",0
TXT_REG1
	DC.B	"   REGISTERED TO :  ",0	
TXT_REG2
	DC.B	"                    ",0
	
ENRG_TXT1
	DC.B	" REGISTERING SCREEN",0
ENRG_TXT2
	DC.B	"ENTER THE NAME AND",0
ENRG_TXT3
	DC.B	"THE CODE ALLOCATED :",0
ENRG_TXT4
	DC.B	"NAME :",0
ENRG_TXT5
	DC.B	"................",0
ENRG_TXT6
	DC.B	"CODE :",0
ENRG_TXT7
	DC.B	"....................",0
ENRG_TXT8
	DC.B	"INVALID! PRESS SPACE",0

TXT_NOFALCON
	DC.B	13,10,"This game will only run on "
	DC.B	13,10,"atari-compatible computer with"
	DC.B	13,10,"a MC68030@16MHz, a DSP56001@32Mhz,"
	DC.B	13,10,"a True Color mode and 4Mb..."
	DC.B	13,10,"press a key and buy a Falcon...",0
	
TXT_NOFILE
	DC.B	13,10,"I cannot find the right files."
	DC.B	13,10,"Please take your responsabilities"
	DC.B	13,10,"and press a key.",0
TXT_WRITE_ERR
	DC.B	13,10,"Error while writing LASEDZOM.INF."
	DC.B	13,10,"No change saved. Notice it and press"
	DC.B	13,10,"a key. Any key.",0
MESSAGE
	DC.B	13,10,"I NEED",13,10,"     M E M O R Y !!!"
	DC.B	13,10,10,10,"Press a key when resurected.",0
	EVEN
TABLEDIR	
	DC.L	AFF_DIR0,AFF_DIR0,AFF_DIR2,AFF_DIR2,AFF_DIR4,AFF_DIR4,AFF_DIR6,AFF_DIR6


	DS.W	32*10
PLAN
	INCBIN	"C:\BASICS\GFA_3.0\LEVEL1.DAT"		*JUSTE POUR AVOIR LA TAILLE

PLAN2	DS.W	32*32	*PLAN DES ENNEMIS/AMIS
	DS.W	32*10
	EVEN
PLANS_TXT
	DC.L	TXT_PLAN0,TXT_PLAN1,TXT_PLAN2,TXT_PLAN3
	DC.L	TXT_PLAN4,TXT_PLAN5,TXT_PLAN6,TXT_PLAN7
	DC.L	TXT_PLAN8,TXT_PLAN9,TXT_PLAN10,TXT_PLAN11
	DC.L	TXT_PLAN12,TXT_PLAN13,TXT_PLAN14

PLANS	DC.L	LEVELD,PERSOD,LEVEL1,PERSO1,LEVEL2,PERSO2,LEVEL3,PERSO3
	DC.L	LEVEL4,PERSO4,LEVEL5,PERSO5,LEVEL6,PERSO6,LEVEL7,PERSO7
	DC.L	LEVEL8,PERSO8,LEVEL9,PERSO9,LEVEL10,PERSO10,LEVEL11,PERSO11
	DC.L	LEVEL12,PERSO12,LEVEL13,PERSO13,LEVEL14,PERSO14

LEVELD	INCBIN	"C:\BASICS\GFA_3.0\MAP.DAT"
	EVEN
PERSOD	INCBIN	"C:\BASICS\GFA_3.0\MAP.DAP"
	EVEN
LEVEL1	INCBIN	"C:\BASICS\GFA_3.0\LEVEL1.DAT"
	EVEN
PERSO1	INCBIN	"C:\BASICS\GFA_3.0\LEVEL1.DAP"
	EVEN
LEVEL2	INCBIN	"C:\BASICS\GFA_3.0\LEVEL2.DAT"
	EVEN
PERSO2	INCBIN	"C:\BASICS\GFA_3.0\LEVEL2.DAP"
	EVEN
LEVEL3	INCBIN	"C:\BASICS\GFA_3.0\LEVEL3.DAT"
	EVEN
PERSO3	INCBIN	"C:\BASICS\GFA_3.0\LEVEL3.DAP"
	EVEN
LEVEL4	INCBIN	"C:\BASICS\GFA_3.0\LEVEL4.DAT"
	EVEN
PERSO4	INCBIN	"C:\BASICS\GFA_3.0\LEVEL4.DAP"
	EVEN
LEVEL5	INCBIN	"C:\BASICS\GFA_3.0\LEVEL5.DAT"
	EVEN
PERSO5	INCBIN	"C:\BASICS\GFA_3.0\LEVEL5.DAP"
	EVEN
LEVEL6	INCBIN	"C:\BASICS\GFA_3.0\LEVEL6.DAT"
	EVEN
PERSO6	INCBIN	"C:\BASICS\GFA_3.0\LEVEL6.DAP"
	EVEN
LEVEL7	INCBIN	"C:\BASICS\GFA_3.0\LEVEL7.DAT"
	EVEN
PERSO7	INCBIN	"C:\BASICS\GFA_3.0\LEVEL7.DAP"
	EVEN
LEVEL8	INCBIN	"C:\BASICS\GFA_3.0\LEVEL8.DAT"
	EVEN
PERSO8	INCBIN	"C:\BASICS\GFA_3.0\LEVEL8.DAP"
	EVEN
LEVEL9	INCBIN	"C:\BASICS\GFA_3.0\LEVEL9.DAT"
	EVEN
PERSO9	INCBIN	"C:\BASICS\GFA_3.0\LEVEL9.DAP"
	EVEN
LEVEL10	INCBIN	"C:\BASICS\GFA_3.0\LEVEL10.DAT"
	EVEN
PERSO10	INCBIN	"C:\BASICS\GFA_3.0\LEVEL10.DAP"
	EVEN
LEVEL11	INCBIN	"C:\BASICS\GFA_3.0\LEVEL11.DAT"
	EVEN
PERSO11	INCBIN	"C:\BASICS\GFA_3.0\LEVEL11.DAP"
	EVEN
LEVEL12	INCBIN	"C:\BASICS\GFA_3.0\LEVEL12.DAT"
	EVEN
PERSO12	INCBIN	"C:\BASICS\GFA_3.0\LEVEL12.DAP"
	EVEN
LEVEL13	INCBIN	"C:\BASICS\GFA_3.0\LEVEL13.DAT"
	EVEN
PERSO13	INCBIN	"C:\BASICS\GFA_3.0\LEVEL13.DAP"
	EVEN
LEVEL14	INCBIN	"C:\BASICS\GFA_3.0\LEVEL14.DAT"
	EVEN
PERSO14	INCBIN	"C:\BASICS\GFA_3.0\LEVEL14.DAP"
	EVEN

	*TABLE DE SENSIBILITE SOURIS
	* VAL MAX,M_SENSX
M_S_TBL
	DC.W	2,0,5,1,10,2,40,3,128,4,$7FFF,5
	
SCRUT_TBL
	DC.L	SCRUT_0,SCRUT_1,SCRUT_2,SCRUT_3,SCRUT_4,SCRUT_5,SCRUT_6,SCRUT_7
ACESS_TBL
	DC.L	ACESS_0,ACESS_1,ACESS_2,ACESS_3,ACESS_4,ACESS_5,ACESS_6,ACESS_7
CHEM_TBL
	DC.L	CBASE,DBS,CHEM_2,CHEM_3,CHEM_4,CHEM_5,CHEM_6,CHEM_7
PRISE_DE_VUE
	DC.L	PDV_0,PDV_1,PDV_2,PDV_3,PDV_4,PDV_5,PDV_6,PDV_7
	
	*FORMAT : 1ER OCTET=NOMBRE DE PRISES, PUIS PAR COUPLE (DX,DY)
PDV_0
	DC.B	42
	DC.B	-4,-5, 04,-5, -3,-5, 03,-5, -2,-5, 02,-5, -1,-5, 01,-5, 00,-5	*9
	DC.B	-4,-4, 04,-4, -3,-4, 03,-4, -2,-4, 02,-4, -1,-4, 01,-4, 00,-4	*18
	DC.B	-4,-3, 04,-3, -3,-3, 03,-3, -2,-3, 02,-3, -1,-3, 01,-3, 00,-3	*27
	DC.B		      -3,-2, 03,-2, -2,-2, 02,-2, -1,-2, 01,-2, 00,-2	*34
	DC.B		      		    -2,-1, 02,-1, -1,-1, 01,-1, 00,-1	*39
	DC.B						  -1,00, 01,00, 00,00	*42
PDV_1
	DC.B	47
	DC.B	01,-7, 07,-1, 02,-6, 06,-2, 03,-5, 05,-3, 04,-4
	DC.B	01,-6, 06,-1, 02,-5, 05,-2, 03,-4, 04,-3
	DC.B	00,-5, 05,00, 01,-5, 05,-1, 02,-4, 04,-2, 03,-3
	DC.B	01,-4, 04,-1, 02,-3, 03,-2
	DC.B	00,-4, 04,00, 01,-3, 03,-1, 02,-2
	DC.B	00,-3, 03,00, 01,-2, 02,-1
	DC.B	-1,-3, 03,01, 00,-2, 02,00, 01,-1
	DC.B	-1,-2, 02,01, 00,-1, 01,00
	DC.B	-2,-2, 02,02, -1,-1, 01,01, 00,00

SCRUT_0	*ORDRE DE SCRUTATION POSTION NORD : NOMBRE, DX,DY
	DC.B	24
	DC.B	00,-1, -1,-1, 01,-1, -1,00, 01,00, 00,-2, -1,-2, 01,-2, -2,-1, 02,-1
	DC.B	-2,00, 02,00, 00,-3, -1,-3, 01,-3, -2,-2, 02,-2, 00,-4, -1,-4, 01,-4
	DC.B	-2,-3, 02,-3, -2,-4, 02,-4
SCRUT_1	*ORDRE DE SCRUT POSITION NE : NB, DX DY
	DC.B	29
	DC.B	01,-1, 00,-1, 01,00, -1,-1, 01,01, 00,-2, 02,00, 02,-2, 01,-2, 02,-1, -1,-2
	DC.B	02,01, 00,-2, 03,00, -2,-2, 02,02, 02,-3, 03,-2, 01,-3, 03,-1, -1,-3, 03,01
	DC.B	03,-3, 04,-2, 02,-4, 04,-1, 01,-4, 04,00, 00,-4
	EVEN
ACESS_0
	*TABLEAU D'ACCESSIBILITE NORD - A1 A E5 - DEPART C5
	DC.W	2*(2+4*5)	*OFFSET DE DEPART
	DC.W	2*5		*LARGEUR D'UNE LIGNE
	DC.W	CA1-CBASE,CB1-CBASE,CC1-CBASE,CD1-CBASE,CE1-CBASE
	DC.W	CA2-CBASE,CB2-CBASE,CC2-CBASE,CD2-CBASE,CE2-CBASE
	DC.W	CA3-CBASE,CB3-CBASE,CC3-CBASE,CD3-CBASE,CE3-CBASE
	DC.W	CA4-CBASE,CB4-CBASE,CC4-CBASE,CD4-CBASE,CE4-CBASE
	DC.W	CA5-CBASE,CB5-CBASE,NIL-CBASE,CD5-CBASE,CE5-CBASE
	
	*CHEMINS : NOMBRE, DX&DY - SI NB=0 OK SI NB=-1 ERROR
CBASE	*BASE POUR ADR RELATIVES
NIL	DC.B	-1	
			* A  B  C  D  E  /  1  2  3  4  5
			*-2 -1  0  1  2  / -4 -3 -2 -1  0
CA5	DC.B	1, -1,00
CB5	DC.B	0
CD5	DC.B	0
CE5	DC.B	1, 01,00
CA4	DC.B	3, -1,00, -1,-1, -2,00
CB4	DC.B	2, -1,00, 00,-1
CC4	DC.B	0
CD4	DC.B	2, 01,00, 00,-1
CE4	DC.B	3, 01,00, 01,-1, 02,00
CA3	DC.B	5, -1,00, 00,-1, -1,-1, -2,-1, -1,-2
CB3	DC.B	4, -1,00, 00,-1, -1,-1, 00,-2
CC3	DC.B	1, 00,-1
CD3	DC.B	4, 01,00, 00,-1, 01,-1, 00,-2
CE3	DC.B	5, 01,00, 00,-1, 01,-1, 02,-1,01,-2
CA2	DC.B	6, -1,00, 00,-1, -1,-1, -1,-2, -2,-2, -1,-3
CB2	DC.B	6, -1,00, 00,-1, -1,-1, 00,-2, -1,-2, 00,-3
CC2	DC.B	2, 00,-1, 00,-2
CD2	DC.B	6, 01,00, 00,-1, 01,-1, 00,-2, 01,-2, 00,-3
CE2	DC.B	6, 01,00, 00,-1, 01,-1, 01,-2, 02,-2, 01,-3
CA1	DC.B	5, 00,-1, -1,-1, -1,-2, -1,-3, -2,-3
CB1	DC.B	8, -1,00, 00,-1, -1,-1, 00,-2, -1,-2, 00,-3, -1,-3, 00,-4
CC1	DC.B	3, 00,-1, 00,-2, 00,-3
CD1	DC.B	8, 01,00, 00,-1, 01,-1, 00,-2, 01,-2, 00,-3, 01,-3, 00,-4
CE1	DC.B	5, 00,-1, 01,-1, 01,-2, 01,-3, 02,-3
CEND
	EVEN
ACESS_1
	*TABLEAU D'ACCESSIBILITE NE - A3 A G9 - DEPART C7
	DC.W	2*(2+4*7)	*OFFSET DE DEPART
	DC.W	2*7		*LARGEUR D'UNE LIGNE
	DC.W	NUL-DBS,NUL-DBS,DC3-DBS,DD3-DBS,DE3-DBS,NUL-DBS,NUL-DBS
	DC.W	NUL-DBS,DB4-DBS,DC4-DBS,DD4-DBS,DE4-DBS,DF4-DBS,NUL-DBS
	DC.W	DA5-DBS,DB5-DBS,DC5-DBS,DD5-DBS,DE5-DBS,DF5-DBS,DG5-DBS
	DC.W	NUL-DBS,DB6-DBS,DC6-DBS,DD6-DBS,DE6-DBS,DF6-DBS,DG6-DBS
	DC.W	NUL-DBS,NUL-DBS,NUL-DBS,DD7-DBS,DE7-DBS,DF7-DBS,DG7-DBS
	DC.W	NUL-DBS,NUL-DBS,NUL-DBS,DD8-DBS,DE8-DBS,DF8-DBS,NUL-DBS
	DC.W	NUL-DBS,NUL-DBS,NUL-DBS,NUL-DBS,DE9-DBS,NUL-DBS,NUL-DBS

		*A=-2 B=-1 C=00 D=01 E=02 F=03 G=04	
		*3=-4 4=-3 5=-2 6=-1 7=00 8=01 9=02
DBS
NUL	DC.B	-1
DE9	DC.B	5, 00,01, 01,00, 01,01, 01,02, 02,01
DD8	DC.B	2, 00,01, 01,00
DE8	DC.B	4, 00,01, 01,00, 01,01, 02,00
DF8	DC.B	6, 00,01, 01,00, 01,01, 02,00, 02,01, 03,00
DD7	DC.B	0
DE7	DC.B	1, 01,00
DF7	DC.B	2, 01,00, 02,00
DG7	DC.B	3, 01,00, 02,00, 03,00
DB6	DC.B	2, -1,00, 00,-1
DC6	DC.B	0
DD6	DC.B	2, 01,00, 00,-1
DE6	DC.B	4, 00,-1, 01,-1, 01,00, 02,00
DF6	DC.B	6, 00,-1, 01,-1, 01,00, 02,-1, 02,00, 03,00
DG6	DC.B	8, 00,-1, 01,-1, 01,00, 02,-1, 02,00, 03,-1, 03,00, 04,00
DA5	DC.B	5, -1,00, 00,-1, -1,-1, -2,-1, -1,-2
DB5	DC.B	4, -1,00, 00,-1, -1,-1, 00,-2
DC5	DC.B	1, 00,-1
DD5	DC.B	4, 01,00, 00,-1, 01,-1, 00,-2
DE5	DC.B	5, 00,-1, 01,00, 01,-1, 01,-2, 02,-1
DF5	DC.B	6, 00,-1, 01,00, 01,-1, 02,-1, 02,-2, 03,-1
DG5	DC.B	9, 00,-1, 01,-1, 01,00, 02,-2, 02,-1, 02,00, 03,-2, 03,-1, 04,-1
DB4	DC.B	6, -1,00, 00,-1, -1,-1, 00,-2, -1,-2, 00,-3
DC4	DC.B	2, 00,-1, 00,-2
DD4	DC.B	6, 01,00, 00,-1, 01,-1, 00,-2, 01,-2, 00,-3
DE4	DC.B	6, 01,00, 00,-1, 01,-1, 02,-2, 01,-2, 01,-3
DF4	DC.B	8, 00,-1, 01,00, 01,-1, 01,-2, 02,-1, 02,-2, 02,-3, 03,-2
DC3	DC.B	3, 00,-1, 00,-2, 00,-3
DD3	DC.B	8, 01,00, 00,-1, 01,-1, 00,-2, 01,-2, 00,-3, 01,-3, 00,-4
DE3	DC.B	9, 00,-1, 01,00, 01,-1, 00,-2, 01,-2, 02,-2, 01,-3, 02,-3, 01,-4
DEND
	EVEN

ELEV_TBL	*TABLE D'ELEVATION DES SOLS (16 ENTREES .W)
	DC.W	0,YIMG_D/16,-YIMG_D/8,YIMG_D*3/16,-YIMG_D*4/16,YIMG_D*5/16,-YIMG_D*6/16,YIMG_D*7/16
	DC.W	-YIMG_D*8/16,YIMG_D*9/16,-YIMG_D*10/16,YIMG_D*11/16,-YIMG_D*12/16,YIMG_D*13/16,-YIMG_D*14/16,YIMG_D


ELEV_TBL_D
	DC.W	0,YIMG_DD/16,-YIMG_DD*2/16,YIMG_DD*3/16,-YIMG_DD*4/16,YIMG_DD*5/16,-YIMG_DD*6/16,YIMG_DD*7/16
	DC.W	-YIMG_DD*8/16,YIMG_DD*9/16,-YIMG_DD*10/16,YIMG_DD*11/16,-YIMG_DD*12/16,YIMG_DD*13/16,-YIMG_DD*14/16,YIMG_DD



		* PERSOS PREDEFINIS
	*ORDRE : NOM,NO,TEMPS DE REFLEXE, PRECISION, PARANO, SHIELD 
	*NE PAS SEPARER (N=POINTEUR)


	DC.L	HEROS
PF_TBLE	DC.L	PF0,PF1,PF2,PF4,PF5,PF6,PF7,PF10,PF8,-1
PF_TBLA	DC.L	PF3,PF9,-1	
	*20 CARACTERES POUR LE NOM MAXI

HEROS_S	DC.B	"> PLAYER      ",0
HEROS	DC.B	"> PLAYER      ",0
	EVEN
PF0	DC.B	"K. S.         ",0,"     "
	DC.W	0,4,65*328,5*32,2500
PF1	DC.B	"NEPHISTOPHELES",0,"     "
	DC.W	1,1,32000,0,4000
PF2	DC.B	"FER           ",0,"     "
	DC.W	2,1,90*328,0,3000
PF4	DC.B	"JU-JU         ",0,"     "
	DC.W	3,2,80*328,32,3000
PF5	DC.B	"K-RHO         ",0,"     "
	DC.W	4,3,70*328,32,2500
PF6	DC.B	"DUPDOB        ",0,"     "
	DC.W	5,4,60*328,2*32,2000
PF7	DC.B	"THE HACKER    ",0,"     "
	DC.W	6,1,75*328,16000,2000
PF10	DC.B	"DIDBO         ",0,"     "
	DC.W	7,3,68*328,32,2750
PF8	DC.B	"1ST CL.SOLDIER",0,"     "
	DC.W	8,4,60*328,32*5,1200

PF3	DC.B	"BILL          ",0,"     "
	DC.W	10,4,70*328,32000,2500
PF9	DC.B	"2ND CL.SOLDIER",0,"     "
	DC.W	11,4,50*328,32*5,1000

ELEIT	DC.W	10*R+20*G+15,15*R+20*G+10,10*R+20*G+15,15*R+20*G+10,10*R+20*G+15
	DC.W	15*R+20*G+10,10*R+20*G+15,15*R+20*G+10,10*R+20*G+15,15*R+20*G+10
	DC.W	10*R+20*G+15,15*R+20*G+10,10*R+20*G+15,15*R+20*G+10,10*R+20*G+15
	DC.W	15*R+20*G+10,10*R+20*G+15,15*R+20*G+10,10*R+20*G+15,15*R+20*G+10	
	DC.W	10*R+20*G+15,15*R+20*G+10,10*R+20*G+15,15*R+20*G+10,10*R+20*G+15

NOIR	DS.W	25

GRIS	

	DC.W	12*R+24*G+12,18*R+36*G+18,18*R+36*G+18,18*R+36*G+18,20*R+40*G+20
	DC.W	10*R+20*G+10,15*R+30*G+15,15*R+30*G+15,15*R+30*G+15,18*R+36*G+18
	DC.W	10*R+20*G+10,15*R+30*G+15,15*R+30*G+15,15*R+30*G+15,18*R+36*G+18
	DC.W	10*R+20*G+10,15*R+30*G+15,15*R+30*G+15,15*R+30*G+15,18*R+36*G+18
	DC.W	08*R+16*G+08,10*R+20*G+10,10*R+20*G+10,10*R+20*G+10,15*R+30*G+15
	
MARRON	
	DC.W	10*R+4*G+2,12*R+5*G+4,12*R+5*G+4,12*R+5*G+4,10*R+4*G+2
	DC.W	12*R+5*G+4,15*R+7*G+5,15*R+7*G+5,15*R+7*G+5,12*R+5*G+4
	DC.W	12*R+5*G+4,15*R+7*G+5,18*R+8*G+6,15*R+7*G+5,12*R+5*G+4
	DC.W	12*R+5*G+4,15*R+7*G+5,15*R+7*G+5,15*R+7*G+5,12*R+5*G+4
	DC.W	10*R+4*G+2,12*R+5*G+4,12*R+5*G+4,12*R+5*G+4,10*R+4*G+2
	
ROSE	
	DC.W	15*R+15,17*R+17,17*R+17,17*R+17,15*R+15
	DC.W	17*R+17,20*R+20,20*R+20,20*R+20,17*R+17
	DC.W	17*R+17,20*R+20,23*R+23,20*R+20,17*R+17
	DC.W	17*R+17,20*R+20,20*R+20,20*R+20,17*R+17
	DC.W	15*R+15,17*R+17,17*R+17,17*R+17,15*R+15

PORTEV	
	DC.W	0,0,10*R+10*G+2,0,0
	DC.W	0,0,12*R+12*G+3,0,0
	DC.W	0,0,15*R+15*G+5,0,0
	DC.W	0,0,12*R+12*G+3,0,0
	DC.W	0,0,10*R+10*G+2,0,0

PORTEH	DS.W	2*5
	DC.W	10*R+10*G+2,12*R+12*G+3,15*R+15*G+5,12*R+12*G+3,10*R+10*G+2
	DS.W	2*5
	
INTRAV	DC.W	00*R,00*R,10*R,00*R,00*R
	DC.W	00*R,10*R,20*R,10*R,00*R
	DC.W	10*R,20*R,30*R,20*R,10*R
	DC.W	00*R,10*R,20*R,10*R,00*R
	DC.W	00*R,00*R,10*R,00*R,00*R

TRAV	DC.W	00*R,00*R,00*R,00*R,00*R
	DC.W	00*R,00*R,10*R,00*R,00*R
	DC.W	00*R,10*R,20*R,10*R,00*R
	DC.W	00*R,00*R,10*R,00*R,00*R
	DC.W	00*R,00*R,00*R,00*R,00*R
BROUIL
	DC.W	320,640,320,640,320
	DC.W	640,320,640,320,640
	DC.W	320,640,320,640,320
	DC.W	640,320,640,320,640
	DC.W	320,640,320,640,320
AMITEM	
	DC.W	0,25*R+25*G,31*R+35*G,25*R+25*G,0
	DC.W	25*R+25*G,10*R+10*G,31*R+35*G,10*R+10*G,25*R+25*G
	DC.W	25*R+25*G,10*R+10*G,31*R+35*G,10*R+10*G,25*R+25*G
	DC.W	25*R+35*G,31*R+35*G,31*R+35*G,25*R+35*G,31*R+25*G
	DC.W	0,25*R+25*G,20*R+20*G,25*R+25*G,0

EMITEM

*	DC.W	"  XXXXXX  "
*	DC.W	"XXOOXXOOXX"
*	DC.W	"XXOOXXOOXX"
*	DC.W	"XXXXXXXXXX"
*	DC.W	"  XXIIXX  "
	
	DC.W	0,25,31,25,0
	DC.W	25,10,31,10,25
	DC.W	25,10,31,10,25
	DC.W	25,31,31,31,25
	DC.W	0,25,20,25,0
	
HEROS_IT
	
	DC.W	0,0,15*G+15,0,0
	DC.W	0,15*G+15,21*G+21,15*G+15,0
	DC.W	15*G+15,21*G+21,30*G+30,21*G+21,15*G+15
	DC.W	21*G+21,30*G+30,30*G+30,30*G+30,21*G+21
	DC.W	15*G+15,21*G+21,30*G+30,21*G+21,15*G+15
	DC.W	0,15*G+15,21*G+21,15*G+15,0
	
ITEMS_M	DC.L	NOIR,GRIS,GRIS,GRIS,MARRON,ROSE,MARRON,MARRON,MARRON,GRIS,MARRON,GRIS,ROSE,NOIR,NOIR,NOIR
ITEMS_O	DC.L	NOIR,INTRAV,INTRAV,TRAV,INTRAV,INTRAV,TRAV,BROUIL,NOIR,NOIR,NOIR,NOIR,NOIR,NOIR,NOIR,NOIR
ITEMS_P	DC.L	PORTEH,PORTEV
ITEMS_J	DC.L	AMITEM,EMITEM

	*SOUND FX : FREQUENCE,FIN,SON
SND_CHARGE
	DC.B	%0100,0
	DC.L	SND_CHARGE+54098
	INCBIN	"C:\680X0\SOURCES\FX\CHARGE.RAW"
	EVEN
SND_LASER	
	DC.B	%1011,0
	DC.L	SND_LASER+1704
	INCBIN	"C:\680X0\SOURCES\FX\LASER.RAW"
	EVEN
SND_DOOR
	DC.B	%1001,0
	DC.L	SND_DOOR+10798
	INCBIN	"C:\680X0\SOURCES\FX\STARDOOR.RAW"
	EVEN
SND_COUP
	DC.B	%0111,0
	DC.L	SND_COUP+6802
	INCBIN	"C:\680X0\SOURCES\FX\COUP.RAW"
	EVEN

SND_FIN
	DC.B	%0101,0
	DC.L	SND_FIN+159528
	INCBIN	"C:\680X0\SOURCES\FX\FIN.RAW"
	EVEN
	
GARDE	INCBIN	"C:\680X0\SOURCES\TC4\DLDH.CCR"
CADREI	INCBIN	"C:\680X0\SOURCES\TC4\CADRE.CCR"
FONT	INCBIN	"C:\680X0\SOURCES\TC4\FON16X16.TC5"
CHIFFRES
	INCBIN	"C:\680X0\SOURCES\TC4\CHIFFRES.TC5"
	DS.B	16*4		*BLANC
IMAGE	DC.L	IMAGE1,IMAGE2,IMAGE3,IMAGE4,IMAGE5,IMAGE6,IMAGE7,IMAGE8,IMAGE9,IMAGE10
	DC.L	IMAGE11,IMAGE12
OBJET	DC.L	OBJET1,OBJET2,OBJET3,OBJET4,OBJET5,OBJET6,OBJET7
SOLS	DC.L	SOL1,SOL2,SOL3,SOL4,SOL5,SOL6
	
SOL1	INCBIN	"C:\680X0\SOURCES\TC4\SOLDMA.TC4"
SOL2	INCBIN	"C:\680X0\SOURCES\TC4\SOLHEX.TC4"
SOL3	INCBIN	"C:\680X0\SOURCES\TC4\SOL.TC4"
SOL4	INCBIN	"C:\680X0\SOURCES\TC4\SOLRIVET.TC4"
SOL5	INCBIN	"C:\680X0\SOURCES\TC4\SOLBRICK.TC4"
SOL6	INCBIN	"C:\680X0\SOURCES\TC4\SOLBOIS.TC4"

IMAGE1	INCBIN	"C:\680X0\SOURCES\TC4\MURFACE.TC4"
IMAGE2	INCBIN	"C:\680X0\SOURCES\TC4\MUR.TC4"	
IMAGE3	INCBIN	"C:\680X0\SOURCES\TC4\MURBOUT.TC4"	
IMAGE4	INCBIN	"C:\680X0\SOURCES\TC4\BOIS.TC4"	
IMAGE5	INCBIN	"C:\680X0\SOURCES\TC4\LOGODMA.TC4"	
IMAGE6	INCBIN	"C:\680X0\SOURCES\TC4\MURMET2.TC4"	
IMAGE7	INCBIN	"C:\680X0\SOURCES\TC4\DINO.TC4"	
IMAGE8	INCBIN	"C:\680X0\SOURCES\TC4\NEON.TC4"	
IMAGE9	INCBIN	"C:\680X0\SOURCES\TC4\MURCARRE.TC4"	
IMAGE10	INCBIN	"C:\680X0\SOURCES\TC4\MURPIERR.TC4"	
IMAGE11	INCBIN	"C:\680X0\SOURCES\TC4\MURDEGRA.TC4"	
IMAGE12	INCBIN	"C:\680X0\SOURCES\TC4\BRICK.TC4"	

DEDICACE
	INCBIN	"C:\680X0\SOURCES\TC4\DEDICACE.BTM"
	EVEN

OBJET1	INCBIN	"C:\680X0\SOURCES\TC4\COLONNE.TC4"	
OBJET2	INCBIN	"C:\680X0\SOURCES\TC4\TABLE.TC4"	
OBJET3	INCBIN	"C:\680X0\SOURCES\TC4\TABOURET.TC4"	
OBJET4	INCBIN	"C:\680X0\SOURCES\TC4\TROU.TC4"	
OBJET5	INCBIN	"C:\680X0\SOURCES\TC4\ARBRE.TC4"	
OBJET6	INCBIN	"C:\680X0\SOURCES\TC4\PTICOL.TC4"	
OBJET7	INCBIN	"C:\680X0\SOURCES\TC4\NUAGES.TC4"	
	DS.W	160	*PR VOIR - BREAKPOINT

PORTE	INCBIN	"C:\680X0\SOURCES\TC4\PORTE.TC4"	

LASER	INCBIN	"C:\680X0\SOURCES\TC4\LASER.TC4"	*18*89 (13+76)
IMPACT	INCBIN	"C:\680X0\SOURCES\TC4\IMPACT.TC4"	*64*64 
	DS.B	64
	
	*ICI CHARGEMENT A PARTIR DU DISQUE POUR CAUSE DE PLACE
	*MEMOIRE
	
NOMS_AMIS	
	*80*120 CHACUN = 9636
	DC.B	"TC4\AMIS.C4S",0	

NOMS_ENNEMIS
	DC.B	"TC4\ENNEMIS.C4S",0	

NOM_INF	DC.B	"LASEDZOM.INF",0
NOM_F1	DC.B	"READ_ME.TXT",0
NOM_F2	DC.B	"LISEZMOI.TXT",0
	
	EVEN
	
	INCLUDE	"COSTBL.S"
	INCLUDE	"SINTBL.S"

ROUL_TBL
	*POUR ROUL=20
*	DC.L	24,20,16,14,12,12,10,10,8,8,8,6,6,6,4,4,4,4,2,2
*	DC.L	2,2,4,4,4,4,6,6,6,8,8,8,10,10,12,12,14,16,20,24
	DC.L	32,14,10,8,8,8,6,6,6,6,6,6,6,6,6,6,4,4,4,4
	DC.L	4,4,4,4,6,6,6,6,6,6,6,6,6,6,8,8,8,10,14,32
	
DEGRADE_FOND
	*HAUTEUR STANDARD : 130
	
	DC.W	02,31, 02,30, 02,29, 02,28, 01,27, 01,26, 01,25, 01,24		*8
	DC.W	01,23, 01,22, 01,21, 01,20, 01,19, 01,18, 01,17, 01,16		*16
	DC.W	01,15, 01,14, 01,13, 01,12, 01,11, 01,10, 01,09, 01,08		*24
	DC.W	01,07, 01,06, 01,05, 01,04, 01,03, 01,02, 01,01, 33,00		*32+32=64
	
	DC.W	62,00,-1
	
*	DC.W	01,00, 01,01, 01,02, 01,03 		*SOL BITMAP
*	DC.W	02,04, 02,05, 02,06, 02,07		*80
*	DC.W	02,08, 02,09, 02,10, 02,11, 02,12, 02,13, 02,14, 02,15		*96
*	DC.W	02,16, 02,17, 02,18, 02,19, 02,20, 02,21, 02,22, 02,23		*112
*	DC.W	02,24, 02,25, 02,26, 02,27, 02,28, 02,29, 03,30, 03,31		*128+2
*	DC.W	-1
	

DEGRADE_FONDD
	*HAUTEUR STANDARD : 65
	
	DC.W	01,31, 01,30, 01,29, 01,28, 01,27, 01,25	*4
	DC.W	01,23, 01,21, 01,19, 01,17 	*8
	DC.W	01,15, 01,13, 01,11, 01,09 	*12
	DC.W	01,07, 01,05, 01,03, 01,01, 16,00		*16+16=32
	
	DC.W	31,00,-1
	*DC.W	01,01, 01,03, -1 *SOL BITMAP
	*DC.W	01,04, 01,05, 01,06, 01,07		*40
	*DC.W	01,08, 01,09, 01,10, 01,11, 01,12, 01,13, 01,14, 01,15		*48
	*DC.W	01,16, 01,17, 01,18, 01,19, 01,20, 01,21, 01,22, 01,23		*56
	*DC.W	01,24, 01,25, 01,26, 01,27, 01,28, 01,29, 01,30, 02,31		*64+1
	*DC.W	-1

TBL_PORTE	

*TABLE DES 19 OFFSETS DE POSITION DE POINTEUR,(120-LONGEUR) ET (120-Y_IMG)

	DC.W	0,30,60,75,90,105,110,115
*	DC.W	0,10,20,30,40,50,60,65,70,75,80,85,90,95,100,105,110,115
	DCB.W	20,115
	DC.W	115,111,103,91,75,55,31,3,0
	DC.W	12,20,24,24,20,12,0,8,12,12,8,0,4,4,0,1,0
	DC.W	-1
	
TBL_DEVANT	*DANS LES 8 DIRECTIONS OFFSET A AJOUTER POUR L'OBJET DEVANT SON NEZ
	DC.W	-64,2-64,2,2+64,64,64-2,-2,-2-64	

ORDRE	DC.B	$1B,$4B,000,$87,000,000,000,$C6,$27,000,$63,$93,000,000,000,$D2
	DC.B	000,000,000,000,000,000,000,000,$36,000,$72,000,000,000,$B1,$E1
	DC.B	$1E,$4E,000,000,000,$8D,000,$C9,000,000,000,000,000,000,000,000
	DC.B	$2D,000,000,000,$6C,$9C,000,$D8,$39,000,000,000,$78,000,$B4,$E4
	EVEN

RANDOM	DC.W	$FF

*YVD	EQU	40-7	* Y "         "
*YV	EQU	80-14  	* Y "         "

YV_TBL	DC.W	66,68,69,69,68,66,64,63,62,62,63,64,-1
YV_TBLD	DC.W	66/2,68/2,69/2,69/2,68/2,66/2,64/2,63/2,62/2,62/2,63/2,64/2,-1

X_REC	DC.W	0,160

Y_REC	DC.W	0,120		*60 SI DOUBLE
*Z_REC	DC.W	0,0

X_REC2	DC.W	40,120		*BONHOMME
Y_REC2	DC.W	0,YIMG_D

X_REC3	DC.W	80,80		*LASER
Y_REC3	DC.W	HLASER
X_RECS	DC.W	0,160

	*PROGRAMME DSP
PROG_DSP
	INCBIN	"DLDH.P56"
FIN_DSP
	EVEN
	
	SECTION BSS
AMIS	DS.L	1	*ADRESSE DU BUFFER GRAPHIQUE DES AMIS
ENNEMIS	DS.L	1	*IDEM
XP_W	DS.W	1
YP_W	DS.W	1	
	*NE PAS SEPARER
XCOOR	DS.W	8
YCOOR	DS.W	8
ZCOOR	DS.W	8

DEBECL	DS.W	1			*PARAM ECLAIRAGE
FINECL	DS.W	1
ECLDEB	DS.W	1
ECLFIN	DS.W	1
DEST	DS.L	1
MONTYPE	DS.W	1
VBLFLAG	DS.W	1			*POUR VSYNC
SOV70	DS.L	1			*SOV PARAM INTERRUPTIONS
SOV118	DS.L	1
SOV120	DS.L	1
SOVSR	DS.W	1
SOVSCR	DS.B	5
SOVMFP	DS.B	2
	EVEN
*SOVIDEL	DS.W	20			*SOV ECRAN VIDEL
BASE	DS.L	1			*ADRESSE ECRAN LOGIQUE
ECRANG	DS.L	1			*ADRESSE #ECRAN AND $F...F00
OLDRES	DS.W	1		*RESOLUTION AU BOOT
PHYBASE	DS.L	1

XMIEFF	DS.W	200	*COORDONNEES DE LA ZONE ECRAN TOUCHEE PAR LE POLYGONE
YMIEFF	DS.W	200
XMAEFF	DS.W	200
YMAEFF	DS.W	200
XMIE_P	DS.L	1
YMIE_P	DS.L	1
XMAE_P	DS.L	1
YMAE_P	DS.L	1
X_IMG	DS.W	1	*TAILLE D'UN MOTIF
Y_IMG	DS.W	1	*VARIABLE A CAUSE DE LA PORTE...
	DS.W	1	*A 0
X_LARG	DS.W	1	*VARIABLE A CAUSE DU BONHOMME
O_PORTE	DS.W	1
P_IMAGE	DS.L	1	*POINTEUR SUR IMAGE
P_POLY	DS.L	1	*POINTEUR SUR POLYG
ZTRANS	DS.W	18*200	*ENREGISTREMENT DES Z POUR L'ECLAIRAGE
COORD	DS.W	48*200	*COORD. SPATIALES TRANSFORMEES
POLYBUF	DS.W	6*50	*50 TYPES QUI TIRENT EN MEME TEMPS MAX


ZTRANS_P	DS.L	1	*POINTEUR
COORD_P		DS.L	1	*POINTEUR
MURCOUNT	DS.W	1	*NOMBRE DE MURS

COMPINC	DS.W	1
SHIELD	DS.W	1
SCORE	DS.W	1
NBTIRE	DS.W	1
NBTOUC	DS.W	1
NUM_LEVEL
	DS.W	1	*NUMERO DU NIVEAU

		*A NE PAS SEPARER
X_POS2	DS.W	1
Y_POS2	DS.W	1
ANG32	DS.W	1
X_POS	DS.W	1
Y_POS	DS.W	1
ANG2	DS.W	1
ANG	DS.W	1
DIR	DS.W	1

DX	DS.W	1
DY	DS.W	1

BITMAP	DS.W	48	*COORD. DU MOTIF BITMAP (DECOUPE)
XDSOV	DS.W	1	*SHADOW POUR MODULO
YDSOV	DS.W	1
XA	DS.W	1	*XA QUADR. ECRAN
YA	DS.W	1
XB	DS.W	1
YB	DS.W	1
XC	DS.W	1
YC	DS.W	1
XD	DS.W	1
YD	DS.W	1
XASOV	DS.W	1
YASOV	DS.W	1

XDPSOV	DS.W	1	*SHADOW POUR MODULO
YDPSOV	DS.W	1
XAP	DS.W	1	*XA' MOTIF BITMAP
YAP	DS.W	1
XBP	DS.W	1
YBP	DS.W	1
XCP	DS.W	1	
YCP	DS.W	1
XDP	DS.W	1
YDP	DS.W	1
XAPSOV	DS.W	1
YAPSOV	DS.W	1

XTRF	DS.W	1	*TRANSLATION AVANT ROTATION
YTRF	DS.W	1
ZTRF	DS.W	1
XTRL	DS.W	1	*TRANSLATION APRES ROTATION
YTRL	DS.W	1
ZTRL	DS.W	1
PAS_VBL	DS.W	1
PAS2_VBL	DS.W	1	*PAS MODULES PAR LE NOMBRE DE VBLS
PAS2_VBL2	DS.W	1	*IDEM POUR SOURIS
DX2	DS.W	1		*P SOURIS
DY2	DS.W	1
DX3	DS.W	1	*COPIE DE DX HORS VBL
DY3	DS.W	1
DX4	DS.W	1	*POUR RECHERCHE LASER
DY4	DS.W	1
JEUREG1	DS.L	16	*LIGNE DU HAUT ECRAN
JEUREG2	DS.L	16	*LIGNE DU BAS	ECRAN
JEUREG3	DS.L	16	*LIGNE DU HAUT/BAS MOTIF
JEUREG4	DS.L	16	*ECLAIRAGE
SOVREG	DS.L	1	*GARDE
XCOL	DS.W	1	*LIGNE A REMPLIR
TOPCOL	DS.W	1	*NIVEAU HAUT
BOTCOL	DS.W	1	*NIVEAU BAS
NEW_ECR	DS.L	1	*NOUVEL ECRAN
OLD_DMAPT	DS.L	1	*POUR DETECTION DE TERMINAISON SON

YV_PT	DS.L	1	*POINTEUR YV
	*GESTION DE L'ELEVATION DES SOLS
OF_HG	DS.W	1
OF_HD	DS.W	1
OF_BD	DS.W	1
OF_BG	DS.W	1
	*NE PAS SEPARER
OA	DS.W	1
OB	DS.W	1
OD	DS.W	1
OC	DS.W	1

	*VARIABLES DE STRETCH POLYGONAL
CLIP_TOT_SOL	DS.L	1	*PILE POUR ABANDON
XPE	DS.W	1
XQE	DS.W	1
YE	DS.W	1
DXPE	DS.W	1
DXQE	DS.W	1
DYPE	DS.W	1
DYQE	DS.W	1
EPE	DS.W	1
EQE	DS.W	1
XU	DS.W	1
YU	DS.W	1
DXU	DS.W	1
DYU	DS.W	1
COMPU	DS.W	1
AU	DS.W	1
NU	DS.W	1
XVV	DS.W	1
YVV	DS.W	1
DXV	DS.W	1
DYV	DS.W	1
COMPV	DS.W	1
AV	DS.W	1
NV	DS.W	1

S1PE	DS.W	1
S1QE	DS.W	1
S1U	DS.W	1
S2U	DS.W	1
S1V	DS.W	1
S2V	DS.W	1
S1M	DS.W	1
S2M	DS.W	1
LET	DS.L	4	*ADRESSE X DE CHAQUE NUMERO D'ORDRE

V_ECLINT	DS.W	1
V_ECLSUB	DS.W	1
TALK_PTR	DS.L	1	*ADR DU MESSAGE A DIRE
LIM_MOT		DS.L	2	*LIMTES DU MOTIF POUR LE SOL
	*OCTETS
TALK_FLAG	DS.B	1	*A 1 SI ON DIT QQCH
ACTUEL	DS.B	1		*VALEUR DE MOTIF		
FLIP_POSSIBLE	DS.B	1	*FLAG VBL
SEC_VBL	DS.B	1		*FLAG SEC VBL
SEC_VBL_D	DS.B	1	*FLAG DOUBLE
MOUV	DS.B	1		*MOUVEMENT GER OU NON DE NOUS
MOUV2	DS.B	1		* "	"	"      DES AUTRES
TIR_HEROS	DS.B	1
ENC_MOR	DS.B	1	*POUR SAVOIR S'IL Y A ENCORE UN MORT
FL_AMIS	DS.B	1	*ALTERNE ATTAQUE AMIS/ENNEMIS
HUIT_VBLS	DS.B	1	*MIS A UN TOUTES LES 8 VBLS
FLAG_EQUIPE	DS.B	1
FLAG_EXCL	DS.B	1	*EMPECHE LA MODIF EN VBL DES PERSOS
MORE75_FL	DS.B	1	*BONI
MORE50_FL	DS.B	1
SURVIE_FL	DS.B	1
TRANSP_FL	DS.B	1	*AFF TRANS OU NON DES CHIFFRES
SOV_SND	*SAUVEGARDE DES REGISTRES HARD SND
	DS.B	20
SND_BUSY	DS.B	1	*A 1 SI UN SON EST JOU
DBLH_F2	DS.B	1		*FLAG DOUBLE HORIZONTAL MODIFIE VBL
DBLH_F	DS.B	1		*FLAG DOUBLE HORIZONTAL
DBLVS_F2	DS.B	1	*FLAG SOL VERTICAL
DBLVS_F		DS.B	1
DOUBLE_F	DS.B	1
DOUBLE_RGB_F	DS.B	1
DOUBLE_EMUL_F	DS.B	1
LETS_ROCK	DS.B	1	*MUSIC ON/OFF
PLAFOND		DS.B	1
EVOL_YV		DS.B	1	*QD ON SE DEPLACE, PT DE V OSCILLE
F_AMI		DS.B	1	*POUR ANGLE_PPE
MURBAS_F	DS.B	1	*POUR SAVOIR SI ON AFFICHE UN MUR BAS
REGISTRE_F	DS.B	1	*A UN SI C'EST ENREGISTR
PARANOIA_F	DS.B	1
REGSCR_F	DS.B	1	*POUR AUTORISER OU NON L'ECRAN DE REG
AZERTY_F	DS.B	1	*TYPE DE CLAVIER
GAGNE_F		DS.B	1	*<>0 SI ON GAGNE (COMPTEUR)
PORTE_F		DS.B	1	*A FF SI ON TRAITE UNE PORTE

	EVEN
	
	*DOUBLE DYNAMIQUE
HLASER_F	DS.W	1
YMICLIP_F	DS.W	1
YMACLIP_F	DS.W	1
YTR_F		DS.W	1
YV_F		DS.W	1
LONECR_F	DS.L	1
YIMG_D_F	DS.W	1
	
NB_AMIS	DS.W	1		*NBRE D'AMIS ET D'ENNEMIS
NB_ENNEMIS	DS.W	1
XYCUR	DS.L	1	*INDICES COURANT DANS PLAN
XYMOI	DS.L	1	*INDICE POSITION
XYMOI2	DS.L	1
PERSO_P	DS.L	1

FRIENDS	DS.W	1	*NOMBRES ENCORE EN VIE
FOES	DS.W	1
CHIF_BUF
	DS.B	6	*PLACE POUR STOCKER LE CHIFFRE ASCII


HI_SCORE_TBL
	DS.W	10*3	*NOM,SCORE,%
		
	*OFFSETS DE VUE

PDV_2	DS.B	85	*-Y,X
PDV_3	DS.B	95	*-Y,X
PDV_4	DS.B	85	*-X,-Y
PDV_5	DS.B	95	*-X,-Y
PDV_6	DS.B	85	*Y,-X
PDV_7	DS.B	95	*Y,-X

SCRUT_2	DS.B	49	*-Y,X
SCRUT_3	DS.B	59	*-Y,X
SCRUT_4	DS.B	49	*-X,-Y
SCRUT_5	DS.B	59	*-X,-Y
SCRUT_6	DS.B	49	*Y,-X
SCRUT_7	DS.B	59	*Y,-X

	EVEN

ACESS_2	DS.W	27
ACESS_3	DS.W	51
ACESS_4	DS.W	27
ACESS_5	DS.W	51
ACESS_6	DS.W	27
ACESS_7	DS.W	51
	*CHEMIN A PARCOURIR POUR TOUCHER (CBASE ET DBS)
CHEM_2	DS.B	260		*CEND-CBASE		
CHEM_3	DS.B	400		*DEND-DBS
CHEM_4	DS.B	260		*CEND-CBASE
CHEM_5	DS.B	400		*DEND-DBS
CHEM_6	DS.B	260		*CEND-CBASE
CHEM_7	DS.B	400		*DEND-DBS
	
TAMPIMG	DS.B	200*8
BUFTIR	DS.W	200

PALPORTE
	DS.W	32*32
	
PALS	DS.W	32*32*NBMUR	*32 NIVEAUX D'ECLAIRAGE
PALS_B	DS.W	32*32*NBMUR

PALS_OBJET
	DS.W	32*32*NBOBJ	*32 NIVEAUX D'ECLAIRAGE
PALS_SOL_E
	DS.W	32*32*NBSOL
PALS_SOL
	DS.W	32*32*NBSOL
PALS_AMIS
	DS.W	32*32*12
PALS_ENNEMIS
	DS.W	32*32*12
PAL_MORTA
	DS.W	32*32
PAL_MORTE
	DS.W	32*32
QUI_TOUC
	DS.W	1	

NIVEAU0	DS.L	1	*PILE BCLE PPALE	
SOV_REG	DS.W	1	*UNE VARIABLE DE SAUVEGARDE
SOVCOL0	DS.L	1	*SAUVEGARDE DE LA COULEUR DU FOND
NB_PORTE
	DS.W	1
NB_MORTS	
	DS.W	1	
NBM_C	DS.W	1
PT_MORT	DS.L	1
PILE_PORTE
	DS.W	200*5	*200 PORTES PREVUES AU MAX

	*NE PAS SEPARER NI CHANGER D'ORDRE - TAILLES RIGOUREUSEMENT IDENTIQUES
	*PILE_AMIS2-PILE_AMIS=PILE_ENNEMIS2-PILE_ENNEMIS
PILE_AMIS	
	*PILE PERSO 
*XY(*2),XPOS,YPOS,ANG,DIR,ETAT,REFLEXES,PRECISION,PARANOIA,COMPTEUR DE CHGT,DX,DY,
*SCORE,NBAUBUT*100,NBTIRE,CIBLE,NOM,SHIELD,VIS,DX LAS,DY LAS

*SOIENT 22 MOTS
	DS.W	200*22
PILE_ENNEMIS
	DS.W	200*22
PILE_AMIS2	*CELLES QUI SONT MODIFIEES EN VBL
	DS.W	200*22
PILE_ENNEMIS2
	DS.W	200*22
PILE_MORTS
	DS.W	400*5	*XYPOS,XPOS,YPOS,AMI/ENNEMI

*MEMOIRE POUR LASEZDOM.INF
BUF_INF
	DS.B	LONG_INF
BUF_DEC	DS.B	10	*BUFFER POUR DECODAGE	
TAMP_INPUT	DS.B	20	*BUFFER POUR INPUT CODE
TAMP_INF	DS.B	26

VAGUEF	DS.W	160	*POUR EFFACEMENT PAR VAGUE
	*BUFFER POUR LA MORT
	
	CNOP	0,16
	DS.B	256	*DE JUSTIFICATION
ECRAN	DS.W	128000+64000

FINBSS
	END

 